(* Test array operations *)

structure Main =
struct
   val say = outputc std_out
   val prRealOp = fn (name,v:real) => say (name ^ " = "^ (makestring v) ^ "\n")
   val prIntOp = fn (name,v:int) => say (name ^ " = "^ (makestring v) ^ "\n")
   val prBool = fn (name,v:bool) => say (name ^ " = "^ (makestring v) ^ "\n")
   val getInteger = fn () =>
	     (say "Please enter a number:";
	      flush_out std_out;
	      let val s = input_line std_in
	      in fold (fn (x,y) => (x-48)+10*y)
		      (map ord (tl (rev (explode s)))) 0
	      end)

   (* create array whose elements range from start to finish *)

   val start = (say "(start)"; (getInteger()))
   val finish = (say "(finish)"; getInteger())

   val a = array(finish-start+1,1);

   (* check the length *)

   val _ = (print "length = "; print (Array.length a); print "\n")

   (* check the initialization *)

   val _ = let fun f i = if i <= finish then
				  (print (a sub (i-start));
			           print " ";
			           f(i+1))
	                 else ()
	   in (f start; print "\n")
	   end

   (* number elements of array from start to finish *)

   val _ = 
	let fun f i = if i <= finish then (update(a,i-start,i); f (i+1))
	              else ()
	in f start
        end

   (* print out each element *)

   val _ = let fun f i = if i <= finish then
				  (print (a sub (i-start));
			           print " ";
			           f(i+1))
	                 else ()
	   in (f start; print "\n")
	   end
end

