(* Test floating point operations *)

structure Main =
struct
   val say = outputc std_out
   val prRealOp = fn (name,v:real) => say (name ^ " = "^ (makestring v) ^ "\n")
   val prIntOp = fn (name,v:int) => say (name ^ " = "^ (makestring v) ^ "\n")
   val prBool = fn (name,v:bool) => say (name ^ " = "^ (makestring v) ^ "\n")
   val getInteger = fn () =>
	     (say "Please enter a number:";
	      flush_out std_out;
	      let val s = input_line std_in
	      in fold (fn (x,y) => (x-48)+10*y)
		      (map ord (tl (rev (explode s)))) 0
	      end)

   val n = (real(getInteger()))/100.00
   val m = (real(getInteger()))/100.00

   val _ = prRealOp("n",n)
   val _ = prRealOp("m",m)

   val _ = prRealOp("-n",~n)
   val _ = prRealOp("n+m",n+m)
   val _ = prRealOp("n-m",n-m)
   val _ = prRealOp("n*m",n*m)
   val _ = prRealOp("n/m",n/m)
  
   val _ = prBool("n > m",n>m)
   val _ = prBool("n < m",n<m)
   val _ = prBool("n >= m",n>=m)
   val _ = prBool("n <= m",n<=m)
   val _ = prBool("n = m",n=m)

   val _ = prRealOp("abs n",abs n)
   val _ = prIntOp("floor n",floor n)
   val _ = prRealOp("sqrt(abs n))",sqrt(abs n))
   val _ = prRealOp("sin n",sin n)
   val _ = prRealOp("cos n",cos n)
   val _ = prRealOp("arctan n",arctan n)
   val _ = prRealOp("e ^ m",exp m)
   val _ = prRealOp("ln m",ln m)

end

