import "fifo";
import "queue";
import "preempt_co_thread";
import "future";
import "radixsort";
import "radix_arg";
import "random";

structure Run : sig end =
  struct
     structure Random = Random()
     structure PreemptS = Preempt_Co_Thread(Queue(Fifo()))
     structure RadixSortS = RadixSort(structure Radix = Byte()
			              structure Future=Future(PreemptS.Thread))
     val _ = PreemptS.Control.setPreempt (SOME 1)
     val l = Random.randomlist 100 250 3.1415
     val say = outputc std_out
     val saynum = fn (n : int) => say (makestring n ^ " ")
     val printList = fn l => (app saynum l; print "\n")
     val _ = (printList l; printList(RadixSortS.sort l))
end

	

     

      
