import "fifo.sig";
import "queue.sig";

functor Queue(Fifo: FIFO) : QUEUE =
    struct
	type '1a t = '1a Fifo.t ref

	exception Deq = Fifo.Deq

	fun create () = ref Fifo.empty

	fun enq q x = q := (Fifo.enq (!q) x)

        fun deq q = 
	    let val (x,newq) = Fifo.deq (!q) in
		q := newq;
		x
	    end
	
	fun len q = Fifo.len (!q)

	fun contents q = Fifo.contents (!q)

    end
