(* This file is taken from the appendix of J.H. Reppy's paper entitled
   "First-class Synchronous Operations in Standard ML", TR 89-1068,
   December 1989, Department of Computer Science, Cornell University,
   Ithaca, NY  14853-7501.  Reppy's email address is jhr@cs.cornell.edu.
*)

signature EVENTS = sig

  (* processes *)
  type procid
  type proc

  val process : (unit -> unit) -> procid

  val yield : unit -> unit

  val getpid : unit -> procid

  val pid2string : procid -> string

  (* channels *)
  type 'a chan

  val channel : unit -> '1a chan

  val send : ('1a * '1a chan) -> unit
  val accept : '1a chan -> '1a

  (* events *)
  type 'a event

  exception Sync

  val sync : '1a event -> '1a

  val wrap : ('a event * ('a -> 'b)) -> 'b event

  val choose : 'a event list -> 'a event

  val anyevent : unit event
  val rdyevent : unit event
  val noevent  : 'a event

  val transmit : ('1a * '1a chan) -> unit event
  val receive : '1a chan -> '1a event

  val wait' : procid -> unit event

  (* reset the system *)
  val reset : unit -> unit

end (* signature EVENTS *)
