functor Channel(structure Thread: THREAD
		structure Queue : QUEUE ):CHANNEL =
    struct
	structure Thread = Thread

	datatype '1a t = CHAN of {lock: Thread.mutex,
				  value_here: Thread.condition,
				  values: '1a Queue.t}

	fun create () = CHAN{lock = Thread.mutex(),
			     value_here = Thread.condition(),
			     values = Queue.create()}

	fun put (CHAN{lock,value_here,values}) value =
	    Thread.with_mutex lock
	    (fn () => (Queue.enq values value;
		       Thread.signal value_here))

	fun get (CHAN{lock,value_here,values}) =
	    let fun get' () =
		(Queue.deq values) handle Queue.Deq =>
		    (Thread.wait lock value_here;
		     get' ())
	    in
		Thread.with_mutex lock get'
	    end

	fun try_get (CHAN{lock,value_here,values}) =
	    Thread.with_mutex lock
	    (fn () => SOME(Queue.deq values) handle Queue.Deq => NONE)

    end (* struct *)
