functor AlertableThread (Thread : THREAD) : ALERTABLE_THREAD =
    struct
	structure Thread = Thread

	datatype thread = TH of bool ref * Thread.condition option ref

	exception Alerted

	fun new_thread () = TH (ref false, ref NONE)

	val thread_self = Thread.var (new_thread ())

	fun self () =
	    Thread.get thread_self
	    handle Thread.Undefined =>
		let val t = new_thread ()
		in
		    Thread.set thread_self t;
		    t
		end

	fun alert (TH (p, ref opt)) =
	    (p := true;
	     case opt of
		 NONE => ()
	       | SOME cond => Thread.broadcast cond)

	fun alerted () =
	    let val (TH (ref b, _)) = self ()
	    in
		b
	    end

	fun fork f =
	    let val t = new_thread ()
		fun body () =
		    (Thread.set thread_self t;
		     f ())
	    in
		Thread.fork body;
		t
	    end

	fun wait mutex cond =
	    let val (TH (p, c)) = self ()
	    in
		c := SOME cond;
		Thread.wait mutex cond;
		if !p then
		    raise Alerted
		else
		    ()
	    end

	fun yield () =
	    if alerted () then
		raise Alerted
	    else
		Thread.yield ()
    end
