(* Execute a function n times, print out the average time *)

signature TIME =
   sig
     val time : (unit -> 'b) * string * int -> unit
   end
     
structure Time : TIME =
   struct
      val time = fn (f,name,n) =>
	  let val timer = System.Timer.start_timer()
	      val extract = fn (System.Timer.TIME {usec,sec}) =>
					 (real usec)/1.0E6+real sec
	      fun loop i = if i<n then (f(); loop (i+1)) else ()
	      val _ = loop 0
	      val non_gc_time = extract (System.Timer.check_timer timer)
	      val gc_time = extract (System.Timer.check_timer_gc timer)
	      val total = gc_time + non_gc_time
	      val n' = real n
	      val avg_non_gc_time = non_gc_time/n'
	      val avg_gc_time = gc_time/n'
	      val avg_total = total/n'
	   in outputc std_out
	      (name ^ ":\n" ^
	       "avg non-gc time = " ^ makestring avg_non_gc_time ^ "\n" ^
	       "avg gc time = " ^ makestring avg_gc_time ^ "\n" ^
	       "avg total time = " ^ makestring avg_total ^ "\n")
	   end
   end
   
signature RANDOM =
  sig
    val genlist : int * int -> int list
  end

structure Random : RANDOM =
  struct
    val b = 23421
    val m = 30000
    val genlist = fn (start,size) =>
	let fun loop (n,0,r) = r
	      | loop (n,c,r) = loop((n*b+1) mod m,c-1,n::r)
        in loop (start,size,nil)
        end
  end
        
signature SORT =
   sig
     val sort : int list -> int list
   end

structure Sort : SORT =
   struct
       val sort = 
          let fun insert (a,nil) = [a]
                | insert (a, l as h :: t) = 
                        if Integer.>(h,a) then a::l else h :: insert (a,t)
	  in fn l => fold insert l nil
          end
   end

structure Run =
   struct
      val l = Random.genlist (5,2000)
      val _ = Time.time(fn () => Sort.sort l,"insert sort",3)
   end  
