functor MLLrValsFun(structure Token : TOKEN)
 = 
struct
structure ParserData=
struct
structure Header = 
struct
(* Copyright 1989 by AT&T Bell Laboratories *)
open ErrorMsg Symbol Access Basics BasicTypes TypesUtil Absyn
open Env EnvAccess Misc CoreLang Signs Strs TyvarSet
fun fire a b c = (a(); b c)
fun markexp (e as MARKexp _, _, _) = e
  | markexp(e,a,b) = if !System.Control.markabsyn
			then MARKexp(e,a,b) else e
fun markdec(d as MARKdec _, _, _) = d
  | markdec(d,a,b) = if !System.Control.markabsyn
			then MARKdec(d,a,b) else d

fun markstr(a,b,f) $ = case f $
			of s as (MARKstr _,x,y) => s
			 | s as (t,x,y) => if !System.Control.markabsyn
				  then (MARKstr(t,a,b),x,y) else s

infix \/ 
val op \/ = union_tyvars

fun V(_,vars) = vars and E(e,_) = e


end
structure LrTable = Token.LrTable
structure Token = Token
local open LrTable in 
val table=let val actionT =
"\
\\003\000\051\000\005\000\050\000\006\000\049\000\
\\007\000\048\000\008\000\047\000\009\000\046\000\010\000\045\000\
\\015\000\044\000\016\000\043\000\020\000\042\000\022\000\041\000\
\\026\000\040\000\027\000\039\000\028\000\038\000\030\000\037\000\
\\031\000\036\000\034\000\035\000\035\000\034\000\036\000\033\000\
\\037\000\032\000\038\000\031\000\040\000\030\000\041\000\029\000\
\\042\000\028\000\044\000\027\000\048\000\026\000\050\000\025\000\
\\052\000\024\000\053\000\023\000\054\000\022\000\058\000\021\000\
\\061\000\020\000\062\000\019\000\063\000\018\000\069\000\017\000\000\000\001\000\
\\001\000\167\002\002\000\167\002\009\000\046\000\
\\010\000\045\000\016\000\043\000\022\000\041\000\027\000\039\000\
\\028\000\038\000\034\000\035\000\035\000\034\000\037\000\032\000\
\\038\000\031\000\041\000\029\000\042\000\028\000\048\000\026\000\
\\050\000\025\000\052\000\024\000\053\000\023\000\000\000\001\000\
\\001\000\181\002\002\000\181\002\000\000\001\000\
\\001\000\172\002\002\000\172\002\009\000\172\002\
\\010\000\172\002\016\000\172\002\019\000\172\002\022\000\172\002\
\\027\000\172\002\028\000\172\002\032\000\172\002\034\000\172\002\
\\035\000\172\002\037\000\172\002\038\000\172\002\041\000\172\002\
\\042\000\172\002\048\000\172\002\050\000\172\002\052\000\172\002\
\\053\000\172\002\066\000\172\002\000\000\001\000\
\\003\000\055\000\020\000\042\000\058\000\021\000\000\000\001\000\
\\001\000\248\001\002\000\248\001\009\000\248\001\
\\010\000\248\001\011\000\248\001\014\000\248\001\016\000\248\001\
\\018\000\248\001\019\000\248\001\022\000\248\001\023\000\248\001\
\\027\000\248\001\028\000\248\001\029\000\057\000\032\000\248\001\
\\034\000\248\001\035\000\248\001\037\000\248\001\038\000\248\001\
\\039\000\248\001\041\000\248\001\042\000\248\001\048\000\248\001\
\\050\000\248\001\051\000\248\001\052\000\248\001\053\000\248\001\
\\060\000\248\001\064\000\248\001\065\000\248\001\066\000\248\001\
\\067\000\056\000\000\000\001\000\
\\001\000\245\001\002\000\245\001\009\000\245\001\
\\010\000\245\001\011\000\245\001\014\000\245\001\016\000\245\001\
\\018\000\245\001\019\000\245\001\022\000\245\001\023\000\245\001\
\\027\000\245\001\028\000\245\001\032\000\245\001\034\000\245\001\
\\035\000\245\001\037\000\245\001\038\000\245\001\039\000\245\001\
\\041\000\245\001\042\000\245\001\048\000\245\001\050\000\245\001\
\\051\000\245\001\052\000\245\001\053\000\245\001\060\000\245\001\
\\064\000\245\001\065\000\245\001\066\000\245\001\000\000\001\000\
\\001\000\250\001\002\000\250\001\009\000\250\001\
\\010\000\250\001\011\000\250\001\014\000\250\001\016\000\250\001\
\\018\000\250\001\019\000\250\001\022\000\250\001\023\000\250\001\
\\027\000\250\001\028\000\250\001\029\000\250\001\032\000\250\001\
\\034\000\250\001\035\000\250\001\037\000\250\001\038\000\250\001\
\\039\000\250\001\041\000\250\001\042\000\250\001\048\000\250\001\
\\050\000\250\001\051\000\250\001\052\000\250\001\053\000\250\001\
\\060\000\250\001\064\000\250\001\065\000\250\001\066\000\250\001\
\\067\000\250\001\068\000\058\000\000\000\001\000\
\\001\000\254\001\002\000\254\001\009\000\254\001\
\\010\000\254\001\011\000\254\001\014\000\254\001\016\000\254\001\
\\018\000\254\001\019\000\254\001\022\000\254\001\023\000\254\001\
\\027\000\254\001\028\000\254\001\032\000\254\001\034\000\254\001\
\\035\000\254\001\037\000\254\001\038\000\254\001\039\000\254\001\
\\041\000\254\001\042\000\254\001\048\000\254\001\050\000\254\001\
\\051\000\254\001\052\000\254\001\053\000\254\001\060\000\254\001\
\\064\000\254\001\065\000\254\001\066\000\254\001\000\000\001\000\
\\001\000\001\002\002\000\001\002\009\000\001\002\
\\010\000\001\002\011\000\001\002\014\000\001\002\016\000\001\002\
\\018\000\001\002\019\000\001\002\022\000\001\002\023\000\001\002\
\\027\000\001\002\028\000\001\002\032\000\001\002\034\000\001\002\
\\035\000\001\002\037\000\001\002\038\000\001\002\039\000\001\002\
\\041\000\001\002\042\000\001\002\048\000\001\002\050\000\001\002\
\\051\000\001\002\052\000\001\002\053\000\001\002\060\000\001\002\
\\064\000\001\002\065\000\001\002\066\000\001\002\000\000\001\000\
\\001\000\007\002\002\000\007\002\003\000\007\002\
\\005\000\007\002\006\000\007\002\007\000\007\002\008\000\007\002\
\\009\000\007\002\010\000\007\002\011\000\007\002\014\000\007\002\
\\015\000\007\002\016\000\007\002\018\000\007\002\019\000\007\002\
\\020\000\007\002\022\000\007\002\023\000\007\002\026\000\007\002\
\\027\000\007\002\028\000\007\002\029\000\007\002\030\000\007\002\
\\031\000\007\002\032\000\007\002\034\000\007\002\035\000\007\002\
\\036\000\007\002\037\000\007\002\038\000\007\002\039\000\007\002\
\\040\000\007\002\041\000\007\002\042\000\007\002\044\000\007\002\
\\048\000\007\002\050\000\007\002\051\000\007\002\052\000\007\002\
\\053\000\007\002\054\000\007\002\058\000\007\002\059\000\007\002\
\\060\000\007\002\061\000\007\002\062\000\007\002\063\000\007\002\
\\064\000\007\002\065\000\007\002\066\000\007\002\067\000\007\002\
\\068\000\007\002\000\000\001\000\
\\001\000\253\001\002\000\253\001\003\000\051\000\
\\005\000\050\000\006\000\049\000\007\000\048\000\008\000\047\000\
\\009\000\253\001\010\000\253\001\011\000\253\001\014\000\253\001\
\\015\000\044\000\016\000\253\001\018\000\253\001\019\000\253\001\
\\020\000\042\000\022\000\253\001\023\000\253\001\026\000\040\000\
\\027\000\253\001\028\000\253\001\029\000\253\001\030\000\037\000\
\\031\000\036\000\032\000\253\001\034\000\253\001\035\000\253\001\
\\036\000\033\000\037\000\253\001\038\000\253\001\039\000\253\001\
\\040\000\030\000\041\000\253\001\042\000\253\001\044\000\027\000\
\\048\000\253\001\050\000\253\001\051\000\253\001\052\000\253\001\
\\053\000\253\001\054\000\022\000\058\000\021\000\059\000\062\000\
\\060\000\253\001\061\000\020\000\062\000\019\000\063\000\018\000\
\\064\000\253\001\065\000\253\001\066\000\253\001\067\000\253\001\
\\068\000\253\001\000\000\001\000\
\\001\000\183\002\002\000\183\002\000\000\001\000\
\\001\000\013\002\002\000\013\002\003\000\013\002\
\\005\000\013\002\006\000\013\002\007\000\013\002\008\000\013\002\
\\009\000\013\002\010\000\013\002\011\000\013\002\014\000\013\002\
\\015\000\013\002\016\000\013\002\018\000\013\002\019\000\013\002\
\\020\000\013\002\022\000\013\002\023\000\013\002\026\000\013\002\
\\027\000\013\002\028\000\013\002\029\000\013\002\030\000\013\002\
\\031\000\013\002\032\000\013\002\034\000\013\002\035\000\013\002\
\\036\000\013\002\037\000\013\002\038\000\013\002\039\000\013\002\
\\040\000\013\002\041\000\013\002\042\000\013\002\044\000\013\002\
\\048\000\013\002\050\000\013\002\051\000\013\002\052\000\013\002\
\\053\000\013\002\054\000\013\002\058\000\013\002\059\000\013\002\
\\060\000\013\002\061\000\013\002\062\000\013\002\063\000\013\002\
\\064\000\013\002\065\000\013\002\066\000\013\002\067\000\013\002\
\\068\000\013\002\000\000\001\000\
\\001\000\008\002\002\000\008\002\003\000\008\002\
\\005\000\008\002\006\000\008\002\007\000\008\002\008\000\008\002\
\\009\000\008\002\010\000\008\002\011\000\008\002\014\000\008\002\
\\015\000\008\002\016\000\008\002\018\000\008\002\019\000\008\002\
\\020\000\008\002\022\000\008\002\023\000\008\002\026\000\008\002\
\\027\000\008\002\028\000\008\002\029\000\008\002\030\000\008\002\
\\031\000\008\002\032\000\008\002\034\000\008\002\035\000\008\002\
\\036\000\008\002\037\000\008\002\038\000\008\002\039\000\008\002\
\\040\000\008\002\041\000\008\002\042\000\008\002\044\000\008\002\
\\048\000\008\002\050\000\008\002\051\000\008\002\052\000\008\002\
\\053\000\008\002\054\000\008\002\058\000\008\002\059\000\008\002\
\\060\000\008\002\061\000\008\002\062\000\008\002\063\000\008\002\
\\064\000\008\002\065\000\008\002\066\000\008\002\067\000\008\002\
\\068\000\008\002\000\000\001\000\
\\008\000\064\000\000\000\001\000\
\\003\000\051\000\005\000\050\000\006\000\049\000\
\\007\000\048\000\008\000\047\000\015\000\044\000\020\000\042\000\
\\026\000\040\000\030\000\037\000\031\000\036\000\036\000\033\000\
\\040\000\030\000\044\000\027\000\054\000\022\000\058\000\021\000\
\\061\000\020\000\062\000\019\000\063\000\018\000\066\000\068\000\000\000\001\000\
\\003\000\051\000\005\000\050\000\006\000\049\000\
\\007\000\048\000\008\000\047\000\015\000\044\000\020\000\042\000\
\\026\000\040\000\030\000\037\000\031\000\036\000\036\000\033\000\
\\040\000\030\000\044\000\027\000\054\000\022\000\058\000\021\000\
\\061\000\020\000\062\000\019\000\063\000\018\000\065\000\071\000\000\000\001\000\
\\003\000\077\000\005\000\076\000\064\000\075\000\000\000\001\000\
\\001\000\208\001\002\000\208\001\003\000\208\001\
\\005\000\208\001\006\000\208\001\007\000\208\001\008\000\208\001\
\\009\000\208\001\010\000\208\001\011\000\208\001\013\000\208\001\
\\014\000\208\001\015\000\208\001\016\000\208\001\018\000\208\001\
\\019\000\208\001\020\000\208\001\021\000\208\001\022\000\208\001\
\\023\000\208\001\025\000\208\001\026\000\208\001\027\000\208\001\
\\028\000\208\001\029\000\208\001\030\000\208\001\031\000\208\001\
\\032\000\208\001\033\000\208\001\034\000\208\001\035\000\208\001\
\\036\000\208\001\037\000\208\001\038\000\208\001\039\000\208\001\
\\040\000\208\001\041\000\208\001\042\000\208\001\044\000\208\001\
\\046\000\208\001\048\000\208\001\050\000\208\001\051\000\208\001\
\\052\000\208\001\053\000\208\001\054\000\208\001\055\000\208\001\
\\056\000\208\001\057\000\208\001\058\000\208\001\059\000\208\001\
\\060\000\208\001\061\000\208\001\062\000\208\001\063\000\208\001\
\\064\000\208\001\065\000\208\001\066\000\208\001\067\000\208\001\
\\068\000\208\001\000\000\001\000\
\\003\000\051\000\005\000\050\000\006\000\049\000\
\\007\000\048\000\008\000\047\000\015\000\044\000\020\000\042\000\
\\026\000\040\000\030\000\037\000\031\000\036\000\036\000\033\000\
\\040\000\030\000\044\000\027\000\054\000\022\000\058\000\021\000\
\\061\000\020\000\062\000\019\000\063\000\018\000\000\000\001\000\
\\003\000\096\000\005\000\050\000\006\000\049\000\
\\007\000\095\000\008\000\094\000\040\000\093\000\045\000\092\000\
\\055\000\091\000\058\000\090\000\061\000\089\000\062\000\088\000\
\\063\000\087\000\000\000\001\000\
\\003\000\079\002\004\000\100\000\020\000\079\002\
\\058\000\079\002\063\000\099\000\000\000\001\000\
\\003\000\055\000\020\000\042\000\058\000\021\000\000\000\001\000\
\\003\000\055\000\020\000\042\000\058\000\021\000\000\000\001\000\
\\003\000\051\000\005\000\050\000\006\000\049\000\
\\007\000\048\000\008\000\047\000\015\000\044\000\020\000\042\000\
\\026\000\040\000\030\000\037\000\031\000\036\000\036\000\033\000\
\\040\000\030\000\044\000\027\000\054\000\022\000\058\000\021\000\
\\061\000\020\000\062\000\019\000\063\000\018\000\000\000\001\000\
\\003\000\055\000\020\000\042\000\058\000\021\000\000\000\001\000\
\\003\000\110\000\020\000\042\000\058\000\021\000\000\000\001\000\
\\003\000\055\000\020\000\042\000\058\000\021\000\000\000\001\000\
\\003\000\101\002\020\000\101\002\058\000\101\002\000\000\001\000\
\\002\000\115\000\009\000\046\000\010\000\045\000\
\\016\000\043\000\022\000\041\000\027\000\039\000\028\000\038\000\
\\032\000\163\002\034\000\035\000\035\000\034\000\037\000\114\000\
\\038\000\031\000\041\000\029\000\042\000\028\000\048\000\026\000\
\\050\000\025\000\052\000\024\000\053\000\023\000\000\000\001\000\
\\002\000\119\000\010\000\045\000\016\000\043\000\
\\022\000\041\000\027\000\039\000\032\000\115\002\034\000\035\000\
\\035\000\034\000\037\000\118\000\038\000\031\000\041\000\029\000\
\\042\000\028\000\052\000\024\000\053\000\023\000\000\000\001\000\
\\003\000\099\002\005\000\050\000\006\000\049\000\
\\020\000\099\002\058\000\099\002\000\000\001\000\
\\003\000\097\002\005\000\050\000\006\000\049\000\
\\020\000\097\002\058\000\097\002\000\000\001\000\
\\003\000\051\000\005\000\050\000\006\000\049\000\
\\007\000\048\000\008\000\047\000\015\000\044\000\020\000\042\000\
\\026\000\040\000\030\000\037\000\031\000\036\000\036\000\033\000\
\\040\000\030\000\044\000\027\000\054\000\022\000\058\000\021\000\
\\061\000\020\000\062\000\019\000\063\000\018\000\000\000\001\000\
\\003\000\077\000\005\000\076\000\000\000\001\000\
\\003\000\055\000\020\000\042\000\058\000\021\000\000\000\001\000\
\\003\000\096\000\005\000\050\000\006\000\049\000\
\\007\000\095\000\008\000\094\000\040\000\093\000\055\000\091\000\
\\058\000\090\000\061\000\089\000\062\000\088\000\063\000\131\000\000\000\001\000\
\\003\000\096\000\005\000\050\000\006\000\049\000\
\\007\000\095\000\008\000\094\000\040\000\093\000\055\000\091\000\
\\058\000\090\000\061\000\089\000\062\000\088\000\063\000\087\000\000\000\001\000\
\\003\000\211\001\020\000\211\001\040\000\137\000\
\\058\000\211\001\000\000\001\000\
\\001\000\209\001\002\000\209\001\003\000\209\001\
\\005\000\209\001\006\000\209\001\007\000\209\001\008\000\209\001\
\\009\000\209\001\010\000\209\001\011\000\209\001\013\000\209\001\
\\014\000\209\001\015\000\209\001\016\000\209\001\018\000\209\001\
\\019\000\209\001\020\000\209\001\021\000\209\001\022\000\209\001\
\\023\000\209\001\025\000\209\001\026\000\209\001\027\000\209\001\
\\028\000\209\001\029\000\209\001\030\000\209\001\031\000\209\001\
\\032\000\209\001\033\000\209\001\034\000\209\001\035\000\209\001\
\\036\000\209\001\037\000\209\001\038\000\209\001\039\000\209\001\
\\040\000\209\001\041\000\209\001\042\000\209\001\044\000\209\001\
\\046\000\209\001\048\000\209\001\050\000\209\001\051\000\209\001\
\\052\000\209\001\053\000\209\001\054\000\209\001\055\000\209\001\
\\056\000\209\001\057\000\209\001\058\000\209\001\059\000\209\001\
\\060\000\209\001\061\000\209\001\062\000\209\001\063\000\209\001\
\\064\000\209\001\065\000\209\001\066\000\209\001\067\000\209\001\
\\068\000\209\001\000\000\001\000\
\\003\000\079\002\004\000\100\000\020\000\079\002\
\\058\000\079\002\063\000\099\000\000\000\001\000\
\\003\000\051\000\005\000\050\000\006\000\049\000\
\\007\000\048\000\008\000\047\000\015\000\044\000\020\000\042\000\
\\026\000\040\000\030\000\037\000\031\000\036\000\036\000\033\000\
\\040\000\030\000\044\000\027\000\054\000\022\000\058\000\021\000\
\\061\000\020\000\062\000\019\000\063\000\018\000\000\000\001\000\
\\003\000\079\002\004\000\100\000\020\000\079\002\
\\058\000\079\002\063\000\099\000\000\000\001\000\
\\003\000\055\000\020\000\042\000\058\000\021\000\000\000\001\000\
\\001\000\015\002\002\000\015\002\003\000\015\002\
\\005\000\015\002\006\000\015\002\007\000\015\002\008\000\015\002\
\\009\000\015\002\010\000\015\002\011\000\015\002\014\000\015\002\
\\015\000\015\002\016\000\015\002\018\000\015\002\019\000\015\002\
\\020\000\015\002\022\000\015\002\023\000\015\002\026\000\015\002\
\\027\000\015\002\028\000\015\002\029\000\015\002\030\000\015\002\
\\031\000\015\002\032\000\015\002\034\000\015\002\035\000\015\002\
\\036\000\015\002\037\000\015\002\038\000\015\002\039\000\015\002\
\\040\000\015\002\041\000\015\002\042\000\015\002\044\000\015\002\
\\048\000\015\002\050\000\015\002\051\000\015\002\052\000\015\002\
\\053\000\015\002\054\000\015\002\058\000\015\002\059\000\015\002\
\\060\000\015\002\061\000\015\002\062\000\015\002\063\000\015\002\
\\064\000\015\002\065\000\015\002\066\000\015\002\067\000\015\002\
\\068\000\015\002\000\000\001\000\
\\001\000\014\002\002\000\014\002\003\000\014\002\
\\005\000\014\002\006\000\014\002\007\000\014\002\008\000\014\002\
\\009\000\014\002\010\000\014\002\011\000\014\002\014\000\014\002\
\\015\000\014\002\016\000\014\002\018\000\014\002\019\000\014\002\
\\020\000\014\002\022\000\014\002\023\000\014\002\026\000\014\002\
\\027\000\014\002\028\000\014\002\029\000\014\002\030\000\014\002\
\\031\000\014\002\032\000\014\002\034\000\014\002\035\000\014\002\
\\036\000\014\002\037\000\014\002\038\000\014\002\039\000\014\002\
\\040\000\014\002\041\000\014\002\042\000\014\002\044\000\014\002\
\\048\000\014\002\050\000\014\002\051\000\014\002\052\000\014\002\
\\053\000\014\002\054\000\014\002\058\000\014\002\059\000\014\002\
\\060\000\014\002\061\000\014\002\062\000\014\002\063\000\014\002\
\\064\000\014\002\065\000\014\002\066\000\014\002\067\000\014\002\
\\068\000\014\002\000\000\001\000\
\\001\000\204\001\002\000\204\001\003\000\204\001\
\\005\000\204\001\006\000\204\001\007\000\204\001\008\000\204\001\
\\009\000\204\001\010\000\204\001\011\000\204\001\013\000\204\001\
\\014\000\204\001\015\000\204\001\016\000\204\001\018\000\204\001\
\\019\000\204\001\020\000\204\001\022\000\204\001\023\000\204\001\
\\025\000\204\001\026\000\204\001\027\000\204\001\028\000\204\001\
\\029\000\204\001\030\000\204\001\031\000\204\001\032\000\204\001\
\\034\000\204\001\035\000\204\001\036\000\204\001\037\000\204\001\
\\038\000\204\001\039\000\204\001\040\000\204\001\041\000\204\001\
\\042\000\204\001\044\000\204\001\048\000\204\001\050\000\204\001\
\\051\000\204\001\052\000\204\001\053\000\204\001\054\000\204\001\
\\055\000\204\001\058\000\204\001\059\000\204\001\060\000\204\001\
\\061\000\204\001\062\000\204\001\063\000\204\001\064\000\204\001\
\\065\000\204\001\066\000\204\001\067\000\204\001\068\000\204\001\000\000\001\000\
\\001\000\203\001\002\000\203\001\003\000\203\001\
\\005\000\203\001\006\000\203\001\007\000\203\001\008\000\203\001\
\\009\000\203\001\010\000\203\001\011\000\203\001\013\000\203\001\
\\014\000\203\001\015\000\203\001\016\000\203\001\018\000\203\001\
\\019\000\203\001\020\000\203\001\022\000\203\001\023\000\203\001\
\\025\000\203\001\026\000\203\001\027\000\203\001\028\000\203\001\
\\029\000\203\001\030\000\203\001\031\000\203\001\032\000\203\001\
\\034\000\203\001\035\000\203\001\036\000\203\001\037\000\203\001\
\\038\000\203\001\039\000\203\001\040\000\203\001\041\000\203\001\
\\042\000\203\001\044\000\203\001\048\000\203\001\050\000\203\001\
\\051\000\203\001\052\000\203\001\053\000\203\001\054\000\203\001\
\\055\000\203\001\058\000\203\001\059\000\203\001\060\000\203\001\
\\061\000\203\001\062\000\203\001\063\000\203\001\064\000\203\001\
\\065\000\203\001\066\000\203\001\067\000\203\001\068\000\203\001\000\000\001\000\
\\001\000\207\001\002\000\207\001\003\000\207\001\
\\005\000\207\001\006\000\207\001\007\000\207\001\008\000\207\001\
\\009\000\207\001\010\000\207\001\011\000\207\001\014\000\207\001\
\\015\000\207\001\016\000\207\001\018\000\207\001\019\000\207\001\
\\020\000\207\001\022\000\207\001\023\000\207\001\024\000\144\000\
\\026\000\207\001\027\000\207\001\028\000\207\001\029\000\207\001\
\\030\000\207\001\031\000\207\001\032\000\207\001\034\000\207\001\
\\035\000\207\001\036\000\207\001\037\000\207\001\038\000\207\001\
\\039\000\207\001\040\000\207\001\041\000\207\001\042\000\207\001\
\\044\000\207\001\048\000\207\001\050\000\207\001\051\000\207\001\
\\052\000\207\001\053\000\207\001\054\000\207\001\058\000\207\001\
\\059\000\207\001\060\000\207\001\061\000\207\001\062\000\207\001\
\\063\000\207\001\064\000\207\001\065\000\207\001\066\000\207\001\
\\067\000\207\001\068\000\207\001\000\000\001\000\
\\001\000\164\002\002\000\164\002\000\000\001\000\
\\001\000\111\002\002\000\111\002\009\000\111\002\
\\010\000\111\002\016\000\111\002\019\000\111\002\022\000\111\002\
\\027\000\111\002\028\000\111\002\032\000\111\002\034\000\111\002\
\\035\000\111\002\037\000\111\002\038\000\111\002\041\000\111\002\
\\042\000\111\002\048\000\111\002\050\000\111\002\052\000\111\002\
\\053\000\111\002\066\000\111\002\000\000\001\000\
\\001\000\119\002\002\000\119\002\003\000\055\000\
\\009\000\119\002\010\000\119\002\016\000\119\002\019\000\119\002\
\\020\000\042\000\021\000\119\002\022\000\119\002\027\000\119\002\
\\028\000\119\002\032\000\119\002\033\000\119\002\034\000\119\002\
\\035\000\119\002\037\000\119\002\038\000\119\002\041\000\119\002\
\\042\000\119\002\046\000\119\002\048\000\119\002\050\000\119\002\
\\052\000\119\002\053\000\119\002\058\000\021\000\066\000\119\002\000\000\001\000\
\\001\000\207\001\002\000\207\001\003\000\207\001\
\\005\000\207\001\006\000\207\001\007\000\207\001\008\000\207\001\
\\009\000\207\001\010\000\207\001\011\000\207\001\013\000\207\001\
\\014\000\207\001\015\000\207\001\016\000\207\001\018\000\207\001\
\\019\000\207\001\020\000\207\001\021\000\207\001\022\000\207\001\
\\023\000\207\001\025\000\207\001\026\000\207\001\027\000\207\001\
\\028\000\207\001\029\000\207\001\030\000\207\001\031\000\207\001\
\\032\000\207\001\033\000\207\001\034\000\207\001\035\000\207\001\
\\036\000\207\001\037\000\207\001\038\000\207\001\039\000\207\001\
\\040\000\207\001\041\000\207\001\042\000\207\001\044\000\207\001\
\\046\000\207\001\048\000\207\001\050\000\207\001\051\000\207\001\
\\052\000\207\001\053\000\207\001\054\000\207\001\055\000\207\001\
\\056\000\207\001\057\000\207\001\058\000\207\001\059\000\207\001\
\\060\000\207\001\061\000\207\001\062\000\207\001\063\000\207\001\
\\064\000\207\001\065\000\207\001\066\000\207\001\067\000\207\001\
\\068\000\207\001\000\000\001\000\
\\003\000\051\000\005\000\050\000\006\000\049\000\
\\007\000\048\000\008\000\047\000\015\000\044\000\020\000\042\000\
\\026\000\040\000\030\000\037\000\031\000\036\000\036\000\033\000\
\\040\000\030\000\044\000\027\000\054\000\022\000\058\000\021\000\
\\061\000\020\000\062\000\019\000\063\000\018\000\000\000\001\000\
\\003\000\096\000\005\000\050\000\006\000\049\000\
\\007\000\095\000\008\000\094\000\040\000\093\000\055\000\091\000\
\\058\000\090\000\061\000\089\000\062\000\088\000\063\000\087\000\000\000\001\000\
\\003\000\051\000\005\000\050\000\006\000\049\000\
\\007\000\048\000\008\000\047\000\015\000\044\000\020\000\042\000\
\\026\000\040\000\030\000\037\000\031\000\036\000\036\000\033\000\
\\040\000\030\000\044\000\027\000\054\000\022\000\058\000\021\000\
\\061\000\020\000\062\000\019\000\063\000\018\000\000\000\001\000\
\\001\000\000\002\002\000\000\002\009\000\000\002\
\\010\000\000\002\011\000\000\002\014\000\000\002\016\000\000\002\
\\018\000\000\002\019\000\000\002\022\000\000\002\023\000\000\002\
\\027\000\000\002\028\000\000\002\032\000\000\002\034\000\000\002\
\\035\000\000\002\037\000\000\002\038\000\000\002\039\000\000\002\
\\041\000\000\002\042\000\000\002\048\000\000\002\050\000\000\002\
\\051\000\000\002\052\000\000\002\053\000\000\002\060\000\000\002\
\\064\000\000\002\065\000\000\002\066\000\000\002\000\000\001\000\
\\001\000\009\002\002\000\009\002\003\000\009\002\
\\005\000\009\002\006\000\009\002\007\000\009\002\008\000\009\002\
\\009\000\009\002\010\000\009\002\011\000\009\002\014\000\009\002\
\\015\000\009\002\016\000\009\002\018\000\009\002\019\000\009\002\
\\020\000\009\002\022\000\009\002\023\000\009\002\026\000\009\002\
\\027\000\009\002\028\000\009\002\029\000\009\002\030\000\009\002\
\\031\000\009\002\032\000\009\002\034\000\009\002\035\000\009\002\
\\036\000\009\002\037\000\009\002\038\000\009\002\039\000\009\002\
\\040\000\009\002\041\000\009\002\042\000\009\002\044\000\009\002\
\\048\000\009\002\050\000\009\002\051\000\009\002\052\000\009\002\
\\053\000\009\002\054\000\009\002\058\000\009\002\059\000\009\002\
\\060\000\009\002\061\000\009\002\062\000\009\002\063\000\009\002\
\\064\000\009\002\065\000\009\002\066\000\009\002\067\000\009\002\
\\068\000\009\002\000\000\001\000\
\\001\000\010\002\002\000\010\002\003\000\010\002\
\\005\000\010\002\006\000\010\002\007\000\010\002\008\000\010\002\
\\009\000\010\002\010\000\010\002\011\000\010\002\014\000\010\002\
\\015\000\010\002\016\000\010\002\018\000\010\002\019\000\010\002\
\\020\000\010\002\022\000\010\002\023\000\010\002\026\000\010\002\
\\027\000\010\002\028\000\010\002\029\000\010\002\030\000\010\002\
\\031\000\010\002\032\000\010\002\034\000\010\002\035\000\010\002\
\\036\000\010\002\037\000\010\002\038\000\010\002\039\000\010\002\
\\040\000\010\002\041\000\010\002\042\000\010\002\044\000\010\002\
\\048\000\010\002\050\000\010\002\051\000\010\002\052\000\010\002\
\\053\000\010\002\054\000\010\002\058\000\010\002\059\000\010\002\
\\060\000\010\002\061\000\010\002\062\000\010\002\063\000\010\002\
\\064\000\010\002\065\000\010\002\066\000\010\002\067\000\010\002\
\\068\000\010\002\000\000\001\000\
\\003\000\158\000\004\000\157\000\061\000\156\000\
\\063\000\155\000\000\000\001\000\
\\001\000\182\002\002\000\182\002\000\000\001\000\
\\001\000\179\002\002\000\179\002\008\000\064\000\000\000\001\000\
\\066\000\160\000\000\000\001\000\
\\002\000\162\000\060\000\161\000\066\000\243\001\000\000\001\000\
\\066\000\163\000\000\000\001\000\
\\001\000\019\002\002\000\019\002\003\000\019\002\
\\005\000\019\002\006\000\019\002\007\000\019\002\008\000\019\002\
\\009\000\019\002\010\000\019\002\011\000\019\002\014\000\019\002\
\\015\000\019\002\016\000\019\002\018\000\019\002\019\000\019\002\
\\020\000\019\002\022\000\019\002\023\000\019\002\026\000\019\002\
\\027\000\019\002\028\000\019\002\029\000\019\002\030\000\019\002\
\\031\000\019\002\032\000\019\002\034\000\019\002\035\000\019\002\
\\036\000\019\002\037\000\019\002\038\000\019\002\039\000\019\002\
\\040\000\019\002\041\000\019\002\042\000\019\002\044\000\019\002\
\\048\000\019\002\050\000\019\002\051\000\019\002\052\000\019\002\
\\053\000\019\002\054\000\019\002\058\000\019\002\059\000\019\002\
\\060\000\019\002\061\000\019\002\062\000\019\002\063\000\019\002\
\\064\000\019\002\065\000\019\002\066\000\019\002\067\000\019\002\
\\068\000\019\002\000\000\001\000\
\\065\000\164\000\000\000\001\000\
\\060\000\165\000\065\000\027\002\000\000\001\000\
\\001\000\023\002\002\000\023\002\003\000\023\002\
\\005\000\023\002\006\000\023\002\007\000\023\002\008\000\023\002\
\\009\000\023\002\010\000\023\002\011\000\023\002\014\000\023\002\
\\015\000\023\002\016\000\023\002\018\000\023\002\019\000\023\002\
\\020\000\023\002\022\000\023\002\023\000\023\002\026\000\023\002\
\\027\000\023\002\028\000\023\002\029\000\023\002\030\000\023\002\
\\031\000\023\002\032\000\023\002\034\000\023\002\035\000\023\002\
\\036\000\023\002\037\000\023\002\038\000\023\002\039\000\023\002\
\\040\000\023\002\041\000\023\002\042\000\023\002\044\000\023\002\
\\048\000\023\002\050\000\023\002\051\000\023\002\052\000\023\002\
\\053\000\023\002\054\000\023\002\058\000\023\002\059\000\023\002\
\\060\000\023\002\061\000\023\002\062\000\023\002\063\000\023\002\
\\064\000\023\002\065\000\023\002\066\000\023\002\067\000\023\002\
\\068\000\023\002\000\000\001\000\
\\064\000\166\000\000\000\001\000\
\\060\000\167\000\064\000\242\001\000\000\001\000\
\\020\000\168\000\000\000\001\000\
\\001\000\018\002\002\000\018\002\003\000\018\002\
\\005\000\018\002\006\000\018\002\007\000\018\002\008\000\018\002\
\\009\000\018\002\010\000\018\002\011\000\018\002\014\000\018\002\
\\015\000\018\002\016\000\018\002\018\000\018\002\019\000\018\002\
\\020\000\018\002\022\000\018\002\023\000\018\002\026\000\018\002\
\\027\000\018\002\028\000\018\002\029\000\018\002\030\000\018\002\
\\031\000\018\002\032\000\018\002\034\000\018\002\035\000\018\002\
\\036\000\018\002\037\000\018\002\038\000\018\002\039\000\018\002\
\\040\000\018\002\041\000\018\002\042\000\018\002\044\000\018\002\
\\048\000\018\002\050\000\018\002\051\000\018\002\052\000\018\002\
\\053\000\018\002\054\000\018\002\058\000\018\002\059\000\018\002\
\\060\000\018\002\061\000\018\002\062\000\018\002\063\000\018\002\
\\064\000\018\002\065\000\018\002\066\000\018\002\067\000\018\002\
\\068\000\018\002\000\000\001\000\
\\001\000\217\001\002\000\217\001\003\000\217\001\
\\005\000\217\001\006\000\217\001\007\000\217\001\008\000\217\001\
\\009\000\217\001\010\000\217\001\011\000\217\001\014\000\217\001\
\\015\000\217\001\016\000\217\001\018\000\217\001\019\000\217\001\
\\020\000\217\001\022\000\217\001\023\000\217\001\026\000\217\001\
\\027\000\217\001\028\000\217\001\029\000\217\001\030\000\217\001\
\\031\000\217\001\032\000\217\001\034\000\217\001\035\000\217\001\
\\036\000\217\001\037\000\217\001\038\000\217\001\039\000\217\001\
\\040\000\217\001\041\000\217\001\042\000\217\001\044\000\217\001\
\\048\000\217\001\050\000\217\001\051\000\217\001\052\000\217\001\
\\053\000\217\001\054\000\217\001\058\000\217\001\059\000\217\001\
\\060\000\217\001\061\000\217\001\062\000\217\001\063\000\217\001\
\\064\000\217\001\065\000\217\001\066\000\217\001\067\000\217\001\
\\068\000\217\001\000\000\001\000\
\\001\000\216\001\002\000\216\001\003\000\216\001\
\\005\000\216\001\006\000\216\001\007\000\216\001\008\000\216\001\
\\009\000\216\001\010\000\216\001\011\000\216\001\014\000\216\001\
\\015\000\216\001\016\000\216\001\018\000\216\001\019\000\216\001\
\\020\000\216\001\022\000\216\001\023\000\216\001\026\000\216\001\
\\027\000\216\001\028\000\216\001\029\000\216\001\030\000\216\001\
\\031\000\216\001\032\000\216\001\034\000\216\001\035\000\216\001\
\\036\000\216\001\037\000\216\001\038\000\216\001\039\000\216\001\
\\040\000\216\001\041\000\216\001\042\000\216\001\044\000\216\001\
\\048\000\216\001\050\000\216\001\051\000\216\001\052\000\216\001\
\\053\000\216\001\054\000\216\001\058\000\216\001\059\000\216\001\
\\060\000\216\001\061\000\216\001\062\000\216\001\063\000\216\001\
\\064\000\216\001\065\000\216\001\066\000\216\001\067\000\216\001\
\\068\000\216\001\000\000\001\000\
\\023\000\169\000\000\000\001\000\
\\001\000\102\002\002\000\102\002\009\000\102\002\
\\010\000\102\002\011\000\170\000\016\000\102\002\019\000\102\002\
\\022\000\102\002\027\000\102\002\028\000\102\002\032\000\102\002\
\\034\000\102\002\035\000\102\002\037\000\102\002\038\000\102\002\
\\041\000\102\002\042\000\102\002\048\000\102\002\050\000\102\002\
\\052\000\102\002\053\000\102\002\066\000\102\002\000\000\001\000\
\\003\000\035\002\005\000\035\002\006\000\035\002\
\\007\000\035\002\008\000\035\002\013\000\035\002\020\000\035\002\
\\025\000\035\002\040\000\035\002\055\000\035\002\058\000\035\002\
\\059\000\035\002\060\000\035\002\061\000\035\002\062\000\035\002\
\\063\000\035\002\064\000\035\002\065\000\035\002\066\000\035\002\000\000\001\000\
\\003\000\033\002\005\000\033\002\006\000\033\002\
\\007\000\033\002\008\000\033\002\013\000\033\002\020\000\033\002\
\\025\000\033\002\040\000\033\002\055\000\033\002\058\000\033\002\
\\059\000\033\002\060\000\033\002\061\000\033\002\062\000\033\002\
\\063\000\033\002\064\000\033\002\065\000\033\002\066\000\033\002\000\000\001\000\
\\003\000\096\000\005\000\050\000\006\000\049\000\
\\007\000\095\000\008\000\094\000\013\000\072\002\020\000\072\002\
\\025\000\072\002\040\000\093\000\055\000\091\000\058\000\090\000\
\\059\000\072\002\060\000\072\002\061\000\089\000\062\000\088\000\
\\063\000\087\000\064\000\072\002\065\000\072\002\066\000\072\002\000\000\001\000\
\\013\000\029\002\020\000\029\002\025\000\029\002\
\\060\000\029\002\064\000\029\002\065\000\029\002\066\000\029\002\000\000\001\000\
\\013\000\174\000\020\000\173\000\000\000\001\000\
\\003\000\041\002\005\000\041\002\006\000\041\002\
\\007\000\041\002\008\000\041\002\013\000\041\002\020\000\041\002\
\\025\000\041\002\040\000\041\002\055\000\041\002\058\000\041\002\
\\059\000\041\002\060\000\041\002\061\000\041\002\062\000\041\002\
\\063\000\041\002\064\000\041\002\065\000\041\002\066\000\041\002\000\000\001\000\
\\003\000\036\002\005\000\036\002\006\000\036\002\
\\007\000\036\002\008\000\036\002\013\000\036\002\020\000\036\002\
\\025\000\036\002\040\000\036\002\055\000\036\002\058\000\036\002\
\\059\000\036\002\060\000\036\002\061\000\036\002\062\000\036\002\
\\063\000\036\002\064\000\036\002\065\000\036\002\066\000\036\002\000\000\001\000\
\\003\000\096\000\005\000\050\000\006\000\049\000\
\\007\000\095\000\008\000\094\000\040\000\093\000\055\000\091\000\
\\058\000\090\000\061\000\089\000\062\000\088\000\063\000\087\000\
\\066\000\176\000\000\000\001\000\
\\003\000\096\000\005\000\050\000\006\000\049\000\
\\007\000\095\000\008\000\094\000\040\000\093\000\055\000\091\000\
\\058\000\090\000\061\000\089\000\062\000\088\000\063\000\087\000\
\\065\000\179\000\000\000\001\000\
\\003\000\185\000\005\000\076\000\017\000\184\000\
\\064\000\183\000\000\000\001\000\
\\003\000\206\001\005\000\206\001\006\000\206\001\
\\007\000\206\001\008\000\206\001\013\000\206\001\020\000\206\001\
\\025\000\206\001\040\000\206\001\055\000\206\001\058\000\206\001\
\\059\000\206\001\060\000\206\001\061\000\206\001\062\000\206\001\
\\063\000\206\001\064\000\206\001\065\000\206\001\066\000\206\001\000\000\001\000\
\\003\000\044\002\005\000\044\002\006\000\044\002\
\\007\000\044\002\008\000\044\002\013\000\044\002\020\000\044\002\
\\025\000\044\002\040\000\044\002\055\000\044\002\058\000\044\002\
\\059\000\044\002\060\000\044\002\061\000\044\002\062\000\044\002\
\\063\000\044\002\064\000\044\002\065\000\044\002\066\000\044\002\000\000\001\000\
\\003\000\190\000\040\000\189\000\058\000\090\000\000\000\001\000\
\\003\000\055\000\020\000\042\000\058\000\021\000\000\000\001\000\
\\003\000\043\002\005\000\043\002\006\000\043\002\
\\007\000\043\002\008\000\043\002\013\000\043\002\020\000\043\002\
\\025\000\043\002\040\000\043\002\055\000\043\002\058\000\043\002\
\\059\000\043\002\060\000\043\002\061\000\043\002\062\000\043\002\
\\063\000\043\002\064\000\043\002\065\000\043\002\066\000\043\002\000\000\001\000\
\\003\000\042\002\005\000\042\002\006\000\042\002\
\\007\000\042\002\008\000\042\002\013\000\042\002\020\000\042\002\
\\025\000\042\002\040\000\042\002\055\000\042\002\058\000\042\002\
\\059\000\042\002\060\000\042\002\061\000\042\002\062\000\042\002\
\\063\000\042\002\064\000\042\002\065\000\042\002\066\000\042\002\000\000\001\000\
\\003\000\205\001\005\000\205\001\006\000\205\001\
\\007\000\205\001\008\000\205\001\013\000\205\001\020\000\205\001\
\\024\000\192\000\025\000\205\001\040\000\205\001\055\000\205\001\
\\058\000\205\001\059\000\205\001\060\000\205\001\061\000\205\001\
\\062\000\205\001\063\000\205\001\064\000\205\001\065\000\205\001\
\\066\000\205\001\000\000\001\000\
\\003\000\055\000\020\000\042\000\058\000\021\000\000\000\001\000\
\\001\000\105\002\002\000\105\002\009\000\105\002\
\\010\000\105\002\011\000\194\000\016\000\105\002\019\000\105\002\
\\022\000\105\002\027\000\105\002\028\000\105\002\032\000\105\002\
\\034\000\105\002\035\000\105\002\037\000\105\002\038\000\105\002\
\\041\000\105\002\042\000\105\002\048\000\105\002\050\000\105\002\
\\052\000\105\002\053\000\105\002\066\000\105\002\000\000\001\000\
\\004\000\196\000\000\000\001\000\
\\003\000\077\002\020\000\077\002\058\000\077\002\000\000\001\000\
\\001\000\168\002\002\000\168\002\009\000\168\002\
\\010\000\168\002\011\000\197\000\016\000\168\002\019\000\168\002\
\\022\000\168\002\027\000\168\002\028\000\168\002\032\000\168\002\
\\034\000\168\002\035\000\168\002\037\000\168\002\038\000\168\002\
\\041\000\168\002\042\000\168\002\048\000\168\002\050\000\168\002\
\\052\000\168\002\053\000\168\002\066\000\168\002\000\000\001\000\
\\020\000\151\002\059\000\199\000\000\000\001\000\
\\001\000\170\002\002\000\170\002\009\000\170\002\
\\010\000\170\002\011\000\200\000\016\000\170\002\019\000\170\002\
\\022\000\170\002\027\000\170\002\028\000\170\002\032\000\170\002\
\\034\000\170\002\035\000\170\002\037\000\170\002\038\000\170\002\
\\041\000\170\002\042\000\170\002\048\000\170\002\050\000\170\002\
\\052\000\170\002\053\000\170\002\066\000\170\002\000\000\001\000\
\\020\000\201\000\000\000\001\000\
\\001\000\006\002\002\000\006\002\009\000\006\002\
\\010\000\006\002\011\000\006\002\014\000\006\002\016\000\006\002\
\\018\000\006\002\019\000\006\002\022\000\006\002\023\000\006\002\
\\027\000\006\002\028\000\006\002\032\000\006\002\034\000\006\002\
\\035\000\006\002\037\000\006\002\038\000\006\002\039\000\006\002\
\\041\000\006\002\042\000\006\002\048\000\006\002\050\000\006\002\
\\051\000\006\002\052\000\006\002\053\000\006\002\060\000\006\002\
\\064\000\006\002\065\000\006\002\066\000\006\002\000\000\001\000\
\\059\000\202\000\000\000\001\000\
\\001\000\110\002\002\000\110\002\009\000\110\002\
\\010\000\110\002\016\000\110\002\019\000\110\002\022\000\110\002\
\\027\000\110\002\028\000\110\002\032\000\110\002\034\000\110\002\
\\035\000\110\002\037\000\110\002\038\000\110\002\041\000\110\002\
\\042\000\110\002\048\000\110\002\050\000\110\002\052\000\110\002\
\\053\000\110\002\066\000\110\002\000\000\001\000\
\\001\000\095\002\002\000\095\002\003\000\110\000\
\\009\000\095\002\010\000\095\002\016\000\095\002\019\000\095\002\
\\020\000\042\000\022\000\095\002\027\000\095\002\028\000\095\002\
\\032\000\095\002\034\000\095\002\035\000\095\002\037\000\095\002\
\\038\000\095\002\041\000\095\002\042\000\095\002\048\000\095\002\
\\050\000\095\002\052\000\095\002\053\000\095\002\058\000\021\000\
\\066\000\095\002\000\000\001\000\
\\001\000\215\001\002\000\215\001\003\000\215\001\
\\005\000\215\001\006\000\215\001\007\000\215\001\008\000\215\001\
\\009\000\215\001\010\000\215\001\011\000\215\001\013\000\215\001\
\\014\000\215\001\015\000\215\001\016\000\215\001\018\000\215\001\
\\019\000\215\001\020\000\215\001\021\000\215\001\022\000\215\001\
\\023\000\215\001\025\000\215\001\026\000\215\001\027\000\215\001\
\\028\000\215\001\029\000\215\001\030\000\215\001\031\000\215\001\
\\032\000\215\001\033\000\215\001\034\000\215\001\035\000\215\001\
\\036\000\215\001\037\000\215\001\038\000\215\001\039\000\215\001\
\\040\000\215\001\041\000\215\001\042\000\215\001\044\000\215\001\
\\046\000\215\001\048\000\215\001\050\000\215\001\051\000\215\001\
\\052\000\215\001\053\000\215\001\054\000\215\001\055\000\215\001\
\\058\000\215\001\059\000\215\001\060\000\215\001\061\000\215\001\
\\062\000\215\001\063\000\215\001\064\000\215\001\065\000\215\001\
\\066\000\215\001\067\000\215\001\068\000\215\001\000\000\001\000\
\\001\000\207\001\002\000\207\001\003\000\207\001\
\\005\000\207\001\006\000\207\001\007\000\207\001\008\000\207\001\
\\009\000\207\001\010\000\207\001\011\000\207\001\013\000\207\001\
\\014\000\207\001\015\000\207\001\016\000\207\001\018\000\207\001\
\\019\000\207\001\020\000\207\001\021\000\207\001\022\000\207\001\
\\023\000\207\001\024\000\204\000\025\000\207\001\026\000\207\001\
\\027\000\207\001\028\000\207\001\029\000\207\001\030\000\207\001\
\\031\000\207\001\032\000\207\001\033\000\207\001\034\000\207\001\
\\035\000\207\001\036\000\207\001\037\000\207\001\038\000\207\001\
\\039\000\207\001\040\000\207\001\041\000\207\001\042\000\207\001\
\\044\000\207\001\046\000\207\001\048\000\207\001\050\000\207\001\
\\051\000\207\001\052\000\207\001\053\000\207\001\054\000\207\001\
\\055\000\207\001\058\000\207\001\059\000\207\001\060\000\207\001\
\\061\000\207\001\062\000\207\001\063\000\207\001\064\000\207\001\
\\065\000\207\001\066\000\207\001\067\000\207\001\068\000\207\001\000\000\001\000\
\\001\000\011\002\002\000\011\002\003\000\011\002\
\\005\000\011\002\006\000\011\002\007\000\011\002\008\000\011\002\
\\009\000\011\002\010\000\011\002\011\000\011\002\014\000\011\002\
\\015\000\011\002\016\000\011\002\018\000\011\002\019\000\011\002\
\\020\000\011\002\022\000\011\002\023\000\011\002\026\000\011\002\
\\027\000\011\002\028\000\011\002\029\000\011\002\030\000\011\002\
\\031\000\011\002\032\000\011\002\034\000\011\002\035\000\011\002\
\\036\000\011\002\037\000\011\002\038\000\011\002\039\000\011\002\
\\040\000\011\002\041\000\011\002\042\000\011\002\044\000\011\002\
\\048\000\011\002\050\000\011\002\051\000\011\002\052\000\011\002\
\\053\000\011\002\054\000\011\002\058\000\011\002\059\000\011\002\
\\060\000\011\002\061\000\011\002\062\000\011\002\063\000\011\002\
\\064\000\011\002\065\000\011\002\066\000\011\002\067\000\011\002\
\\068\000\011\002\000\000\001\000\
\\002\000\115\000\009\000\046\000\010\000\045\000\
\\016\000\043\000\019\000\163\002\022\000\041\000\027\000\039\000\
\\028\000\038\000\032\000\163\002\034\000\035\000\035\000\034\000\
\\037\000\114\000\038\000\031\000\041\000\029\000\042\000\028\000\
\\048\000\026\000\050\000\025\000\052\000\024\000\053\000\023\000\
\\066\000\163\002\000\000\001\000\
\\032\000\206\000\000\000\001\000\
\\002\000\115\000\009\000\046\000\010\000\045\000\
\\016\000\043\000\022\000\041\000\027\000\039\000\028\000\038\000\
\\032\000\163\002\034\000\035\000\035\000\034\000\037\000\114\000\
\\038\000\031\000\041\000\029\000\042\000\028\000\048\000\026\000\
\\050\000\025\000\052\000\024\000\053\000\023\000\000\000\001\000\
\\002\000\115\000\009\000\046\000\010\000\045\000\
\\016\000\043\000\019\000\163\002\022\000\041\000\027\000\039\000\
\\028\000\038\000\032\000\163\002\034\000\035\000\035\000\034\000\
\\037\000\114\000\038\000\031\000\041\000\029\000\042\000\028\000\
\\048\000\026\000\050\000\025\000\052\000\024\000\053\000\023\000\
\\066\000\163\002\000\000\001\000\
\\032\000\209\000\000\000\001\000\
\\002\000\119\000\010\000\045\000\016\000\043\000\
\\019\000\115\002\022\000\041\000\027\000\039\000\032\000\115\002\
\\034\000\035\000\035\000\034\000\037\000\118\000\038\000\031\000\
\\041\000\029\000\042\000\028\000\052\000\024\000\053\000\023\000\000\000\001\000\
\\002\000\119\000\010\000\045\000\016\000\043\000\
\\022\000\041\000\027\000\039\000\032\000\115\002\034\000\035\000\
\\035\000\034\000\037\000\118\000\038\000\031\000\041\000\029\000\
\\042\000\028\000\052\000\024\000\053\000\023\000\000\000\001\000\
\\002\000\119\000\010\000\045\000\016\000\043\000\
\\019\000\115\002\022\000\041\000\027\000\039\000\032\000\115\002\
\\034\000\035\000\035\000\034\000\037\000\118\000\038\000\031\000\
\\041\000\029\000\042\000\028\000\052\000\024\000\053\000\023\000\000\000\001\000\
\\003\000\100\002\020\000\100\002\058\000\100\002\000\000\001\000\
\\003\000\098\002\020\000\098\002\058\000\098\002\000\000\001\000\
\\051\000\213\000\000\000\001\000\
\\001\000\016\002\002\000\016\002\003\000\016\002\
\\005\000\016\002\006\000\016\002\007\000\016\002\008\000\016\002\
\\009\000\016\002\010\000\016\002\011\000\016\002\014\000\016\002\
\\015\000\016\002\016\000\016\002\018\000\016\002\019\000\016\002\
\\020\000\016\002\022\000\016\002\023\000\016\002\026\000\016\002\
\\027\000\016\002\028\000\016\002\029\000\016\002\030\000\016\002\
\\031\000\016\002\032\000\016\002\034\000\016\002\035\000\016\002\
\\036\000\016\002\037\000\016\002\038\000\016\002\039\000\016\002\
\\040\000\016\002\041\000\016\002\042\000\016\002\044\000\016\002\
\\048\000\016\002\050\000\016\002\051\000\016\002\052\000\016\002\
\\053\000\016\002\054\000\016\002\058\000\016\002\059\000\016\002\
\\060\000\016\002\061\000\016\002\062\000\016\002\063\000\016\002\
\\064\000\016\002\065\000\016\002\066\000\016\002\067\000\016\002\
\\068\000\016\002\000\000\001\000\
\\001\000\171\002\002\000\171\002\009\000\171\002\
\\010\000\171\002\011\000\214\000\016\000\171\002\019\000\171\002\
\\022\000\171\002\027\000\171\002\028\000\171\002\032\000\171\002\
\\034\000\171\002\035\000\171\002\037\000\171\002\038\000\171\002\
\\041\000\171\002\042\000\171\002\048\000\171\002\050\000\171\002\
\\052\000\171\002\053\000\171\002\066\000\171\002\000\000\001\000\
\\063\000\215\000\000\000\001\000\
\\001\000\065\002\002\000\065\002\009\000\065\002\
\\010\000\065\002\011\000\065\002\014\000\216\000\016\000\065\002\
\\019\000\065\002\022\000\065\002\027\000\065\002\028\000\065\002\
\\032\000\065\002\034\000\065\002\035\000\065\002\037\000\065\002\
\\038\000\065\002\041\000\065\002\042\000\065\002\048\000\065\002\
\\050\000\065\002\052\000\065\002\053\000\065\002\066\000\065\002\000\000\001\000\
\\020\000\061\002\059\000\218\000\000\000\001\000\
\\001\000\104\002\002\000\104\002\009\000\104\002\
\\010\000\104\002\016\000\104\002\019\000\104\002\022\000\104\002\
\\027\000\104\002\028\000\104\002\032\000\104\002\034\000\104\002\
\\035\000\104\002\037\000\104\002\038\000\104\002\041\000\104\002\
\\042\000\104\002\048\000\104\002\050\000\104\002\052\000\104\002\
\\053\000\104\002\066\000\104\002\000\000\001\000\
\\001\000\067\002\002\000\067\002\009\000\067\002\
\\010\000\067\002\011\000\219\000\016\000\067\002\019\000\067\002\
\\022\000\067\002\027\000\067\002\028\000\067\002\032\000\067\002\
\\034\000\067\002\035\000\067\002\037\000\067\002\038\000\067\002\
\\041\000\067\002\042\000\067\002\048\000\067\002\050\000\067\002\
\\052\000\067\002\053\000\067\002\066\000\067\002\000\000\001\000\
\\003\000\096\000\005\000\050\000\006\000\049\000\
\\007\000\095\000\008\000\094\000\020\000\072\002\040\000\093\000\
\\055\000\091\000\058\000\090\000\059\000\072\002\061\000\089\000\
\\062\000\088\000\063\000\087\000\000\000\001\000\
\\003\000\096\000\005\000\050\000\006\000\049\000\
\\007\000\095\000\008\000\094\000\040\000\093\000\055\000\091\000\
\\058\000\090\000\061\000\089\000\062\000\088\000\063\000\087\000\
\\066\000\176\000\000\000\001\000\
\\013\000\174\000\025\000\224\000\000\000\001\000\
\\001\000\237\001\002\000\237\001\009\000\237\001\
\\010\000\237\001\011\000\237\001\014\000\225\000\016\000\237\001\
\\018\000\237\001\019\000\237\001\022\000\237\001\023\000\237\001\
\\027\000\237\001\028\000\237\001\032\000\237\001\034\000\237\001\
\\035\000\237\001\037\000\237\001\038\000\237\001\039\000\237\001\
\\041\000\237\001\042\000\237\001\048\000\237\001\050\000\237\001\
\\051\000\237\001\052\000\237\001\053\000\237\001\060\000\237\001\
\\064\000\237\001\065\000\237\001\066\000\237\001\000\000\001\000\
\\001\000\002\002\002\000\002\002\009\000\002\002\
\\010\000\002\002\011\000\002\002\014\000\002\002\016\000\002\002\
\\018\000\002\002\019\000\002\002\022\000\002\002\023\000\002\002\
\\027\000\002\002\028\000\002\002\032\000\002\002\034\000\002\002\
\\035\000\002\002\037\000\002\002\038\000\002\002\039\000\002\002\
\\041\000\002\002\042\000\002\002\048\000\002\002\050\000\002\002\
\\051\000\002\002\052\000\002\002\053\000\002\002\060\000\002\002\
\\064\000\002\002\065\000\002\002\066\000\002\002\000\000\001\000\
\\001\000\109\002\002\000\109\002\009\000\109\002\
\\010\000\109\002\011\000\226\000\016\000\109\002\019\000\109\002\
\\022\000\109\002\027\000\109\002\028\000\109\002\032\000\109\002\
\\034\000\109\002\035\000\109\002\037\000\109\002\038\000\109\002\
\\041\000\109\002\042\000\109\002\048\000\109\002\050\000\109\002\
\\052\000\109\002\053\000\109\002\066\000\109\002\000\000\001\000\
\\003\000\055\000\020\000\042\000\058\000\021\000\000\000\001\000\
\\003\000\210\001\020\000\210\001\058\000\210\001\000\000\001\000\
\\001\000\083\002\002\000\083\002\009\000\083\002\
\\010\000\083\002\011\000\228\000\016\000\083\002\019\000\083\002\
\\021\000\083\002\022\000\083\002\027\000\083\002\028\000\083\002\
\\032\000\083\002\033\000\083\002\034\000\083\002\035\000\083\002\
\\037\000\083\002\038\000\083\002\041\000\083\002\042\000\083\002\
\\046\000\083\002\048\000\083\002\050\000\083\002\052\000\083\002\
\\053\000\083\002\056\000\083\002\057\000\083\002\066\000\083\002\000\000\001\000\
\\001\000\106\002\002\000\106\002\009\000\106\002\
\\010\000\106\002\016\000\106\002\019\000\106\002\022\000\106\002\
\\027\000\106\002\028\000\106\002\032\000\106\002\034\000\106\002\
\\035\000\106\002\037\000\106\002\038\000\106\002\041\000\106\002\
\\042\000\106\002\048\000\106\002\050\000\106\002\052\000\106\002\
\\053\000\106\002\057\000\229\000\066\000\106\002\000\000\001\000\
\\003\000\055\000\020\000\042\000\058\000\021\000\000\000\001\000\
\\039\000\231\000\000\000\001\000\
\\056\000\232\000\000\000\001\000\
\\001\000\169\002\002\000\169\002\009\000\169\002\
\\010\000\169\002\011\000\197\000\016\000\169\002\019\000\169\002\
\\022\000\169\002\027\000\169\002\028\000\169\002\032\000\169\002\
\\034\000\169\002\035\000\169\002\037\000\169\002\038\000\169\002\
\\041\000\169\002\042\000\169\002\048\000\169\002\050\000\169\002\
\\052\000\169\002\053\000\169\002\066\000\169\002\000\000\001\000\
\\003\000\110\000\020\000\042\000\058\000\021\000\000\000\001\000\
\\001\000\120\002\002\000\120\002\009\000\120\002\
\\010\000\120\002\016\000\120\002\019\000\120\002\021\000\120\002\
\\022\000\120\002\027\000\120\002\028\000\120\002\032\000\120\002\
\\033\000\120\002\034\000\120\002\035\000\120\002\037\000\120\002\
\\038\000\120\002\041\000\120\002\042\000\120\002\046\000\120\002\
\\048\000\120\002\050\000\120\002\052\000\120\002\053\000\120\002\
\\066\000\120\002\000\000\001\000\
\\001\000\249\001\002\000\249\001\009\000\249\001\
\\010\000\249\001\011\000\249\001\014\000\249\001\016\000\249\001\
\\018\000\249\001\019\000\249\001\022\000\249\001\023\000\249\001\
\\027\000\249\001\028\000\249\001\029\000\249\001\032\000\249\001\
\\034\000\249\001\035\000\249\001\037\000\249\001\038\000\249\001\
\\039\000\249\001\041\000\249\001\042\000\249\001\048\000\249\001\
\\050\000\249\001\051\000\249\001\052\000\249\001\053\000\249\001\
\\060\000\249\001\064\000\249\001\065\000\249\001\066\000\249\001\
\\067\000\249\001\000\000\001\000\
\\001\000\246\001\002\000\246\001\009\000\246\001\
\\010\000\246\001\011\000\246\001\014\000\246\001\016\000\246\001\
\\018\000\246\001\019\000\246\001\022\000\246\001\023\000\246\001\
\\027\000\246\001\028\000\246\001\032\000\246\001\034\000\246\001\
\\035\000\246\001\037\000\246\001\038\000\246\001\039\000\246\001\
\\041\000\246\001\042\000\246\001\048\000\246\001\050\000\246\001\
\\051\000\246\001\052\000\246\001\053\000\246\001\060\000\246\001\
\\064\000\246\001\065\000\246\001\066\000\246\001\000\000\001\000\
\\001\000\247\001\002\000\247\001\009\000\247\001\
\\010\000\247\001\011\000\247\001\014\000\247\001\016\000\247\001\
\\018\000\247\001\019\000\247\001\022\000\247\001\023\000\247\001\
\\027\000\247\001\028\000\247\001\032\000\247\001\034\000\247\001\
\\035\000\247\001\037\000\247\001\038\000\247\001\039\000\247\001\
\\041\000\247\001\042\000\247\001\048\000\247\001\050\000\247\001\
\\051\000\247\001\052\000\247\001\053\000\247\001\060\000\247\001\
\\064\000\247\001\065\000\247\001\066\000\247\001\000\000\001\000\
\\001\000\251\001\002\000\251\001\009\000\251\001\
\\010\000\251\001\011\000\251\001\014\000\251\001\016\000\251\001\
\\018\000\251\001\019\000\251\001\022\000\251\001\023\000\251\001\
\\027\000\251\001\028\000\251\001\029\000\251\001\032\000\251\001\
\\034\000\251\001\035\000\251\001\037\000\251\001\038\000\251\001\
\\039\000\251\001\041\000\251\001\042\000\251\001\048\000\251\001\
\\050\000\251\001\051\000\251\001\052\000\251\001\053\000\251\001\
\\060\000\251\001\064\000\251\001\065\000\251\001\066\000\251\001\
\\067\000\251\001\068\000\251\001\000\000\001\000\
\\001\000\255\001\002\000\255\001\009\000\255\001\
\\010\000\255\001\011\000\255\001\014\000\255\001\016\000\255\001\
\\018\000\255\001\019\000\255\001\022\000\255\001\023\000\255\001\
\\027\000\255\001\028\000\255\001\032\000\255\001\034\000\255\001\
\\035\000\255\001\037\000\255\001\038\000\255\001\039\000\255\001\
\\041\000\255\001\042\000\255\001\048\000\255\001\050\000\255\001\
\\051\000\255\001\052\000\255\001\053\000\255\001\060\000\255\001\
\\064\000\255\001\065\000\255\001\066\000\255\001\000\000\001\000\
\\001\000\252\001\002\000\252\001\009\000\252\001\
\\010\000\252\001\011\000\252\001\012\000\236\000\014\000\252\001\
\\016\000\252\001\018\000\252\001\019\000\252\001\022\000\252\001\
\\023\000\252\001\027\000\252\001\028\000\252\001\029\000\252\001\
\\032\000\252\001\034\000\252\001\035\000\252\001\037\000\252\001\
\\038\000\252\001\039\000\252\001\041\000\252\001\042\000\252\001\
\\048\000\252\001\050\000\252\001\051\000\252\001\052\000\252\001\
\\053\000\252\001\060\000\252\001\064\000\252\001\065\000\252\001\
\\066\000\252\001\067\000\252\001\068\000\252\001\000\000\001\000\
\\001\000\232\001\002\000\232\001\009\000\232\001\
\\010\000\232\001\011\000\232\001\012\000\232\001\013\000\232\001\
\\014\000\232\001\016\000\232\001\018\000\232\001\019\000\232\001\
\\020\000\232\001\021\000\232\001\022\000\232\001\023\000\232\001\
\\025\000\232\001\027\000\232\001\028\000\232\001\029\000\232\001\
\\032\000\232\001\033\000\232\001\034\000\232\001\035\000\232\001\
\\037\000\232\001\038\000\232\001\039\000\232\001\041\000\232\001\
\\042\000\232\001\046\000\232\001\048\000\232\001\050\000\232\001\
\\051\000\232\001\052\000\232\001\053\000\232\001\056\000\232\001\
\\057\000\232\001\060\000\232\001\064\000\232\001\065\000\232\001\
\\066\000\232\001\067\000\232\001\068\000\232\001\000\000\001\000\
\\001\000\234\001\002\000\234\001\003\000\158\000\
\\009\000\234\001\010\000\234\001\011\000\234\001\012\000\234\001\
\\013\000\234\001\014\000\234\001\016\000\234\001\018\000\234\001\
\\019\000\234\001\020\000\234\001\021\000\234\001\022\000\234\001\
\\023\000\234\001\025\000\234\001\027\000\234\001\028\000\234\001\
\\029\000\234\001\032\000\234\001\033\000\234\001\034\000\234\001\
\\035\000\234\001\037\000\234\001\038\000\234\001\039\000\234\001\
\\041\000\234\001\042\000\234\001\046\000\234\001\048\000\234\001\
\\050\000\234\001\051\000\234\001\052\000\234\001\053\000\234\001\
\\056\000\234\001\057\000\234\001\058\000\238\000\060\000\234\001\
\\064\000\234\001\065\000\234\001\066\000\234\001\067\000\234\001\
\\068\000\234\001\000\000\001\000\
\\001\000\229\001\002\000\229\001\003\000\229\001\
\\009\000\229\001\010\000\229\001\011\000\229\001\012\000\229\001\
\\013\000\229\001\014\000\229\001\016\000\229\001\018\000\229\001\
\\019\000\229\001\020\000\229\001\021\000\229\001\022\000\229\001\
\\023\000\229\001\025\000\229\001\027\000\229\001\028\000\229\001\
\\029\000\229\001\032\000\229\001\033\000\229\001\034\000\229\001\
\\035\000\229\001\037\000\229\001\038\000\229\001\039\000\229\001\
\\041\000\229\001\042\000\229\001\046\000\229\001\048\000\229\001\
\\050\000\229\001\051\000\229\001\052\000\229\001\053\000\229\001\
\\056\000\229\001\057\000\229\001\058\000\229\001\060\000\229\001\
\\064\000\229\001\065\000\229\001\066\000\229\001\067\000\229\001\
\\068\000\229\001\000\000\001\000\
\\003\000\158\000\004\000\157\000\061\000\156\000\
\\063\000\155\000\000\000\001\000\
\\003\000\077\000\005\000\076\000\064\000\244\000\000\000\001\000\
\\001\000\223\001\002\000\223\001\003\000\223\001\
\\009\000\223\001\010\000\223\001\011\000\223\001\012\000\223\001\
\\013\000\223\001\014\000\223\001\016\000\223\001\018\000\223\001\
\\019\000\223\001\020\000\223\001\021\000\223\001\022\000\223\001\
\\023\000\223\001\025\000\223\001\027\000\223\001\028\000\223\001\
\\029\000\223\001\032\000\223\001\033\000\223\001\034\000\223\001\
\\035\000\223\001\037\000\223\001\038\000\223\001\039\000\223\001\
\\041\000\223\001\042\000\223\001\046\000\223\001\048\000\223\001\
\\050\000\223\001\051\000\223\001\052\000\223\001\053\000\223\001\
\\056\000\223\001\057\000\223\001\058\000\223\001\060\000\223\001\
\\064\000\223\001\065\000\223\001\066\000\223\001\067\000\223\001\
\\068\000\223\001\000\000\001\000\
\\001\000\219\001\002\000\219\001\003\000\219\001\
\\009\000\219\001\010\000\219\001\011\000\219\001\012\000\219\001\
\\013\000\219\001\014\000\219\001\016\000\219\001\018\000\219\001\
\\019\000\219\001\020\000\219\001\021\000\219\001\022\000\219\001\
\\023\000\219\001\024\000\245\000\025\000\219\001\027\000\219\001\
\\028\000\219\001\029\000\219\001\032\000\219\001\033\000\219\001\
\\034\000\219\001\035\000\219\001\037\000\219\001\038\000\219\001\
\\039\000\219\001\041\000\219\001\042\000\219\001\046\000\219\001\
\\048\000\219\001\050\000\219\001\051\000\219\001\052\000\219\001\
\\053\000\219\001\056\000\219\001\057\000\219\001\058\000\219\001\
\\060\000\219\001\064\000\219\001\065\000\219\001\066\000\219\001\
\\067\000\219\001\068\000\219\001\000\000\001\000\
\\001\000\180\002\002\000\180\002\000\000\001\000\
\\001\000\021\002\002\000\021\002\003\000\021\002\
\\005\000\021\002\006\000\021\002\007\000\021\002\008\000\021\002\
\\009\000\021\002\010\000\021\002\011\000\021\002\014\000\021\002\
\\015\000\021\002\016\000\021\002\018\000\021\002\019\000\021\002\
\\020\000\021\002\022\000\021\002\023\000\021\002\026\000\021\002\
\\027\000\021\002\028\000\021\002\029\000\021\002\030\000\021\002\
\\031\000\021\002\032\000\021\002\034\000\021\002\035\000\021\002\
\\036\000\021\002\037\000\021\002\038\000\021\002\039\000\021\002\
\\040\000\021\002\041\000\021\002\042\000\021\002\044\000\021\002\
\\048\000\021\002\050\000\021\002\051\000\021\002\052\000\021\002\
\\053\000\021\002\054\000\021\002\058\000\021\002\059\000\021\002\
\\060\000\021\002\061\000\021\002\062\000\021\002\063\000\021\002\
\\064\000\021\002\065\000\021\002\066\000\021\002\067\000\021\002\
\\068\000\021\002\000\000\001\000\
\\003\000\051\000\005\000\050\000\006\000\049\000\
\\007\000\048\000\008\000\047\000\015\000\044\000\020\000\042\000\
\\026\000\040\000\030\000\037\000\031\000\036\000\036\000\033\000\
\\040\000\030\000\044\000\027\000\054\000\022\000\058\000\021\000\
\\061\000\020\000\062\000\019\000\063\000\018\000\000\000\001\000\
\\003\000\051\000\005\000\050\000\006\000\049\000\
\\007\000\048\000\008\000\047\000\015\000\044\000\020\000\042\000\
\\026\000\040\000\030\000\037\000\031\000\036\000\036\000\033\000\
\\040\000\030\000\044\000\027\000\054\000\022\000\058\000\021\000\
\\061\000\020\000\062\000\019\000\063\000\018\000\000\000\001\000\
\\001\000\020\002\002\000\020\002\003\000\020\002\
\\005\000\020\002\006\000\020\002\007\000\020\002\008\000\020\002\
\\009\000\020\002\010\000\020\002\011\000\020\002\014\000\020\002\
\\015\000\020\002\016\000\020\002\018\000\020\002\019\000\020\002\
\\020\000\020\002\022\000\020\002\023\000\020\002\026\000\020\002\
\\027\000\020\002\028\000\020\002\029\000\020\002\030\000\020\002\
\\031\000\020\002\032\000\020\002\034\000\020\002\035\000\020\002\
\\036\000\020\002\037\000\020\002\038\000\020\002\039\000\020\002\
\\040\000\020\002\041\000\020\002\042\000\020\002\044\000\020\002\
\\048\000\020\002\050\000\020\002\051\000\020\002\052\000\020\002\
\\053\000\020\002\054\000\020\002\058\000\020\002\059\000\020\002\
\\060\000\020\002\061\000\020\002\062\000\020\002\063\000\020\002\
\\064\000\020\002\065\000\020\002\066\000\020\002\067\000\020\002\
\\068\000\020\002\000\000\001\000\
\\001\000\022\002\002\000\022\002\003\000\022\002\
\\005\000\022\002\006\000\022\002\007\000\022\002\008\000\022\002\
\\009\000\022\002\010\000\022\002\011\000\022\002\014\000\022\002\
\\015\000\022\002\016\000\022\002\018\000\022\002\019\000\022\002\
\\020\000\022\002\022\000\022\002\023\000\022\002\026\000\022\002\
\\027\000\022\002\028\000\022\002\029\000\022\002\030\000\022\002\
\\031\000\022\002\032\000\022\002\034\000\022\002\035\000\022\002\
\\036\000\022\002\037\000\022\002\038\000\022\002\039\000\022\002\
\\040\000\022\002\041\000\022\002\042\000\022\002\044\000\022\002\
\\048\000\022\002\050\000\022\002\051\000\022\002\052\000\022\002\
\\053\000\022\002\054\000\022\002\058\000\022\002\059\000\022\002\
\\060\000\022\002\061\000\022\002\062\000\022\002\063\000\022\002\
\\064\000\022\002\065\000\022\002\066\000\022\002\067\000\022\002\
\\068\000\022\002\000\000\001\000\
\\003\000\051\000\005\000\050\000\006\000\049\000\
\\007\000\048\000\008\000\047\000\015\000\044\000\020\000\042\000\
\\026\000\040\000\030\000\037\000\031\000\036\000\036\000\033\000\
\\040\000\030\000\044\000\027\000\054\000\022\000\058\000\021\000\
\\061\000\020\000\062\000\019\000\063\000\018\000\000\000\001\000\
\\001\000\017\002\002\000\017\002\003\000\017\002\
\\005\000\017\002\006\000\017\002\007\000\017\002\008\000\017\002\
\\009\000\017\002\010\000\017\002\011\000\017\002\014\000\017\002\
\\015\000\017\002\016\000\017\002\018\000\017\002\019\000\017\002\
\\020\000\017\002\022\000\017\002\023\000\017\002\026\000\017\002\
\\027\000\017\002\028\000\017\002\029\000\017\002\030\000\017\002\
\\031\000\017\002\032\000\017\002\034\000\017\002\035\000\017\002\
\\036\000\017\002\037\000\017\002\038\000\017\002\039\000\017\002\
\\040\000\017\002\041\000\017\002\042\000\017\002\044\000\017\002\
\\048\000\017\002\050\000\017\002\051\000\017\002\052\000\017\002\
\\053\000\017\002\054\000\017\002\058\000\017\002\059\000\017\002\
\\060\000\017\002\061\000\017\002\062\000\017\002\063\000\017\002\
\\064\000\017\002\065\000\017\002\066\000\017\002\067\000\017\002\
\\068\000\017\002\000\000\001\000\
\\003\000\077\000\005\000\076\000\000\000\001\000\
\\003\000\051\000\005\000\050\000\006\000\049\000\
\\007\000\048\000\008\000\047\000\015\000\044\000\020\000\042\000\
\\026\000\040\000\030\000\037\000\031\000\036\000\036\000\033\000\
\\040\000\030\000\044\000\027\000\054\000\022\000\058\000\021\000\
\\061\000\020\000\062\000\019\000\063\000\018\000\000\000\001\000\
\\003\000\051\000\005\000\050\000\006\000\049\000\
\\007\000\048\000\008\000\047\000\015\000\044\000\020\000\042\000\
\\026\000\040\000\030\000\037\000\031\000\036\000\036\000\033\000\
\\040\000\030\000\044\000\027\000\054\000\022\000\058\000\021\000\
\\061\000\020\000\062\000\019\000\063\000\018\000\000\000\001\000\
\\003\000\096\000\005\000\050\000\006\000\049\000\
\\007\000\095\000\008\000\094\000\040\000\093\000\055\000\091\000\
\\058\000\090\000\061\000\089\000\062\000\088\000\063\000\087\000\000\000\001\000\
\\013\000\030\002\020\000\030\002\025\000\030\002\
\\059\000\255\000\060\000\030\002\064\000\030\002\065\000\030\002\
\\066\000\030\002\000\000\001\000\
\\003\000\096\000\005\000\050\000\006\000\049\000\
\\007\000\095\000\008\000\094\000\013\000\072\002\020\000\072\002\
\\025\000\072\002\040\000\093\000\055\000\091\000\058\000\090\000\
\\059\000\072\002\060\000\072\002\061\000\089\000\062\000\088\000\
\\063\000\087\000\064\000\072\002\065\000\072\002\066\000\072\002\000\000\001\000\
\\003\000\051\000\005\000\050\000\006\000\049\000\
\\007\000\048\000\008\000\047\000\015\000\044\000\020\000\042\000\
\\026\000\040\000\030\000\037\000\031\000\036\000\036\000\033\000\
\\040\000\030\000\044\000\027\000\054\000\022\000\058\000\021\000\
\\061\000\020\000\062\000\019\000\063\000\018\000\000\000\001\000\
\\003\000\096\000\005\000\050\000\006\000\049\000\
\\007\000\095\000\008\000\094\000\040\000\093\000\055\000\091\000\
\\058\000\090\000\061\000\089\000\062\000\088\000\063\000\087\000\000\000\001\000\
\\013\000\174\000\060\000\004\001\066\000\003\001\000\000\001\000\
\\003\000\037\002\005\000\037\002\006\000\037\002\
\\007\000\037\002\008\000\037\002\013\000\037\002\020\000\037\002\
\\025\000\037\002\040\000\037\002\055\000\037\002\058\000\037\002\
\\059\000\037\002\060\000\037\002\061\000\037\002\062\000\037\002\
\\063\000\037\002\064\000\037\002\065\000\037\002\066\000\037\002\000\000\001\000\
\\065\000\005\001\000\000\001\000\
\\013\000\174\000\060\000\006\001\065\000\057\002\
\\066\000\057\002\000\000\001\000\
\\003\000\045\002\005\000\045\002\006\000\045\002\
\\007\000\045\002\008\000\045\002\013\000\045\002\020\000\045\002\
\\025\000\045\002\040\000\045\002\055\000\045\002\058\000\045\002\
\\059\000\045\002\060\000\045\002\061\000\045\002\062\000\045\002\
\\063\000\045\002\064\000\045\002\065\000\045\002\066\000\045\002\000\000\001\000\
\\064\000\007\001\000\000\001\000\
\\060\000\008\001\064\000\055\002\000\000\001\000\
\\020\000\009\001\000\000\001\000\
\\003\000\047\002\005\000\047\002\006\000\047\002\
\\007\000\047\002\008\000\047\002\013\000\047\002\020\000\047\002\
\\025\000\047\002\040\000\047\002\055\000\047\002\058\000\047\002\
\\059\000\047\002\060\000\047\002\061\000\047\002\062\000\047\002\
\\063\000\047\002\064\000\047\002\065\000\047\002\066\000\047\002\000\000\001\000\
\\064\000\056\002\000\000\001\000\
\\013\000\011\001\020\000\216\001\059\000\010\001\
\\060\000\050\002\064\000\050\002\000\000\001\000\
\\001\000\103\002\002\000\103\002\009\000\103\002\
\\010\000\103\002\011\000\012\001\016\000\103\002\019\000\103\002\
\\022\000\103\002\027\000\103\002\028\000\103\002\032\000\103\002\
\\034\000\103\002\035\000\103\002\037\000\103\002\038\000\103\002\
\\041\000\103\002\042\000\103\002\048\000\103\002\050\000\103\002\
\\052\000\103\002\053\000\103\002\066\000\103\002\000\000\001\000\
\\020\000\061\002\059\000\218\000\000\000\001\000\
\\020\000\212\001\059\000\212\001\000\000\001\000\
\\003\000\055\000\020\000\042\000\058\000\021\000\000\000\001\000\
\\020\000\205\001\059\000\205\001\000\000\001\000\
\\003\000\039\002\005\000\039\002\006\000\039\002\
\\007\000\039\002\008\000\039\002\013\000\039\002\020\000\039\002\
\\025\000\039\002\040\000\039\002\055\000\039\002\058\000\039\002\
\\059\000\039\002\060\000\039\002\061\000\039\002\062\000\039\002\
\\063\000\039\002\064\000\039\002\065\000\039\002\066\000\039\002\000\000\001\000\
\\003\000\110\000\020\000\042\000\058\000\021\000\000\000\001\000\
\\020\000\016\001\000\000\001\000\
\\003\000\079\002\004\000\100\000\020\000\079\002\
\\058\000\079\002\063\000\099\000\000\000\001\000\
\\066\000\018\001\000\000\001\000\
\\060\000\019\001\066\000\080\002\000\000\001\000\
\\003\000\055\000\020\000\042\000\058\000\021\000\000\000\001\000\
\\020\000\021\001\000\000\001\000\
\\003\000\024\001\047\000\023\001\000\000\001\000\
\\003\000\055\000\020\000\042\000\058\000\021\000\000\000\001\000\
\\003\000\024\001\047\000\023\001\000\000\001\000\
\\003\000\158\000\004\000\157\000\061\000\156\000\
\\063\000\155\000\000\000\001\000\
\\001\000\096\002\002\000\096\002\009\000\096\002\
\\010\000\096\002\016\000\096\002\019\000\096\002\022\000\096\002\
\\027\000\096\002\028\000\096\002\032\000\096\002\034\000\096\002\
\\035\000\096\002\037\000\096\002\038\000\096\002\041\000\096\002\
\\042\000\096\002\048\000\096\002\050\000\096\002\052\000\096\002\
\\053\000\096\002\066\000\096\002\000\000\001\000\
\\003\000\110\000\020\000\042\000\058\000\021\000\000\000\001\000\
\\019\000\160\002\032\000\160\002\066\000\160\002\000\000\001\000\
\\002\000\115\000\009\000\046\000\010\000\045\000\
\\016\000\043\000\019\000\163\002\022\000\041\000\027\000\039\000\
\\028\000\038\000\034\000\035\000\035\000\034\000\037\000\114\000\
\\038\000\031\000\041\000\029\000\042\000\028\000\048\000\026\000\
\\050\000\025\000\052\000\024\000\053\000\023\000\000\000\001\000\
\\032\000\030\001\000\000\001\000\
\\019\000\161\002\032\000\161\002\066\000\161\002\000\000\001\000\
\\003\000\051\000\005\000\050\000\006\000\049\000\
\\007\000\048\000\008\000\047\000\015\000\044\000\020\000\042\000\
\\026\000\040\000\030\000\037\000\031\000\036\000\036\000\033\000\
\\040\000\030\000\044\000\027\000\054\000\022\000\058\000\021\000\
\\061\000\020\000\062\000\019\000\063\000\018\000\000\000\001\000\
\\019\000\116\002\032\000\116\002\000\000\001\000\
\\032\000\032\001\000\000\001\000\
\\019\000\117\002\032\000\117\002\000\000\001\000\
\\003\000\051\000\005\000\050\000\006\000\049\000\
\\007\000\048\000\008\000\047\000\015\000\044\000\020\000\042\000\
\\026\000\040\000\030\000\037\000\031\000\036\000\036\000\033\000\
\\040\000\030\000\044\000\027\000\054\000\022\000\058\000\021\000\
\\061\000\020\000\062\000\019\000\063\000\018\000\000\000\001\000\
\\003\000\055\000\020\000\042\000\058\000\021\000\000\000\001\000\
\\002\000\050\001\003\000\049\001\016\000\048\001\
\\021\000\047\001\022\000\046\001\033\000\045\001\034\000\035\000\
\\035\000\034\000\037\000\044\001\038\000\031\000\041\000\043\001\
\\046\000\042\001\050\000\041\001\052\000\040\001\053\000\039\001\
\\066\000\121\002\000\000\001\000\
\\003\000\096\000\005\000\050\000\006\000\049\000\
\\007\000\095\000\008\000\094\000\040\000\093\000\055\000\091\000\
\\058\000\090\000\061\000\089\000\062\000\088\000\063\000\131\000\000\000\001\000\
\\020\000\052\001\000\000\001\000\
\\003\000\158\000\004\000\157\000\061\000\156\000\
\\063\000\155\000\000\000\001\000\
\\003\000\096\000\005\000\050\000\006\000\049\000\
\\007\000\095\000\008\000\094\000\040\000\093\000\055\000\091\000\
\\058\000\090\000\061\000\089\000\062\000\088\000\063\000\131\000\000\000\001\000\
\\020\000\071\002\059\000\071\002\000\000\001\000\
\\003\000\096\000\005\000\050\000\006\000\049\000\
\\007\000\095\000\008\000\094\000\013\000\072\002\040\000\093\000\
\\055\000\091\000\058\000\090\000\059\000\072\002\060\000\072\002\
\\061\000\089\000\062\000\088\000\063\000\087\000\066\000\072\002\000\000\001\000\
\\013\000\029\002\060\000\029\002\066\000\056\001\000\000\001\000\
\\013\000\174\000\060\000\004\001\000\000\001\000\
\\003\000\051\000\005\000\050\000\006\000\049\000\
\\007\000\048\000\008\000\047\000\015\000\044\000\020\000\042\000\
\\026\000\040\000\030\000\037\000\031\000\036\000\036\000\033\000\
\\040\000\030\000\044\000\027\000\054\000\022\000\058\000\021\000\
\\061\000\020\000\062\000\019\000\063\000\018\000\000\000\001\000\
\\003\000\096\000\005\000\050\000\006\000\049\000\
\\007\000\095\000\008\000\094\000\040\000\093\000\055\000\091\000\
\\058\000\090\000\061\000\089\000\062\000\088\000\063\000\087\000\000\000\001\000\
\\003\000\211\001\020\000\211\001\040\000\137\000\
\\058\000\211\001\000\000\001\000\
\\001\000\089\002\002\000\089\002\009\000\089\002\
\\010\000\089\002\011\000\089\002\016\000\089\002\019\000\089\002\
\\020\000\061\001\022\000\089\002\027\000\089\002\028\000\089\002\
\\032\000\089\002\034\000\089\002\035\000\089\002\037\000\089\002\
\\038\000\089\002\039\000\060\001\041\000\089\002\042\000\089\002\
\\048\000\089\002\050\000\089\002\052\000\089\002\053\000\089\002\
\\066\000\089\002\000\000\001\000\
\\003\000\079\002\004\000\100\000\020\000\079\002\
\\058\000\079\002\063\000\099\000\000\000\001\000\
\\003\000\079\002\004\000\100\000\020\000\079\002\
\\058\000\079\002\063\000\099\000\000\000\001\000\
\\020\000\064\001\000\000\001\000\
\\003\000\096\000\005\000\050\000\006\000\049\000\
\\007\000\095\000\008\000\094\000\040\000\093\000\055\000\091\000\
\\058\000\090\000\061\000\089\000\062\000\088\000\063\000\087\000\000\000\001\000\
\\002\000\119\000\010\000\045\000\016\000\043\000\
\\019\000\115\002\022\000\041\000\027\000\039\000\034\000\035\000\
\\035\000\034\000\037\000\118\000\038\000\031\000\041\000\029\000\
\\042\000\028\000\052\000\024\000\053\000\023\000\000\000\001\000\
\\001\000\012\002\002\000\012\002\003\000\012\002\
\\005\000\012\002\006\000\012\002\007\000\012\002\008\000\012\002\
\\009\000\012\002\010\000\012\002\011\000\012\002\014\000\012\002\
\\015\000\012\002\016\000\012\002\018\000\012\002\019\000\012\002\
\\020\000\012\002\022\000\012\002\023\000\012\002\026\000\012\002\
\\027\000\012\002\028\000\012\002\029\000\012\002\030\000\012\002\
\\031\000\012\002\032\000\012\002\034\000\012\002\035\000\012\002\
\\036\000\012\002\037\000\012\002\038\000\012\002\039\000\012\002\
\\040\000\012\002\041\000\012\002\042\000\012\002\044\000\012\002\
\\048\000\012\002\050\000\012\002\051\000\012\002\052\000\012\002\
\\053\000\012\002\054\000\012\002\058\000\012\002\059\000\012\002\
\\060\000\012\002\061\000\012\002\062\000\012\002\063\000\012\002\
\\064\000\012\002\065\000\012\002\066\000\012\002\067\000\012\002\
\\068\000\012\002\000\000\001\000\
\\003\000\051\000\005\000\050\000\006\000\049\000\
\\007\000\048\000\008\000\047\000\020\000\042\000\030\000\037\000\
\\036\000\033\000\040\000\030\000\058\000\021\000\061\000\020\000\
\\062\000\019\000\063\000\018\000\000\000\001\000\
\\003\000\051\000\005\000\050\000\006\000\049\000\
\\007\000\048\000\008\000\047\000\020\000\042\000\030\000\037\000\
\\036\000\033\000\040\000\030\000\058\000\021\000\061\000\020\000\
\\062\000\019\000\063\000\018\000\000\000\001\000\
\\003\000\158\000\004\000\157\000\061\000\156\000\
\\063\000\155\000\000\000\001\000\
\\001\000\228\001\002\000\228\001\003\000\228\001\
\\009\000\228\001\010\000\228\001\011\000\228\001\012\000\228\001\
\\013\000\228\001\014\000\228\001\016\000\228\001\018\000\228\001\
\\019\000\228\001\020\000\228\001\021\000\228\001\022\000\228\001\
\\023\000\228\001\025\000\228\001\027\000\228\001\028\000\228\001\
\\029\000\228\001\032\000\228\001\033\000\228\001\034\000\228\001\
\\035\000\228\001\037\000\228\001\038\000\228\001\039\000\228\001\
\\041\000\228\001\042\000\228\001\046\000\228\001\048\000\228\001\
\\050\000\228\001\051\000\228\001\052\000\228\001\053\000\228\001\
\\056\000\228\001\057\000\228\001\058\000\228\001\060\000\228\001\
\\064\000\228\001\065\000\228\001\066\000\228\001\067\000\228\001\
\\068\000\228\001\000\000\001\000\
\\003\000\158\000\004\000\157\000\061\000\156\000\
\\063\000\155\000\000\000\001\000\
\\066\000\072\001\000\000\001\000\
\\012\000\236\000\060\000\074\001\066\000\073\001\000\000\001\000\
\\064\000\075\001\000\000\001\000\
\\060\000\076\001\064\000\222\001\000\000\001\000\
\\059\000\077\001\000\000\001\000\
\\001\000\225\001\002\000\225\001\003\000\225\001\
\\009\000\225\001\010\000\225\001\011\000\225\001\012\000\225\001\
\\013\000\225\001\014\000\225\001\016\000\225\001\018\000\225\001\
\\019\000\225\001\020\000\225\001\021\000\225\001\022\000\225\001\
\\023\000\225\001\025\000\225\001\027\000\225\001\028\000\225\001\
\\029\000\225\001\032\000\225\001\033\000\225\001\034\000\225\001\
\\035\000\225\001\037\000\225\001\038\000\225\001\039\000\225\001\
\\041\000\225\001\042\000\225\001\046\000\225\001\048\000\225\001\
\\050\000\225\001\051\000\225\001\052\000\225\001\053\000\225\001\
\\056\000\225\001\057\000\225\001\058\000\225\001\060\000\225\001\
\\064\000\225\001\065\000\225\001\066\000\225\001\067\000\225\001\
\\068\000\225\001\000\000\001\000\
\\003\000\158\000\000\000\001\000\
\\066\000\025\002\000\000\001\000\
\\060\000\161\000\066\000\026\002\000\000\001\000\
\\002\000\162\000\019\000\243\001\066\000\243\001\000\000\001\000\
\\019\000\244\001\066\000\244\001\000\000\001\000\
\\065\000\028\002\000\000\001\000\
\\064\000\241\001\000\000\001\000\
\\060\000\240\001\064\000\240\001\000\000\001\000\
\\001\000\004\002\002\000\004\002\009\000\004\002\
\\010\000\004\002\011\000\004\002\014\000\004\002\016\000\004\002\
\\018\000\004\002\019\000\004\002\022\000\004\002\023\000\004\002\
\\027\000\004\002\028\000\004\002\032\000\004\002\034\000\004\002\
\\035\000\004\002\037\000\004\002\038\000\004\002\039\000\004\002\
\\041\000\004\002\042\000\004\002\048\000\004\002\050\000\004\002\
\\051\000\004\002\052\000\004\002\053\000\004\002\060\000\004\002\
\\064\000\004\002\065\000\004\002\066\000\004\002\000\000\001\000\
\\001\000\059\002\002\000\059\002\009\000\059\002\
\\010\000\059\002\011\000\170\000\016\000\059\002\019\000\059\002\
\\022\000\059\002\027\000\059\002\028\000\059\002\032\000\059\002\
\\034\000\059\002\035\000\059\002\037\000\059\002\038\000\059\002\
\\041\000\059\002\042\000\059\002\048\000\059\002\050\000\059\002\
\\052\000\059\002\053\000\059\002\066\000\059\002\000\000\001\000\
\\003\000\158\000\004\000\157\000\061\000\156\000\
\\063\000\155\000\000\000\001\000\
\\013\000\073\002\020\000\073\002\025\000\073\002\
\\059\000\073\002\060\000\073\002\064\000\073\002\065\000\073\002\
\\066\000\073\002\000\000\001\000\
\\001\000\060\002\002\000\060\002\009\000\060\002\
\\010\000\060\002\011\000\060\002\016\000\060\002\019\000\060\002\
\\022\000\060\002\027\000\060\002\028\000\060\002\032\000\060\002\
\\034\000\060\002\035\000\060\002\037\000\060\002\038\000\060\002\
\\041\000\060\002\042\000\060\002\048\000\060\002\050\000\060\002\
\\052\000\060\002\053\000\060\002\066\000\060\002\000\000\001\000\
\\013\000\174\000\020\000\031\002\025\000\031\002\
\\060\000\031\002\064\000\031\002\065\000\031\002\066\000\031\002\000\000\001\000\
\\003\000\034\002\005\000\034\002\006\000\034\002\
\\007\000\034\002\008\000\034\002\013\000\034\002\020\000\034\002\
\\025\000\034\002\040\000\034\002\055\000\034\002\058\000\034\002\
\\059\000\034\002\060\000\034\002\061\000\034\002\062\000\034\002\
\\063\000\034\002\064\000\034\002\065\000\034\002\066\000\034\002\000\000\001\000\
\\003\000\096\000\005\000\050\000\006\000\049\000\
\\007\000\095\000\008\000\094\000\040\000\093\000\055\000\091\000\
\\058\000\090\000\061\000\089\000\062\000\088\000\063\000\087\000\000\000\001\000\
\\003\000\046\002\005\000\046\002\006\000\046\002\
\\007\000\046\002\008\000\046\002\013\000\046\002\020\000\046\002\
\\025\000\046\002\040\000\046\002\055\000\046\002\058\000\046\002\
\\059\000\046\002\060\000\046\002\061\000\046\002\062\000\046\002\
\\063\000\046\002\064\000\046\002\065\000\046\002\066\000\046\002\000\000\001\000\
\\003\000\096\000\005\000\050\000\006\000\049\000\
\\007\000\095\000\008\000\094\000\040\000\093\000\055\000\091\000\
\\058\000\090\000\061\000\089\000\062\000\088\000\063\000\087\000\000\000\001\000\
\\003\000\048\002\005\000\048\002\006\000\048\002\
\\007\000\048\002\008\000\048\002\013\000\048\002\020\000\048\002\
\\025\000\048\002\040\000\048\002\055\000\048\002\058\000\048\002\
\\059\000\048\002\060\000\048\002\061\000\048\002\062\000\048\002\
\\063\000\048\002\064\000\048\002\065\000\048\002\066\000\048\002\000\000\001\000\
\\003\000\185\000\005\000\076\000\017\000\184\000\000\000\001\000\
\\003\000\096\000\005\000\050\000\006\000\049\000\
\\007\000\095\000\008\000\094\000\040\000\093\000\055\000\091\000\
\\058\000\090\000\061\000\089\000\062\000\088\000\063\000\087\000\000\000\001\000\
\\003\000\158\000\004\000\157\000\061\000\156\000\
\\063\000\155\000\000\000\001\000\
\\003\000\096\000\005\000\050\000\006\000\049\000\
\\007\000\095\000\008\000\094\000\040\000\093\000\055\000\091\000\
\\058\000\090\000\061\000\089\000\062\000\088\000\063\000\087\000\000\000\001\000\
\\003\000\190\000\040\000\189\000\058\000\090\000\000\000\001\000\
\\020\000\087\001\000\000\001\000\
\\020\000\213\001\059\000\213\001\000\000\001\000\
\\003\000\040\002\005\000\040\002\006\000\040\002\
\\007\000\040\002\008\000\040\002\013\000\040\002\020\000\040\002\
\\025\000\040\002\040\000\040\002\055\000\040\002\058\000\040\002\
\\059\000\040\002\060\000\040\002\061\000\040\002\062\000\040\002\
\\063\000\040\002\064\000\040\002\065\000\040\002\066\000\040\002\000\000\001\000\
\\003\000\158\000\004\000\157\000\061\000\156\000\
\\063\000\155\000\000\000\001\000\
\\001\000\076\002\002\000\076\002\009\000\076\002\
\\010\000\076\002\011\000\194\000\016\000\076\002\019\000\076\002\
\\022\000\076\002\027\000\076\002\028\000\076\002\032\000\076\002\
\\034\000\076\002\035\000\076\002\037\000\076\002\038\000\076\002\
\\041\000\076\002\042\000\076\002\048\000\076\002\050\000\076\002\
\\052\000\076\002\053\000\076\002\066\000\076\002\000\000\001\000\
\\003\000\078\002\020\000\078\002\058\000\078\002\000\000\001\000\
\\004\000\196\000\000\000\001\000\
\\001\000\174\002\002\000\174\002\009\000\174\002\
\\010\000\174\002\011\000\197\000\016\000\174\002\019\000\174\002\
\\022\000\174\002\027\000\174\002\028\000\174\002\032\000\174\002\
\\034\000\174\002\035\000\174\002\037\000\174\002\038\000\174\002\
\\041\000\174\002\042\000\174\002\048\000\174\002\050\000\174\002\
\\052\000\174\002\053\000\174\002\066\000\174\002\000\000\001\000\
\\003\000\094\001\020\000\042\000\036\000\093\001\
\\049\000\092\001\058\000\021\000\000\000\001\000\
\\020\000\152\002\000\000\001\000\
\\002\000\050\001\016\000\048\001\019\000\121\002\
\\021\000\047\001\022\000\046\001\033\000\045\001\034\000\035\000\
\\035\000\034\000\037\000\044\001\038\000\031\000\041\000\043\001\
\\046\000\042\001\050\000\041\001\052\000\040\001\053\000\039\001\000\000\001\000\
\\001\000\149\002\002\000\149\002\009\000\149\002\
\\010\000\149\002\011\000\149\002\016\000\149\002\019\000\149\002\
\\020\000\149\002\021\000\149\002\022\000\149\002\027\000\149\002\
\\028\000\149\002\032\000\149\002\033\000\149\002\034\000\149\002\
\\035\000\149\002\037\000\149\002\038\000\149\002\041\000\149\002\
\\042\000\149\002\046\000\149\002\048\000\149\002\050\000\149\002\
\\052\000\149\002\053\000\149\002\066\000\149\002\000\000\001\000\
\\001\000\153\002\002\000\153\002\009\000\153\002\
\\010\000\153\002\011\000\200\000\016\000\153\002\019\000\153\002\
\\022\000\153\002\027\000\153\002\028\000\153\002\032\000\153\002\
\\034\000\153\002\035\000\153\002\037\000\153\002\038\000\153\002\
\\041\000\153\002\042\000\153\002\048\000\153\002\050\000\153\002\
\\052\000\153\002\053\000\153\002\066\000\153\002\000\000\001\000\
\\001\000\154\002\002\000\154\002\009\000\154\002\
\\010\000\154\002\011\000\154\002\016\000\154\002\019\000\154\002\
\\022\000\154\002\027\000\154\002\028\000\154\002\032\000\154\002\
\\034\000\154\002\035\000\154\002\037\000\154\002\038\000\154\002\
\\041\000\154\002\042\000\154\002\048\000\154\002\050\000\154\002\
\\052\000\154\002\053\000\154\002\066\000\154\002\000\000\001\000\
\\012\000\236\000\013\000\096\001\000\000\001\000\
\\001\000\214\001\002\000\214\001\003\000\214\001\
\\005\000\214\001\006\000\214\001\007\000\214\001\008\000\214\001\
\\009\000\214\001\010\000\214\001\011\000\214\001\013\000\214\001\
\\014\000\214\001\015\000\214\001\016\000\214\001\018\000\214\001\
\\019\000\214\001\020\000\214\001\021\000\214\001\022\000\214\001\
\\023\000\214\001\025\000\214\001\026\000\214\001\027\000\214\001\
\\028\000\214\001\029\000\214\001\030\000\214\001\031\000\214\001\
\\032\000\214\001\033\000\214\001\034\000\214\001\035\000\214\001\
\\036\000\214\001\037\000\214\001\038\000\214\001\039\000\214\001\
\\040\000\214\001\041\000\214\001\042\000\214\001\044\000\214\001\
\\046\000\214\001\048\000\214\001\050\000\214\001\051\000\214\001\
\\052\000\214\001\053\000\214\001\054\000\214\001\055\000\214\001\
\\058\000\214\001\059\000\214\001\060\000\214\001\061\000\214\001\
\\062\000\214\001\063\000\214\001\064\000\214\001\065\000\214\001\
\\066\000\214\001\067\000\214\001\068\000\214\001\000\000\001\000\
\\019\000\097\001\000\000\001\000\
\\002\000\115\000\009\000\046\000\010\000\045\000\
\\016\000\043\000\019\000\163\002\022\000\041\000\027\000\039\000\
\\028\000\038\000\034\000\035\000\035\000\034\000\037\000\114\000\
\\038\000\031\000\041\000\029\000\042\000\028\000\048\000\026\000\
\\050\000\025\000\052\000\024\000\053\000\023\000\000\000\001\000\
\\019\000\099\001\000\000\001\000\
\\002\000\119\000\010\000\045\000\016\000\043\000\
\\019\000\115\002\022\000\041\000\027\000\039\000\034\000\035\000\
\\035\000\034\000\037\000\118\000\038\000\031\000\041\000\029\000\
\\042\000\028\000\052\000\024\000\053\000\023\000\000\000\001\000\
\\018\000\101\001\000\000\001\000\
\\001\000\178\002\002\000\178\002\009\000\178\002\
\\010\000\178\002\011\000\214\000\016\000\178\002\019\000\178\002\
\\022\000\178\002\027\000\178\002\028\000\178\002\032\000\178\002\
\\034\000\178\002\035\000\178\002\037\000\178\002\038\000\178\002\
\\041\000\178\002\042\000\178\002\048\000\178\002\050\000\178\002\
\\052\000\178\002\053\000\178\002\066\000\178\002\000\000\001\000\
\\066\000\102\001\000\000\001\000\
\\002\000\050\001\016\000\048\001\019\000\121\002\
\\021\000\047\001\022\000\046\001\032\000\121\002\033\000\045\001\
\\034\000\035\000\035\000\034\000\037\000\044\001\038\000\031\000\
\\041\000\043\001\046\000\042\001\050\000\041\001\052\000\040\001\
\\053\000\039\001\066\000\121\002\000\000\001\000\
\\066\000\176\002\000\000\001\000\
\\003\000\055\000\020\000\042\000\058\000\021\000\000\000\001\000\
\\003\000\211\001\020\000\211\001\040\000\137\000\
\\058\000\211\001\000\000\001\000\
\\003\000\079\002\004\000\100\000\020\000\079\002\
\\058\000\079\002\063\000\099\000\000\000\001\000\
\\003\000\055\000\020\000\042\000\058\000\021\000\000\000\001\000\
\\003\000\110\000\020\000\042\000\052\000\114\001\
\\058\000\021\000\000\000\001\000\
\\003\000\110\000\020\000\042\000\058\000\021\000\000\000\001\000\
\\002\000\050\001\016\000\048\001\021\000\047\001\
\\022\000\046\001\032\000\121\002\033\000\045\001\034\000\035\000\
\\035\000\034\000\037\000\044\001\038\000\031\000\041\000\043\001\
\\046\000\042\001\050\000\041\001\052\000\040\001\053\000\039\001\000\000\001\000\
\\003\000\055\000\020\000\042\000\058\000\021\000\000\000\001\000\
\\003\000\055\000\020\000\042\000\058\000\021\000\000\000\001\000\
\\003\000\079\002\004\000\100\000\020\000\079\002\
\\058\000\079\002\063\000\099\000\000\000\001\000\
\\003\000\079\002\004\000\100\000\020\000\079\002\
\\058\000\079\002\063\000\099\000\000\000\001\000\
\\059\000\123\001\000\000\001\000\
\\002\000\050\001\016\000\048\001\019\000\121\002\
\\021\000\047\001\022\000\046\001\032\000\121\002\033\000\045\001\
\\034\000\035\000\035\000\034\000\037\000\044\001\038\000\031\000\
\\041\000\043\001\046\000\042\001\050\000\041\001\052\000\040\001\
\\053\000\039\001\066\000\121\002\000\000\001\000\
\\001\000\066\002\002\000\066\002\009\000\066\002\
\\010\000\066\002\011\000\066\002\016\000\066\002\019\000\066\002\
\\022\000\066\002\027\000\066\002\028\000\066\002\032\000\066\002\
\\034\000\066\002\035\000\066\002\037\000\066\002\038\000\066\002\
\\041\000\066\002\042\000\066\002\048\000\066\002\050\000\066\002\
\\052\000\066\002\053\000\066\002\066\000\066\002\000\000\001\000\
\\003\000\051\000\005\000\050\000\006\000\049\000\
\\007\000\048\000\008\000\047\000\015\000\044\000\020\000\042\000\
\\026\000\040\000\030\000\037\000\031\000\036\000\036\000\033\000\
\\040\000\030\000\044\000\027\000\054\000\022\000\058\000\021\000\
\\061\000\020\000\062\000\019\000\063\000\018\000\000\000\001\000\
\\012\000\236\000\020\000\062\002\000\000\001\000\
\\001\000\068\002\002\000\068\002\009\000\068\002\
\\010\000\068\002\016\000\068\002\019\000\068\002\022\000\068\002\
\\027\000\068\002\028\000\068\002\032\000\068\002\034\000\068\002\
\\035\000\068\002\037\000\068\002\038\000\068\002\041\000\068\002\
\\042\000\068\002\048\000\068\002\050\000\068\002\052\000\068\002\
\\053\000\068\002\066\000\068\002\000\000\001\000\
\\013\000\030\002\059\000\255\000\060\000\030\002\
\\066\000\126\001\000\000\001\000\
\\003\000\096\000\005\000\050\000\006\000\049\000\
\\007\000\095\000\008\000\094\000\020\000\072\002\040\000\093\000\
\\055\000\091\000\058\000\090\000\059\000\072\002\061\000\089\000\
\\062\000\088\000\063\000\087\000\000\000\001\000\
\\001\000\239\001\002\000\239\001\009\000\239\001\
\\010\000\239\001\011\000\239\001\014\000\239\001\016\000\239\001\
\\018\000\239\001\019\000\239\001\022\000\239\001\023\000\239\001\
\\027\000\239\001\028\000\239\001\032\000\239\001\034\000\239\001\
\\035\000\239\001\037\000\239\001\038\000\239\001\039\000\239\001\
\\041\000\239\001\042\000\239\001\048\000\239\001\050\000\239\001\
\\051\000\239\001\052\000\239\001\053\000\239\001\060\000\239\001\
\\064\000\239\001\065\000\239\001\066\000\239\001\000\000\001\000\
\\001\000\238\001\002\000\238\001\009\000\238\001\
\\010\000\238\001\011\000\238\001\014\000\238\001\016\000\238\001\
\\018\000\238\001\019\000\238\001\022\000\238\001\023\000\238\001\
\\027\000\238\001\028\000\238\001\032\000\238\001\034\000\238\001\
\\035\000\238\001\037\000\238\001\038\000\238\001\039\000\238\001\
\\041\000\238\001\042\000\238\001\048\000\238\001\050\000\238\001\
\\051\000\238\001\052\000\238\001\053\000\238\001\060\000\238\001\
\\064\000\238\001\065\000\238\001\066\000\238\001\000\000\001\000\
\\001\000\092\002\002\000\092\002\009\000\092\002\
\\010\000\092\002\011\000\226\000\016\000\092\002\019\000\092\002\
\\022\000\092\002\027\000\092\002\028\000\092\002\032\000\092\002\
\\034\000\092\002\035\000\092\002\037\000\092\002\038\000\092\002\
\\041\000\092\002\042\000\092\002\048\000\092\002\050\000\092\002\
\\052\000\092\002\053\000\092\002\066\000\092\002\000\000\001\000\
\\003\000\158\000\004\000\157\000\061\000\156\000\
\\063\000\155\000\000\000\001\000\
\\003\000\110\000\020\000\042\000\058\000\021\000\000\000\001\000\
\\001\000\082\002\002\000\082\002\009\000\082\002\
\\010\000\082\002\016\000\082\002\019\000\082\002\021\000\082\002\
\\022\000\082\002\027\000\082\002\028\000\082\002\032\000\082\002\
\\033\000\082\002\034\000\082\002\035\000\082\002\037\000\082\002\
\\038\000\082\002\041\000\082\002\042\000\082\002\046\000\082\002\
\\048\000\082\002\050\000\082\002\052\000\082\002\053\000\082\002\
\\056\000\082\002\057\000\082\002\066\000\082\002\000\000\001\000\
\\001\000\107\002\002\000\107\002\009\000\107\002\
\\010\000\107\002\011\000\194\000\016\000\107\002\019\000\107\002\
\\022\000\107\002\027\000\107\002\028\000\107\002\032\000\107\002\
\\034\000\107\002\035\000\107\002\037\000\107\002\038\000\107\002\
\\041\000\107\002\042\000\107\002\048\000\107\002\050\000\107\002\
\\052\000\107\002\053\000\107\002\066\000\107\002\000\000\001\000\
\\003\000\211\001\020\000\211\001\040\000\137\000\
\\058\000\211\001\000\000\001\000\
\\001\000\003\002\002\000\003\002\009\000\003\002\
\\010\000\003\002\011\000\003\002\014\000\003\002\016\000\003\002\
\\018\000\003\002\019\000\003\002\022\000\003\002\023\000\003\002\
\\027\000\003\002\028\000\003\002\032\000\003\002\034\000\003\002\
\\035\000\003\002\037\000\003\002\038\000\003\002\039\000\003\002\
\\041\000\003\002\042\000\003\002\048\000\003\002\050\000\003\002\
\\051\000\003\002\052\000\003\002\053\000\003\002\060\000\003\002\
\\064\000\003\002\065\000\003\002\066\000\003\002\000\000\001\000\
\\019\000\133\001\000\000\001\000\
\\001\000\250\001\002\000\250\001\009\000\250\001\
\\010\000\250\001\011\000\250\001\014\000\250\001\016\000\250\001\
\\018\000\250\001\019\000\250\001\022\000\250\001\023\000\250\001\
\\027\000\250\001\028\000\250\001\029\000\250\001\032\000\250\001\
\\034\000\250\001\035\000\250\001\037\000\250\001\038\000\250\001\
\\039\000\250\001\041\000\250\001\042\000\250\001\048\000\250\001\
\\050\000\250\001\051\000\250\001\052\000\250\001\053\000\250\001\
\\060\000\250\001\064\000\250\001\065\000\250\001\066\000\250\001\
\\067\000\250\001\068\000\235\000\000\000\001\000\
\\001\000\253\001\002\000\253\001\003\000\051\000\
\\005\000\050\000\006\000\049\000\007\000\048\000\008\000\047\000\
\\009\000\253\001\010\000\253\001\011\000\253\001\014\000\253\001\
\\016\000\253\001\018\000\253\001\019\000\253\001\020\000\042\000\
\\022\000\253\001\023\000\253\001\027\000\253\001\028\000\253\001\
\\029\000\253\001\030\000\037\000\032\000\253\001\034\000\253\001\
\\035\000\253\001\036\000\033\000\037\000\253\001\038\000\253\001\
\\039\000\253\001\040\000\030\000\041\000\253\001\042\000\253\001\
\\048\000\253\001\050\000\253\001\051\000\253\001\052\000\253\001\
\\053\000\253\001\058\000\021\000\059\000\062\000\060\000\253\001\
\\061\000\020\000\062\000\019\000\063\000\018\000\064\000\253\001\
\\065\000\253\001\066\000\253\001\067\000\253\001\068\000\253\001\000\000\001\000\
\\001\000\233\001\002\000\233\001\009\000\233\001\
\\010\000\233\001\011\000\233\001\012\000\236\000\013\000\233\001\
\\014\000\233\001\016\000\233\001\018\000\233\001\019\000\233\001\
\\020\000\233\001\021\000\233\001\022\000\233\001\023\000\233\001\
\\025\000\233\001\027\000\233\001\028\000\233\001\029\000\233\001\
\\032\000\233\001\033\000\233\001\034\000\233\001\035\000\233\001\
\\037\000\233\001\038\000\233\001\039\000\233\001\041\000\233\001\
\\042\000\233\001\046\000\233\001\048\000\233\001\050\000\233\001\
\\051\000\233\001\052\000\233\001\053\000\233\001\056\000\233\001\
\\057\000\233\001\060\000\233\001\064\000\233\001\065\000\233\001\
\\066\000\233\001\067\000\233\001\068\000\233\001\000\000\001\000\
\\001\000\230\001\002\000\230\001\009\000\230\001\
\\010\000\230\001\011\000\230\001\012\000\230\001\013\000\230\001\
\\014\000\230\001\016\000\230\001\018\000\230\001\019\000\230\001\
\\020\000\230\001\021\000\230\001\022\000\230\001\023\000\230\001\
\\025\000\230\001\027\000\230\001\028\000\230\001\029\000\230\001\
\\032\000\230\001\033\000\230\001\034\000\230\001\035\000\230\001\
\\037\000\230\001\038\000\230\001\039\000\230\001\041\000\230\001\
\\042\000\230\001\046\000\230\001\048\000\230\001\050\000\230\001\
\\051\000\230\001\052\000\230\001\053\000\230\001\056\000\230\001\
\\057\000\230\001\060\000\230\001\064\000\230\001\065\000\230\001\
\\066\000\230\001\067\000\230\001\068\000\230\001\000\000\001\000\
\\001\000\231\001\002\000\231\001\003\000\158\000\
\\009\000\231\001\010\000\231\001\011\000\231\001\012\000\231\001\
\\013\000\231\001\014\000\231\001\016\000\231\001\018\000\231\001\
\\019\000\231\001\020\000\231\001\021\000\231\001\022\000\231\001\
\\023\000\231\001\025\000\231\001\027\000\231\001\028\000\231\001\
\\029\000\231\001\032\000\231\001\033\000\231\001\034\000\231\001\
\\035\000\231\001\037\000\231\001\038\000\231\001\039\000\231\001\
\\041\000\231\001\042\000\231\001\046\000\231\001\048\000\231\001\
\\050\000\231\001\051\000\231\001\052\000\231\001\053\000\231\001\
\\056\000\231\001\057\000\231\001\058\000\238\000\060\000\231\001\
\\064\000\231\001\065\000\231\001\066\000\231\001\067\000\231\001\
\\068\000\231\001\000\000\001\000\
\\003\000\158\000\000\000\001\000\
\\001\000\227\001\002\000\227\001\003\000\227\001\
\\009\000\227\001\010\000\227\001\011\000\227\001\012\000\227\001\
\\013\000\227\001\014\000\227\001\016\000\227\001\018\000\227\001\
\\019\000\227\001\020\000\227\001\021\000\227\001\022\000\227\001\
\\023\000\227\001\025\000\227\001\027\000\227\001\028\000\227\001\
\\029\000\227\001\032\000\227\001\033\000\227\001\034\000\227\001\
\\035\000\227\001\037\000\227\001\038\000\227\001\039\000\227\001\
\\041\000\227\001\042\000\227\001\046\000\227\001\048\000\227\001\
\\050\000\227\001\051\000\227\001\052\000\227\001\053\000\227\001\
\\056\000\227\001\057\000\227\001\058\000\227\001\060\000\227\001\
\\064\000\227\001\065\000\227\001\066\000\227\001\067\000\227\001\
\\068\000\227\001\000\000\001\000\
\\003\000\158\000\004\000\157\000\061\000\156\000\
\\063\000\155\000\000\000\001\000\
\\001\000\224\001\002\000\224\001\003\000\224\001\
\\009\000\224\001\010\000\224\001\011\000\224\001\012\000\224\001\
\\013\000\224\001\014\000\224\001\016\000\224\001\018\000\224\001\
\\019\000\224\001\020\000\224\001\021\000\224\001\022\000\224\001\
\\023\000\224\001\025\000\224\001\027\000\224\001\028\000\224\001\
\\029\000\224\001\032\000\224\001\033\000\224\001\034\000\224\001\
\\035\000\224\001\037\000\224\001\038\000\224\001\039\000\224\001\
\\041\000\224\001\042\000\224\001\046\000\224\001\048\000\224\001\
\\050\000\224\001\051\000\224\001\052\000\224\001\053\000\224\001\
\\056\000\224\001\057\000\224\001\058\000\224\001\060\000\224\001\
\\064\000\224\001\065\000\224\001\066\000\224\001\067\000\224\001\
\\068\000\224\001\000\000\001\000\
\\003\000\077\000\005\000\076\000\000\000\001\000\
\\003\000\158\000\004\000\157\000\061\000\156\000\
\\063\000\155\000\000\000\001\000\
\\001\000\218\001\002\000\218\001\003\000\218\001\
\\009\000\218\001\010\000\218\001\011\000\218\001\012\000\218\001\
\\013\000\218\001\014\000\218\001\016\000\218\001\018\000\218\001\
\\019\000\218\001\020\000\218\001\021\000\218\001\022\000\218\001\
\\023\000\218\001\025\000\218\001\027\000\218\001\028\000\218\001\
\\029\000\218\001\032\000\218\001\033\000\218\001\034\000\218\001\
\\035\000\218\001\037\000\218\001\038\000\218\001\039\000\218\001\
\\041\000\218\001\042\000\218\001\046\000\218\001\048\000\218\001\
\\050\000\218\001\051\000\218\001\052\000\218\001\053\000\218\001\
\\056\000\218\001\057\000\218\001\058\000\218\001\060\000\218\001\
\\064\000\218\001\065\000\218\001\066\000\218\001\067\000\218\001\
\\068\000\218\001\000\000\001\000\
\\012\000\236\000\013\000\032\002\020\000\032\002\
\\025\000\032\002\060\000\032\002\064\000\032\002\065\000\032\002\
\\066\000\032\002\000\000\001\000\
\\066\000\139\001\000\000\001\000\
\\065\000\058\002\066\000\058\002\000\000\001\000\
\\064\000\054\002\000\000\001\000\
\\013\000\174\000\060\000\049\002\064\000\049\002\000\000\001\000\
\\012\000\236\000\013\000\140\001\060\000\052\002\
\\064\000\052\002\000\000\001\000\
\\013\000\174\000\060\000\051\002\064\000\051\002\000\000\001\000\
\\001\000\064\002\002\000\064\002\009\000\064\002\
\\010\000\064\002\011\000\012\001\016\000\064\002\019\000\064\002\
\\022\000\064\002\027\000\064\002\028\000\064\002\032\000\064\002\
\\034\000\064\002\035\000\064\002\037\000\064\002\038\000\064\002\
\\041\000\064\002\042\000\064\002\048\000\064\002\050\000\064\002\
\\052\000\064\002\053\000\064\002\066\000\064\002\000\000\001\000\
\\026\000\141\001\000\000\001\000\
\\001\000\075\002\002\000\075\002\009\000\075\002\
\\010\000\075\002\011\000\075\002\012\000\236\000\016\000\075\002\
\\019\000\075\002\022\000\075\002\027\000\075\002\028\000\075\002\
\\032\000\075\002\034\000\075\002\035\000\075\002\037\000\075\002\
\\038\000\075\002\041\000\075\002\042\000\075\002\048\000\075\002\
\\050\000\075\002\052\000\075\002\053\000\075\002\066\000\075\002\000\000\001\000\
\\066\000\081\002\000\000\001\000\
\\001\000\173\002\002\000\173\002\009\000\173\002\
\\010\000\173\002\011\000\173\002\016\000\173\002\019\000\173\002\
\\022\000\173\002\027\000\173\002\028\000\173\002\032\000\173\002\
\\034\000\173\002\035\000\173\002\037\000\173\002\038\000\173\002\
\\041\000\173\002\042\000\173\002\048\000\173\002\050\000\173\002\
\\052\000\173\002\053\000\173\002\066\000\173\002\000\000\001\000\
\\001\000\155\002\002\000\155\002\009\000\155\002\
\\010\000\155\002\011\000\155\002\016\000\155\002\019\000\155\002\
\\022\000\155\002\027\000\155\002\028\000\155\002\032\000\155\002\
\\034\000\155\002\035\000\155\002\037\000\155\002\038\000\155\002\
\\041\000\155\002\042\000\155\002\048\000\155\002\050\000\155\002\
\\052\000\155\002\053\000\155\002\066\000\155\002\000\000\001\000\
\\002\000\115\000\009\000\046\000\010\000\045\000\
\\016\000\043\000\019\000\163\002\022\000\041\000\027\000\039\000\
\\028\000\038\000\034\000\035\000\035\000\034\000\037\000\114\000\
\\038\000\031\000\041\000\029\000\042\000\028\000\048\000\026\000\
\\050\000\025\000\052\000\024\000\053\000\023\000\000\000\001\000\
\\002\000\115\000\009\000\046\000\010\000\045\000\
\\016\000\043\000\022\000\041\000\027\000\039\000\028\000\038\000\
\\032\000\163\002\034\000\035\000\035\000\034\000\037\000\114\000\
\\038\000\031\000\041\000\029\000\042\000\028\000\048\000\026\000\
\\050\000\025\000\052\000\024\000\053\000\023\000\000\000\001\000\
\\001\000\207\001\002\000\207\001\009\000\207\001\
\\010\000\207\001\011\000\207\001\016\000\207\001\019\000\207\001\
\\022\000\207\001\024\000\204\000\027\000\207\001\028\000\207\001\
\\032\000\207\001\034\000\207\001\035\000\207\001\037\000\207\001\
\\038\000\207\001\041\000\207\001\042\000\207\001\048\000\207\001\
\\050\000\207\001\052\000\207\001\053\000\207\001\063\000\144\001\
\\066\000\207\001\000\000\001\000\
\\019\000\145\001\000\000\001\000\
\\003\000\051\000\005\000\050\000\006\000\049\000\
\\007\000\048\000\008\000\047\000\015\000\044\000\020\000\042\000\
\\026\000\040\000\030\000\037\000\031\000\036\000\036\000\033\000\
\\040\000\030\000\044\000\027\000\054\000\022\000\058\000\021\000\
\\061\000\020\000\062\000\019\000\063\000\018\000\000\000\001\000\
\\001\000\166\002\002\000\166\002\009\000\046\000\
\\010\000\045\000\016\000\043\000\022\000\041\000\027\000\039\000\
\\028\000\038\000\034\000\035\000\035\000\034\000\037\000\032\000\
\\038\000\031\000\041\000\029\000\042\000\028\000\048\000\026\000\
\\050\000\025\000\052\000\024\000\053\000\023\000\000\000\001\000\
\\019\000\149\001\000\000\001\000\
\\001\000\024\002\002\000\024\002\003\000\024\002\
\\005\000\024\002\006\000\024\002\007\000\024\002\008\000\024\002\
\\009\000\024\002\010\000\024\002\011\000\024\002\014\000\024\002\
\\015\000\024\002\016\000\024\002\018\000\024\002\019\000\024\002\
\\020\000\024\002\022\000\024\002\023\000\024\002\026\000\024\002\
\\027\000\024\002\028\000\024\002\029\000\024\002\030\000\024\002\
\\031\000\024\002\032\000\024\002\034\000\024\002\035\000\024\002\
\\036\000\024\002\037\000\024\002\038\000\024\002\039\000\024\002\
\\040\000\024\002\041\000\024\002\042\000\024\002\044\000\024\002\
\\048\000\024\002\050\000\024\002\051\000\024\002\052\000\024\002\
\\053\000\024\002\054\000\024\002\058\000\024\002\059\000\024\002\
\\060\000\024\002\061\000\024\002\062\000\024\002\063\000\024\002\
\\064\000\024\002\065\000\024\002\066\000\024\002\067\000\024\002\
\\068\000\024\002\000\000\001\000\
\\019\000\150\001\000\000\001\000\
\\003\000\051\000\005\000\050\000\006\000\049\000\
\\007\000\048\000\008\000\047\000\015\000\044\000\020\000\042\000\
\\026\000\040\000\030\000\037\000\031\000\036\000\036\000\033\000\
\\040\000\030\000\044\000\027\000\054\000\022\000\058\000\021\000\
\\061\000\020\000\062\000\019\000\063\000\018\000\000\000\001\000\
\\020\000\151\002\059\000\199\000\000\000\001\000\
\\019\000\122\002\032\000\122\002\066\000\122\002\000\000\001\000\
\\002\000\130\002\016\000\130\002\019\000\130\002\
\\021\000\130\002\022\000\130\002\032\000\130\002\033\000\130\002\
\\034\000\130\002\035\000\130\002\037\000\130\002\038\000\130\002\
\\041\000\130\002\046\000\130\002\050\000\130\002\052\000\130\002\
\\053\000\130\002\066\000\130\002\000\000\001\000\
\\002\000\128\002\011\000\153\001\016\000\128\002\
\\019\000\128\002\021\000\128\002\022\000\128\002\032\000\128\002\
\\033\000\128\002\034\000\128\002\035\000\128\002\037\000\128\002\
\\038\000\128\002\041\000\128\002\046\000\128\002\050\000\128\002\
\\052\000\128\002\053\000\128\002\066\000\128\002\000\000\001\000\
\\003\000\055\000\020\000\042\000\058\000\021\000\000\000\001\000\
\\002\000\126\002\011\000\155\001\016\000\126\002\
\\019\000\126\002\021\000\126\002\022\000\126\002\032\000\126\002\
\\033\000\126\002\034\000\126\002\035\000\126\002\037\000\126\002\
\\038\000\126\002\041\000\126\002\046\000\126\002\050\000\126\002\
\\052\000\126\002\053\000\126\002\066\000\126\002\000\000\001\000\
\\003\000\055\000\020\000\042\000\058\000\021\000\000\000\001\000\
\\002\000\124\002\011\000\157\001\016\000\124\002\
\\019\000\124\002\021\000\124\002\022\000\124\002\032\000\124\002\
\\033\000\124\002\034\000\124\002\035\000\124\002\037\000\124\002\
\\038\000\124\002\041\000\124\002\046\000\124\002\050\000\124\002\
\\052\000\124\002\053\000\124\002\066\000\124\002\000\000\001\000\
\\059\000\158\001\000\000\001\000\
\\002\000\146\002\011\000\146\002\016\000\146\002\
\\019\000\146\002\021\000\146\002\022\000\146\002\032\000\146\002\
\\033\000\146\002\034\000\146\002\035\000\146\002\037\000\146\002\
\\038\000\146\002\041\000\146\002\046\000\146\002\050\000\146\002\
\\052\000\146\002\053\000\146\002\066\000\146\002\000\000\001\000\
\\002\000\131\002\011\000\159\001\016\000\131\002\
\\019\000\131\002\021\000\131\002\022\000\131\002\032\000\131\002\
\\033\000\131\002\034\000\131\002\035\000\131\002\037\000\131\002\
\\038\000\131\002\041\000\131\002\046\000\131\002\050\000\131\002\
\\052\000\131\002\053\000\131\002\066\000\131\002\000\000\001\000\
\\020\000\160\001\000\000\001\000\
\\003\000\110\000\020\000\042\000\058\000\021\000\000\000\001\000\
\\002\000\132\002\016\000\132\002\019\000\132\002\
\\021\000\132\002\022\000\132\002\032\000\132\002\033\000\132\002\
\\034\000\132\002\035\000\132\002\037\000\132\002\038\000\132\002\
\\041\000\132\002\046\000\132\002\050\000\132\002\052\000\132\002\
\\053\000\132\002\066\000\132\002\000\000\001\000\
\\002\000\093\002\003\000\110\000\016\000\093\002\
\\019\000\093\002\020\000\042\000\021\000\093\002\022\000\093\002\
\\032\000\093\002\033\000\093\002\034\000\093\002\035\000\093\002\
\\037\000\093\002\038\000\093\002\041\000\093\002\046\000\093\002\
\\050\000\093\002\052\000\093\002\053\000\093\002\058\000\021\000\
\\066\000\093\002\000\000\001\000\
\\032\000\163\001\000\000\001\000\
\\002\000\134\002\016\000\134\002\019\000\134\002\
\\021\000\134\002\022\000\134\002\032\000\134\002\033\000\134\002\
\\034\000\134\002\035\000\134\002\037\000\134\002\038\000\134\002\
\\041\000\134\002\046\000\134\002\050\000\134\002\052\000\134\002\
\\053\000\134\002\066\000\134\002\000\000\001\000\
\\002\000\129\002\011\000\164\001\016\000\129\002\
\\019\000\129\002\021\000\129\002\022\000\129\002\032\000\129\002\
\\033\000\129\002\034\000\129\002\035\000\129\002\037\000\129\002\
\\038\000\129\002\041\000\129\002\046\000\129\002\050\000\129\002\
\\052\000\129\002\053\000\129\002\066\000\129\002\000\000\001\000\
\\002\000\142\002\011\000\142\002\016\000\142\002\
\\019\000\142\002\021\000\142\002\022\000\142\002\032\000\142\002\
\\033\000\142\002\034\000\142\002\035\000\142\002\037\000\142\002\
\\038\000\142\002\039\000\165\001\041\000\142\002\046\000\142\002\
\\050\000\142\002\052\000\142\002\053\000\142\002\066\000\142\002\000\000\001\000\
\\002\000\127\002\011\000\155\001\016\000\127\002\
\\019\000\127\002\021\000\127\002\022\000\127\002\032\000\127\002\
\\033\000\127\002\034\000\127\002\035\000\127\002\037\000\127\002\
\\038\000\127\002\041\000\127\002\046\000\127\002\050\000\127\002\
\\052\000\127\002\053\000\127\002\066\000\127\002\000\000\001\000\
\\002\000\125\002\016\000\125\002\019\000\125\002\
\\021\000\125\002\022\000\125\002\032\000\125\002\033\000\125\002\
\\034\000\125\002\035\000\125\002\037\000\125\002\038\000\125\002\
\\041\000\125\002\046\000\125\002\050\000\125\002\052\000\125\002\
\\053\000\125\002\066\000\125\002\000\000\001\000\
\\003\000\024\001\047\000\023\001\000\000\001\000\
\\019\000\123\002\032\000\123\002\066\000\123\002\000\000\001\000\
\\001\000\074\002\002\000\074\002\009\000\074\002\
\\010\000\074\002\011\000\074\002\014\000\074\002\016\000\074\002\
\\019\000\074\002\022\000\074\002\027\000\074\002\028\000\074\002\
\\032\000\074\002\034\000\074\002\035\000\074\002\037\000\074\002\
\\038\000\074\002\041\000\074\002\042\000\074\002\048\000\074\002\
\\050\000\074\002\052\000\074\002\053\000\074\002\066\000\074\002\000\000\001\000\
\\003\000\096\000\005\000\050\000\006\000\049\000\
\\007\000\095\000\008\000\094\000\020\000\072\002\040\000\093\000\
\\055\000\091\000\058\000\090\000\059\000\072\002\061\000\089\000\
\\062\000\088\000\063\000\087\000\000\000\001\000\
\\020\000\070\002\059\000\070\002\000\000\001\000\
\\001\000\090\002\002\000\090\002\009\000\090\002\
\\010\000\090\002\011\000\090\002\012\000\236\000\016\000\090\002\
\\019\000\090\002\022\000\090\002\027\000\090\002\028\000\090\002\
\\032\000\090\002\034\000\090\002\035\000\090\002\037\000\090\002\
\\038\000\090\002\041\000\090\002\042\000\090\002\048\000\090\002\
\\050\000\090\002\052\000\090\002\053\000\090\002\066\000\090\002\000\000\001\000\
\\001\000\091\002\002\000\091\002\009\000\091\002\
\\010\000\091\002\011\000\091\002\016\000\091\002\019\000\091\002\
\\022\000\091\002\027\000\091\002\028\000\091\002\032\000\091\002\
\\034\000\091\002\035\000\091\002\037\000\091\002\038\000\091\002\
\\041\000\091\002\042\000\091\002\048\000\091\002\050\000\091\002\
\\052\000\091\002\053\000\091\002\066\000\091\002\000\000\001\000\
\\001\000\085\002\002\000\085\002\009\000\085\002\
\\010\000\085\002\011\000\085\002\014\000\168\001\016\000\085\002\
\\019\000\085\002\021\000\085\002\022\000\085\002\027\000\085\002\
\\028\000\085\002\032\000\085\002\033\000\085\002\034\000\085\002\
\\035\000\085\002\037\000\085\002\038\000\085\002\041\000\085\002\
\\042\000\085\002\046\000\085\002\048\000\085\002\050\000\085\002\
\\052\000\085\002\053\000\085\002\056\000\085\002\057\000\085\002\
\\066\000\085\002\000\000\001\000\
\\001\000\084\002\002\000\084\002\009\000\084\002\
\\010\000\084\002\011\000\084\002\016\000\084\002\019\000\084\002\
\\021\000\084\002\022\000\084\002\027\000\084\002\028\000\084\002\
\\032\000\084\002\033\000\084\002\034\000\084\002\035\000\084\002\
\\037\000\084\002\038\000\084\002\041\000\084\002\042\000\084\002\
\\046\000\084\002\048\000\084\002\050\000\084\002\052\000\084\002\
\\053\000\084\002\056\000\084\002\057\000\084\002\066\000\084\002\000\000\001\000\
\\003\000\055\000\020\000\042\000\058\000\021\000\000\000\001\000\
\\001\000\108\002\002\000\108\002\009\000\108\002\
\\010\000\108\002\016\000\108\002\019\000\108\002\022\000\108\002\
\\027\000\108\002\028\000\108\002\032\000\108\002\034\000\108\002\
\\035\000\108\002\037\000\108\002\038\000\108\002\041\000\108\002\
\\042\000\108\002\048\000\108\002\050\000\108\002\052\000\108\002\
\\053\000\108\002\066\000\108\002\000\000\001\000\
\\001\000\226\001\002\000\226\001\003\000\226\001\
\\009\000\226\001\010\000\226\001\011\000\226\001\012\000\226\001\
\\013\000\226\001\014\000\226\001\016\000\226\001\018\000\226\001\
\\019\000\226\001\020\000\226\001\021\000\226\001\022\000\226\001\
\\023\000\226\001\025\000\226\001\027\000\226\001\028\000\226\001\
\\029\000\226\001\032\000\226\001\033\000\226\001\034\000\226\001\
\\035\000\226\001\037\000\226\001\038\000\226\001\039\000\226\001\
\\041\000\226\001\042\000\226\001\046\000\226\001\048\000\226\001\
\\050\000\226\001\051\000\226\001\052\000\226\001\053\000\226\001\
\\056\000\226\001\057\000\226\001\058\000\226\001\060\000\226\001\
\\064\000\226\001\065\000\226\001\066\000\226\001\067\000\226\001\
\\068\000\226\001\000\000\001\000\
\\066\000\236\001\000\000\001\000\
\\012\000\236\000\060\000\074\001\066\000\235\001\000\000\001\000\
\\064\000\221\001\000\000\001\000\
\\012\000\236\000\060\000\220\001\064\000\220\001\000\000\001\000\
\\003\000\038\002\005\000\038\002\006\000\038\002\
\\007\000\038\002\008\000\038\002\013\000\038\002\020\000\038\002\
\\025\000\038\002\040\000\038\002\055\000\038\002\058\000\038\002\
\\059\000\038\002\060\000\038\002\061\000\038\002\062\000\038\002\
\\063\000\038\002\064\000\038\002\065\000\038\002\066\000\038\002\000\000\001\000\
\\003\000\096\000\005\000\050\000\006\000\049\000\
\\007\000\095\000\008\000\094\000\040\000\093\000\055\000\091\000\
\\058\000\090\000\061\000\089\000\062\000\088\000\063\000\087\000\000\000\001\000\
\\003\000\096\000\005\000\050\000\006\000\049\000\
\\007\000\095\000\008\000\094\000\040\000\093\000\055\000\091\000\
\\058\000\090\000\061\000\089\000\062\000\088\000\063\000\087\000\000\000\001\000\
\\019\000\172\001\000\000\001\000\
\\032\000\173\001\000\000\001\000\
\\002\000\115\000\003\000\094\001\009\000\046\000\
\\010\000\045\000\016\000\043\000\020\000\042\000\022\000\041\000\
\\027\000\039\000\028\000\038\000\034\000\035\000\035\000\034\000\
\\036\000\093\001\037\000\114\000\038\000\031\000\041\000\029\000\
\\042\000\028\000\048\000\026\000\049\000\092\001\050\000\025\000\
\\052\000\024\000\053\000\023\000\058\000\021\000\066\000\163\002\000\000\001\000\
\\001\000\150\002\002\000\150\002\009\000\150\002\
\\010\000\150\002\011\000\150\002\016\000\150\002\019\000\150\002\
\\020\000\150\002\021\000\150\002\022\000\150\002\027\000\150\002\
\\028\000\150\002\032\000\150\002\033\000\150\002\034\000\150\002\
\\035\000\150\002\037\000\150\002\038\000\150\002\041\000\150\002\
\\042\000\150\002\046\000\150\002\048\000\150\002\050\000\150\002\
\\052\000\150\002\053\000\150\002\066\000\150\002\000\000\001\000\
\\001\000\112\002\002\000\112\002\009\000\112\002\
\\010\000\112\002\016\000\112\002\019\000\112\002\022\000\112\002\
\\027\000\112\002\028\000\112\002\032\000\112\002\034\000\112\002\
\\035\000\112\002\037\000\112\002\038\000\112\002\041\000\112\002\
\\042\000\112\002\048\000\112\002\050\000\112\002\052\000\112\002\
\\053\000\112\002\066\000\112\002\000\000\001\000\
\\001\000\113\002\002\000\113\002\009\000\113\002\
\\010\000\113\002\011\000\176\001\016\000\113\002\019\000\113\002\
\\022\000\113\002\027\000\113\002\028\000\113\002\032\000\113\002\
\\034\000\113\002\035\000\113\002\037\000\113\002\038\000\113\002\
\\041\000\113\002\042\000\113\002\048\000\113\002\050\000\113\002\
\\052\000\113\002\053\000\113\002\066\000\113\002\000\000\001\000\
\\001\000\165\002\002\000\165\002\000\000\001\000\
\\002\000\115\000\009\000\046\000\010\000\045\000\
\\016\000\043\000\019\000\163\002\022\000\041\000\027\000\039\000\
\\028\000\038\000\032\000\163\002\034\000\035\000\035\000\034\000\
\\037\000\114\000\038\000\031\000\041\000\029\000\042\000\028\000\
\\048\000\026\000\050\000\025\000\052\000\024\000\053\000\023\000\
\\066\000\163\002\000\000\001\000\
\\002\000\119\000\010\000\045\000\016\000\043\000\
\\019\000\115\002\022\000\041\000\027\000\039\000\032\000\115\002\
\\034\000\035\000\035\000\034\000\037\000\118\000\038\000\031\000\
\\041\000\029\000\042\000\028\000\052\000\024\000\053\000\023\000\000\000\001\000\
\\001\000\005\002\002\000\005\002\009\000\005\002\
\\010\000\005\002\011\000\005\002\014\000\005\002\016\000\005\002\
\\018\000\005\002\019\000\005\002\022\000\005\002\023\000\005\002\
\\027\000\005\002\028\000\005\002\032\000\005\002\034\000\005\002\
\\035\000\005\002\037\000\005\002\038\000\005\002\039\000\005\002\
\\041\000\005\002\042\000\005\002\048\000\005\002\050\000\005\002\
\\051\000\005\002\052\000\005\002\053\000\005\002\060\000\005\002\
\\064\000\005\002\065\000\005\002\066\000\005\002\000\000\001\000\
\\020\000\179\001\000\000\001\000\
\\003\000\211\001\020\000\211\001\040\000\137\000\
\\058\000\211\001\000\000\001\000\
\\059\000\181\001\000\000\001\000\
\\003\000\079\002\004\000\100\000\020\000\079\002\
\\058\000\079\002\063\000\099\000\000\000\001\000\
\\002\000\138\002\011\000\138\002\016\000\138\002\
\\019\000\138\002\021\000\138\002\022\000\138\002\032\000\138\002\
\\033\000\138\002\034\000\138\002\035\000\138\002\037\000\138\002\
\\038\000\138\002\041\000\138\002\046\000\138\002\050\000\138\002\
\\052\000\138\002\053\000\138\002\066\000\138\002\000\000\001\000\
\\003\000\055\000\020\000\042\000\058\000\021\000\000\000\001\000\
\\003\000\024\001\047\000\023\001\000\000\001\000\
\\003\000\110\000\020\000\042\000\052\000\114\001\
\\058\000\021\000\000\000\001\000\
\\003\000\110\000\020\000\042\000\058\000\021\000\000\000\001\000\
\\002\000\145\002\011\000\145\002\016\000\145\002\
\\019\000\145\002\021\000\145\002\022\000\145\002\032\000\145\002\
\\033\000\145\002\034\000\145\002\035\000\145\002\037\000\145\002\
\\038\000\145\002\041\000\145\002\046\000\145\002\050\000\145\002\
\\052\000\145\002\053\000\145\002\066\000\145\002\000\000\001\000\
\\002\000\094\002\016\000\094\002\019\000\094\002\
\\021\000\094\002\022\000\094\002\032\000\094\002\033\000\094\002\
\\034\000\094\002\035\000\094\002\037\000\094\002\038\000\094\002\
\\041\000\094\002\046\000\094\002\050\000\094\002\052\000\094\002\
\\053\000\094\002\066\000\094\002\000\000\001\000\
\\002\000\050\001\016\000\048\001\019\000\121\002\
\\021\000\047\001\022\000\046\001\033\000\045\001\034\000\035\000\
\\035\000\034\000\037\000\044\001\038\000\031\000\041\000\043\001\
\\046\000\042\001\050\000\041\001\052\000\040\001\053\000\039\001\000\000\001\000\
\\003\000\055\000\020\000\042\000\058\000\021\000\000\000\001\000\
\\003\000\158\000\004\000\157\000\061\000\156\000\
\\063\000\155\000\000\000\001\000\
\\066\000\175\002\000\000\001\000\
\\020\000\069\002\059\000\069\002\000\000\001\000\
\\003\000\211\001\020\000\211\001\040\000\137\000\
\\058\000\211\001\000\000\001\000\
\\001\000\087\002\002\000\087\002\009\000\087\002\
\\010\000\087\002\011\000\087\002\014\000\087\002\016\000\087\002\
\\019\000\087\002\021\000\087\002\022\000\087\002\027\000\087\002\
\\028\000\087\002\032\000\087\002\033\000\087\002\034\000\087\002\
\\035\000\087\002\037\000\087\002\038\000\087\002\039\000\192\001\
\\041\000\087\002\042\000\087\002\046\000\087\002\048\000\087\002\
\\050\000\087\002\052\000\087\002\053\000\087\002\056\000\087\002\
\\057\000\087\002\066\000\087\002\000\000\001\000\
\\013\000\174\000\060\000\053\002\064\000\053\002\000\000\001\000\
\\001\000\063\002\002\000\063\002\009\000\063\002\
\\010\000\063\002\011\000\063\002\016\000\063\002\019\000\063\002\
\\022\000\063\002\027\000\063\002\028\000\063\002\032\000\063\002\
\\034\000\063\002\035\000\063\002\037\000\063\002\038\000\063\002\
\\041\000\063\002\042\000\063\002\048\000\063\002\050\000\063\002\
\\052\000\063\002\053\000\063\002\066\000\063\002\000\000\001\000\
\\001\000\156\002\002\000\156\002\009\000\156\002\
\\010\000\156\002\011\000\156\002\016\000\156\002\019\000\156\002\
\\022\000\156\002\027\000\156\002\028\000\156\002\032\000\156\002\
\\034\000\156\002\035\000\156\002\037\000\156\002\038\000\156\002\
\\041\000\156\002\042\000\156\002\048\000\156\002\050\000\156\002\
\\052\000\156\002\053\000\156\002\066\000\156\002\000\000\001\000\
\\003\000\094\001\020\000\042\000\036\000\093\001\
\\049\000\092\001\058\000\021\000\000\000\001\000\
\\066\000\194\001\000\000\001\000\
\\066\000\195\001\000\000\001\000\
\\003\000\051\000\005\000\050\000\006\000\049\000\
\\007\000\048\000\008\000\047\000\015\000\044\000\020\000\042\000\
\\026\000\040\000\030\000\037\000\031\000\036\000\036\000\033\000\
\\040\000\030\000\044\000\027\000\054\000\022\000\058\000\021\000\
\\061\000\020\000\062\000\019\000\063\000\018\000\000\000\001\000\
\\019\000\162\002\032\000\162\002\066\000\162\002\000\000\001\000\
\\019\000\118\002\032\000\118\002\000\000\001\000\
\\003\000\094\001\020\000\042\000\036\000\093\001\
\\049\000\092\001\058\000\021\000\000\000\001\000\
\\002\000\139\002\011\000\153\001\016\000\139\002\
\\019\000\139\002\021\000\139\002\022\000\139\002\032\000\139\002\
\\033\000\139\002\034\000\139\002\035\000\139\002\037\000\139\002\
\\038\000\139\002\041\000\139\002\046\000\139\002\050\000\139\002\
\\052\000\139\002\053\000\139\002\066\000\139\002\000\000\001\000\
\\003\000\158\000\004\000\157\000\061\000\156\000\
\\063\000\155\000\000\000\001\000\
\\002\000\137\002\011\000\155\001\016\000\137\002\
\\019\000\137\002\021\000\137\002\022\000\137\002\032\000\137\002\
\\033\000\137\002\034\000\137\002\035\000\137\002\037\000\137\002\
\\038\000\137\002\041\000\137\002\046\000\137\002\050\000\137\002\
\\052\000\137\002\053\000\137\002\066\000\137\002\000\000\001\000\
\\002\000\135\002\011\000\157\001\016\000\135\002\
\\019\000\135\002\021\000\135\002\022\000\135\002\032\000\135\002\
\\033\000\135\002\034\000\135\002\035\000\135\002\037\000\135\002\
\\038\000\135\002\041\000\135\002\046\000\135\002\050\000\135\002\
\\052\000\135\002\053\000\135\002\066\000\135\002\000\000\001\000\
\\002\000\136\002\011\000\136\002\016\000\136\002\
\\019\000\136\002\021\000\136\002\022\000\136\002\032\000\136\002\
\\033\000\136\002\034\000\136\002\035\000\136\002\037\000\136\002\
\\038\000\136\002\041\000\136\002\046\000\136\002\050\000\136\002\
\\052\000\136\002\053\000\136\002\066\000\136\002\000\000\001\000\
\\002\000\144\002\011\000\159\001\016\000\144\002\
\\019\000\144\002\021\000\144\002\022\000\144\002\032\000\144\002\
\\033\000\144\002\034\000\144\002\035\000\144\002\037\000\144\002\
\\038\000\144\002\041\000\144\002\046\000\144\002\050\000\144\002\
\\052\000\144\002\053\000\144\002\066\000\144\002\000\000\001\000\
\\002\000\148\002\011\000\148\002\016\000\148\002\
\\019\000\148\002\021\000\148\002\022\000\148\002\032\000\148\002\
\\033\000\148\002\034\000\148\002\035\000\148\002\037\000\148\002\
\\038\000\148\002\041\000\148\002\046\000\148\002\050\000\148\002\
\\052\000\148\002\053\000\148\002\066\000\148\002\000\000\001\000\
\\002\000\147\002\011\000\147\002\016\000\147\002\
\\019\000\147\002\020\000\160\001\021\000\147\002\022\000\147\002\
\\032\000\147\002\033\000\147\002\034\000\147\002\035\000\147\002\
\\037\000\147\002\038\000\147\002\041\000\147\002\046\000\147\002\
\\050\000\147\002\052\000\147\002\053\000\147\002\066\000\147\002\000\000\001\000\
\\019\000\199\001\000\000\001\000\
\\002\000\141\002\011\000\164\001\016\000\141\002\
\\019\000\141\002\021\000\141\002\022\000\141\002\032\000\141\002\
\\033\000\141\002\034\000\141\002\035\000\141\002\037\000\141\002\
\\038\000\141\002\041\000\141\002\046\000\141\002\050\000\141\002\
\\052\000\141\002\053\000\141\002\066\000\141\002\000\000\001\000\
\\002\000\143\002\011\000\143\002\012\000\236\000\
\\016\000\143\002\019\000\143\002\021\000\143\002\022\000\143\002\
\\032\000\143\002\033\000\143\002\034\000\143\002\035\000\143\002\
\\037\000\143\002\038\000\143\002\041\000\143\002\046\000\143\002\
\\050\000\143\002\052\000\143\002\053\000\143\002\066\000\143\002\000\000\001\000\
\\001\000\086\002\002\000\086\002\009\000\086\002\
\\010\000\086\002\011\000\086\002\016\000\086\002\019\000\086\002\
\\021\000\086\002\022\000\086\002\027\000\086\002\028\000\086\002\
\\032\000\086\002\033\000\086\002\034\000\086\002\035\000\086\002\
\\037\000\086\002\038\000\086\002\041\000\086\002\042\000\086\002\
\\046\000\086\002\048\000\086\002\050\000\086\002\052\000\086\002\
\\053\000\086\002\056\000\086\002\057\000\086\002\066\000\086\002\000\000\001\000\
\\003\000\158\000\004\000\157\000\061\000\156\000\
\\063\000\155\000\000\000\001\000\
\\019\000\201\001\000\000\001\000\
\\001\000\157\002\002\000\157\002\009\000\157\002\
\\010\000\157\002\011\000\157\002\016\000\157\002\019\000\157\002\
\\022\000\157\002\027\000\157\002\028\000\157\002\032\000\157\002\
\\034\000\157\002\035\000\157\002\037\000\157\002\038\000\157\002\
\\041\000\157\002\042\000\157\002\048\000\157\002\050\000\157\002\
\\052\000\157\002\053\000\157\002\066\000\157\002\000\000\001\000\
\\001\000\158\002\002\000\158\002\009\000\158\002\
\\010\000\158\002\011\000\158\002\016\000\158\002\019\000\158\002\
\\022\000\158\002\027\000\158\002\028\000\158\002\032\000\158\002\
\\034\000\158\002\035\000\158\002\037\000\158\002\038\000\158\002\
\\041\000\158\002\042\000\158\002\048\000\158\002\050\000\158\002\
\\052\000\158\002\053\000\158\002\066\000\158\002\000\000\001\000\
\\001\000\114\002\002\000\114\002\009\000\114\002\
\\010\000\114\002\016\000\114\002\019\000\114\002\022\000\114\002\
\\027\000\114\002\028\000\114\002\032\000\114\002\034\000\114\002\
\\035\000\114\002\037\000\114\002\038\000\114\002\041\000\114\002\
\\042\000\114\002\048\000\114\002\050\000\114\002\052\000\114\002\
\\053\000\114\002\066\000\114\002\000\000\001\000\
\\001\000\177\002\002\000\177\002\009\000\177\002\
\\010\000\177\002\011\000\177\002\016\000\177\002\019\000\177\002\
\\022\000\177\002\027\000\177\002\028\000\177\002\032\000\177\002\
\\034\000\177\002\035\000\177\002\037\000\177\002\038\000\177\002\
\\041\000\177\002\042\000\177\002\048\000\177\002\050\000\177\002\
\\052\000\177\002\053\000\177\002\066\000\177\002\000\000\001\000\
\\002\000\140\002\011\000\140\002\012\000\236\000\
\\016\000\140\002\019\000\140\002\021\000\140\002\022\000\140\002\
\\032\000\140\002\033\000\140\002\034\000\140\002\035\000\140\002\
\\037\000\140\002\038\000\140\002\041\000\140\002\046\000\140\002\
\\050\000\140\002\052\000\140\002\053\000\140\002\066\000\140\002\000\000\001\000\
\\002\000\133\002\016\000\133\002\019\000\133\002\
\\021\000\133\002\022\000\133\002\032\000\133\002\033\000\133\002\
\\034\000\133\002\035\000\133\002\037\000\133\002\038\000\133\002\
\\041\000\133\002\046\000\133\002\050\000\133\002\052\000\133\002\
\\053\000\133\002\066\000\133\002\000\000\001\000\
\\001\000\088\002\002\000\088\002\009\000\088\002\
\\010\000\088\002\011\000\088\002\012\000\236\000\014\000\088\002\
\\016\000\088\002\019\000\088\002\021\000\088\002\022\000\088\002\
\\027\000\088\002\028\000\088\002\032\000\088\002\033\000\088\002\
\\034\000\088\002\035\000\088\002\037\000\088\002\038\000\088\002\
\\041\000\088\002\042\000\088\002\046\000\088\002\048\000\088\002\
\\050\000\088\002\052\000\088\002\053\000\088\002\056\000\088\002\
\\057\000\088\002\066\000\088\002\000\000\001\000\
\\001\000\159\002\002\000\159\002\009\000\159\002\
\\010\000\159\002\011\000\159\002\016\000\159\002\019\000\159\002\
\\022\000\159\002\027\000\159\002\028\000\159\002\032\000\159\002\
\\034\000\159\002\035\000\159\002\037\000\159\002\038\000\159\002\
\\041\000\159\002\042\000\159\002\048\000\159\002\050\000\159\002\
\\052\000\159\002\053\000\159\002\066\000\159\002\000\000\001\000\
\\001\000\000\000\002\000\000\000\000\000\001\000\
\"
val gotoT =
"\
\\001\000\014\000\003\000\013\000\021\000\012\000\
\\022\000\011\000\023\000\010\000\024\000\009\000\025\000\008\000\
\\026\000\007\000\027\000\006\000\028\000\005\000\057\000\004\000\
\\058\000\003\000\075\000\002\000\076\000\001\000\081\000\200\001\000\000\000\000\
\\057\000\004\000\058\000\003\000\075\000\050\000\
\\076\000\001\000\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\001\000\052\000\061\000\051\000\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\001\000\059\000\003\000\013\000\023\000\058\000\
\\024\000\057\000\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\080\000\061\000\000\000\000\000\
\\001\000\014\000\003\000\013\000\020\000\065\000\
\\021\000\064\000\022\000\011\000\023\000\010\000\024\000\009\000\
\\025\000\008\000\026\000\007\000\027\000\006\000\028\000\005\000\
\\030\000\063\000\000\000\000\000\
\\001\000\014\000\003\000\013\000\021\000\068\000\
\\022\000\011\000\023\000\010\000\024\000\009\000\025\000\008\000\
\\026\000\007\000\027\000\006\000\028\000\005\000\029\000\067\000\000\000\000\000\
\\008\000\072\000\018\000\071\000\019\000\070\000\000\000\000\000\
\\000\000\000\000\
\\001\000\014\000\003\000\013\000\021\000\076\000\
\\022\000\011\000\023\000\010\000\024\000\009\000\025\000\008\000\
\\026\000\007\000\027\000\006\000\028\000\005\000\000\000\000\000\
\\002\000\084\000\003\000\083\000\031\000\082\000\
\\032\000\081\000\033\000\080\000\034\000\079\000\035\000\078\000\
\\040\000\077\000\000\000\000\000\
\\048\000\096\000\049\000\095\000\000\000\000\000\
\\001\000\100\000\077\000\099\000\000\000\000\000\
\\001\000\102\000\072\000\101\000\000\000\000\000\
\\001\000\014\000\003\000\013\000\021\000\103\000\
\\022\000\011\000\023\000\010\000\024\000\009\000\025\000\008\000\
\\026\000\007\000\027\000\006\000\028\000\005\000\000\000\000\000\
\\001\000\104\000\000\000\000\000\
\\001\000\107\000\006\000\106\000\056\000\105\000\000\000\000\000\
\\001\000\109\000\000\000\000\000\
\\000\000\000\000\
\\057\000\004\000\058\000\003\000\074\000\111\000\
\\076\000\110\000\000\000\000\000\
\\057\000\004\000\058\000\115\000\060\000\114\000\000\000\000\000\
\\003\000\118\000\000\000\000\000\
\\003\000\119\000\000\000\000\000\
\\001\000\014\000\003\000\013\000\021\000\120\000\
\\022\000\011\000\023\000\010\000\024\000\009\000\025\000\008\000\
\\026\000\007\000\027\000\006\000\028\000\005\000\000\000\000\000\
\\008\000\121\000\000\000\000\000\
\\001\000\123\000\079\000\122\000\000\000\000\000\
\\002\000\084\000\003\000\083\000\034\000\128\000\
\\035\000\078\000\043\000\127\000\044\000\126\000\046\000\125\000\
\\047\000\124\000\000\000\000\000\
\\002\000\084\000\003\000\083\000\016\000\132\000\
\\017\000\131\000\031\000\130\000\032\000\081\000\033\000\080\000\
\\034\000\079\000\035\000\078\000\000\000\000\000\
\\004\000\134\000\055\000\133\000\000\000\000\000\
\\000\000\000\000\
\\049\000\138\000\051\000\137\000\052\000\136\000\000\000\000\000\
\\001\000\014\000\003\000\013\000\021\000\139\000\
\\022\000\011\000\023\000\010\000\024\000\009\000\025\000\008\000\
\\026\000\007\000\027\000\006\000\028\000\005\000\000\000\000\000\
\\049\000\138\000\051\000\140\000\052\000\136\000\000\000\000\000\
\\001\000\100\000\077\000\141\000\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\001\000\052\000\061\000\143\000\000\000\000\000\
\\000\000\000\000\
\\001\000\014\000\003\000\013\000\022\000\011\000\
\\023\000\010\000\024\000\009\000\025\000\008\000\026\000\007\000\
\\027\000\145\000\028\000\144\000\000\000\000\000\
\\002\000\084\000\003\000\083\000\016\000\146\000\
\\017\000\131\000\031\000\130\000\032\000\081\000\033\000\080\000\
\\034\000\079\000\035\000\078\000\000\000\000\000\
\\001\000\014\000\003\000\013\000\022\000\011\000\
\\023\000\010\000\024\000\009\000\025\000\148\000\026\000\147\000\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\009\000\152\000\012\000\151\000\013\000\150\000\
\\014\000\149\000\000\000\000\000\
\\000\000\000\000\
\\080\000\157\000\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\002\000\084\000\003\000\083\000\033\000\170\000\
\\034\000\079\000\035\000\078\000\045\000\169\000\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\002\000\084\000\003\000\083\000\031\000\173\000\
\\032\000\081\000\033\000\080\000\034\000\079\000\035\000\078\000\000\000\000\000\
\\002\000\084\000\003\000\083\000\031\000\176\000\
\\032\000\081\000\033\000\080\000\034\000\079\000\035\000\078\000\
\\039\000\175\000\000\000\000\000\
\\008\000\180\000\036\000\179\000\037\000\178\000\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\002\000\186\000\005\000\185\000\042\000\184\000\000\000\000\000\
\\001\000\189\000\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\001\000\191\000\000\000\000\000\
\\000\000\000\000\
\\050\000\193\000\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\071\000\196\000\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\001\000\107\000\006\000\106\000\056\000\201\000\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\057\000\004\000\058\000\003\000\074\000\203\000\
\\076\000\110\000\000\000\000\000\
\\000\000\000\000\
\\057\000\004\000\058\000\003\000\074\000\205\000\
\\076\000\110\000\000\000\000\000\
\\057\000\004\000\058\000\003\000\074\000\206\000\
\\076\000\110\000\000\000\000\000\
\\000\000\000\000\
\\057\000\004\000\058\000\115\000\060\000\208\000\000\000\000\000\
\\057\000\004\000\058\000\115\000\060\000\209\000\000\000\000\000\
\\057\000\004\000\058\000\115\000\060\000\210\000\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\041\000\215\000\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\002\000\084\000\003\000\083\000\033\000\170\000\
\\034\000\079\000\035\000\078\000\045\000\218\000\000\000\000\000\
\\002\000\084\000\003\000\083\000\031\000\221\000\
\\032\000\220\000\033\000\219\000\034\000\079\000\035\000\078\000\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\001\000\225\000\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\001\000\228\000\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\001\000\107\000\006\000\231\000\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\009\000\235\000\000\000\000\000\
\\000\000\000\000\
\\009\000\152\000\012\000\151\000\013\000\150\000\
\\014\000\238\000\015\000\237\000\000\000\000\000\
\\008\000\241\000\010\000\240\000\011\000\239\000\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\001\000\014\000\003\000\013\000\021\000\245\000\
\\022\000\011\000\023\000\010\000\024\000\009\000\025\000\008\000\
\\026\000\007\000\027\000\006\000\028\000\005\000\030\000\244\000\000\000\000\000\
\\001\000\014\000\003\000\013\000\020\000\247\000\
\\021\000\246\000\022\000\011\000\023\000\010\000\024\000\009\000\
\\025\000\008\000\026\000\007\000\027\000\006\000\028\000\005\000\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\001\000\014\000\003\000\013\000\021\000\068\000\
\\022\000\011\000\023\000\010\000\024\000\009\000\025\000\008\000\
\\026\000\007\000\027\000\006\000\028\000\005\000\029\000\248\000\000\000\000\000\
\\000\000\000\000\
\\008\000\072\000\018\000\071\000\019\000\249\000\000\000\000\000\
\\001\000\014\000\003\000\013\000\021\000\250\000\
\\022\000\011\000\023\000\010\000\024\000\009\000\025\000\008\000\
\\026\000\007\000\027\000\006\000\028\000\005\000\000\000\000\000\
\\001\000\014\000\003\000\013\000\021\000\251\000\
\\022\000\011\000\023\000\010\000\024\000\009\000\025\000\008\000\
\\026\000\007\000\027\000\006\000\028\000\005\000\000\000\000\000\
\\002\000\084\000\003\000\083\000\031\000\082\000\
\\032\000\081\000\033\000\080\000\034\000\079\000\035\000\078\000\
\\040\000\252\000\000\000\000\000\
\\000\000\000\000\
\\002\000\084\000\003\000\083\000\033\000\170\000\
\\034\000\079\000\035\000\078\000\045\000\254\000\000\000\000\000\
\\001\000\014\000\003\000\013\000\021\000\255\000\
\\022\000\011\000\023\000\010\000\024\000\009\000\025\000\008\000\
\\026\000\007\000\027\000\006\000\028\000\005\000\000\000\000\000\
\\002\000\084\000\003\000\083\000\031\000\000\001\
\\032\000\081\000\033\000\080\000\034\000\079\000\035\000\078\000\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\041\000\011\001\000\000\000\000\
\\000\000\000\000\
\\001\000\012\001\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\001\000\107\000\006\000\013\001\000\000\000\000\
\\000\000\000\000\
\\048\000\015\001\049\000\095\000\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\001\000\100\000\077\000\018\001\000\000\000\000\
\\000\000\000\000\
\\070\000\020\001\000\000\000\000\
\\001\000\102\000\072\000\023\001\000\000\000\000\
\\070\000\024\001\000\000\000\000\
\\009\000\152\000\012\000\151\000\013\000\150\000\
\\014\000\025\001\000\000\000\000\
\\000\000\000\000\
\\001\000\107\000\006\000\026\001\000\000\000\000\
\\000\000\000\000\
\\057\000\004\000\058\000\003\000\074\000\027\001\
\\076\000\110\000\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\001\000\014\000\003\000\013\000\020\000\029\001\
\\021\000\246\000\022\000\011\000\023\000\010\000\024\000\009\000\
\\025\000\008\000\026\000\007\000\027\000\006\000\028\000\005\000\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\001\000\014\000\003\000\013\000\021\000\031\001\
\\022\000\011\000\023\000\010\000\024\000\009\000\025\000\008\000\
\\026\000\007\000\027\000\006\000\028\000\005\000\000\000\000\000\
\\001\000\123\000\079\000\032\001\000\000\000\000\
\\057\000\036\001\062\000\035\001\063\000\034\001\
\\078\000\033\001\000\000\000\000\
\\002\000\084\000\003\000\083\000\034\000\128\000\
\\035\000\078\000\043\000\049\001\046\000\125\000\047\000\124\000\000\000\000\000\
\\000\000\000\000\
\\009\000\152\000\012\000\151\000\013\000\150\000\
\\014\000\051\001\000\000\000\000\
\\002\000\084\000\003\000\083\000\034\000\128\000\
\\035\000\078\000\043\000\127\000\044\000\052\001\046\000\125\000\
\\047\000\124\000\000\000\000\000\
\\000\000\000\000\
\\002\000\084\000\003\000\083\000\033\000\170\000\
\\034\000\079\000\035\000\078\000\045\000\053\001\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\001\000\014\000\003\000\013\000\021\000\055\001\
\\022\000\011\000\023\000\010\000\024\000\009\000\025\000\008\000\
\\026\000\007\000\027\000\006\000\028\000\005\000\000\000\000\000\
\\002\000\084\000\003\000\083\000\016\000\056\001\
\\017\000\131\000\031\000\130\000\032\000\081\000\033\000\080\000\
\\034\000\079\000\035\000\078\000\000\000\000\000\
\\004\000\134\000\055\000\057\001\000\000\000\000\
\\000\000\000\000\
\\049\000\138\000\051\000\060\001\052\000\136\000\000\000\000\000\
\\048\000\061\001\049\000\095\000\000\000\000\000\
\\000\000\000\000\
\\002\000\084\000\003\000\083\000\016\000\063\001\
\\017\000\131\000\031\000\130\000\032\000\081\000\033\000\080\000\
\\034\000\079\000\035\000\078\000\000\000\000\000\
\\057\000\004\000\058\000\115\000\060\000\064\001\000\000\000\000\
\\000\000\000\000\
\\001\000\014\000\003\000\013\000\022\000\066\001\
\\023\000\010\000\026\000\065\001\028\000\144\000\000\000\000\000\
\\001\000\014\000\003\000\013\000\022\000\066\001\
\\023\000\010\000\026\000\147\000\000\000\000\000\
\\009\000\152\000\012\000\151\000\013\000\150\000\
\\014\000\067\001\000\000\000\000\
\\000\000\000\000\
\\009\000\152\000\012\000\069\001\013\000\068\001\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\009\000\076\001\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\009\000\152\000\012\000\151\000\013\000\150\000\
\\014\000\077\001\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\002\000\084\000\003\000\083\000\031\000\176\000\
\\032\000\081\000\033\000\080\000\034\000\079\000\035\000\078\000\
\\039\000\078\001\000\000\000\000\
\\000\000\000\000\
\\002\000\084\000\003\000\083\000\031\000\176\000\
\\032\000\081\000\033\000\080\000\034\000\079\000\035\000\078\000\
\\039\000\079\001\000\000\000\000\
\\000\000\000\000\
\\008\000\180\000\036\000\179\000\037\000\080\001\000\000\000\000\
\\002\000\084\000\003\000\083\000\031\000\081\001\
\\032\000\081\000\033\000\080\000\034\000\079\000\035\000\078\000\000\000\000\000\
\\009\000\152\000\012\000\151\000\013\000\150\000\
\\014\000\082\001\000\000\000\000\
\\002\000\084\000\003\000\083\000\031\000\083\001\
\\032\000\081\000\033\000\080\000\034\000\079\000\035\000\078\000\000\000\000\000\
\\002\000\186\000\005\000\185\000\042\000\084\001\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\009\000\152\000\012\000\151\000\013\000\150\000\
\\014\000\086\001\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\050\000\087\001\000\000\000\000\
\\000\000\000\000\
\\001\000\107\000\006\000\089\001\073\000\088\001\000\000\000\000\
\\000\000\000\000\
\\057\000\036\001\062\000\093\001\063\000\034\001\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\057\000\004\000\058\000\003\000\074\000\096\001\
\\076\000\110\000\000\000\000\000\
\\000\000\000\000\
\\057\000\004\000\058\000\115\000\060\000\098\001\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\057\000\036\001\062\000\101\001\063\000\034\001\000\000\000\000\
\\000\000\000\000\
\\001\000\052\000\061\000\102\001\000\000\000\000\
\\004\000\104\001\066\000\103\001\000\000\000\000\
\\049\000\106\001\065\000\105\001\000\000\000\000\
\\001\000\108\001\064\000\107\001\000\000\000\000\
\\001\000\107\000\006\000\111\001\068\000\110\001\
\\069\000\109\001\000\000\000\000\
\\001\000\107\000\006\000\114\001\007\000\113\001\000\000\000\000\
\\057\000\036\001\062\000\115\001\063\000\034\001\000\000\000\000\
\\001\000\116\001\000\000\000\000\
\\001\000\118\001\067\000\117\001\000\000\000\000\
\\049\000\106\001\065\000\119\001\000\000\000\000\
\\049\000\138\000\051\000\120\001\052\000\136\000\000\000\000\000\
\\000\000\000\000\
\\057\000\036\001\062\000\122\001\063\000\034\001\000\000\000\000\
\\000\000\000\000\
\\001\000\014\000\003\000\013\000\021\000\123\001\
\\022\000\011\000\023\000\010\000\024\000\009\000\025\000\008\000\
\\026\000\007\000\027\000\006\000\028\000\005\000\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\002\000\084\000\003\000\083\000\033\000\170\000\
\\034\000\079\000\035\000\078\000\045\000\125\001\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\009\000\152\000\012\000\151\000\013\000\150\000\
\\014\000\126\001\000\000\000\000\
\\001\000\107\000\006\000\127\001\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\004\000\130\001\053\000\129\001\054\000\128\001\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\001\000\059\000\003\000\013\000\023\000\058\000\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\009\000\235\000\000\000\000\000\
\\009\000\132\001\000\000\000\000\
\\000\000\000\000\
\\009\000\152\000\012\000\151\000\013\000\150\000\
\\014\000\134\001\015\000\133\001\000\000\000\000\
\\000\000\000\000\
\\008\000\241\000\010\000\240\000\011\000\135\001\000\000\000\000\
\\009\000\152\000\012\000\151\000\013\000\150\000\
\\014\000\136\001\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\057\000\004\000\058\000\003\000\074\000\140\001\
\\076\000\110\000\000\000\000\000\
\\057\000\004\000\058\000\003\000\074\000\141\001\
\\076\000\110\000\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\001\000\014\000\003\000\013\000\021\000\145\001\
\\022\000\011\000\023\000\010\000\024\000\009\000\025\000\008\000\
\\026\000\007\000\027\000\006\000\028\000\005\000\059\000\144\001\000\000\000\000\
\\057\000\004\000\058\000\003\000\075\000\146\001\
\\076\000\001\000\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\001\000\014\000\003\000\013\000\021\000\149\001\
\\022\000\011\000\023\000\010\000\024\000\009\000\025\000\008\000\
\\026\000\007\000\027\000\006\000\028\000\005\000\000\000\000\000\
\\071\000\150\001\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\001\000\152\001\000\000\000\000\
\\000\000\000\000\
\\001\000\154\001\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\001\000\107\000\006\000\111\001\069\000\159\001\000\000\000\000\
\\000\000\000\000\
\\001\000\107\000\006\000\114\001\007\000\160\001\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\070\000\164\001\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\002\000\084\000\003\000\083\000\033\000\170\000\
\\034\000\079\000\035\000\078\000\045\000\165\001\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\001\000\167\001\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\002\000\084\000\003\000\083\000\031\000\168\001\
\\032\000\081\000\033\000\080\000\034\000\079\000\035\000\078\000\000\000\000\000\
\\002\000\084\000\003\000\083\000\016\000\169\001\
\\017\000\131\000\031\000\130\000\032\000\081\000\033\000\080\000\
\\034\000\079\000\035\000\078\000\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\001\000\107\000\006\000\089\001\057\000\004\000\
\\058\000\003\000\073\000\173\001\074\000\172\001\076\000\110\000\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\057\000\004\000\058\000\003\000\074\000\175\001\
\\076\000\110\000\000\000\000\000\
\\057\000\004\000\058\000\115\000\060\000\176\001\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\004\000\104\001\066\000\178\001\000\000\000\000\
\\000\000\000\000\
\\049\000\106\001\065\000\180\001\000\000\000\000\
\\000\000\000\000\
\\001\000\108\001\064\000\181\001\000\000\000\000\
\\070\000\182\001\000\000\000\000\
\\001\000\107\000\006\000\111\001\068\000\183\001\
\\069\000\109\001\000\000\000\000\
\\001\000\107\000\006\000\185\001\069\000\184\001\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\057\000\036\001\062\000\186\001\063\000\034\001\000\000\000\000\
\\001\000\118\001\067\000\187\001\000\000\000\000\
\\009\000\152\000\012\000\151\000\013\000\150\000\
\\014\000\188\001\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\004\000\130\001\053\000\189\001\054\000\128\001\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\001\000\107\000\006\000\089\001\073\000\191\001\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\001\000\014\000\003\000\013\000\021\000\145\001\
\\022\000\011\000\023\000\010\000\024\000\009\000\025\000\008\000\
\\026\000\007\000\027\000\006\000\028\000\005\000\059\000\194\001\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\001\000\107\000\006\000\089\001\073\000\195\001\000\000\000\000\
\\000\000\000\000\
\\009\000\152\000\012\000\151\000\013\000\150\000\
\\014\000\196\001\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\009\000\152\000\012\000\151\000\013\000\150\000\
\\014\000\198\001\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\\000\000\000\000\
\"
val numstates = 457
val string_to_int = fn(s,index) => (ordof(s,index) + 
			ordof(s,index+1)*256,index+2)
	val convert_string_to_row = fn (conv_key,conv_entry) =>
	     fn(s,index) =>
		let fun f (r,index) =
			let val (num,index) = string_to_int(s,index)
			    val (i,index) = string_to_int(s,index)
			in if num=0 then ((rev r,conv_entry i),index)
			   else f((conv_key (num-1),conv_entry i)::r,index)
			end
		in f(nil,index)
		end
	 val convert_string_to_row_list = fn conv_funcs => fn s =>
		    let val convert_row =convert_string_to_row conv_funcs
		 	fun f(r,index) =
			  if index < String.length s then
			    let val (newlist,index) = convert_row (s,index)
			    in f(newlist::r,index)
			    end
			  else rev r
		    in f(nil,0)
		    end
	 val entry_to_action = fn j =>
		       if j=0 then ACCEPT
		       else if j=1 then ERROR
		       else if j >= (numstates+2) then REDUCE (j-numstates-2)
		       else SHIFT (STATE (j-2))
	 val make_goto_table = convert_string_to_row_list(NT,STATE)
	 val make_action_table=convert_string_to_row_list(T,entry_to_action)
	 val gotoT = map (fn (a,b) => a) (make_goto_table gotoT)
	 val actionT = make_action_table actionT
     in LrTable.mkLrTable {actions=actionT,gotos=gotoT,
	  numStates=numstates,initialState=STATE 0}
     end
end
local open Header in
type pos = int
type arg = pos*pos -> ErrorMsg.severity -> string -> unit
structure MlyValue = 
struct
datatype svalue = VOID | ntVOID of unit | STRING of  (string)
 | REAL of  (string) | INT0 of  (int) | INT of  (int)
 | TYVAR of  (Symbol.symbol) | ID of  (Symbol.symbol)
 | interdec of  (dec susp) | importdec of  (string list)
 | fctb of  ( ( symbol * functorVar * fctb )  list susp)
 | fparam of  ( ( symbol * Structure * bool )  susp)
 | strb of  (bool ->  ( symbol*structureVar*strb )  list pathstamped)
 | sdec of  (dec pathnstamped) | sdecs' of  (dec list pathnstamped)
 | sdecs of  (dec list pathnstamped)
 | str of  (strArg -> strexp*Structure*thinning)
 | sigb of  (signatureVar list susp)
 | sigconstraint_op of  (Structure -> Structure option)
 | sign of  (bool*Structure -> signtype)
 | patheqn of  (symbol list list) | sharespec of  (spectype)
 | exnspec of  (spectype) | valspec of  (spectype)
 | tyspec of  (eqprop -> spectype) | strspec of  (spectype)
 | spec of  (spectype) | spec_s of  (spectype) | ops of  (symbol list)
 | ldecs of  (dec pathvstamped uvars) | exp_pa of  (exp list vstamped)
 | ldec of  (dec pathvstamped uvars) | fixity of  (fixity)
 | qid_p of  (structureVar list susp)
 | eb of  (eb list pathvstamped uvars)
 | constr of  ( ( ty * tyclooker -> symbol * bool * ty )  uvars)
 | constrs of  ( ( ty * tyclooker -> (symbol * bool * ty) list )  uvars)
 | db' of  (symbol*int*datacon list tpathed)
 | db of  ( ( symbol * int * datacon list tpathed )  list)
 | tyvar_pc of  (tyvar list) | tyvars of  (tyvar list)
 | tb of  (bool -> tb list pathvstamped)
 | clause of  (rawclause susp uvars)
 | clause' of  ( ( symbol * pat list )  susp uvars)
 | apats of  ( ( pat * fixity * complainer )  list susp uvars)
 | fb of  (rawclause list list susp uvars)
 | fb' of  (rawclause list susp uvars) | rvb of  (rawrvb list susp)
 | constraint of  (ty option susp uvars) | vb of  (vb list vstamped)
 | pat_list of  (pat list susp uvars)
 | pat_2c of  (pat list susp uvars)
 | plabels of  ( ( (symbol * pat) list * bool )  susp uvars)
 | plabel of  ( ( symbol * pat )  susp uvars)
 | apat'' of  (pat susp uvars)
 | apat' of  ( ( pat * fixity * complainer )  susp uvars)
 | apat of  ( ( pat * fixity * complainer )  susp uvars)
 | pat' of  (pat susp uvars) | pat of  (pat susp uvars)
 | exp_2c of  (exp list vstamped uvars)
 | exp_list of  (exp list vstamped uvars)
 | eexp of  (exp vstamped uvars) | dexp' of  (exp vstamped uvars)
 | dexp of  (exp vstamped uvars) | cexp' of  (exp vstamped uvars)
 | bexp of  (exp vstamped uvars) | aexp of  (exp vstamped uvars)
 | app_exp of  (exp precStack vstamped uvars)
 | exp of  (exp vstamped uvars) | exp_ps of  (exp list vstamped uvars)
 | elabels of  ( ( symbol * exp )  list vstamped uvars)
 | elabel of  ( ( symbol * exp )  vstamped uvars)
 | rule of  (rule vstamped uvars)
 | match of  (rule list vstamped uvars)
 | ty0_pc of  (ty list tsusp uvars) | ty of  (ty tsusp uvars)
 | tuple_ty of  (ty list tsusp uvars) | ty' of  (ty tsusp uvars)
 | tlabels of  ( ( symbol * ty )  list tsusp uvars)
 | tlabel of  ( ( symbol * ty )  tsusp uvars)
 | tycon of  (symbol list) | selector of  (symbol)
 | qid_p0 of  (symbol list list) | qid of  (symbol list)
 | opid of  (symbol susp) | op_op of  (unit susp) | int of  (int)
 | id of  (symbol) | ident of  (symbol)
end
type svalue = MlyValue.svalue
type result = dec susp
end
structure EC=
struct
open LrTable
val is_keyword =
fn (T 68) => true | (T 67) => true | (T 66) => true | (T 56) => true
 | (T 55) => true | (T 53) => true | (T 52) => true | (T 51) => true
 | (T 50) => true | (T 49) => true | (T 48) => true | (T 47) => true
 | (T 46) => true | (T 45) => true | (T 44) => true | (T 43) => true
 | (T 41) => true | (T 40) => true | (T 39) => true | (T 38) => true
 | (T 37) => true | (T 36) => true | (T 35) => true | (T 34) => true
 | (T 33) => true | (T 32) => true | (T 31) => true | (T 30) => true
 | (T 28) => true | (T 27) => true | (T 26) => true | (T 25) => true
 | (T 24) => true | (T 22) => true | (T 21) => true | (T 20) => true
 | (T 18) => true | (T 17) => true | (T 16) => true | (T 15) => true
 | (T 14) => true | (T 12) => true | (T 10) => true | (T 9) => true | 
(T 8) => true | _ => false
val preferred_insert =
fn (T 17) => true | (T 50) => true | (T 52) => true | _ => false
val preferred_subst =
fn (T 1) =>(T 59)::nil
|(T 10) =>(T 67)::nil
|(T 19) =>(T 24)::nil
|(T 24) =>(T 19)::nil
|(T 58) =>(T 38)::nil
|(T 59) =>(T 1)::nil
| _ => nil
val noShift = 
fn (T 0) => true | _ => false
val showTerminal =
fn (T 0) => "EOF"
  | (T 1) => "SEMICOLON"
  | (T 2) => "ID"
  | (T 3) => "TYVAR"
  | (T 4) => "INT"
  | (T 5) => "INT0"
  | (T 6) => "REAL"
  | (T 7) => "STRING"
  | (T 8) => "ABSTRACTION"
  | (T 9) => "ABSTYPE"
  | (T 10) => "AND"
  | (T 11) => "ARROW"
  | (T 12) => "AS"
  | (T 13) => "BAR"
  | (T 14) => "CASE"
  | (T 15) => "DATATYPE"
  | (T 16) => "DOTDOTDOT"
  | (T 17) => "ELSE"
  | (T 18) => "END"
  | (T 19) => "EQUAL"
  | (T 20) => "EQTYPE"
  | (T 21) => "EXCEPTION"
  | (T 22) => "DO"
  | (T 23) => "DOT"
  | (T 24) => "DARROW"
  | (T 25) => "FN"
  | (T 26) => "FUN"
  | (T 27) => "FUNCTOR"
  | (T 28) => "HANDLE"
  | (T 29) => "HASH"
  | (T 30) => "IF"
  | (T 31) => "IN"
  | (T 32) => "INCLUDE"
  | (T 33) => "INFIX"
  | (T 34) => "INFIXR"
  | (T 35) => "LET"
  | (T 36) => "LOCAL"
  | (T 37) => "NONFIX"
  | (T 38) => "OF"
  | (T 39) => "OP"
  | (T 40) => "OPEN"
  | (T 41) => "OVERLOAD"
  | (T 42) => "QUERY"
  | (T 43) => "RAISE"
  | (T 44) => "REC"
  | (T 45) => "SHARING"
  | (T 46) => "SIG"
  | (T 47) => "SIGNATURE"
  | (T 48) => "STRUCT"
  | (T 49) => "STRUCTURE"
  | (T 50) => "THEN"
  | (T 51) => "TYPE"
  | (T 52) => "VAL"
  | (T 53) => "WHILE"
  | (T 54) => "WILD"
  | (T 55) => "WITH"
  | (T 56) => "WITHTYPE"
  | (T 57) => "ASTERISK"
  | (T 58) => "COLON"
  | (T 59) => "COMMA"
  | (T 60) => "LBRACE"
  | (T 61) => "LBRACKET"
  | (T 62) => "LPAREN"
  | (T 63) => "RBRACE"
  | (T 64) => "RBRACKET"
  | (T 65) => "RPAREN"
  | (T 66) => "ORELSE"
  | (T 67) => "ANDALSO"
  | (T 68) => "IMPORT"
  | _ => "bogus-term"
val errtermvalue=
let open Header in
fn (T 2) => MlyValue.ID((Symbol.symbol "bogus")) | 
(T 3) => MlyValue.TYVAR((Symbol.symbol "'bogus")) | 
(T 4) => MlyValue.INT((1)) | 
(T 5) => MlyValue.INT0((0)) | 
(T 6) => MlyValue.REAL(("0.0")) | 
(T 7) => MlyValue.STRING(("")) | 
_ => MlyValue.VOID
end
val terms = (T 0) :: (T 1) :: (T 8) :: (T 9) :: (T 10) :: (T 11) :: 
(T 12) :: (T 13) :: (T 14) :: (T 15) :: (T 16) :: (T 17) :: (T 18) :: 
(T 19) :: (T 20) :: (T 21) :: (T 22) :: (T 23) :: (T 24) :: (T 25) :: 
(T 26) :: (T 27) :: (T 28) :: (T 29) :: (T 30) :: (T 31) :: (T 32) :: 
(T 33) :: (T 34) :: (T 35) :: (T 36) :: (T 37) :: (T 38) :: (T 39) :: 
(T 40) :: (T 41) :: (T 42) :: (T 43) :: (T 44) :: (T 45) :: (T 46) :: 
(T 47) :: (T 48) :: (T 49) :: (T 50) :: (T 51) :: (T 52) :: (T 53) :: 
(T 54) :: (T 55) :: (T 56) :: (T 57) :: (T 58) :: (T 59) :: (T 60) :: 
(T 61) :: (T 62) :: (T 63) :: (T 64) :: (T 65) :: (T 66) :: (T 67) :: 
(T 68) :: nil
end
structure Actions =
struct 
exception mlyAction of int
val actions = 
let open Header
in
fn (i392,defaultPos,stack,
    (error):arg) =>
case (i392,stack)
of (0,(_,(MlyValue.INT (INT1 as INT),INTleft as INT1left,INTright as 
INT1right)) :: rest671) =>
let val result = 
MlyValue.int (((INT)))
in (LrTable.NT 2,(result,INT1left,INT1right),rest671)
end
| (1,(_,(MlyValue.INT0 (INT01 as INT0),INT0left as INT01left,
INT0right as INT01right)) :: rest671) =>
let val result = 
MlyValue.int (((INT0)))
in (LrTable.NT 2,(result,INT01left,INT01right),rest671)
end
| (2,(_,(MlyValue.ID (ID1 as ID),IDleft as ID1left,IDright as ID1right
)) :: rest671) =>
let val result = 
MlyValue.id (((ID)))
in (LrTable.NT 1,(result,ID1left,ID1right),rest671)
end
| (3,(_,(_,ASTERISKleft as ASTERISK1left,ASTERISKright as 
ASTERISK1right)) :: rest671) =>
let val result = 
MlyValue.id (((ASTERISKsym)))
in (LrTable.NT 1,(result,ASTERISK1left,ASTERISK1right),rest671)
end
| (4,(_,(MlyValue.ID (ID1 as ID),IDleft as ID1left,IDright as ID1right
)) :: rest671) =>
let val result = 
MlyValue.ident (((ID)))
in (LrTable.NT 0,(result,ID1left,ID1right),rest671)
end
| (5,(_,(_,ASTERISKleft as ASTERISK1left,ASTERISKright as 
ASTERISK1right)) :: rest671) =>
let val result = 
MlyValue.ident (((ASTERISKsym)))
in (LrTable.NT 0,(result,ASTERISK1left,ASTERISK1right),rest671)
end
| (6,(_,(_,EQUALleft as EQUAL1left,EQUALright as EQUAL1right)) :: rest671) =>
let val result = 
MlyValue.ident (((EQUALsym)))
in (LrTable.NT 0,(result,EQUAL1left,EQUAL1right),rest671)
end
| (7,(_,(_,OPleft as OP1left,OPright as OP1right)) :: rest671) =>
let val result = 
MlyValue.op_op (((
fn()=> error (OPleft,OPright) WARN "unnecessary `op'")))
in (LrTable.NT 3,(result,OP1left,OP1right),rest671)
end
| (8,rest671) =>
let val result = 
MlyValue.op_op (((fn()=>())))
in (LrTable.NT 3,(result,defaultPos,defaultPos),rest671)
end
| (9,(_,(MlyValue.id (id1 as id),idleft as id1left,idright as id1right
)) :: rest671) =>
let val result = 
MlyValue.opid (((
fn()=>(case lookFIX id of NONfix => ()
				  | _ => error(idleft,idright)COMPLAIN
						"nonfix identifier required";
				id)
)))
in (LrTable.NT 4,(result,id1left,id1right),rest671)
end
| (10,(_,(MlyValue.ident (ident1 as ident),identleft as ident1left,
identright as ident1right)) :: (_,(_,OPleft as OP1left,OPright as 
OP1right)) :: rest671) =>
let val result = 
MlyValue.opid (((fn()=>ident)))
in (LrTable.NT 4,(result,OP1left,ident1right),rest671)
end
| (11,(_,(MlyValue.qid (qid1 as qid),qidleft as qid1left,qidright as 
qid1right)) :: (_,(_,DOTleft as DOT1left,DOTright as DOT1right)) :: 
(_,(MlyValue.ID (ID1 as ID),IDleft as ID1left,IDright as ID1right
)) :: rest671) =>
let val result = 
MlyValue.qid (((ID :: qid)))
in (LrTable.NT 5,(result,ID1left,qid1right),rest671)
end
| (12,(_,(MlyValue.ident (ident1 as ident),identleft as ident1left,
identright as ident1right)) :: rest671) =>
let val result = 
MlyValue.qid ((([ident])))
in (LrTable.NT 5,(result,ident1left,ident1right),rest671)
end
| (13,(_,(MlyValue.ID (ID1 as ID),IDleft as ID1left,IDright as 
ID1right)) :: rest671) =>
let val result = 
MlyValue.selector (((ID)))
in (LrTable.NT 7,(result,ID1left,ID1right),rest671)
end
| (14,(_,(MlyValue.INT (INT1 as INT),INTleft as INT1left,INTright as 
INT1right)) :: rest671) =>
let val result = 
MlyValue.selector (((Symbol.symbol(makestring INT))))
in (LrTable.NT 7,(result,INT1left,INT1right),rest671)
end
| (15,(_,(MlyValue.tycon (tycon1 as tycon),tyconleft as tycon1left,
tyconright as tycon1right)) :: (_,(_,DOTleft as DOT1left,DOTright as 
DOT1right)) :: (_,(MlyValue.ID (ID1 as ID),IDleft as ID1left,
IDright as ID1right)) :: rest671) =>
let val result = 
MlyValue.tycon (((ID :: tycon)))
in (LrTable.NT 8,(result,ID1left,tycon1right),rest671)
end
| (16,(_,(MlyValue.ID (ID1 as ID),IDleft as ID1left,IDright as 
ID1right)) :: rest671) =>
let val result = 
MlyValue.tycon ((([ID])))
in (LrTable.NT 8,(result,ID1left,ID1right),rest671)
end
| (17,(_,(MlyValue.ty (ty1 as ty),tyleft as ty1left,tyright as 
ty1right)) :: (_,(_,COLONleft as COLON1left,COLONright as COLON1right
)) :: (_,(MlyValue.selector (selector1 as selector),selectorleft as 
selector1left,selectorright as selector1right)) :: rest671) =>
let val result = 
MlyValue.tlabel (((fn $ =>(selector, E ty $), V ty)))
in (LrTable.NT 9,(result,selector1left,ty1right),rest671)
end
| (18,(_,(MlyValue.tlabels (tlabels1 as tlabels),tlabelsleft as 
tlabels1left,tlabelsright as tlabels1right)) :: (_,(_,COMMAleft as 
COMMA1left,COMMAright as COMMA1right)) :: (_,(MlyValue.tlabel (tlabel1
 as tlabel),tlabelleft as tlabel1left,tlabelright as tlabel1right
)) :: rest671) =>
let val result = 
MlyValue.tlabels (((
fn $ => E tlabel $ :: E tlabels $,
				 V tlabel \/ V tlabels)))
in (LrTable.NT 10,(result,tlabel1left,tlabels1right),rest671)
end
| (19,(_,(MlyValue.tlabel (tlabel1 as tlabel),tlabelleft as 
tlabel1left,tlabelright as tlabel1right)) :: rest671) =>
let val result = 
MlyValue.tlabels (((fn $ => [E tlabel $], V tlabel)))
in (LrTable.NT 10,(result,tlabel1left,tlabel1right),rest671)
end
| (20,(_,(MlyValue.TYVAR (TYVAR1 as TYVAR),TYVARleft as TYVAR1left,
TYVARright as TYVAR1right)) :: rest671) =>
let val result = 
MlyValue.ty' (((
let val tyv = mkTyvar(mkUBOUND TYVAR)
			  in (fn $ => VARty tyv, singleton_tyvar tyv)
			 end
)))
in (LrTable.NT 11,(result,TYVAR1left,TYVAR1right),rest671)
end
| (21,(_,(_,RBRACEleft as RBRACE1left,RBRACEright as RBRACE1right
)) :: (_,(MlyValue.tlabels (tlabels1 as tlabels),tlabelsleft as 
tlabels1left,tlabelsright as tlabels1right)) :: (_,(_,LBRACEleft as 
LBRACE1left,LBRACEright as LBRACE1right)) :: rest671) =>
let val result = 
MlyValue.ty' (((
fn $ => make_recordTy(E tlabels $,
						error(LBRACEleft,RBRACEright)),
			 V tlabels
)))
in (LrTable.NT 11,(result,LBRACE1left,RBRACE1right),rest671)
end
| (22,(_,(_,RBRACEleft as RBRACE1left,RBRACEright as RBRACE1right
)) :: (_,(_,LBRACEleft as LBRACE1left,LBRACEright as LBRACE1right
)) :: rest671) =>
let val result = 
MlyValue.ty' (((
fn $ => make_recordTy(nil,
					error(LBRACEleft,RBRACEright)),
			 no_tyvars
)))
in (LrTable.NT 11,(result,LBRACE1left,RBRACE1right),rest671)
end
| (23,(_,(MlyValue.tycon (tycon1 as tycon),tyconleft as tycon1left,
tyconright as tycon1right)) :: (_,(_,RPARENleft as RPAREN1left,
RPARENright as RPAREN1right)) :: (_,(MlyValue.ty0_pc (ty0_pc1
 as ty0_pc),ty0_pcleft as ty0_pc1left,ty0_pcright as ty0_pc1right
)) :: (_,(_,LPARENleft as LPAREN1left,LPARENright as LPAREN1right
)) :: rest671) =>
let val result = 
MlyValue.ty' (((
fn look =>let val ts = E ty0_pc look
			  in CONty(look(tycon,length ts,error(tyconleft,tyconright)COMPLAIN),ts)
				 end,
			 V ty0_pc
)))
in (LrTable.NT 11,(result,LPAREN1left,tycon1right),rest671)
end
| (24,(_,(_,RPARENleft as RPAREN1left,RPARENright as RPAREN1right
)) :: (_,(MlyValue.ty (ty1 as ty),tyleft as ty1left,tyright as 
ty1right)) :: (_,(_,LPARENleft as LPAREN1left,LPARENright as 
LPAREN1right)) :: rest671) =>
let val result = 
MlyValue.ty' (((ty)))
in (LrTable.NT 11,(result,LPAREN1left,RPAREN1right),rest671)
end
| (25,(_,(MlyValue.tycon (tycon1 as tycon),tyconleft as tycon1left,
tyconright as tycon1right)) :: (_,(MlyValue.ty' (ty'1 as ty'),
ty'left as ty'1left,ty'right as ty'1right)) :: rest671) =>
let val result = 
MlyValue.ty' (((
fn look =>CONty(look(tycon,1,
					error(tyconleft,tyconright)COMPLAIN),
					[E ty' look]),
			 V ty'
)))
in (LrTable.NT 11,(result,ty'1left,tycon1right),rest671)
end
| (26,(_,(MlyValue.tycon (tycon1 as tycon),tyconleft as tycon1left,
tyconright as tycon1right)) :: rest671) =>
let val result = 
MlyValue.ty' (((
fn look =>CONty(look(tycon, 0,
				  error(tyconleft,tyconright)COMPLAIN),[]),
			 no_tyvars
)))
in (LrTable.NT 11,(result,tycon1left,tycon1right),rest671)
end
| (27,(_,(MlyValue.tuple_ty (tuple_ty1 as tuple_ty),tuple_tyleft as 
tuple_ty1left,tuple_tyright as tuple_ty1right)) :: (_,(_,
ASTERISKleft as ASTERISK1left,ASTERISKright as ASTERISK1right)) :: 
(_,(MlyValue.ty' (ty'1 as ty'),ty'left as ty'1left,ty'right as 
ty'1right)) :: rest671) =>
let val result = 
MlyValue.tuple_ty (((
fn $ => E ty' $ :: E tuple_ty $,
			  V ty' \/ V tuple_ty)))
in (LrTable.NT 12,(result,ty'1left,tuple_ty1right),rest671)
end
| (28,(_,(MlyValue.ty' (ty'2),ty'2left,ty'2right)) :: (_,(_,
ASTERISKleft as ASTERISK1left,ASTERISKright as ASTERISK1right)) :: 
(_,(MlyValue.ty' (ty'1 as ty'),ty'left as ty'1left,ty'right as 
ty'1right)) :: rest671) =>
let val result = 
MlyValue.tuple_ty (((fn $ =>[E ty'1 $, E ty'2 $], V ty'1 \/ V ty'2)))
in (LrTable.NT 12,(result,ty'1left,ty'2right),rest671)
end
| (29,(_,(MlyValue.tuple_ty (tuple_ty1 as tuple_ty),tuple_tyleft as 
tuple_ty1left,tuple_tyright as tuple_ty1right)) :: rest671) =>
let val result = 
MlyValue.ty (((fn $ =>tupleTy(E tuple_ty $), V tuple_ty)))
in (LrTable.NT 13,(result,tuple_ty1left,tuple_ty1right),rest671)
end
| (30,(_,(MlyValue.ty (ty2),ty2left,ty2right)) :: (_,(_,ARROWleft as 
ARROW1left,ARROWright as ARROW1right)) :: (_,(MlyValue.ty (ty1 as ty),
tyleft as ty1left,tyright as ty1right)) :: rest671) =>
let val result = 
MlyValue.ty (((
fn $ =>CONty(arrowTycon, [E ty1 $, E ty2 $]),
			 V ty1 \/ V ty2)))
in (LrTable.NT 13,(result,ty1left,ty2right),rest671)
end
| (31,(_,(MlyValue.ty' (ty'1 as ty'),ty'left as ty'1left,ty'right as 
ty'1right)) :: rest671) =>
let val result = 
MlyValue.ty (((ty')))
in (LrTable.NT 13,(result,ty'1left,ty'1right),rest671)
end
| (32,(_,(MlyValue.ty (ty2),ty2left,ty2right)) :: (_,(_,COMMAleft as 
COMMA1left,COMMAright as COMMA1right)) :: (_,(MlyValue.ty (ty1 as ty),
tyleft as ty1left,tyright as ty1right)) :: rest671) =>
let val result = 
MlyValue.ty0_pc (((fn $ => [E ty1 $, E ty2 $], V ty1 \/ V ty2)))
in (LrTable.NT 14,(result,ty1left,ty2right),rest671)
end
| (33,(_,(MlyValue.ty0_pc (ty0_pc1 as ty0_pc),ty0_pcleft as 
ty0_pc1left,ty0_pcright as ty0_pc1right)) :: (_,(_,COMMAleft as 
COMMA1left,COMMAright as COMMA1right)) :: (_,(MlyValue.ty (ty1 as ty),
tyleft as ty1left,tyright as ty1right)) :: rest671) =>
let val result = 
MlyValue.ty0_pc (((fn $ => E ty $ :: E ty0_pc $, V ty \/ V ty0_pc)))
in (LrTable.NT 14,(result,ty1left,ty0_pc1right),rest671)
end
| (34,(_,(MlyValue.rule (rule1 as rule),ruleleft as rule1left,
ruleright as rule1right)) :: rest671) =>
let val result = 
MlyValue.match (((fn st => [E rule st], V rule)))
in (LrTable.NT 15,(result,rule1left,rule1right),rest671)
end
| (35,(_,(MlyValue.match (match1 as match),matchleft as match1left,
matchright as match1right)) :: (_,(_,BARleft as BAR1left,BARright as 
BAR1right)) :: (_,(MlyValue.rule (rule1 as rule),ruleleft as rule1left
,ruleright as rule1right)) :: rest671) =>
let val result = 
MlyValue.match (((fn st => E rule st :: E match st, V rule \/ V match)))
in (LrTable.NT 15,(result,rule1left,match1right),rest671)
end
| (36,(_,(MlyValue.exp (exp1 as exp),expleft as exp1left,expright as 
exp1right)) :: (_,(_,DARROWleft as DARROW1left,DARROWright as 
DARROW1right)) :: (_,(MlyValue.pat (pat1 as pat),patleft as pat1left,
patright as pat1right)) :: rest671) =>
let val result = 
MlyValue.rule (((
makeRULE(E pat, fn $ => markexp(E exp $,expleft,expright),
					error(patleft,patright)),
			 V pat \/ V exp
)))
in (LrTable.NT 16,(result,pat1left,exp1right),rest671)
end
| (37,(_,(MlyValue.exp (exp1 as exp),expleft as exp1left,expright as 
exp1right)) :: (_,(_,EQUALleft as EQUAL1left,EQUALright as EQUAL1right
)) :: (_,(MlyValue.selector (selector1 as selector),selectorleft as 
selector1left,selectorright as selector1right)) :: rest671) =>
let val result = 
MlyValue.elabel (((fn st => (selector,E exp st), V exp)))
in (LrTable.NT 17,(result,selector1left,exp1right),rest671)
end
| (38,(_,(MlyValue.elabels (elabels1 as elabels),elabelsleft as 
elabels1left,elabelsright as elabels1right)) :: (_,(_,COMMAleft as 
COMMA1left,COMMAright as COMMA1right)) :: (_,(MlyValue.elabel (elabel1
 as elabel),elabelleft as elabel1left,elabelright as elabel1right
)) :: rest671) =>
let val result = 
MlyValue.elabels (((
fn st => (E elabel st :: E elabels st),
			 V elabel \/ V elabels)))
in (LrTable.NT 18,(result,elabel1left,elabels1right),rest671)
end
| (39,(_,(MlyValue.elabel (elabel1 as elabel),elabelleft as 
elabel1left,elabelright as elabel1right)) :: rest671) =>
let val result = 
MlyValue.elabels (((fn st => [E elabel st], V elabel)))
in (LrTable.NT 18,(result,elabel1left,elabel1right),rest671)
end
| (40,(_,(MlyValue.exp (exp1 as exp),expleft as exp1left,expright as 
exp1right)) :: rest671) =>
let val result = 
MlyValue.exp_ps (((fn st => [E exp st], V exp)))
in (LrTable.NT 19,(result,exp1left,exp1right),rest671)
end
| (41,(_,(MlyValue.exp_ps (exp_ps1 as exp_ps),exp_psleft as 
exp_ps1left,exp_psright as exp_ps1right)) :: (_,(_,SEMICOLONleft as 
SEMICOLON1left,SEMICOLONright as SEMICOLON1right)) :: (_,(MlyValue.exp
 (exp1 as exp),expleft as exp1left,expright as exp1right)) :: rest671) =>
let val result = 
MlyValue.exp_ps (((fn st => E exp st :: E exp_ps st, V exp \/ V exp_ps
)))
in (LrTable.NT 19,(result,exp1left,exp_ps1right),rest671)
end
| (42,(_,(MlyValue.dexp' (dexp'1 as dexp'),dexp'left as dexp'1left,
dexp'right as dexp'1right)) :: rest671) =>
let val result = 
MlyValue.exp (((dexp')))
in (LrTable.NT 20,(result,dexp'1left,dexp'1right),rest671)
end
| (43,(_,(MlyValue.dexp' (dexp'1 as dexp'),dexp'left as dexp'1left,
dexp'right as dexp'1right)) :: (_,(_,ORELSEleft as ORELSE1left,
ORELSEright as ORELSE1right)) :: (_,(MlyValue.eexp (eexp1 as eexp),
eexpleft as eexp1left,eexpright as eexp1right)) :: rest671) =>
let val result = 
MlyValue.exp (((
fn st=> ORELSEexp(markexp(E eexp st,eexpleft,eexpright),
				   		markexp(E dexp' st,dexp'left,dexp'right)),
			 V eexp \/ V dexp'
)))
in (LrTable.NT 20,(result,eexp1left,dexp'1right),rest671)
end
| (44,(_,(MlyValue.match (match1 as match),matchleft as match1left,
matchright as match1right)) :: (_,(_,HANDLEleft as HANDLE1left,
HANDLEright as HANDLE1right)) :: (_,(MlyValue.eexp (eexp1 as eexp),
eexpleft as eexp1left,eexpright as eexp1right)) :: rest671) =>
let val result = 
MlyValue.exp (((
fn st=> makeHANDLEexp(E eexp st, E match st),
				 V eexp \/ V match)))
in (LrTable.NT 20,(result,eexp1left,match1right),rest671)
end
| (45,(_,(MlyValue.eexp (eexp1 as eexp),eexpleft as eexp1left,
eexpright as eexp1right)) :: rest671) =>
let val result = 
MlyValue.exp (((eexp)))
in (LrTable.NT 20,(result,eexp1left,eexp1right),rest671)
end
| (46,(_,(MlyValue.eexp (eexp2),eexp2left,eexp2right)) :: (_,(_,
ORELSEleft as ORELSE1left,ORELSEright as ORELSE1right)) :: (_,(
MlyValue.eexp (eexp1 as eexp),eexpleft as eexp1left,eexpright as 
eexp1right)) :: rest671) =>
let val result = 
MlyValue.eexp (((
fn st=> ORELSEexp(markexp(E eexp1 st, eexp1left,eexp1right),
					 markexp(E eexp2 st,eexp2left,eexpright)),
			 V eexp1 \/ V eexp2
)))
in (LrTable.NT 27,(result,eexp1left,eexp2right),rest671)
end
| (47,(_,(MlyValue.dexp (dexp1 as dexp),dexpleft as dexp1left,
dexpright as dexp1right)) :: rest671) =>
let val result = 
MlyValue.eexp (((dexp)))
in (LrTable.NT 27,(result,dexp1left,dexp1right),rest671)
end
| (48,(_,(MlyValue.dexp (dexp2),dexp2left,dexp2right)) :: (_,(_,
ANDALSOleft as ANDALSO1left,ANDALSOright as ANDALSO1right)) :: (_,(
MlyValue.dexp (dexp1 as dexp),dexpleft as dexp1left,dexpright as 
dexp1right)) :: rest671) =>
let val result = 
MlyValue.dexp (((
fn st=> ANDALSOexp(markexp(E dexp1 st,dexp1left,dexp1right),
				markexp(E dexp2 st,dexp2left,dexp2right)),
			 V dexp1 \/ V dexp2
)))
in (LrTable.NT 25,(result,dexp1left,dexp2right),rest671)
end
| (49,(_,(MlyValue.ty (ty1 as ty),tyleft as ty1left,tyright as 
ty1right)) :: (_,(_,COLONleft as COLON1left,COLONright as COLON1right
)) :: (_,(MlyValue.app_exp (app_exp1 as app_exp),app_expleft as 
app_exp1left,app_expright as app_exp1right)) :: rest671) =>
let val result = 
MlyValue.dexp (((
fn st=> CONSTRAINTexp(exp_finish(E app_exp st,
				       error(app_expright,app_expright)),
					E ty tyArg),
			 V app_exp \/ V ty
)))
in (LrTable.NT 25,(result,app_exp1left,ty1right),rest671)
end
| (50,(_,(MlyValue.app_exp (app_exp1 as app_exp),app_expleft as 
app_exp1left,app_expright as app_exp1right)) :: rest671) =>
let val result = 
MlyValue.dexp (((
fn st=> exp_finish(E app_exp st,
					error(app_expright,app_expright)),
			 V app_exp
)))
in (LrTable.NT 25,(result,app_exp1left,app_exp1right),rest671)
end
| (51,(_,(MlyValue.cexp' (cexp'1 as cexp'),cexp'left as cexp'1left,
cexp'right as cexp'1right)) :: rest671) =>
let val result = 
MlyValue.dexp' (((cexp')))
in (LrTable.NT 26,(result,cexp'1left,cexp'1right),rest671)
end
| (52,(_,(MlyValue.cexp' (cexp'1 as cexp'),cexp'left as cexp'1left,
cexp'right as cexp'1right)) :: (_,(_,ANDALSOleft as ANDALSO1left,
ANDALSOright as ANDALSO1right)) :: (_,(MlyValue.dexp (dexp1 as dexp),
dexpleft as dexp1left,dexpright as dexp1right)) :: rest671) =>
let val result = 
MlyValue.dexp' (((
fn st=> ANDALSOexp(markexp(E dexp st, 
						dexpleft,dexpright),
				    markexp(E cexp' st,cexp'left,cexp'right)),
			 V dexp \/ V cexp'
)))
in (LrTable.NT 26,(result,dexp1left,cexp'1right),rest671)
end
| (53,(_,(MlyValue.bexp (bexp1 as bexp),bexpleft as bexp1left,
bexpright as bexp1right)) :: (_,(MlyValue.app_exp (app_exp1 as app_exp
),app_expleft as app_exp1left,app_expright as app_exp1right)) :: rest671) =>
let val result = 
MlyValue.cexp' (((
fn st =>  exp_finish(exp_parse'(E app_exp st, 
					markexp(E bexp st, bexpleft,bexpright),
					NONfix, error(bexpleft,bexpright)),
						error(bexpright,bexpright)),
			 V app_exp \/ V bexp
)))
in (LrTable.NT 24,(result,app_exp1left,bexp1right),rest671)
end
| (54,(_,(MlyValue.bexp (bexp1 as bexp),bexpleft as bexp1left,
bexpright as bexp1right)) :: rest671) =>
let val result = 
MlyValue.cexp' (((bexp)))
in (LrTable.NT 24,(result,bexp1left,bexp1right),rest671)
end
| (55,(_,(MlyValue.match (match1 as match),matchleft as match1left,
matchright as match1right)) :: (_,(_,FNleft as FN1left,FNright as 
FN1right)) :: rest671) =>
let val result = 
MlyValue.bexp (((
fn st=> markexp(FNexp(completeMatch(E match st)),
					 FNleft,matchright),
			 V match
)))
in (LrTable.NT 23,(result,FN1left,match1right),rest671)
end
| (56,(_,(MlyValue.match (match1 as match),matchleft as match1left,
matchright as match1right)) :: (_,(_,OFleft as OF1left,OFright as 
OF1right)) :: (_,(MlyValue.exp (exp1 as exp),expleft as exp1left,
expright as exp1right)) :: (_,(_,CASEleft as CASE1left,CASEright as 
CASE1right)) :: rest671) =>
let val result = 
MlyValue.bexp (((
fn st=>markexp(CASEexp(E exp st, 
						completeMatch(E match st)),
						CASEleft,matchright),
			 V exp \/ V match
)))
in (LrTable.NT 23,(result,CASE1left,match1right),rest671)
end
| (57,(_,(MlyValue.exp (exp2),exp2left,exp2right)) :: (_,(_,DOleft as 
DO1left,DOright as DO1right)) :: (_,(MlyValue.exp (exp1 as exp),
expleft as exp1left,expright as exp1right)) :: (_,(_,WHILEleft as 
WHILE1left,WHILEright as WHILE1right)) :: rest671) =>
let val result = 
MlyValue.bexp (((
fn st=> WHILEexp(E exp1 st,
					markexp(E exp2 st,exp2left,exp2right)),
			 V exp1 \/ V exp2
)))
in (LrTable.NT 23,(result,WHILE1left,exp2right),rest671)
end
| (58,(_,(MlyValue.exp (exp3),exp3left,exp3right)) :: (_,(_,
ELSEleft as ELSE1left,ELSEright as ELSE1right)) :: (_,(MlyValue.exp (
exp2),exp2left,exp2right)) :: (_,(_,THENleft as THEN1left,
THENright as THEN1right)) :: (_,(MlyValue.exp (exp1 as exp),
expleft as exp1left,expright as exp1right)) :: (_,(_,IFleft as IF1left
,IFright as IF1right)) :: rest671) =>
let val result = 
MlyValue.bexp (((
fn st=>IFexp(E exp1 st, 
					markexp(E exp2 st,exp2left,exp2right),
				        markexp(E exp3 st,exp3left,exp3right)),
			 V exp1 \/ V exp2 \/ V exp3
)))
in (LrTable.NT 23,(result,IF1left,exp3right),rest671)
end
| (59,(_,(MlyValue.exp (exp1 as exp),expleft as exp1left,expright as 
exp1right)) :: (_,(_,RAISEleft as RAISE1left,RAISEright as RAISE1right
)) :: rest671) =>
let val result = 
MlyValue.bexp (((
fn st=>markexp(RAISEexp(E exp st),RAISEleft,expright),
			 V exp)))
in (LrTable.NT 23,(result,RAISE1left,exp1right),rest671)
end
| (60,(_,(MlyValue.aexp (aexp1 as aexp),aexpleft as aexp1left,
aexpright as aexp1right)) :: rest671) =>
let val result = 
MlyValue.app_exp (((
fn st => exp_start(markexp(E aexp st, aexpleft,aexpright),
					    NONfix, 
					    error (aexpleft,aexpright)),
			 V aexp
)))
in (LrTable.NT 21,(result,aexp1left,aexp1right),rest671)
end
| (61,(_,(MlyValue.ident (ident1 as ident),identleft as ident1left,
identright as ident1right)) :: rest671) =>
let val result = 
MlyValue.app_exp (((
fn st => let val e = error(identleft,identright)
			       in exp_start(markexp(lookID(ident,e),identleft,identright),
					    lookFIX ident, e)
			 end,
			 no_tyvars
)))
in (LrTable.NT 21,(result,ident1left,ident1right),rest671)
end
| (62,(_,(MlyValue.aexp (aexp1 as aexp),aexpleft as aexp1left,
aexpright as aexp1right)) :: (_,(MlyValue.app_exp (app_exp1 as app_exp
),app_expleft as app_exp1left,app_expright as app_exp1right)) :: rest671) =>
let val result = 
MlyValue.app_exp (((
fn st => exp_parse(E app_exp st, 
					markexp(E aexp st, aexpleft,aexpright),
					NONfix,
					error (aexpleft,aexpright)),
			 V app_exp \/ V aexp
)))
in (LrTable.NT 21,(result,app_exp1left,aexp1right),rest671)
end
| (63,(_,(MlyValue.ident (ident1 as ident),identleft as ident1left,
identright as ident1right)) :: (_,(MlyValue.app_exp (app_exp1
 as app_exp),app_expleft as app_exp1left,app_expright as app_exp1right
)) :: rest671) =>
let val result = 
MlyValue.app_exp (((
fn st => let val e = error(identleft,identright)
			           in exp_parse(E app_exp st, 
						markexp(lookID(ident,e), identleft,identright),
						lookFIX ident, e)
				  end,
			 V app_exp
)))
in (LrTable.NT 21,(result,app_exp1left,ident1right),rest671)
end
| (64,(_,(MlyValue.ident (ident1 as ident),identleft as ident1left,
identright as ident1right)) :: (_,(_,OPleft as OP1left,OPright as 
OP1right)) :: rest671) =>
let val result = 
MlyValue.aexp (((
fn st=> lookID(ident,error(identleft,identright)),
				 no_tyvars)))
in (LrTable.NT 22,(result,OP1left,ident1right),rest671)
end
| (65,(_,(MlyValue.qid (qid1 as qid),qidleft as qid1left,qidright as 
qid1right)) :: (_,(_,DOTleft as DOT1left,DOTright as DOT1right)) :: 
(_,(MlyValue.ID (ID1 as ID),IDleft as ID1left,IDright as ID1right
)) :: rest671) =>
let val result = 
MlyValue.aexp (((
fn st=> varcon(lookPathVARCON(ID::qid,
						    error(IDleft,qidright)COMPLAIN)),
				 no_tyvars
)))
in (LrTable.NT 22,(result,ID1left,qid1right),rest671)
end
| (66,(_,(MlyValue.int (int1 as int),intleft as int1left,intright as 
int1right)) :: rest671) =>
let val result = 
MlyValue.aexp (((fn st => INTexp int, no_tyvars)))
in (LrTable.NT 22,(result,int1left,int1right),rest671)
end
| (67,(_,(MlyValue.REAL (REAL1 as REAL),REALleft as REAL1left,
REALright as REAL1right)) :: rest671) =>
let val result = 
MlyValue.aexp (((fn st => REALexp REAL, no_tyvars)))
in (LrTable.NT 22,(result,REAL1left,REAL1right),rest671)
end
| (68,(_,(MlyValue.STRING (STRING1 as STRING),STRINGleft as 
STRING1left,STRINGright as STRING1right)) :: rest671) =>
let val result = 
MlyValue.aexp (((fn st => STRINGexp STRING, no_tyvars)))
in (LrTable.NT 22,(result,STRING1left,STRING1right),rest671)
end
| (69,(_,(MlyValue.selector (selector1 as selector),selectorleft as 
selector1left,selectorright as selector1right)) :: (_,(_,HASHleft as 
HASH1left,HASHright as HASH1right)) :: rest671) =>
let val result = 
MlyValue.aexp (((fn st => SELECTORexp selector, no_tyvars)))
in (LrTable.NT 22,(result,HASH1left,selector1right),rest671)
end
| (70,(_,(_,RBRACEleft as RBRACE1left,RBRACEright as RBRACE1right
)) :: (_,(MlyValue.elabels (elabels1 as elabels),elabelsleft as 
elabels1left,elabelsright as elabels1right)) :: (_,(_,LBRACEleft as 
LBRACE1left,LBRACEright as LBRACE1right)) :: rest671) =>
let val result = 
MlyValue.aexp (((
fn st=> makeRECORDexp(E elabels st,
				        error(LBRACEleft,RBRACEright)),
				 V elabels
)))
in (LrTable.NT 22,(result,LBRACE1left,RBRACE1right),rest671)
end
| (71,(_,(_,RBRACEleft as RBRACE1left,RBRACEright as RBRACE1right
)) :: (_,(_,LBRACEleft as LBRACE1left,LBRACEright as LBRACE1right
)) :: rest671) =>
let val result = 
MlyValue.aexp (((fn st=> RECORDexp nil, no_tyvars)))
in (LrTable.NT 22,(result,LBRACE1left,RBRACE1right),rest671)
end
| (72,(_,(_,RPARENleft as RPAREN1left,RPARENright as RPAREN1right
)) :: (_,(_,LPARENleft as LPAREN1left,LPARENright as LPAREN1right
)) :: rest671) =>
let val result = 
MlyValue.aexp (((fn st=> unitExp, no_tyvars)))
in (LrTable.NT 22,(result,LPAREN1left,RPAREN1right),rest671)
end
| (73,(_,(_,RPARENleft as RPAREN1left,RPARENright as RPAREN1right
)) :: (_,(MlyValue.exp_ps (exp_ps1 as exp_ps),exp_psleft as 
exp_ps1left,exp_psright as exp_ps1right)) :: (_,(_,LPARENleft as 
LPAREN1left,LPARENright as LPAREN1right)) :: rest671) =>
let val result = 
MlyValue.aexp (((fn st=> SEQexp(E exp_ps st), V exp_ps)))
in (LrTable.NT 22,(result,LPAREN1left,RPAREN1right),rest671)
end
| (74,(_,(_,RPARENleft as RPAREN1left,RPARENright as RPAREN1right
)) :: (_,(MlyValue.exp_2c (exp_2c1 as exp_2c),exp_2cleft as 
exp_2c1left,exp_2cright as exp_2c1right)) :: (_,(_,LPARENleft as 
LPAREN1left,LPARENright as LPAREN1right)) :: rest671) =>
let val result = 
MlyValue.aexp (((fn st=> TUPLEexp(E exp_2c st), V exp_2c)))
in (LrTable.NT 22,(result,LPAREN1left,RPAREN1right),rest671)
end
| (75,(_,(_,RBRACKETleft as RBRACKET1left,RBRACKETright as 
RBRACKET1right)) :: (_,(MlyValue.exp_list (exp_list1 as exp_list),
exp_listleft as exp_list1left,exp_listright as exp_list1right)) :: 
(_,(_,LBRACKETleft as LBRACKET1left,LBRACKETright as LBRACKET1right
)) :: rest671) =>
let val result = 
MlyValue.aexp (((fn st=> LISTexp(E exp_list st), V exp_list)))
in (LrTable.NT 22,(result,LBRACKET1left,RBRACKET1right),rest671)
end
| (76,(_,(_,RBRACKETleft as RBRACKET1left,RBRACKETright as 
RBRACKET1right)) :: (_,(_,LBRACKETleft as LBRACKET1left,
LBRACKETright as LBRACKET1right)) :: rest671) =>
let val result = 
MlyValue.aexp (((fn st=> nilExp, no_tyvars)))
in (LrTable.NT 22,(result,LBRACKET1left,RBRACKET1right),rest671)
end
| (77,(_,(_,ENDleft as END1left,ENDright as END1right)) :: (_,(
MlyValue.exp_ps (exp_ps1 as exp_ps),exp_psleft as exp_ps1left,
exp_psright as exp_ps1right)) :: (_,(_,INleft as IN1left,INright as 
IN1right)) :: (_,(MlyValue.ldecs (ldecs1 as ldecs),ldecsleft as 
ldecs1left,ldecsright as ldecs1right)) :: (_,(_,LETleft as LET1left,
LETright as LET1right)) :: rest671) =>
let val result = 
MlyValue.aexp (((
fn (tv,st) => protect(protectScope,fn()=>
					 markexp(LETexp(E ldecs([],tv,st),
						SEQexp(E exp_ps(tv,st))),
					    LETleft,ENDright)),
				 V exp_ps \/ V ldecs
)))
in (LrTable.NT 22,(result,LET1left,END1right),rest671)
end
| (78,(_,(MlyValue.exp_2c (exp_2c1 as exp_2c),exp_2cleft as 
exp_2c1left,exp_2cright as exp_2c1right)) :: (_,(_,COMMAleft as 
COMMA1left,COMMAright as COMMA1right)) :: (_,(MlyValue.exp (exp1
 as exp),expleft as exp1left,expright as exp1right)) :: rest671) =>
let val result = 
MlyValue.exp_2c (((
fn st=> E exp st :: E exp_2c st,
				 V exp \/ V exp_2c)))
in (LrTable.NT 29,(result,exp1left,exp_2c1right),rest671)
end
| (79,(_,(MlyValue.exp (exp2),exp2left,exp2right)) :: (_,(_,
COMMAleft as COMMA1left,COMMAright as COMMA1right)) :: (_,(MlyValue.
exp (exp1 as exp),expleft as exp1left,expright as exp1right)) :: rest671) =>
let val result = 
MlyValue.exp_2c (((
fn st=> [E exp1 st, E exp2 st],
				 V exp1 \/ V exp2)))
in (LrTable.NT 29,(result,exp1left,exp2right),rest671)
end
| (80,(_,(MlyValue.exp (exp1 as exp),expleft as exp1left,expright as 
exp1right)) :: rest671) =>
let val result = 
MlyValue.exp_list (((fn st=> [E exp st], V exp)))
in (LrTable.NT 28,(result,exp1left,exp1right),rest671)
end
| (81,(_,(MlyValue.exp_list (exp_list1 as exp_list),exp_listleft as 
exp_list1left,exp_listright as exp_list1right)) :: (_,(_,COMMAleft as 
COMMA1left,COMMAright as COMMA1right)) :: (_,(MlyValue.exp (exp1
 as exp),expleft as exp1left,expright as exp1right)) :: rest671) =>
let val result = 
MlyValue.exp_list (((
fn st=> E exp st :: E exp_list st,
				 V exp \/ V exp_list)))
in (LrTable.NT 28,(result,exp1left,exp_list1right),rest671)
end
| (82,(_,(MlyValue.pat' (pat'1 as pat'),pat'left as pat'1left,
pat'right as pat'1right)) :: rest671) =>
let val result = 
MlyValue.pat (((pat')))
in (LrTable.NT 30,(result,pat'1left,pat'1right),rest671)
end
| (83,(_,(MlyValue.apats (apats1 as apats),apatsleft as apats1left,
apatsright as apats1right)) :: (_,(MlyValue.apat (apat1 as apat),
apatleft as apat1left,apatright as apat1right)) :: rest671) =>
let val result = 
MlyValue.pat (((
fn()=> make_app_pat(E apat()::E apats()),
				 V apat \/ V apats)))
in (LrTable.NT 30,(result,apat1left,apats1right),rest671)
end
| (84,(_,(MlyValue.pat (pat2),pat2left,pat2right)) :: (_,(_,ASleft as 
AS1left,ASright as AS1right)) :: (_,(MlyValue.pat (pat1 as pat),
patleft as pat1left,patright as pat1right)) :: rest671) =>
let val result = 
MlyValue.pat' (((
fn()=> layered(E pat1(), E pat2 (),
						error(pat1left,pat1right)),
				 V pat1 \/ V pat2
)))
in (LrTable.NT 31,(result,pat1left,pat2right),rest671)
end
| (85,(_,(MlyValue.ty (ty1 as ty),tyleft as ty1left,tyright as 
ty1right)) :: (_,(_,COLONleft as COLON1left,COLONright as COLON1right
)) :: (_,(MlyValue.apats (apats1 as apats),apatsleft as apats1left,
apatsright as apats1right)) :: (_,(MlyValue.apat (apat1 as apat),
apatleft as apat1left,apatright as apat1right)) :: rest671) =>
let val result = 
MlyValue.pat' (((
fn()=> CONSTRAINTpat(
					 make_app_pat(E apat()::E apats()),
					  E ty tyArg),
				 V apat \/ V apats \/ V ty
)))
in (LrTable.NT 31,(result,apat1left,ty1right),rest671)
end
| (86,(_,(MlyValue.apat' (apat'1 as apat'),apat'left as apat'1left,
apat'right as apat'1right)) :: rest671) =>
let val result = 
MlyValue.apat (((apat')))
in (LrTable.NT 32,(result,apat'1left,apat'1right),rest671)
end
| (87,(_,(_,RPARENleft as RPAREN1left,RPARENright as RPAREN1right
)) :: (_,(MlyValue.pat (pat1 as pat),patleft as pat1left,patright as 
pat1right)) :: (_,(_,LPARENleft as LPAREN1left,LPARENright as 
LPAREN1right)) :: rest671) =>
let val result = 
MlyValue.apat (((
fn()=>(E pat(),NONfix,error(LPARENleft,RPARENright)),
				 V pat)))
in (LrTable.NT 32,(result,LPAREN1left,RPAREN1right),rest671)
end
| (88,(_,(MlyValue.apat'' (apat''1 as apat''),apat''left as 
apat''1left,apat''right as apat''1right)) :: rest671) =>
let val result = 
MlyValue.apat' (((
fn()=>(E apat''(),NONfix,error(apat''left,apat''right)),
				 V apat''
)))
in (LrTable.NT 33,(result,apat''1left,apat''1right),rest671)
end
| (89,(_,(MlyValue.id (id1 as id),idleft as id1left,idright as 
id1right)) :: rest671) =>
let val result = 
MlyValue.apat' (((
fn()=>let val e = error(idleft,idright)
				  in (pat_id id, lookFIX id, e)
				 end,
				 no_tyvars
)))
in (LrTable.NT 33,(result,id1left,id1right),rest671)
end
| (90,(_,(_,RPARENleft as RPAREN1left,RPARENright as RPAREN1right
)) :: (_,(_,LPARENleft as LPAREN1left,LPARENright as LPAREN1right
)) :: rest671) =>
let val result = 
MlyValue.apat' (((
fn()=>(unitPat,NONfix,
					error(LPARENleft,RPARENright)),
				 no_tyvars
)))
in (LrTable.NT 33,(result,LPAREN1left,RPAREN1right),rest671)
end
| (91,(_,(_,RPARENleft as RPAREN1left,RPARENright as RPAREN1right
)) :: (_,(MlyValue.pat_list (pat_list1 as pat_list),pat_listleft as 
pat_list1left,pat_listright as pat_list1right)) :: (_,(_,COMMAleft as 
COMMA1left,COMMAright as COMMA1right)) :: (_,(MlyValue.pat (pat1
 as pat),patleft as pat1left,patright as pat1right)) :: (_,(_,
LPARENleft as LPAREN1left,LPARENright as LPAREN1right)) :: rest671) =>
let val result = 
MlyValue.apat' (((
fn()=>(TUPLEpat(E pat()::E pat_list()),
					 NONfix,error(LPARENleft,RPARENright)),
				 V pat \/ V pat_list
)))
in (LrTable.NT 33,(result,LPAREN1left,RPAREN1right),rest671)
end
| (92,(_,(MlyValue.ident (ident1 as ident),identleft as ident1left,
identright as ident1right)) :: (_,(_,OPleft as OP1left,OPright as 
OP1right)) :: rest671) =>
let val result = 
MlyValue.apat'' (((fn()=>pat_id ident, no_tyvars)))
in (LrTable.NT 34,(result,OP1left,ident1right),rest671)
end
| (93,(_,(MlyValue.qid (qid1 as qid),qidleft as qid1left,qidright as 
qid1right)) :: (_,(_,DOTleft as DOT1left,DOTright as DOT1right)) :: 
(_,(MlyValue.ID (ID1 as ID),IDleft as ID1left,IDright as ID1right
)) :: rest671) =>
let val result = 
MlyValue.apat'' (((
fn()=>qid_pat(ID::qid,error(IDleft,qidright)),
				 no_tyvars)))
in (LrTable.NT 34,(result,ID1left,qid1right),rest671)
end
| (94,(_,(MlyValue.int (int1 as int),intleft as int1left,intright as 
int1right)) :: rest671) =>
let val result = 
MlyValue.apat'' (((fn()=>INTpat int, no_tyvars)))
in (LrTable.NT 34,(result,int1left,int1right),rest671)
end
| (95,(_,(MlyValue.REAL (REAL1 as REAL),REALleft as REAL1left,
REALright as REAL1right)) :: rest671) =>
let val result = 
MlyValue.apat'' (((fn()=>REALpat REAL, no_tyvars)))
in (LrTable.NT 34,(result,REAL1left,REAL1right),rest671)
end
| (96,(_,(MlyValue.STRING (STRING1 as STRING),STRINGleft as 
STRING1left,STRINGright as STRING1right)) :: rest671) =>
let val result = 
MlyValue.apat'' (((fn()=>STRINGpat STRING, no_tyvars)))
in (LrTable.NT 34,(result,STRING1left,STRING1right),rest671)
end
| (97,(_,(_,WILDleft as WILD1left,WILDright as WILD1right)) :: rest671) =>
let val result = 
MlyValue.apat'' (((fn()=>WILDpat, no_tyvars)))
in (LrTable.NT 34,(result,WILD1left,WILD1right),rest671)
end
| (98,(_,(_,RBRACKETleft as RBRACKET1left,RBRACKETright as 
RBRACKET1right)) :: (_,(_,LBRACKETleft as LBRACKET1left,
LBRACKETright as LBRACKET1right)) :: rest671) =>
let val result = 
MlyValue.apat'' (((fn()=>LISTpat nil, no_tyvars)))
in (LrTable.NT 34,(result,LBRACKET1left,RBRACKET1right),rest671)
end
| (99,(_,(_,RBRACKETleft as RBRACKET1left,RBRACKETright as 
RBRACKET1right)) :: (_,(MlyValue.pat_list (pat_list1 as pat_list),
pat_listleft as pat_list1left,pat_listright as pat_list1right)) :: 
(_,(_,LBRACKETleft as LBRACKET1left,LBRACKETright as LBRACKET1right
)) :: rest671) =>
let val result = 
MlyValue.apat'' (((fn()=>LISTpat(E pat_list()), V pat_list)))
in (LrTable.NT 34,(result,LBRACKET1left,RBRACKET1right),rest671)
end
| (100,(_,(_,RBRACEleft as RBRACE1left,RBRACEright as RBRACE1right
)) :: (_,(_,LBRACEleft as LBRACE1left,LBRACEright as LBRACE1right
)) :: rest671) =>
let val result = 
MlyValue.apat'' (((
fn()=>makeRECORDpat((nil,false),
						error(LBRACEleft,RBRACEright)),
				 no_tyvars
)))
in (LrTable.NT 34,(result,LBRACE1left,RBRACE1right),rest671)
end
| (101,(_,(_,RBRACEleft as RBRACE1left,RBRACEright as RBRACE1right
)) :: (_,(MlyValue.plabels (plabels1 as plabels),plabelsleft as 
plabels1left,plabelsright as plabels1right)) :: (_,(_,LBRACEleft as 
LBRACE1left,LBRACEright as LBRACE1right)) :: rest671) =>
let val result = 
MlyValue.apat'' (((
fn()=>makeRECORDpat(E plabels(),
						error(LBRACEleft,RBRACEright)),
				 V plabels
)))
in (LrTable.NT 34,(result,LBRACE1left,RBRACE1right),rest671)
end
| (102,(_,(MlyValue.pat (pat1 as pat),patleft as pat1left,patright as 
pat1right)) :: (_,(_,EQUALleft as EQUAL1left,EQUALright as EQUAL1right
)) :: (_,(MlyValue.selector (selector1 as selector),selectorleft as 
selector1left,selectorright as selector1right)) :: rest671) =>
let val result = 
MlyValue.plabel (((fn()=> (selector,E pat()), V pat)))
in (LrTable.NT 35,(result,selector1left,pat1right),rest671)
end
| (103,(_,(MlyValue.ID (ID1 as ID),IDleft as ID1left,IDright as 
ID1right)) :: rest671) =>
let val result = 
MlyValue.plabel (((fn()=> (ID, pat_id ID), no_tyvars)))
in (LrTable.NT 35,(result,ID1left,ID1right),rest671)
end
| (104,(_,(MlyValue.pat (pat1 as pat),patleft as pat1left,patright as 
pat1right)) :: (_,(_,ASleft as AS1left,ASright as AS1right)) :: (_,(
MlyValue.ID (ID1 as ID),IDleft as ID1left,IDright as ID1right)) :: rest671) =>
let val result = 
MlyValue.plabel (((
fn()=> (ID, LAYEREDpat(pat_id ID, E pat())),
				 V pat)))
in (LrTable.NT 35,(result,ID1left,pat1right),rest671)
end
| (105,(_,(MlyValue.ty (ty1 as ty),tyleft as ty1left,tyright as 
ty1right)) :: (_,(_,COLONleft as COLON1left,COLONright as COLON1right
)) :: (_,(MlyValue.ID (ID1 as ID),IDleft as ID1left,IDright as 
ID1right)) :: rest671) =>
let val result = 
MlyValue.plabel (((
fn()=> (ID, CONSTRAINTpat(pat_id ID, 
							   E ty tyArg)),
				 V ty
)))
in (LrTable.NT 35,(result,ID1left,ty1right),rest671)
end
| (106,(_,(MlyValue.pat (pat1 as pat),patleft as pat1left,patright as 
pat1right)) :: (_,(_,ASleft as AS1left,ASright as AS1right)) :: (_,(
MlyValue.ty (ty1 as ty),tyleft as ty1left,tyright as ty1right)) :: 
(_,(_,COLONleft as COLON1left,COLONright as COLON1right)) :: (_,(
MlyValue.ID (ID1 as ID),IDleft as ID1left,IDright as ID1right)) :: rest671) =>
let val result = 
MlyValue.plabel (((
fn()=> (ID, LAYEREDpat(CONSTRAINTpat(
					   pat_id ID,
					   E ty tyArg), E pat())),
				 V ty \/ V pat
)))
in (LrTable.NT 35,(result,ID1left,pat1right),rest671)
end
| (107,(_,(MlyValue.plabels (plabels1 as plabels),plabelsleft as 
plabels1left,plabelsright as plabels1right)) :: (_,(_,COMMAleft as 
COMMA1left,COMMAright as COMMA1right)) :: (_,(MlyValue.plabel (plabel1
 as plabel),plabelleft as plabel1left,plabelright as plabel1right
)) :: rest671) =>
let val result = 
MlyValue.plabels (((
fn()=>let val (a,(b,fx))=(E plabel(),E plabels())
				in (a::b, fx)
			       end,
			 V plabel \/ V plabels
)))
in (LrTable.NT 36,(result,plabel1left,plabels1right),rest671)
end
| (108,(_,(MlyValue.plabel (plabel1 as plabel),plabelleft as 
plabel1left,plabelright as plabel1right)) :: rest671) =>
let val result = 
MlyValue.plabels (((fn()=> ([E plabel()],false), V plabel)))
in (LrTable.NT 36,(result,plabel1left,plabel1right),rest671)
end
| (109,(_,(_,DOTDOTDOTleft as DOTDOTDOT1left,DOTDOTDOTright as 
DOTDOTDOT1right)) :: rest671) =>
let val result = 
MlyValue.plabels (((fn()=> (nil, true), no_tyvars)))
in (LrTable.NT 36,(result,DOTDOTDOT1left,DOTDOTDOT1right),rest671)
end
| (110,(_,(MlyValue.pat (pat1 as pat),patleft as pat1left,patright as 
pat1right)) :: rest671) =>
let val result = 
MlyValue.pat_list (((fn()=> [E pat()], V pat)))
in (LrTable.NT 38,(result,pat1left,pat1right),rest671)
end
| (111,(_,(MlyValue.pat_list (pat_list1 as pat_list),pat_listleft as 
pat_list1left,pat_listright as pat_list1right)) :: (_,(_,COMMAleft as 
COMMA1left,COMMAright as COMMA1right)) :: (_,(MlyValue.pat (pat1
 as pat),patleft as pat1left,patright as pat1right)) :: rest671) =>
let val result = 
MlyValue.pat_list (((
fn()=> E pat() :: E pat_list(),
				 V pat \/ V pat_list)))
in (LrTable.NT 38,(result,pat1left,pat_list1right),rest671)
end
| (112,(_,(MlyValue.vb (vb2),vb2left,vb2right)) :: (_,(_,ANDleft as 
AND1left,ANDright as AND1right)) :: (_,(MlyValue.vb (vb1 as vb),
vbleft as vb1left,vbright as vb1right)) :: rest671) =>
let val result = 
MlyValue.vb (((fn st=> vb1 st @ vb2 st)))
in (LrTable.NT 39,(result,vb1left,vb2right),rest671)
end
| (113,(_,(MlyValue.exp (exp1 as exp),expleft as exp1left,expright as 
exp1right)) :: (_,(_,EQUALleft as EQUAL1left,EQUALright as EQUAL1right
)) :: (_,(MlyValue.pat (pat1 as pat),patleft as pat1left,patright as 
pat1right)) :: rest671) =>
let val result = 
MlyValue.vb (((valbind(pat, exp))))
in (LrTable.NT 39,(result,pat1left,exp1right),rest671)
end
| (114,rest671) =>
let val result = 
MlyValue.constraint (((fn()=>NONE, no_tyvars)))
in (LrTable.NT 40,(result,defaultPos,defaultPos),rest671)
end
| (115,(_,(MlyValue.ty (ty1 as ty),tyleft as ty1left,tyright as 
ty1right)) :: (_,(_,COLONleft as COLON1left,COLONright as COLON1right
)) :: rest671) =>
let val result = 
MlyValue.constraint (((fn()=>SOME(E ty tyArg), V ty)))
in (LrTable.NT 40,(result,COLON1left,ty1right),rest671)
end
| (116,(_,(MlyValue.match (match1 as match),matchleft as match1left,
matchright as match1right)) :: (_,(_,FNleft as FN1left,FNright as 
FN1right)) :: (_,(_,EQUALleft as EQUAL1left,EQUALright as EQUAL1right
)) :: (_,(MlyValue.constraint (constraint1 as constraint),
constraintleft as constraint1left,constraintright as constraint1right
)) :: (_,(MlyValue.opid (opid1 as opid),opidleft as opid1left,
opidright as opid1right)) :: rest671) =>
let val result = 
MlyValue.rvb (((fn()=>[{name=opid(),
					 ty=constraint,match=match}]
)))
in (LrTable.NT 41,(result,opid1left,match1right),rest671)
end
| (117,(_,(MlyValue.rvb (rvb2),rvb2left,rvb2right)) :: (_,(_,
ANDleft as AND1left,ANDright as AND1right)) :: (_,(MlyValue.rvb (rvb1
 as rvb),rvbleft as rvb1left,rvbright as rvb1right)) :: rest671) =>
let val result = 
MlyValue.rvb (((fn()=> rvb1() @ rvb2())))
in (LrTable.NT 41,(result,rvb1left,rvb2right),rest671)
end
| (118,(_,(MlyValue.clause (clause1 as clause),clauseleft as 
clause1left,clauseright as clause1right)) :: rest671) =>
let val result = 
MlyValue.fb' (((fn()=>[E clause()], V clause)))
in (LrTable.NT 42,(result,clause1left,clause1right),rest671)
end
| (119,(_,(MlyValue.fb' (fb'1 as fb'),fb'left as fb'1left,fb'right as 
fb'1right)) :: (_,(_,BARleft as BAR1left,BARright as BAR1right)) :: 
(_,(MlyValue.clause (clause1 as clause),clauseleft as clause1left,
clauseright as clause1right)) :: rest671) =>
let val result = 
MlyValue.fb' (((fn()=>E clause()::E fb'(), V clause \/ V fb')))
in (LrTable.NT 42,(result,clause1left,fb'1right),rest671)
end
| (120,(_,(MlyValue.fb' (fb'1 as fb'),fb'left as fb'1left,fb'right as 
fb'1right)) :: rest671) =>
let val result = 
MlyValue.fb (((
fn() => [checkFB(E fb'(),error(fb'left,fb'right))],
				 V fb')))
in (LrTable.NT 43,(result,fb'1left,fb'1right),rest671)
end
| (121,(_,(MlyValue.fb (fb1 as fb),fbleft as fb1left,fbright as 
fb1right)) :: (_,(_,ANDleft as AND1left,ANDright as AND1right)) :: 
(_,(MlyValue.fb' (fb'1 as fb'),fb'left as fb'1left,fb'right as 
fb'1right)) :: rest671) =>
let val result = 
MlyValue.fb (((
fn() => checkFB(E fb'(),error(fb'left,fb'right)) :: E fb(), V fb' \/ V fb
)))
in (LrTable.NT 43,(result,fb'1left,fb1right),rest671)
end
| (122,(_,(MlyValue.apats (apats2),apats2left,apats2right)) :: (_,(_,
RPARENleft as RPAREN1left,RPARENright as RPAREN1right)) :: (_,(
MlyValue.apats (apats1 as apats),apatsleft as apats1left,
apatsright as apats1right)) :: (_,(MlyValue.apat (apat1 as apat),
apatleft as apat1left,apatright as apat1right)) :: (_,(_,
LPARENleft as LPAREN1left,LPARENright as LPAREN1right)) :: rest671) =>
let val result = 
MlyValue.clause' (((
fn()=>makecl(E apat()::E apats1(),E apats2()),
				 V apat \/ V apats1 \/ V apats2
)))
in (LrTable.NT 45,(result,LPAREN1left,apats2right),rest671)
end
| (123,(_,(MlyValue.apats (apats1 as apats),apatsleft as apats1left,
apatsright as apats1right)) :: (_,(_,RPARENleft as RPAREN1left,
RPARENright as RPAREN1right)) :: (_,(MlyValue.pat' (pat'1 as pat'),
pat'left as pat'1left,pat'right as pat'1right)) :: (_,(_,
LPARENleft as LPAREN1left,LPARENright as LPAREN1right)) :: rest671) =>
let val result = 
MlyValue.clause' (((
fn()=>makecl([],(E pat'(),NONfix,
						 error(LPARENleft,RPARENright))
						 ::E apats()),
				 V pat' \/ V apats
)))
in (LrTable.NT 45,(result,LPAREN1left,apats1right),rest671)
end
| (124,(_,(MlyValue.apats (apats1 as apats),apatsleft as apats1left,
apatsright as apats1right)) :: (_,(MlyValue.apat' (apat'1 as apat'),
apat'left as apat'1left,apat'right as apat'1right)) :: rest671) =>
let val result = 
MlyValue.clause' (((
fn()=>makecl([],E apat'()::E apats()),
				 V apat' \/ V apats)))
in (LrTable.NT 45,(result,apat'1left,apats1right),rest671)
end
| (125,rest671) =>
let val result = 
MlyValue.apats (((fn()=>nil, no_tyvars)))
in (LrTable.NT 44,(result,defaultPos,defaultPos),rest671)
end
| (126,(_,(MlyValue.apats (apats1 as apats),apatsleft as apats1left,
apatsright as apats1right)) :: (_,(MlyValue.apat (apat1 as apat),
apatleft as apat1left,apatright as apat1right)) :: rest671) =>
let val result = 
MlyValue.apats (((fn()=> E apat()::E apats(), V apat \/ V apats)))
in (LrTable.NT 44,(result,apat1left,apats1right),rest671)
end
| (127,(_,(MlyValue.exp (exp1 as exp),expleft as exp1left,expright as 
exp1right)) :: (_,(_,EQUALleft as EQUAL1left,EQUALright as EQUAL1right
)) :: (_,(MlyValue.constraint (constraint1 as constraint),
constraintleft as constraint1left,constraintright as constraint1right
)) :: (_,(MlyValue.clause' (clause'1 as clause'),clause'left as 
clause'1left,clause'right as clause'1right)) :: rest671) =>
let val result = 
MlyValue.clause (((
fn()=> let val (id,pats) = E clause'()
				         in {name=id,pats=pats,
					     resultty=E constraint(),
				   	     exp=fn $ => markexp(E exp $,expleft,expright),
					     err=error(clause'left,clause'right)}
					end,
				 V clause' \/ V constraint \/ V exp
)))
in (LrTable.NT 46,(result,clause'1left,exp1right),rest671)
end
| (128,(_,(MlyValue.ty (ty1 as ty),tyleft as ty1left,tyright as 
ty1right)) :: (_,(_,EQUALleft as EQUAL1left,EQUALright as EQUAL1right
)) :: (_,(MlyValue.ident (ident1 as ident),identleft as ident1left,
identright as ident1right)) :: (_,(MlyValue.tyvars (tyvars1 as tyvars)
,tyvarsleft as tyvars1left,tyvarsright as tyvars1right)) :: rest671) =>
let val result = 
MlyValue.tb (((makeTB(tyvars,ident,ty,
					error(tyleft,tyright)))))
in (LrTable.NT 47,(result,tyvars1left,ty1right),rest671)
end
| (129,(_,(MlyValue.tb (tb2),tb2left,tb2right)) :: (_,(_,ANDleft as 
AND1left,ANDright as AND1right)) :: (_,(MlyValue.tb (tb1 as tb),
tbleft as tb1left,tbright as tb1right)) :: rest671) =>
let val result = 
MlyValue.tb (((fn nw => fn $ => tb1 nw $ @ tb2 nw $)))
in (LrTable.NT 47,(result,tb1left,tb2right),rest671)
end
| (130,(_,(MlyValue.TYVAR (TYVAR1 as TYVAR),TYVARleft as TYVAR1left,
TYVARright as TYVAR1right)) :: rest671) =>
let val result = 
MlyValue.tyvars ((([mkTyvar(mkUBOUND TYVAR)])))
in (LrTable.NT 48,(result,TYVAR1left,TYVAR1right),rest671)
end
| (131,(_,(_,RPARENleft as RPAREN1left,RPARENright as RPAREN1right
)) :: (_,(MlyValue.tyvar_pc (tyvar_pc1 as tyvar_pc),tyvar_pcleft as 
tyvar_pc1left,tyvar_pcright as tyvar_pc1right)) :: (_,(_,
LPARENleft as LPAREN1left,LPARENright as LPAREN1right)) :: rest671) =>
let val result = 
MlyValue.tyvars (((
checkUniq(error(tyvar_pcleft,tyvar_pcright),
				  	     "duplicate type variable")
					     (map(fn ref(UBOUND{name,...})=>name)
					      tyvar_pc);
				   tyvar_pc
)))
in (LrTable.NT 48,(result,LPAREN1left,RPAREN1right),rest671)
end
| (132,rest671) =>
let val result = 
MlyValue.tyvars (((nil)))
in (LrTable.NT 48,(result,defaultPos,defaultPos),rest671)
end
| (133,(_,(MlyValue.TYVAR (TYVAR1 as TYVAR),TYVARleft as TYVAR1left,
TYVARright as TYVAR1right)) :: rest671) =>
let val result = 
MlyValue.tyvar_pc ((([mkTyvar(mkUBOUND TYVAR)])))
in (LrTable.NT 49,(result,TYVAR1left,TYVAR1right),rest671)
end
| (134,(_,(MlyValue.tyvar_pc (tyvar_pc1 as tyvar_pc),tyvar_pcleft as 
tyvar_pc1left,tyvar_pcright as tyvar_pc1right)) :: (_,(_,COMMAleft as 
COMMA1left,COMMAright as COMMA1right)) :: (_,(MlyValue.TYVAR (TYVAR1
 as TYVAR),TYVARleft as TYVAR1left,TYVARright as TYVAR1right)) :: rest671) =>
let val result = 
MlyValue.tyvar_pc (((mkTyvar(mkUBOUND TYVAR) :: tyvar_pc)))
in (LrTable.NT 49,(result,TYVAR1left,tyvar_pc1right),rest671)
end
| (135,(_,(MlyValue.db (db1 as db),dbleft as db1left,dbright as 
db1right)) :: (_,(_,ANDleft as AND1left,ANDright as AND1right)) :: 
(_,(MlyValue.db' (db'1 as db'),db'left as db'1left,db'right as 
db'1right)) :: rest671) =>
let val result = 
MlyValue.db (((db' :: db)))
in (LrTable.NT 50,(result,db'1left,db1right),rest671)
end
| (136,(_,(MlyValue.db' (db'1 as db'),db'left as db'1left,db'right as 
db'1right)) :: rest671) =>
let val result = 
MlyValue.db ((([db'])))
in (LrTable.NT 50,(result,db'1left,db'1right),rest671)
end
| (137,(_,(MlyValue.constrs (constrs1 as constrs),constrsleft as 
constrs1left,constrsright as constrs1right)) :: (_,(_,EQUALleft as 
EQUAL1left,EQUALright as EQUAL1right)) :: (_,(MlyValue.ident (ident1
 as ident),identleft as ident1left,identright as ident1right)) :: (_,(
MlyValue.tyvars (tyvars1 as tyvars),tyvarsleft as tyvars1left,
tyvarsright as tyvars1right)) :: rest671) =>
let val result = 
MlyValue.db' (((
ident,length tyvars,
					 makeDB'(tyvars,ident,constrs,
						error(constrsleft,constrsright))
)))
in (LrTable.NT 51,(result,tyvars1left,constrs1right),rest671)
end
| (138,(_,(MlyValue.constr (constr1 as constr),constrleft as 
constr1left,constrright as constr1right)) :: rest671) =>
let val result = 
MlyValue.constrs (((fn $ => [E constr $], V constr)))
in (LrTable.NT 52,(result,constr1left,constr1right),rest671)
end
| (139,(_,(MlyValue.constrs (constrs1 as constrs),constrsleft as 
constrs1left,constrsright as constrs1right)) :: (_,(_,BARleft as 
BAR1left,BARright as BAR1right)) :: (_,(MlyValue.constr (constr1
 as constr),constrleft as constr1left,constrright as constr1right
)) :: rest671) =>
let val result = 
MlyValue.constrs (((
fn $ => E constr $ :: E constrs $,
				 V constr \/ V constrs)))
in (LrTable.NT 52,(result,constr1left,constrs1right),rest671)
end
| (140,(_,(MlyValue.ident (ident1 as ident),identleft as ident1left,
identright as ident1right)) :: (_,(MlyValue.op_op (op_op1 as op_op),
op_opleft as op_op1left,op_opright as op_op1right)) :: rest671) =>
let val result = 
MlyValue.constr (((
fire op_op (fn(t,_)=> (ident,true,t)),
				 no_tyvars)))
in (LrTable.NT 53,(result,op_op1left,ident1right),rest671)
end
| (141,(_,(MlyValue.ty (ty1 as ty),tyleft as ty1left,tyright as 
ty1right)) :: (_,(_,OFleft as OF1left,OFright as OF1right)) :: (_,(
MlyValue.ident (ident1 as ident),identleft as ident1left,
identright as ident1right)) :: (_,(MlyValue.op_op (op_op1 as op_op),
op_opleft as op_op1left,op_opright as op_op1right)) :: rest671) =>
let val result = 
MlyValue.constr (((
fire op_op (fn(t,$)=> (ident,false,
					 CONty(arrowTycon,[E ty $, t]))),
				 V ty
)))
in (LrTable.NT 53,(result,op_op1left,ty1right),rest671)
end
| (142,(_,(MlyValue.ident (ident1 as ident),identleft as ident1left,
identright as ident1right)) :: (_,(MlyValue.op_op (op_op1 as op_op),
op_opleft as op_op1left,op_opright as op_op1right)) :: rest671) =>
let val result = 
MlyValue.eb (((fire op_op (makeEB ident), no_tyvars)))
in (LrTable.NT 54,(result,op_op1left,ident1right),rest671)
end
| (143,(_,(MlyValue.ty (ty1 as ty),tyleft as ty1left,tyright as 
ty1right)) :: (_,(_,OFleft as OF1left,OFright as OF1right)) :: (_,(
MlyValue.ident (ident1 as ident),identleft as ident1left,
identright as ident1right)) :: (_,(MlyValue.op_op (op_op1 as op_op),
op_opleft as op_op1left,op_opright as op_op1right)) :: rest671) =>
let val result = 
MlyValue.eb (((
fire op_op (makeEBof(ident,E ty,
					   error(tyleft,tyright))),
					 V ty
)))
in (LrTable.NT 54,(result,op_op1left,ty1right),rest671)
end
| (144,(_,(MlyValue.qid (qid1 as qid),qidleft as qid1left,qidright as 
qid1right)) :: (_,(_,EQUALleft as EQUAL1left,EQUALright as EQUAL1right
)) :: (_,(MlyValue.ident (ident1 as ident),identleft as ident1left,
identright as ident1right)) :: (_,(MlyValue.op_op (op_op1 as op_op),
op_opleft as op_op1left,op_opright as op_op1right)) :: rest671) =>
let val result = 
MlyValue.eb (((
fire op_op (makeEBeq(ident,qid,
					   error(qidleft,qidright))),
					 no_tyvars
)))
in (LrTable.NT 54,(result,op_op1left,qid1right),rest671)
end
| (145,(_,(MlyValue.eb (eb2),eb2left,eb2right)) :: (_,(_,ANDleft as 
AND1left,ANDright as AND1right)) :: (_,(MlyValue.eb (eb1 as eb),
ebleft as eb1left,ebright as eb1right)) :: rest671) =>
let val result = 
MlyValue.eb (((fn $ => E eb1 $ @ E eb2 $,
					 V eb1 \/ V eb2)))
in (LrTable.NT 54,(result,eb1left,eb2right),rest671)
end
| (146,(_,(MlyValue.qid (qid1 as qid),qidleft as qid1left,qidright as 
qid1right)) :: rest671) =>
let val result = 
MlyValue.qid_p0 ((([qid])))
in (LrTable.NT 6,(result,qid1left,qid1right),rest671)
end
| (147,(_,(MlyValue.qid_p0 (qid_p01 as qid_p0),qid_p0left as 
qid_p01left,qid_p0right as qid_p01right)) :: (_,(MlyValue.qid (qid1
 as qid),qidleft as qid1left,qidright as qid1right)) :: rest671) =>
let val result = 
MlyValue.qid_p0 (((qid::qid_p0)))
in (LrTable.NT 6,(result,qid1left,qid_p01right),rest671)
end
| (148,(_,(MlyValue.qid (qid1 as qid),qidleft as qid1left,qidright as 
qid1right)) :: rest671) =>
let val result = 
MlyValue.qid_p (((fn()=> [getSTRpath(qid,error(qidleft,qidright))])))
in (LrTable.NT 55,(result,qid1left,qid1right),rest671)
end
| (149,(_,(MlyValue.qid_p (qid_p1 as qid_p),qid_pleft as qid_p1left,
qid_pright as qid_p1right)) :: (_,(MlyValue.qid (qid1 as qid),
qidleft as qid1left,qidright as qid1right)) :: rest671) =>
let val result = 
MlyValue.qid_p (((
fn()=> getSTRpath(qid,error(qidleft,qidright)) :: qid_p())))
in (LrTable.NT 55,(result,qid1left,qid_p1right),rest671)
end
| (150,(_,(_,INFIXleft as INFIX1left,INFIXright as INFIX1right)) :: rest671) =>
let val result = 
MlyValue.fixity (((infixleft 0)))
in (LrTable.NT 56,(result,INFIX1left,INFIX1right),rest671)
end
| (151,(_,(MlyValue.int (int1 as int),intleft as int1left,intright as 
int1right)) :: (_,(_,INFIXleft as INFIX1left,INFIXright as INFIX1right
)) :: rest671) =>
let val result = 
MlyValue.fixity (((infixleft int)))
in (LrTable.NT 56,(result,INFIX1left,int1right),rest671)
end
| (152,(_,(_,INFIXRleft as INFIXR1left,INFIXRright as INFIXR1right
)) :: rest671) =>
let val result = 
MlyValue.fixity (((infixright 0)))
in (LrTable.NT 56,(result,INFIXR1left,INFIXR1right),rest671)
end
| (153,(_,(MlyValue.int (int1 as int),intleft as int1left,intright as 
int1right)) :: (_,(_,INFIXRleft as INFIXR1left,INFIXRright as 
INFIXR1right)) :: rest671) =>
let val result = 
MlyValue.fixity (((infixright int)))
in (LrTable.NT 56,(result,INFIXR1left,int1right),rest671)
end
| (154,(_,(_,NONFIXleft as NONFIX1left,NONFIXright as NONFIX1right
)) :: rest671) =>
let val result = 
MlyValue.fixity (((NONfix)))
in (LrTable.NT 56,(result,NONFIX1left,NONFIX1right),rest671)
end
| (155,(_,(MlyValue.vb (vb1 as vb),vbleft as vb1left,vbright as 
vb1right)) :: (_,(_,VALleft as VAL1left,VALright as VAL1right)) :: rest671) =>
let val result = 
MlyValue.ldec (((
(fn $ => markdec(makeVALdec(vb,error(vbleft,vbright)) $,
					 vbleft,vbright)),
				 no_tyvars
)))
in (LrTable.NT 57,(result,VAL1left,vb1right),rest671)
end
| (156,(_,(MlyValue.rvb (rvb1 as rvb),rvbleft as rvb1left,rvbright as 
rvb1right)) :: (_,(_,RECleft as REC1left,RECright as REC1right)) :: 
(_,(_,VALleft as VAL1left,VALright as VAL1right)) :: rest671) =>
let val result = 
MlyValue.ldec (((
(fn $ =>markdec(makeVALRECdec(rvb,
				       		       error(rvbleft,rvbright)) $,
						rvbleft,rvbright)),
				 no_tyvars
)))
in (LrTable.NT 57,(result,VAL1left,rvb1right),rest671)
end
| (157,(_,(MlyValue.fb (fb1 as fb),fbleft as fb1left,fbright as 
fb1right)) :: (_,(_,FUNleft as FUN1left,FUNright as FUN1right)) :: rest671) =>
let val result = 
MlyValue.ldec (((
(fn $ => markdec(makeFUNdec fb $,fbleft,fbright)),
				 no_tyvars)))
in (LrTable.NT 57,(result,FUN1left,fb1right),rest671)
end
| (158,(_,(MlyValue.tb (tb1 as tb),tbleft as tb1left,tbright as 
tb1right)) :: (_,(_,TYPEleft as TYPE1left,TYPEright as TYPE1right
)) :: rest671) =>
let val result = 
MlyValue.ldec (((
(fn ps => makeTYPEdec(tb true ps, 
					      error(tbleft,tbright))),
				 no_tyvars
)))
in (LrTable.NT 57,(result,TYPE1left,tb1right),rest671)
end
| (159,(_,(MlyValue.db (db1 as db),dbleft as db1left,dbright as 
db1right)) :: (_,(_,DATATYPEleft as DATATYPE1left,DATATYPEright as 
DATATYPE1right)) :: rest671) =>
let val result = 
MlyValue.ldec ((((makeDB(db, fn _ => fn _ => nil)),
				 no_tyvars)))
in (LrTable.NT 57,(result,DATATYPE1left,db1right),rest671)
end
| (160,(_,(MlyValue.tb (tb1 as tb),tbleft as tb1left,tbright as 
tb1right)) :: (_,(_,WITHTYPEleft as WITHTYPE1left,WITHTYPEright as 
WITHTYPE1right)) :: (_,(MlyValue.db (db1 as db),dbleft as db1left,
dbright as db1right)) :: (_,(_,DATATYPEleft as DATATYPE1left,
DATATYPEright as DATATYPE1right)) :: rest671) =>
let val result = 
MlyValue.ldec ((((makeDB(db, tb)),
				 no_tyvars)))
in (LrTable.NT 57,(result,DATATYPE1left,tb1right),rest671)
end
| (161,(_,(_,ENDleft as END1left,ENDright as END1right)) :: (_,(
MlyValue.ldecs (ldecs1 as ldecs),ldecsleft as ldecs1left,
ldecsright as ldecs1right)) :: (_,(_,WITHleft as WITH1left,
WITHright as WITH1right)) :: (_,(MlyValue.db (db1 as db),dbleft as 
db1left,dbright as db1right)) :: (_,(_,ABSTYPEleft as ABSTYPE1left,
ABSTYPEright as ABSTYPE1right)) :: rest671) =>
let val result = 
MlyValue.ldec ((((makeABSTYPEdec(db,E ldecs)), V ldecs)))
in (LrTable.NT 57,(result,ABSTYPE1left,END1right),rest671)
end
| (162,(_,(MlyValue.eb (eb1 as eb),ebleft as eb1left,ebright as 
eb1right)) :: (_,(_,EXCEPTIONleft as EXCEPTION1left,EXCEPTIONright as 
EXCEPTION1right)) :: rest671) =>
let val result = 
MlyValue.ldec (((
(fn $ => markdec(makeEXCEPTIONdec(E eb $, 
					          error(ebleft,ebright)),
						 EXCEPTIONleft,ebright)),
				 V eb
)))
in (LrTable.NT 57,(result,EXCEPTION1left,eb1right),rest671)
end
| (163,(_,(MlyValue.qid_p (qid_p1 as qid_p),qid_pleft as qid_p1left,
qid_pright as qid_p1right)) :: (_,(_,OPENleft as OPEN1left,
OPENright as OPEN1right)) :: rest671) =>
let val result = 
MlyValue.ldec (((
(fn $ => markdec(makeOPENdec qid_p $,
						OPENleft,qid_pright)),
				 no_tyvars
)))
in (LrTable.NT 57,(result,OPEN1left,qid_p1right),rest671)
end
| (164,(_,(MlyValue.ops (ops1 as ops),opsleft as ops1left,opsright as 
ops1right)) :: (_,(MlyValue.fixity (fixity1 as fixity),fixityleft as 
fixity1left,fixityright as fixity1right)) :: rest671) =>
let val result = 
MlyValue.ldec (((makeFIXdec(fixity,ops),
				 no_tyvars)))
in (LrTable.NT 57,(result,fixity1left,ops1right),rest671)
end
| (165,(_,(MlyValue.exp_pa (exp_pa1 as exp_pa),exp_paleft as 
exp_pa1left,exp_paright as exp_pa1right)) :: (_,(_,ASleft as AS1left,
ASright as AS1right)) :: (_,(MlyValue.ty (ty1 as ty),tyleft as ty1left
,tyright as ty1right)) :: (_,(_,COLONleft as COLON1left,COLONright as 
COLON1right)) :: (_,(MlyValue.ident (ident1 as ident),identleft as 
ident1left,identright as ident1right)) :: (_,(_,OVERLOADleft as 
OVERLOAD1left,OVERLOADright as OVERLOAD1right)) :: rest671) =>
let val result = 
MlyValue.ldec (((makeOVERLOADdec(ident,ty,exp_pa),
				 no_tyvars)))
in (LrTable.NT 57,(result,OVERLOAD1left,exp_pa1right),rest671)
end
| (166,(_,(MlyValue.exp (exp1 as exp),expleft as exp1left,expright as 
exp1right)) :: rest671) =>
let val result = 
MlyValue.exp_pa (((fn st => [E exp st])))
in (LrTable.NT 58,(result,exp1left,exp1right),rest671)
end
| (167,(_,(MlyValue.exp_pa (exp_pa1 as exp_pa),exp_paleft as 
exp_pa1left,exp_paright as exp_pa1right)) :: (_,(_,ANDleft as AND1left
,ANDright as AND1right)) :: (_,(MlyValue.exp (exp1 as exp),expleft as 
exp1left,expright as exp1right)) :: rest671) =>
let val result = 
MlyValue.exp_pa (((fn st => E exp st :: exp_pa st)))
in (LrTable.NT 58,(result,exp1left,exp_pa1right),rest671)
end
| (168,rest671) =>
let val result = 
MlyValue.ldecs (((fn $ => SEQdec nil, no_tyvars)))
in (LrTable.NT 59,(result,defaultPos,defaultPos),rest671)
end
| (169,(_,(MlyValue.ldecs (ldecs1 as ldecs),ldecsleft as ldecs1left,
ldecsright as ldecs1right)) :: (_,(MlyValue.ldec (ldec1 as ldec),
ldecleft as ldec1left,ldecright as ldec1right)) :: rest671) =>
let val result = 
MlyValue.ldecs (((makeSEQdec(E ldec, E ldecs), V ldec \/ V ldecs)))
in (LrTable.NT 59,(result,ldec1left,ldecs1right),rest671)
end
| (170,(_,(MlyValue.ldecs (ldecs1 as ldecs),ldecsleft as ldecs1left,
ldecsright as ldecs1right)) :: (_,(_,SEMICOLONleft as SEMICOLON1left,
SEMICOLONright as SEMICOLON1right)) :: rest671) =>
let val result = 
MlyValue.ldecs (((ldecs)))
in (LrTable.NT 59,(result,SEMICOLON1left,ldecs1right),rest671)
end
| (171,(_,(MlyValue.ldecs (ldecs3),ldecs3left,ldecs3right)) :: (_,(_,
ENDleft as END1left,ENDright as END1right)) :: (_,(MlyValue.ldecs (
ldecs2),ldecs2left,ldecs2right)) :: (_,(_,INleft as IN1left,
INright as IN1right)) :: (_,(MlyValue.ldecs (ldecs1 as ldecs),
ldecsleft as ldecs1left,ldecsright as ldecs1right)) :: (_,(_,
LOCALleft as LOCAL1left,LOCALright as LOCAL1right)) :: rest671) =>
let val result = 
MlyValue.ldecs (((
makeSEQdec(fn $ => 
				   markdec(makeLOCALdec(E ldecs1, E ldecs2) $,
				   	   	   LOCALleft,ENDright),
				   E ldecs3),
				 V ldecs1 \/ V ldecs2 \/ V ldecs3
)))
in (LrTable.NT 59,(result,LOCAL1left,ldecs3right),rest671)
end
| (172,(_,(MlyValue.ident (ident1 as ident),identleft as ident1left,
identright as ident1right)) :: rest671) =>
let val result = 
MlyValue.ops ((([ident])))
in (LrTable.NT 60,(result,ident1left,ident1right),rest671)
end
| (173,(_,(MlyValue.ops (ops1 as ops),opsleft as ops1left,opsright as 
ops1right)) :: (_,(MlyValue.ident (ident1 as ident),identleft as 
ident1left,identright as ident1right)) :: rest671) =>
let val result = 
MlyValue.ops (((ident::ops)))
in (LrTable.NT 60,(result,ident1left,ops1right),rest671)
end
| (174,rest671) =>
let val result = 
MlyValue.spec_s (((fn $ => nil)))
in (LrTable.NT 61,(result,defaultPos,defaultPos),rest671)
end
| (175,(_,(MlyValue.spec_s (spec_s1 as spec_s),spec_sleft as 
spec_s1left,spec_sright as spec_s1right)) :: (_,(MlyValue.spec (spec1
 as spec),specleft as spec1left,specright as spec1right)) :: rest671) =>
let val result = 
MlyValue.spec_s (((fn $ => spec $ @ spec_s $)))
in (LrTable.NT 61,(result,spec1left,spec_s1right),rest671)
end
| (176,(_,(MlyValue.spec_s (spec_s1 as spec_s),spec_sleft as 
spec_s1left,spec_sright as spec_s1right)) :: (_,(_,SEMICOLONleft as 
SEMICOLON1left,SEMICOLONright as SEMICOLON1right)) :: rest671) =>
let val result = 
MlyValue.spec_s (((spec_s)))
in (LrTable.NT 61,(result,SEMICOLON1left,spec_s1right),rest671)
end
| (177,(_,(MlyValue.strspec (strspec1 as strspec),strspecleft as 
strspec1left,strspecright as strspec1right)) :: (_,(_,
STRUCTUREleft as STRUCTURE1left,STRUCTUREright as STRUCTURE1right
)) :: rest671) =>
let val result = 
MlyValue.spec (((strspec)))
in (LrTable.NT 62,(result,STRUCTURE1left,strspec1right),rest671)
end
| (178,(_,(MlyValue.db (db1 as db),dbleft as db1left,dbright as 
db1right)) :: (_,(_,DATATYPEleft as DATATYPE1left,DATATYPEright as 
DATATYPE1right)) :: rest671) =>
let val result = 
MlyValue.spec (((make_dtyspec db)))
in (LrTable.NT 62,(result,DATATYPE1left,db1right),rest671)
end
| (179,(_,(MlyValue.tyspec (tyspec1 as tyspec),tyspecleft as 
tyspec1left,tyspecright as tyspec1right)) :: (_,(_,TYPEleft as 
TYPE1left,TYPEright as TYPE1right)) :: rest671) =>
let val result = 
MlyValue.spec (((tyspec UNDEF)))
in (LrTable.NT 62,(result,TYPE1left,tyspec1right),rest671)
end
| (180,(_,(MlyValue.tyspec (tyspec1 as tyspec),tyspecleft as 
tyspec1left,tyspecright as tyspec1right)) :: (_,(_,EQTYPEleft as 
EQTYPE1left,EQTYPEright as EQTYPE1right)) :: rest671) =>
let val result = 
MlyValue.spec (((tyspec YES)))
in (LrTable.NT 62,(result,EQTYPE1left,tyspec1right),rest671)
end
| (181,(_,(MlyValue.valspec (valspec1 as valspec),valspecleft as 
valspec1left,valspecright as valspec1right)) :: (_,(_,VALleft as 
VAL1left,VALright as VAL1right)) :: rest671) =>
let val result = 
MlyValue.spec (((valspec)))
in (LrTable.NT 62,(result,VAL1left,valspec1right),rest671)
end
| (182,(_,(MlyValue.exnspec (exnspec1 as exnspec),exnspecleft as 
exnspec1left,exnspecright as exnspec1right)) :: (_,(_,
EXCEPTIONleft as EXCEPTION1left,EXCEPTIONright as EXCEPTION1right
)) :: rest671) =>
let val result = 
MlyValue.spec (((exnspec)))
in (LrTable.NT 62,(result,EXCEPTION1left,exnspec1right),rest671)
end
| (183,(_,(MlyValue.ops (ops1 as ops),opsleft as ops1left,opsright as 
ops1right)) :: (_,(MlyValue.fixity (fixity1 as fixity),fixityleft as 
fixity1left,fixityright as fixity1right)) :: rest671) =>
let val result = 
MlyValue.spec (((make_fixityspec(fixity,ops))))
in (LrTable.NT 62,(result,fixity1left,ops1right),rest671)
end
| (184,(_,(MlyValue.sharespec (sharespec1 as sharespec),
sharespecleft as sharespec1left,sharespecright as sharespec1right
)) :: (_,(_,SHARINGleft as SHARING1left,SHARINGright as SHARING1right
)) :: rest671) =>
let val result = 
MlyValue.spec (((sharespec)))
in (LrTable.NT 62,(result,SHARING1left,sharespec1right),rest671)
end
| (185,(_,(MlyValue.qid_p0 (qid_p01 as qid_p0),qid_p0left as 
qid_p01left,qid_p0right as qid_p01right)) :: (_,(_,OPENleft as 
OPEN1left,OPENright as OPEN1right)) :: rest671) =>
let val result = 
MlyValue.spec (((
make_openspec(qid_p0,
					       error(OPENleft,qid_p0right)))))
in (LrTable.NT 62,(result,OPEN1left,qid_p01right),rest671)
end
| (186,(_,(_,ENDleft as END1left,ENDright as END1right)) :: (_,(
MlyValue.spec_s (spec_s2),spec_s2left,spec_s2right)) :: (_,(_,
INleft as IN1left,INright as IN1right)) :: (_,(MlyValue.spec_s (
spec_s1 as spec_s),spec_sleft as spec_s1left,spec_sright as 
spec_s1right)) :: (_,(_,LOCALleft as LOCAL1left,LOCALright as 
LOCAL1right)) :: rest671) =>
let val result = 
MlyValue.spec (((
fn $ => (spec_s1 $; 
					  error(spec_s1left,spec_s1right) WARN
				"LOCAL specs are only partially implemented";
						spec_s2 $)
)))
in (LrTable.NT 62,(result,LOCAL1left,END1right),rest671)
end
| (187,(_,(MlyValue.ident (ident1 as ident),identleft as ident1left,
identright as ident1right)) :: (_,(_,INCLUDEleft as INCLUDE1left,
INCLUDEright as INCLUDE1right)) :: rest671) =>
let val result = 
MlyValue.spec (((make_includespec(ident,error(identleft,identright)))))
in (LrTable.NT 62,(result,INCLUDE1left,ident1right),rest671)
end
| (188,(_,(MlyValue.strspec (strspec2),strspec2left,strspec2right
)) :: (_,(_,ANDleft as AND1left,ANDright as AND1right)) :: (_,(
MlyValue.strspec (strspec1 as strspec),strspecleft as strspec1left,
strspecright as strspec1right)) :: rest671) =>
let val result = 
MlyValue.strspec (((fn $ => strspec1 $ @ strspec2 $)))
in (LrTable.NT 63,(result,strspec1left,strspec2right),rest671)
end
| (189,(_,(MlyValue.sign (sign1 as sign),signleft as sign1left,
signright as sign1right)) :: (_,(_,COLONleft as COLON1left,
COLONright as COLON1right)) :: (_,(MlyValue.ident (ident1 as ident),
identleft as ident1left,identright as ident1right)) :: rest671) =>
let val result = 
MlyValue.strspec (((make_strspec(ident, sign(false,NULLstr)))))
in (LrTable.NT 63,(result,ident1left,sign1right),rest671)
end
| (190,(_,(MlyValue.tyspec (tyspec2),tyspec2left,tyspec2right)) :: 
(_,(_,ANDleft as AND1left,ANDright as AND1right)) :: (_,(MlyValue.
tyspec (tyspec1 as tyspec),tyspecleft as tyspec1left,tyspecright as 
tyspec1right)) :: rest671) =>
let val result = 
MlyValue.tyspec (((
fn eq => fn $ => 
				    tyspec1 eq $ @ tyspec2 eq $)))
in (LrTable.NT 64,(result,tyspec1left,tyspec2right),rest671)
end
| (191,(_,(MlyValue.ident (ident1 as ident),identleft as ident1left,
identright as ident1right)) :: (_,(MlyValue.tyvars (tyvars1 as tyvars)
,tyvarsleft as tyvars1left,tyvarsright as tyvars1right)) :: rest671) =>
let val result = 
MlyValue.tyspec (((
fn eq => make_tyspec(eq,tyvars,ident,
					error(tyvarsleft,identright))
)))
in (LrTable.NT 64,(result,tyvars1left,ident1right),rest671)
end
| (192,(_,(MlyValue.valspec (valspec2),valspec2left,valspec2right
)) :: (_,(_,ANDleft as AND1left,ANDright as AND1right)) :: (_,(
MlyValue.valspec (valspec1 as valspec),valspecleft as valspec1left,
valspecright as valspec1right)) :: rest671) =>
let val result = 
MlyValue.valspec (((fn $ => valspec1 $ @ valspec2 $)))
in (LrTable.NT 65,(result,valspec1left,valspec2right),rest671)
end
| (193,(_,(MlyValue.ty (ty1 as ty),tyleft as ty1left,tyright as 
ty1right)) :: (_,(_,COLONleft as COLON1left,COLONright as COLON1right
)) :: (_,(MlyValue.ident (ident1 as ident),identleft as ident1left,
identright as ident1right)) :: (_,(MlyValue.op_op (op_op1 as op_op),
op_opleft as op_op1left,op_opright as op_op1right)) :: rest671) =>
let val result = 
MlyValue.valspec (((fire op_op (make_valspec(ident,ty)))))
in (LrTable.NT 65,(result,op_op1left,ty1right),rest671)
end
| (194,(_,(MlyValue.exnspec (exnspec2),exnspec2left,exnspec2right
)) :: (_,(_,ANDleft as AND1left,ANDright as AND1right)) :: (_,(
MlyValue.exnspec (exnspec1 as exnspec),exnspecleft as exnspec1left,
exnspecright as exnspec1right)) :: rest671) =>
let val result = 
MlyValue.exnspec (((fn $ => exnspec1 $ @ exnspec2 $)))
in (LrTable.NT 66,(result,exnspec1left,exnspec2right),rest671)
end
| (195,(_,(MlyValue.ident (ident1 as ident),identleft as ident1left,
identright as ident1right)) :: rest671) =>
let val result = 
MlyValue.exnspec (((make_exnspec ident)))
in (LrTable.NT 66,(result,ident1left,ident1right),rest671)
end
| (196,(_,(MlyValue.ty (ty1 as ty),tyleft as ty1left,tyright as 
ty1right)) :: (_,(_,OFleft as OF1left,OFright as OF1right)) :: (_,(
MlyValue.ident (ident1 as ident),identleft as ident1left,
identright as ident1right)) :: rest671) =>
let val result = 
MlyValue.exnspec (((make_exnspecOF (ident,ty))))
in (LrTable.NT 66,(result,ident1left,ty1right),rest671)
end
| (197,(_,(MlyValue.sharespec (sharespec2),sharespec2left,
sharespec2right)) :: (_,(_,ANDleft as AND1left,ANDright as AND1right
)) :: (_,(MlyValue.sharespec (sharespec1 as sharespec),
sharespecleft as sharespec1left,sharespecright as sharespec1right
)) :: rest671) =>
let val result = 
MlyValue.sharespec (((fn $ => sharespec1 $ @ sharespec2 $)))
in (LrTable.NT 67,(result,sharespec1left,sharespec2right),rest671)
end
| (198,(_,(MlyValue.patheqn (patheqn1 as patheqn),patheqnleft as 
patheqn1left,patheqnright as patheqn1right)) :: (_,(_,TYPEleft as 
TYPE1left,TYPEright as TYPE1right)) :: rest671) =>
let val result = 
MlyValue.sharespec (((make_type_sharespec patheqn)))
in (LrTable.NT 67,(result,TYPE1left,patheqn1right),rest671)
end
| (199,(_,(MlyValue.patheqn (patheqn1 as patheqn),patheqnleft as 
patheqn1left,patheqnright as patheqn1right)) :: rest671) =>
let val result = 
MlyValue.sharespec (((make_str_sharespec patheqn)))
in (LrTable.NT 67,(result,patheqn1left,patheqn1right),rest671)
end
| (200,(_,(MlyValue.qid (qid2),qid2left,qid2right)) :: (_,(_,
EQUALleft as EQUAL1left,EQUALright as EQUAL1right)) :: (_,(MlyValue.
qid (qid1 as qid),qidleft as qid1left,qidright as qid1right)) :: rest671) =>
let val result = 
MlyValue.patheqn ((([qid1,qid2])))
in (LrTable.NT 68,(result,qid1left,qid2right),rest671)
end
| (201,(_,(MlyValue.patheqn (patheqn1 as patheqn),patheqnleft as 
patheqn1left,patheqnright as patheqn1right)) :: (_,(_,EQUALleft as 
EQUAL1left,EQUALright as EQUAL1right)) :: (_,(MlyValue.qid (qid1
 as qid),qidleft as qid1left,qidright as qid1right)) :: rest671) =>
let val result = 
MlyValue.patheqn (((qid :: patheqn)))
in (LrTable.NT 68,(result,qid1left,patheqn1right),rest671)
end
| (202,(_,(MlyValue.ID (ID1 as ID),IDleft as ID1left,IDright as 
ID1right)) :: rest671) =>
let val result = 
MlyValue.sign (((makeSIGid(ID,error(IDleft,IDright)))))
in (LrTable.NT 69,(result,ID1left,ID1right),rest671)
end
| (203,(_,(_,ENDleft as END1left,ENDright as END1right)) :: (_,(
MlyValue.spec_s (spec_s1 as spec_s),spec_sleft as spec_s1left,
spec_sright as spec_s1right)) :: (_,(_,SIGleft as SIG1left,
SIGright as SIG1right)) :: rest671) =>
let val result = 
MlyValue.sign (((makeSIG(spec_s,error(spec_sleft,spec_sright)))))
in (LrTable.NT 69,(result,SIG1left,END1right),rest671)
end
| (204,rest671) =>
let val result = 
MlyValue.sigconstraint_op (((fn _ => NONE)))
in (LrTable.NT 70,(result,defaultPos,defaultPos),rest671)
end
| (205,(_,(MlyValue.sign (sign1 as sign),signleft as sign1left,
signright as sign1right)) :: (_,(_,COLONleft as COLON1left,
COLONright as COLON1right)) :: rest671) =>
let val result = 
MlyValue.sigconstraint_op (((
fn param =>
				  SOME(sign(true,param)
				           (1,Stampset.newStampsets()))
)))
in (LrTable.NT 70,(result,COLON1left,sign1right),rest671)
end
| (206,(_,(MlyValue.sigb (sigb2),sigb2left,sigb2right)) :: (_,(_,
ANDleft as AND1left,ANDright as AND1right)) :: (_,(MlyValue.sigb (
sigb1 as sigb),sigbleft as sigb1left,sigbright as sigb1right)) :: rest671) =>
let val result = 
MlyValue.sigb (((fn()=> sigb1() @ sigb2())))
in (LrTable.NT 71,(result,sigb1left,sigb2right),rest671)
end
| (207,(_,(MlyValue.sign (sign1 as sign),signleft as sign1left,
signright as sign1right)) :: (_,(_,EQUALleft as EQUAL1left,
EQUALright as EQUAL1right)) :: (_,(MlyValue.ident (ident1 as ident),
identleft as ident1left,identright as ident1right)) :: rest671) =>
let val result = 
MlyValue.sigb (((make_sigb(ident, sign(true,NULLstr)))))
in (LrTable.NT 71,(result,ident1left,sign1right),rest671)
end
| (208,(_,(MlyValue.qid (qid1 as qid),qidleft as qid1left,qidright as 
qid1right)) :: rest671) =>
let val result = 
MlyValue.str (((
markstr(qidleft,qidright,
				  make_str_qid(qid,error(qidleft,qidright)))
)))
in (LrTable.NT 72,(result,qid1left,qid1right),rest671)
end
| (209,(_,(_,ENDleft as END1left,ENDright as END1right)) :: (_,(
MlyValue.sdecs (sdecs1 as sdecs),sdecsleft as sdecs1left,
sdecsright as sdecs1right)) :: (_,(_,STRUCTleft as STRUCT1left,
STRUCTright as STRUCT1right)) :: rest671) =>
let val result = 
MlyValue.str (((
markstr(STRUCTleft,ENDright,
				  make_str_struct(sdecs,
					error(STRUCTleft,ENDright)))
)))
in (LrTable.NT 72,(result,STRUCT1left,END1right),rest671)
end
| (210,(_,(_,RPARENleft as RPAREN1left,RPARENright as RPAREN1right
)) :: (_,(MlyValue.sdecs (sdecs1 as sdecs),sdecsleft as sdecs1left,
sdecsright as sdecs1right)) :: (_,(_,LPARENleft as LPAREN1left,
LPARENright as LPAREN1right)) :: (_,(MlyValue.ID (ID1 as ID),
IDleft as ID1left,IDright as ID1right)) :: rest671) =>
let val result = 
MlyValue.str (((
markstr(IDleft,RPARENright,
				   make_str_app(ID,error(IDleft,IDright),
				      (fn $ => let val (s,s')=spread_args sdecs $
					        in (MARKstr(s,sdecsleft,sdecsright)
							     ,s')
					       end)))
)))
in (LrTable.NT 72,(result,ID1left,RPAREN1right),rest671)
end
| (211,(_,(_,RPARENleft as RPAREN1left,RPARENright as RPAREN1right
)) :: (_,(MlyValue.str (str1 as str),strleft as str1left,strright as 
str1right)) :: (_,(_,LPARENleft as LPAREN1left,LPARENright as 
LPAREN1right)) :: (_,(MlyValue.ID (ID1 as ID),IDleft as ID1left,
IDright as ID1right)) :: rest671) =>
let val result = 
MlyValue.str (((
markstr(IDleft,RPARENright,
				  make_str_app(ID,error(IDleft,IDright),
					      single_arg str))
)))
in (LrTable.NT 72,(result,ID1left,RPAREN1right),rest671)
end
| (212,(_,(_,ENDleft as END1left,ENDright as END1right)) :: (_,(
MlyValue.str (str1 as str),strleft as str1left,strright as str1right
)) :: (_,(_,INleft as IN1left,INright as IN1right)) :: (_,(MlyValue.
sdecs (sdecs1 as sdecs),sdecsleft as sdecs1left,sdecsright as 
sdecs1right)) :: (_,(_,LETleft as LET1left,LETright as LET1right)) :: rest671) =>
let val result = 
MlyValue.str (((
markstr(LETleft,ENDright,
				  make_str_let(sdecs,str)))))
in (LrTable.NT 72,(result,LET1left,END1right),rest671)
end
| (213,(_,(MlyValue.sdecs (sdecs1 as sdecs),sdecsleft as sdecs1left,
sdecsright as sdecs1right)) :: (_,(MlyValue.sdec (sdec1 as sdec),
sdecleft as sdec1left,sdecright as sdec1right)) :: rest671) =>
let val result = 
MlyValue.sdecs (((
fn $ => markdec(sdec $,sdecleft,sdecright) :: sdecs $)))
in (LrTable.NT 73,(result,sdec1left,sdecs1right),rest671)
end
| (214,(_,(MlyValue.sdecs (sdecs1 as sdecs),sdecsleft as sdecs1left,
sdecsright as sdecs1right)) :: (_,(_,SEMICOLONleft as SEMICOLON1left,
SEMICOLONright as SEMICOLON1right)) :: rest671) =>
let val result = 
MlyValue.sdecs (((sdecs)))
in (LrTable.NT 73,(result,SEMICOLON1left,sdecs1right),rest671)
end
| (215,(_,(MlyValue.sdecs (sdecs3),sdecs3left,sdecs3right)) :: (_,(_,
ENDleft as END1left,ENDright as END1right)) :: (_,(MlyValue.sdecs (
sdecs2),sdecs2left,sdecs2right)) :: (_,(_,INleft as IN1left,
INright as IN1right)) :: (_,(MlyValue.sdecs (sdecs1 as sdecs),
sdecsleft as sdecs1left,sdecsright as sdecs1right)) :: (_,(_,
LOCALleft as LOCAL1left,LOCALright as LOCAL1right)) :: rest671) =>
let val result = 
MlyValue.sdecs (((
fn $ => makeLOCALsdecs(sdecs1,sdecs2) $
							@ sdecs3 $)))
in (LrTable.NT 73,(result,LOCAL1left,sdecs3right),rest671)
end
| (216,rest671) =>
let val result = 
MlyValue.sdecs (((fn $ => nil)))
in (LrTable.NT 73,(result,defaultPos,defaultPos),rest671)
end
| (217,(_,(MlyValue.sdecs' (sdecs'1 as sdecs'),sdecs'left as 
sdecs'1left,sdecs'right as sdecs'1right)) :: (_,(MlyValue.sdec (sdec1
 as sdec),sdecleft as sdec1left,sdecright as sdec1right)) :: rest671) =>
let val result = 
MlyValue.sdecs' (((
fn $ => markdec(sdec $,sdecleft,sdecright)
						 :: sdecs' $)))
in (LrTable.NT 74,(result,sdec1left,sdecs'1right),rest671)
end
| (218,(_,(MlyValue.sdecs' (sdecs'1 as sdecs'),sdecs'left as 
sdecs'1left,sdecs'right as sdecs'1right)) :: (_,(_,ENDleft as END1left
,ENDright as END1right)) :: (_,(MlyValue.sdecs (sdecs2),sdecs2left,
sdecs2right)) :: (_,(_,INleft as IN1left,INright as IN1right)) :: (_,(
MlyValue.sdecs (sdecs1 as sdecs),sdecsleft as sdecs1left,
sdecsright as sdecs1right)) :: (_,(_,LOCALleft as LOCAL1left,
LOCALright as LOCAL1right)) :: rest671) =>
let val result = 
MlyValue.sdecs' (((
fn $ =>makeLOCALsdecs(sdecs1,sdecs2) $
							@ sdecs' $)))
in (LrTable.NT 74,(result,LOCAL1left,sdecs'1right),rest671)
end
| (219,(_,(_,ENDleft as END1left,ENDright as END1right)) :: (_,(
MlyValue.sdecs (sdecs2),sdecs2left,sdecs2right)) :: (_,(_,INleft as 
IN1left,INright as IN1right)) :: (_,(MlyValue.sdecs (sdecs1 as sdecs),
sdecsleft as sdecs1left,sdecsright as sdecs1right)) :: (_,(_,
LOCALleft as LOCAL1left,LOCALright as LOCAL1right)) :: rest671) =>
let val result = 
MlyValue.sdecs' (((makeLOCALsdecs(sdecs1,sdecs2))))
in (LrTable.NT 74,(result,LOCAL1left,END1right),rest671)
end
| (220,(_,(MlyValue.sdec (sdec1 as sdec),sdecleft as sdec1left,
sdecright as sdec1right)) :: rest671) =>
let val result = 
MlyValue.sdecs' (((fn $ => [markdec(sdec $,sdecleft,sdecright)])))
in (LrTable.NT 74,(result,sdec1left,sdec1right),rest671)
end
| (221,(_,(MlyValue.strb (strb1 as strb),strbleft as strb1left,
strbright as strb1right)) :: (_,(_,STRUCTUREleft as STRUCTURE1left,
STRUCTUREright as STRUCTURE1right)) :: rest671) =>
let val result = 
MlyValue.sdec (((makeSTRBs(strb false))))
in (LrTable.NT 75,(result,STRUCTURE1left,strb1right),rest671)
end
| (222,(_,(MlyValue.strb (strb1 as strb),strbleft as strb1left,
strbright as strb1right)) :: (_,(_,ABSTRACTIONleft as ABSTRACTION1left
,ABSTRACTIONright as ABSTRACTION1right)) :: rest671) =>
let val result = 
MlyValue.sdec (((makeSTRBs(strb true))))
in (LrTable.NT 75,(result,ABSTRACTION1left,strb1right),rest671)
end
| (223,(_,(MlyValue.sigb (sigb1 as sigb),sigbleft as sigb1left,
sigbright as sigb1right)) :: (_,(_,SIGNATUREleft as SIGNATURE1left,
SIGNATUREright as SIGNATURE1right)) :: rest671) =>
let val result = 
MlyValue.sdec (((makeSIGdec(sigb,error(SIGNATUREleft,sigbright)))))
in (LrTable.NT 75,(result,SIGNATURE1left,sigb1right),rest671)
end
| (224,(_,(MlyValue.fctb (fctb1 as fctb),fctbleft as fctb1left,
fctbright as fctb1right)) :: (_,(_,FUNCTORleft as FUNCTOR1left,
FUNCTORright as FUNCTOR1right)) :: rest671) =>
let val result = 
MlyValue.sdec (((makeFCTdec(fctb,error(FUNCTORleft,fctbright)))))
in (LrTable.NT 75,(result,FUNCTOR1left,fctb1right),rest671)
end
| (225,(_,(MlyValue.ldec (ldec1 as ldec),ldecleft as ldec1left,
ldecright as ldec1right)) :: rest671) =>
let val result = 
MlyValue.sdec (((
fn (pa,top,st) => let val dec = E ldec (pa,no_tyvars,st)
			                  in Typecheck.decType(dec,top,error,
							       (ldecleft,ldecright));
					     dec
				         end
)))
in (LrTable.NT 75,(result,ldec1left,ldec1right),rest671)
end
| (226,(_,(MlyValue.str (str1 as str),strleft as str1left,strright as 
str1right)) :: (_,(_,EQUALleft as EQUAL1left,EQUALright as EQUAL1right
)) :: (_,(MlyValue.sigconstraint_op (sigconstraint_op1
 as sigconstraint_op),sigconstraint_opleft as sigconstraint_op1left,
sigconstraint_opright as sigconstraint_op1right)) :: (_,(MlyValue.
ident (ident1 as ident),identleft as ident1left,identright as 
ident1right)) :: rest671) =>
let val result = 
MlyValue.strb (((
makeSTRB(ident,sigconstraint_op,str,
				  error(sigconstraint_opleft,sigconstraint_opright))
)))
in (LrTable.NT 76,(result,ident1left,str1right),rest671)
end
| (227,(_,(MlyValue.strb (strb2),strb2left,strb2right)) :: (_,(_,
ANDleft as AND1left,ANDright as AND1right)) :: (_,(MlyValue.strb (
strb1 as strb),strbleft as strb1left,strbright as strb1right)) :: rest671) =>
let val result = 
MlyValue.strb (((fn a => fn $ => strb1 a $ @ strb2 a $)))
in (LrTable.NT 76,(result,strb1left,strb2right),rest671)
end
| (228,(_,(MlyValue.sign (sign1 as sign),signleft as sign1left,
signright as sign1right)) :: (_,(_,COLONleft as COLON1left,
COLONright as COLON1right)) :: (_,(MlyValue.ID (ID1 as ID),IDleft as 
ID1left,IDright as ID1right)) :: rest671) =>
let val result = 
MlyValue.fparam (((single_formal(ID, sign(true,NULLstr)))))
in (LrTable.NT 77,(result,ID1left,sign1right),rest671)
end
| (229,(_,(MlyValue.spec_s (spec_s1 as spec_s),spec_sleft as 
spec_s1left,spec_sright as spec_s1right)) :: rest671) =>
let val result = 
MlyValue.fparam (((
spread_formal(spec_s,
					       error(spec_sleft,spec_sright)))))
in (LrTable.NT 77,(result,spec_s1left,spec_s1right),rest671)
end
| (230,(_,(MlyValue.str (str1 as str),strleft as str1left,strright as 
str1right)) :: (_,(_,EQUALleft as EQUAL1left,EQUALright as EQUAL1right
)) :: (_,(MlyValue.sigconstraint_op (sigconstraint_op1
 as sigconstraint_op),sigconstraint_opleft as sigconstraint_op1left,
sigconstraint_opright as sigconstraint_op1right)) :: (_,(_,
RPARENleft as RPAREN1left,RPARENright as RPAREN1right)) :: (_,(
MlyValue.fparam (fparam1 as fparam),fparamleft as fparam1left,
fparamright as fparam1right)) :: (_,(_,LPARENleft as LPAREN1left,
LPARENright as LPAREN1right)) :: (_,(MlyValue.ident (ident1 as ident),
identleft as ident1left,identright as ident1right)) :: rest671) =>
let val result = 
MlyValue.fctb (((
makeFCTB(ident,fparam,
						sigconstraint_op,str,
						error(strleft,strright))
)))
in (LrTable.NT 78,(result,ident1left,str1right),rest671)
end
| (231,(_,(MlyValue.fctb (fctb2),fctb2left,fctb2right)) :: (_,(_,
ANDleft as AND1left,ANDright as AND1right)) :: (_,(MlyValue.fctb (
fctb1 as fctb),fctbleft as fctb1left,fctbright as fctb1right)) :: rest671) =>
let val result = 
MlyValue.fctb (((fn $ => fctb1 $ @ fctb2 $)))
in (LrTable.NT 78,(result,fctb1left,fctb2right),rest671)
end
| (232,(_,(MlyValue.STRING (STRING1 as STRING),STRINGleft as 
STRING1left,STRINGright as STRING1right)) :: rest671) =>
let val result = 
MlyValue.importdec ((([STRING])))
in (LrTable.NT 79,(result,STRING1left,STRING1right),rest671)
end
| (233,(_,(MlyValue.importdec (importdec1 as importdec),
importdecleft as importdec1left,importdecright as importdec1right
)) :: (_,(MlyValue.STRING (STRING1 as STRING),STRINGleft as 
STRING1left,STRINGright as STRING1right)) :: rest671) =>
let val result = 
MlyValue.importdec (((STRING :: importdec)))
in (LrTable.NT 79,(result,STRING1left,importdec1right),rest671)
end
| (234,(_,(MlyValue.sdecs' (sdecs'1 as sdecs'),sdecs'left as 
sdecs'1left,sdecs'right as sdecs'1right)) :: rest671) =>
let val result = 
MlyValue.interdec (((
fn()=>markdec(SEQdec(sdecs'([],true,Stampset.globalStamps)),sdecs'left,sdecs'right)
)))
in (LrTable.NT 80,(result,sdecs'1left,sdecs'1right),rest671)
end
| (235,(_,(MlyValue.importdec (importdec1 as importdec),
importdecleft as importdec1left,importdecright as importdec1right
)) :: (_,(_,IMPORTleft as IMPORT1left,IMPORTright as IMPORT1right
)) :: rest671) =>
let val result = 
MlyValue.interdec (((fn()=>IMPORTdec importdec)))
in (LrTable.NT 80,(result,IMPORT1left,importdec1right),rest671)
end
| (236,(_,(MlyValue.exp (exp1 as exp),expleft as exp1left,expright as 
exp1right)) :: rest671) =>
let val result = 
MlyValue.interdec (((
fn()=>markdec(toplevelexp(exp,error,(expleft,expright)),
					expleft,expright)
)))
in (LrTable.NT 80,(result,exp1left,exp1right),rest671)
end
| _ => raise (mlyAction i392)
end
val void = MlyValue.VOID
val extract = fn a => (fn MlyValue.interdec x => x
| _ => let exception ParseInternal
	in raise ParseInternal end) a 
end
end
structure Tokens : ML_TOKENS =
struct
type svalue = ParserData.svalue
type ('a,'b) token = ('a,'b) Token.token
fun EOF (p1,p2) = Token.TOKEN (ParserData.LrTable.T 0,(
ParserData.MlyValue.VOID,p1,p2))
fun SEMICOLON (p1,p2) = Token.TOKEN (ParserData.LrTable.T 1,(
ParserData.MlyValue.VOID,p1,p2))
fun ID (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 2,(
ParserData.MlyValue.ID i,p1,p2))
fun TYVAR (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 3,(
ParserData.MlyValue.TYVAR i,p1,p2))
fun INT (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 4,(
ParserData.MlyValue.INT i,p1,p2))
fun INT0 (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 5,(
ParserData.MlyValue.INT0 i,p1,p2))
fun REAL (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 6,(
ParserData.MlyValue.REAL i,p1,p2))
fun STRING (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 7,(
ParserData.MlyValue.STRING i,p1,p2))
fun ABSTRACTION (p1,p2) = Token.TOKEN (ParserData.LrTable.T 8,(
ParserData.MlyValue.VOID,p1,p2))
fun ABSTYPE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 9,(
ParserData.MlyValue.VOID,p1,p2))
fun AND (p1,p2) = Token.TOKEN (ParserData.LrTable.T 10,(
ParserData.MlyValue.VOID,p1,p2))
fun ARROW (p1,p2) = Token.TOKEN (ParserData.LrTable.T 11,(
ParserData.MlyValue.VOID,p1,p2))
fun AS (p1,p2) = Token.TOKEN (ParserData.LrTable.T 12,(
ParserData.MlyValue.VOID,p1,p2))
fun BAR (p1,p2) = Token.TOKEN (ParserData.LrTable.T 13,(
ParserData.MlyValue.VOID,p1,p2))
fun CASE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 14,(
ParserData.MlyValue.VOID,p1,p2))
fun DATATYPE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 15,(
ParserData.MlyValue.VOID,p1,p2))
fun DOTDOTDOT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 16,(
ParserData.MlyValue.VOID,p1,p2))
fun ELSE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 17,(
ParserData.MlyValue.VOID,p1,p2))
fun END (p1,p2) = Token.TOKEN (ParserData.LrTable.T 18,(
ParserData.MlyValue.VOID,p1,p2))
fun EQUAL (p1,p2) = Token.TOKEN (ParserData.LrTable.T 19,(
ParserData.MlyValue.VOID,p1,p2))
fun EQTYPE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 20,(
ParserData.MlyValue.VOID,p1,p2))
fun EXCEPTION (p1,p2) = Token.TOKEN (ParserData.LrTable.T 21,(
ParserData.MlyValue.VOID,p1,p2))
fun DO (p1,p2) = Token.TOKEN (ParserData.LrTable.T 22,(
ParserData.MlyValue.VOID,p1,p2))
fun DOT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 23,(
ParserData.MlyValue.VOID,p1,p2))
fun DARROW (p1,p2) = Token.TOKEN (ParserData.LrTable.T 24,(
ParserData.MlyValue.VOID,p1,p2))
fun FN (p1,p2) = Token.TOKEN (ParserData.LrTable.T 25,(
ParserData.MlyValue.VOID,p1,p2))
fun FUN (p1,p2) = Token.TOKEN (ParserData.LrTable.T 26,(
ParserData.MlyValue.VOID,p1,p2))
fun FUNCTOR (p1,p2) = Token.TOKEN (ParserData.LrTable.T 27,(
ParserData.MlyValue.VOID,p1,p2))
fun HANDLE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 28,(
ParserData.MlyValue.VOID,p1,p2))
fun HASH (p1,p2) = Token.TOKEN (ParserData.LrTable.T 29,(
ParserData.MlyValue.VOID,p1,p2))
fun IF (p1,p2) = Token.TOKEN (ParserData.LrTable.T 30,(
ParserData.MlyValue.VOID,p1,p2))
fun IN (p1,p2) = Token.TOKEN (ParserData.LrTable.T 31,(
ParserData.MlyValue.VOID,p1,p2))
fun INCLUDE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 32,(
ParserData.MlyValue.VOID,p1,p2))
fun INFIX (p1,p2) = Token.TOKEN (ParserData.LrTable.T 33,(
ParserData.MlyValue.VOID,p1,p2))
fun INFIXR (p1,p2) = Token.TOKEN (ParserData.LrTable.T 34,(
ParserData.MlyValue.VOID,p1,p2))
fun LET (p1,p2) = Token.TOKEN (ParserData.LrTable.T 35,(
ParserData.MlyValue.VOID,p1,p2))
fun LOCAL (p1,p2) = Token.TOKEN (ParserData.LrTable.T 36,(
ParserData.MlyValue.VOID,p1,p2))
fun NONFIX (p1,p2) = Token.TOKEN (ParserData.LrTable.T 37,(
ParserData.MlyValue.VOID,p1,p2))
fun OF (p1,p2) = Token.TOKEN (ParserData.LrTable.T 38,(
ParserData.MlyValue.VOID,p1,p2))
fun OP (p1,p2) = Token.TOKEN (ParserData.LrTable.T 39,(
ParserData.MlyValue.VOID,p1,p2))
fun OPEN (p1,p2) = Token.TOKEN (ParserData.LrTable.T 40,(
ParserData.MlyValue.VOID,p1,p2))
fun OVERLOAD (p1,p2) = Token.TOKEN (ParserData.LrTable.T 41,(
ParserData.MlyValue.VOID,p1,p2))
fun QUERY (p1,p2) = Token.TOKEN (ParserData.LrTable.T 42,(
ParserData.MlyValue.VOID,p1,p2))
fun RAISE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 43,(
ParserData.MlyValue.VOID,p1,p2))
fun REC (p1,p2) = Token.TOKEN (ParserData.LrTable.T 44,(
ParserData.MlyValue.VOID,p1,p2))
fun SHARING (p1,p2) = Token.TOKEN (ParserData.LrTable.T 45,(
ParserData.MlyValue.VOID,p1,p2))
fun SIG (p1,p2) = Token.TOKEN (ParserData.LrTable.T 46,(
ParserData.MlyValue.VOID,p1,p2))
fun SIGNATURE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 47,(
ParserData.MlyValue.VOID,p1,p2))
fun STRUCT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 48,(
ParserData.MlyValue.VOID,p1,p2))
fun STRUCTURE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 49,(
ParserData.MlyValue.VOID,p1,p2))
fun THEN (p1,p2) = Token.TOKEN (ParserData.LrTable.T 50,(
ParserData.MlyValue.VOID,p1,p2))
fun TYPE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 51,(
ParserData.MlyValue.VOID,p1,p2))
fun VAL (p1,p2) = Token.TOKEN (ParserData.LrTable.T 52,(
ParserData.MlyValue.VOID,p1,p2))
fun WHILE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 53,(
ParserData.MlyValue.VOID,p1,p2))
fun WILD (p1,p2) = Token.TOKEN (ParserData.LrTable.T 54,(
ParserData.MlyValue.VOID,p1,p2))
fun WITH (p1,p2) = Token.TOKEN (ParserData.LrTable.T 55,(
ParserData.MlyValue.VOID,p1,p2))
fun WITHTYPE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 56,(
ParserData.MlyValue.VOID,p1,p2))
fun ASTERISK (p1,p2) = Token.TOKEN (ParserData.LrTable.T 57,(
ParserData.MlyValue.VOID,p1,p2))
fun COLON (p1,p2) = Token.TOKEN (ParserData.LrTable.T 58,(
ParserData.MlyValue.VOID,p1,p2))
fun COMMA (p1,p2) = Token.TOKEN (ParserData.LrTable.T 59,(
ParserData.MlyValue.VOID,p1,p2))
fun LBRACE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 60,(
ParserData.MlyValue.VOID,p1,p2))
fun LBRACKET (p1,p2) = Token.TOKEN (ParserData.LrTable.T 61,(
ParserData.MlyValue.VOID,p1,p2))
fun LPAREN (p1,p2) = Token.TOKEN (ParserData.LrTable.T 62,(
ParserData.MlyValue.VOID,p1,p2))
fun RBRACE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 63,(
ParserData.MlyValue.VOID,p1,p2))
fun RBRACKET (p1,p2) = Token.TOKEN (ParserData.LrTable.T 64,(
ParserData.MlyValue.VOID,p1,p2))
fun RPAREN (p1,p2) = Token.TOKEN (ParserData.LrTable.T 65,(
ParserData.MlyValue.VOID,p1,p2))
fun ORELSE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 66,(
ParserData.MlyValue.VOID,p1,p2))
fun ANDALSO (p1,p2) = Token.TOKEN (ParserData.LrTable.T 67,(
ParserData.MlyValue.VOID,p1,p2))
fun IMPORT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 68,(
ParserData.MlyValue.VOID,p1,p2))
end
end
