/* run.c
 *
 * COPYRIGHT (c) 1989 by AT&T Bell Laboratories.
 */

/* Copyright (c) 1991 by Carnegie Mellon University */

#include <stdio.h>
#include "ml_os.h"
#include <sys/stat.h>
#include <sys/file.h>
#include <signal.h>

#include "ml_state.h"
#include "ml_types.h"
#include "tags.h"
#include "prim.h"

extern ML_val_t cstruct[];

static ML_val_t load();

static void enroll();

extern int new_size;
extern int resettimers();
extern ML_val_t apply_ml_fn();

#if defined(M68) || defined(C)
extern ML_val_t mathvec[];
#endif

extern ML_val_t gcmessages0[], ratio0[], softmax0[], pstruct0[];
#define gcmessages (gcmessages0[1])
#define pstruct (pstruct0[1])
#define ratio (ratio0[1])
#define softmax (softmax0[1])

int		isExported = 0;
char		**global_argv;

main (argc, argv)
    int		argc; 
    char	*argv[];
{
    ML_val_t	    perv, core, math, loader, obj;
    char	    **p = argv+1;
    char            *file = NULL;
    int		    xflag = 0;
    char            *start_heap=NULL;
    char            *argname;

    global_argv = argv;

#ifndef C

    if (isExported)
	restart_ml();
    gcmessages	= INT_CtoML(2);
    ratio	= INT_CtoML(5);
    softmax	= INT_CtoML(1024*1024*100);

#else

    gcmessages  = INT_CtoML(0);
    ratio       = INT_CtoML(5);
    softmax     = INT_CtoML(1024*1024*4096);
    new_size    = 1024*1024*2;

#endif

    for (  ; *p != NULL; p++) {
     if (p[0][0] == '-' && p[0][1] != NULL && p[0][2] == NULL)
	switch (p[0][1]) {
	  case 'h':
	    if (p[1]) {
		new_size = 1024*atoi(p[1]);
		p+=1;
	    }
	    else
		quit("no -h value");
	    break;
	  case 'r':
	    if (p[1]) {
		int r = atoi(p[1]);
		p += 1;
		if (r < 3)
		    quit ("bad -r value");
		ratio = INT_CtoML(r);
	    }
	    else
		quit("no -r value");
	    break;
	  case 'm':
	    if (p[1]) {
		softmax = INT_CtoML(1024*atoi(p[1]));
		p+=1;
	    }
	    else
		quit("no -m value");
	    break;
	  case 'g':
	    if (p[1]) {
	 	gcmessages0[1] = INT_CtoML(atoi(p[1]));
		p+=1;
	    }
	    else
		quit("no -g value");
	    break;
#ifdef C
          case 's':
	    if (p[1]) {
	       start_heap = p[1];
               p += 1;
            }
            else
                quit("no -s value");
            break;
#else
	  case 'x':
	    xflag = 1;
	    break;
	  case 'y':
	    xflag = 2;
	    break;
	  case 'z':
	    xflag = 3;
	    break;
#endif
          default:
             break;
	} /* end of switch */
#ifndef C
    else if (file == NULL) file= *p;
#endif
    } /* end of while */

    setup_signals ();
    resettimers ();
    init_mlstate ();
    init_externlist();

#ifndef C

    if ((file == NULL) && (xflag == 0))
	quit("no file to execute\n");

    init_gc();
    perv = load(ML_alloc_string("CoreFunc"));
    enroll (ML_alloc_string("Core"), core = apply_ml_fn(perv, PTR_CtoML(cstruct+1)));
#if defined(M68)
    math = PTR_CtoML(mathvec+1);
#else
    math = load(ML_alloc_string("Math"));
#endif
    enroll (ML_alloc_string("Math"), math);
    perv = pstruct = load(ML_alloc_string("Initial"));
    if (xflag==1) {
	chatting("Result is %#x\n", REC_SELINT(perv, 0));
	_exit(0);
    }

    loader = load(ML_alloc_string("Loader"));
    if (xflag==3) {
	chatting("Result is %#x\n", REC_SELINT(loader, 0));
	_exit(0);
    }

    argname = ML_alloc_string(file);
    REC_ALLOC4(obj, core, perv, math, argname);
    apply_ml_fn (loader, obj);

#else

    if (start_heap != NULL)
        load_heap(start_heap);

    init_gc();
    perv = load(ML_alloc_string("CoreFunc"));
    enroll (ML_alloc_string("Core"),
            core = apply_ml_fn(perv, PTR_CtoML(cstruct+1)));
    math = PTR_CtoML(mathvec+1);
    enroll (ML_alloc_string("Math"), math);
    perv = pstruct = load(ML_alloc_string("Initial"));
    loader = load(ML_alloc_string("Loader"));
    REC_ALLOC3(obj, core, perv, math)
    apply_ml_fn (loader, obj);

#endif

#ifdef GCPROFILE
    print_gcprof();
#endif
    exit(0);
}

/** The table of objects we need to boot. **/

static struct {
    ML_val_t	    name;	/* an ML string */
    ML_val_t	    obj;
} objtbl[10];
int objcount;

/* enroll:
 * Add the (name, obj) pair to the object table.
 */
static void enroll (name, obj)
    ML_val_t	    name, obj;
{
    objtbl[objcount].name = name;
    objtbl[objcount].obj  = obj;
    objcount++;
}

/* lookup:
 * Search for name in the object table, return the corresponding object or 0.
 */
static ML_val_t lookup (name)
    ML_val_t	    name;
{
    int		    i;

    for (i = 0;  i < objcount;  i++) {
	if (ML_eqstr(objtbl[i].name, name))
	    return objtbl[i].obj;
    }
    return 0;
}


/* openread:
 * Return a pointer to the code for the specified structure.  If the structure
 * is not in the data list, then read it into the heap from its ".mo" file.
 */
static ML_val_t openread (s)
    char	    *s;
{
    int		    fd = -1, i;
    register char   *p, *q;
    ML_val_t	    ss = ML_alloc_string(s);
    ML_val_t	    d;

  /* search the datalist for the file */
    for (d = PTR_CtoML(datalist+1);  d != MOLST_nil;  d = MOLST_next(d)) {
	if (ML_eqstr(ss, MOLST_name(d)))
	    return MOLST_code(d);
    }

#ifndef C

  /* not in the datalist, so open the file */
#if defined(V9) || defined(HPUX)
    fd = open(s, 0);
#else
    fd = open(s, O_RDONLY, 0666);
#endif
    if (fd < 0)
	quit("cannot open %s\n",s);

  /* allocate and initialize the code string in the heap */
    p = (char *)(MLState->ml_allocptr);
    MLState->ml_allocptr += sizeof(int);
    while (i = read(fd, MLState->ml_allocptr, 4096))
	MLState->ml_allocptr += i;
    q = (char *)MLState->ml_allocptr;
    MLState->ml_allocptr = ((((int)q) + 3) & ~3);
    *(int*)p = MAKE_DESC(q - (p + 4), tag_string);

    return PTR_CtoML(((int)p) + 4);

#else !C

    die("Internal error: datalist\n");

#endif
} /* end of openread */


/* loadlist:
 */
static ML_val_t loadlist (names)
    ML_val_t	    names;
{
    ML_val_t	    g;

    if (names == ML_nil)
	return ML_nil;
    else {
	ML_val_t	obj  = load(ML_hd(names));
	ML_val_t	rest = loadlist(ML_tl(names));
	return ML_cons(obj, rest);
    }
} /* end of loadlist */

/* load:
 */
static ML_val_t load (name)
    ML_val_t	    name;
{
    ML_val_t	    p, args;
    char	    buf[64];

    if (p = lookup(name))
	return p;
    else {
	strcpy (buf, "mo/");
	strncpy (buf+3, (char *)PTR_MLtoC(name), OBJ_LEN(name));
	strcpy (buf+3+OBJ_LEN(name), ".mo");

#ifndef C
	chatting("[Loading %s]\n", buf);
	p = openread(buf);
	REC_ALLOC1(p, PTR_CtoML(PTR_MLtoC(p)+2));
	p = apply_ml_fn (p, ML_unit);
	chatting("[Executing %s]\n",buf);
#else
	p = openread(buf);
	REC_ALLOC1(p, PTR_CtoML(p))
	p = apply_ml_fn (p, ML_unit);
#endif
	args = loadlist (((int*)p)[1]);
	p = REC_SEL(apply_ml_fn(REC_SEL(p, 0), args), 0);
	enroll (name, p);

	return p;
    }
} /* end of load */


int quit (s, a, b, c, d, e, f)
    char *s;
{
    char dbuf[1024];
    sprintf(dbuf, s, a, b, c, d, e, f);
    write(2, dbuf, strlen(dbuf));
    exit (2);
}

int die (s, a, b, c, d, e, f)
    char *s;
{
    char dbuf[1024];
    sprintf(dbuf, s, a, b, c, d, e, f);
    write(2, dbuf, strlen(dbuf));
    /* abort(); */
    exit(3);
}

int chatting (s, a, b, c, d, e, f, g)
    char *s;
{
    char dbuf[1024];
    sprintf(dbuf, s, a, b, c, d, e, f, g);
    write(2, dbuf, strlen(dbuf));
}
