functor MLLrValsFun(structure Token : TOKEN)
 = 
struct
structure ParserData=
struct
structure Header = 
struct
(* Copyright 1989 by AT&T Bell Laboratories *)
open ErrorMsg Symbol Access Basics BasicTypes TypesUtil Absyn
open Env EnvAccess Misc CoreLang Signs Strs TyvarSet
fun fire a b c = (a(); b c)
fun markexp (e as MARKexp _, _, _) = e
  | markexp(e,a,b) = if !System.Control.markabsyn
			then MARKexp(e,a,b) else e
fun markdec(d as MARKdec _, _, _) = d
  | markdec(d,a,b) = if !System.Control.markabsyn
			then MARKdec(d,a,b) else d

fun markstr(a,b,f) $ = case f $
			of s as (MARKstr _,x,y) => s
			 | s as (t,x,y) => if !System.Control.markabsyn
				  then (MARKstr(t,a,b),x,y) else s

infix \/ 
val op \/ = union_tyvars

fun V(_,vars) = vars and E(e,_) = e


end
structure LrTable = Token.LrTable
structure Token = Token
local open LrTable in 
val table=let val actionRows =
"\
\\001\000\001\000\000\000\002\000\000\000\000\000\
\\001\000\003\000\051\000\005\000\050\000\006\000\049\000\007\000\048\000\
\\008\000\047\000\009\000\046\000\010\000\045\000\015\000\044\000\
\\016\000\043\000\020\000\042\000\022\000\041\000\026\000\040\000\
\\027\000\039\000\028\000\038\000\030\000\037\000\031\000\036\000\
\\034\000\035\000\035\000\034\000\036\000\033\000\037\000\032\000\
\\038\000\031\000\040\000\030\000\041\000\029\000\042\000\028\000\
\\044\000\027\000\048\000\026\000\050\000\025\000\052\000\024\000\
\\053\000\023\000\054\000\022\000\058\000\021\000\061\000\020\000\
\\062\000\019\000\063\000\018\000\069\000\017\000\000\000\
\\001\000\003\000\051\000\005\000\050\000\006\000\049\000\007\000\048\000\
\\008\000\047\000\015\000\044\000\020\000\042\000\026\000\040\000\
\\030\000\037\000\031\000\036\000\036\000\033\000\040\000\030\000\
\\044\000\027\000\054\000\022\000\058\000\021\000\061\000\020\000\
\\062\000\019\000\063\000\018\000\000\000\
\\001\000\003\000\051\000\005\000\050\000\006\000\049\000\007\000\048\000\
\\008\000\047\000\015\000\044\000\020\000\042\000\026\000\040\000\
\\030\000\037\000\031\000\036\000\036\000\033\000\040\000\030\000\
\\044\000\027\000\054\000\022\000\058\000\021\000\061\000\020\000\
\\062\000\019\000\063\000\018\000\065\000\071\000\000\000\
\\001\000\003\000\051\000\005\000\050\000\006\000\049\000\007\000\048\000\
\\008\000\047\000\015\000\044\000\020\000\042\000\026\000\040\000\
\\030\000\037\000\031\000\036\000\036\000\033\000\040\000\030\000\
\\044\000\027\000\054\000\022\000\058\000\021\000\061\000\020\000\
\\062\000\019\000\063\000\018\000\066\000\068\000\000\000\
\\001\000\003\000\051\000\005\000\050\000\006\000\049\000\007\000\048\000\
\\008\000\047\000\020\000\042\000\030\000\037\000\036\000\033\000\
\\040\000\030\000\058\000\021\000\061\000\020\000\062\000\019\000\
\\063\000\018\000\000\000\
\\001\000\003\000\055\000\020\000\042\000\058\000\021\000\000\000\
\\001\000\003\000\077\000\005\000\076\000\000\000\
\\001\000\003\000\077\000\005\000\076\000\064\000\075\000\000\000\
\\001\000\003\000\077\000\005\000\076\000\064\000\244\000\000\000\
\\001\000\003\000\096\000\005\000\050\000\006\000\049\000\007\000\095\000\
\\008\000\094\000\040\000\093\000\045\000\092\000\055\000\091\000\
\\058\000\090\000\061\000\089\000\062\000\088\000\063\000\087\000\000\000\
\\001\000\003\000\096\000\005\000\050\000\006\000\049\000\007\000\095\000\
\\008\000\094\000\040\000\093\000\055\000\091\000\058\000\090\000\
\\061\000\089\000\062\000\088\000\063\000\087\000\000\000\
\\001\000\003\000\096\000\005\000\050\000\006\000\049\000\007\000\095\000\
\\008\000\094\000\040\000\093\000\055\000\091\000\058\000\090\000\
\\061\000\089\000\062\000\088\000\063\000\087\000\065\000\179\000\000\000\
\\001\000\003\000\096\000\005\000\050\000\006\000\049\000\007\000\095\000\
\\008\000\094\000\040\000\093\000\055\000\091\000\058\000\090\000\
\\061\000\089\000\062\000\088\000\063\000\087\000\066\000\176\000\000\000\
\\001\000\003\000\096\000\005\000\050\000\006\000\049\000\007\000\095\000\
\\008\000\094\000\040\000\093\000\055\000\091\000\058\000\090\000\
\\061\000\089\000\062\000\088\000\063\000\131\000\000\000\
\\001\000\003\000\110\000\020\000\042\000\052\000\114\001\058\000\021\000\000\000\
\\001\000\003\000\110\000\020\000\042\000\058\000\021\000\000\000\
\\001\000\003\000\158\000\000\000\
\\001\000\003\000\158\000\004\000\157\000\061\000\156\000\063\000\155\000\000\000\
\\001\000\003\000\185\000\005\000\076\000\017\000\184\000\000\000\
\\001\000\003\000\185\000\005\000\076\000\017\000\184\000\064\000\183\000\000\000\
\\001\000\003\000\190\000\040\000\189\000\058\000\090\000\000\000\
\\001\000\003\000\024\001\047\000\023\001\000\000\
\\001\000\003\000\094\001\020\000\042\000\036\000\093\001\049\000\092\001\
\\058\000\021\000\000\000\
\\001\000\004\000\196\000\000\000\
\\001\000\008\000\064\000\000\000\
\\001\000\012\000\236\000\013\000\096\001\000\000\
\\001\000\012\000\236\000\060\000\074\001\066\000\073\001\000\000\
\\001\000\013\000\174\000\020\000\173\000\000\000\
\\001\000\013\000\174\000\025\000\224\000\000\000\
\\001\000\013\000\174\000\060\000\004\001\000\000\
\\001\000\013\000\174\000\060\000\004\001\066\000\003\001\000\000\
\\001\000\013\000\011\001\020\000\216\001\059\000\010\001\060\000\050\002\
\\064\000\050\002\000\000\
\\001\000\018\000\101\001\000\000\
\\001\000\019\000\097\001\000\000\
\\001\000\019\000\099\001\000\000\
\\001\000\019\000\133\001\000\000\
\\001\000\019\000\145\001\000\000\
\\001\000\019\000\149\001\000\000\
\\001\000\019\000\150\001\000\000\
\\001\000\019\000\172\001\000\000\
\\001\000\019\000\199\001\000\000\
\\001\000\019\000\201\001\000\000\
\\001\000\020\000\168\000\000\000\
\\001\000\020\000\201\000\000\000\
\\001\000\020\000\009\001\000\000\
\\001\000\020\000\016\001\000\000\
\\001\000\020\000\021\001\000\000\
\\001\000\020\000\052\001\000\000\
\\001\000\020\000\064\001\000\000\
\\001\000\020\000\087\001\000\000\
\\001\000\020\000\160\001\000\000\
\\001\000\020\000\179\001\000\000\
\\001\000\023\000\169\000\000\000\
\\001\000\026\000\141\001\000\000\
\\001\000\032\000\206\000\000\000\
\\001\000\032\000\209\000\000\000\
\\001\000\032\000\030\001\000\000\
\\001\000\032\000\032\001\000\000\
\\001\000\032\000\163\001\000\000\
\\001\000\032\000\173\001\000\000\
\\001\000\039\000\231\000\000\000\
\\001\000\051\000\213\000\000\000\
\\001\000\056\000\232\000\000\000\
\\001\000\059\000\202\000\000\000\
\\001\000\059\000\077\001\000\000\
\\001\000\059\000\123\001\000\000\
\\001\000\059\000\158\001\000\000\
\\001\000\059\000\181\001\000\000\
\\001\000\063\000\215\000\000\000\
\\001\000\064\000\166\000\000\000\
\\001\000\064\000\007\001\000\000\
\\001\000\064\000\075\001\000\000\
\\001\000\065\000\164\000\000\000\
\\001\000\065\000\005\001\000\000\
\\001\000\066\000\160\000\000\000\
\\001\000\066\000\163\000\000\000\
\\001\000\066\000\018\001\000\000\
\\001\000\066\000\072\001\000\000\
\\001\000\066\000\102\001\000\000\
\\001\000\066\000\139\001\000\000\
\\001\000\066\000\194\001\000\000\
\\001\000\066\000\195\001\000\000\
\\203\001\000\000\
\\204\001\000\000\
\\205\001\000\000\
\\205\001\024\000\192\000\000\000\
\\206\001\000\000\
\\207\001\000\000\
\\207\001\024\000\144\000\000\000\
\\207\001\024\000\204\000\000\000\
\\207\001\024\000\204\000\063\000\144\001\000\000\
\\208\001\000\000\
\\209\001\000\000\
\\210\001\000\000\
\\211\001\040\000\137\000\000\000\
\\212\001\000\000\
\\213\001\000\000\
\\214\001\000\000\
\\215\001\000\000\
\\216\001\000\000\
\\217\001\000\000\
\\218\001\000\000\
\\219\001\024\000\245\000\000\000\
\\220\001\012\000\236\000\000\000\
\\221\001\000\000\
\\222\001\060\000\076\001\000\000\
\\223\001\000\000\
\\224\001\000\000\
\\225\001\000\000\
\\226\001\000\000\
\\227\001\000\000\
\\228\001\000\000\
\\229\001\000\000\
\\230\001\000\000\
\\231\001\003\000\158\000\058\000\238\000\000\000\
\\232\001\000\000\
\\233\001\012\000\236\000\000\000\
\\234\001\003\000\158\000\058\000\238\000\000\000\
\\235\001\012\000\236\000\060\000\074\001\000\000\
\\236\001\000\000\
\\237\001\014\000\225\000\000\000\
\\238\001\000\000\
\\239\001\000\000\
\\240\001\000\000\
\\241\001\000\000\
\\242\001\060\000\167\000\000\000\
\\243\001\002\000\162\000\000\000\
\\243\001\002\000\162\000\060\000\161\000\000\000\
\\244\001\000\000\
\\245\001\000\000\
\\246\001\000\000\
\\247\001\000\000\
\\248\001\029\000\057\000\067\000\056\000\000\000\
\\249\001\000\000\
\\250\001\068\000\058\000\000\000\
\\250\001\068\000\235\000\000\000\
\\251\001\000\000\
\\252\001\012\000\236\000\000\000\
\\253\001\003\000\051\000\005\000\050\000\006\000\049\000\007\000\048\000\
\\008\000\047\000\015\000\044\000\020\000\042\000\026\000\040\000\
\\030\000\037\000\031\000\036\000\036\000\033\000\040\000\030\000\
\\044\000\027\000\054\000\022\000\058\000\021\000\059\000\062\000\
\\061\000\020\000\062\000\019\000\063\000\018\000\000\000\
\\253\001\003\000\051\000\005\000\050\000\006\000\049\000\007\000\048\000\
\\008\000\047\000\020\000\042\000\030\000\037\000\036\000\033\000\
\\040\000\030\000\058\000\021\000\059\000\062\000\061\000\020\000\
\\062\000\019\000\063\000\018\000\000\000\
\\254\001\000\000\
\\255\001\000\000\
\\000\002\000\000\
\\001\002\000\000\
\\002\002\000\000\
\\003\002\000\000\
\\004\002\000\000\
\\005\002\000\000\
\\006\002\000\000\
\\007\002\000\000\
\\008\002\000\000\
\\009\002\000\000\
\\010\002\000\000\
\\011\002\000\000\
\\012\002\000\000\
\\013\002\000\000\
\\014\002\000\000\
\\015\002\000\000\
\\016\002\000\000\
\\017\002\000\000\
\\018\002\000\000\
\\019\002\000\000\
\\020\002\000\000\
\\021\002\000\000\
\\022\002\000\000\
\\023\002\000\000\
\\024\002\000\000\
\\025\002\000\000\
\\026\002\060\000\161\000\000\000\
\\027\002\060\000\165\000\000\000\
\\028\002\000\000\
\\029\002\000\000\
\\029\002\066\000\056\001\000\000\
\\030\002\059\000\255\000\000\000\
\\030\002\059\000\255\000\066\000\126\001\000\000\
\\031\002\013\000\174\000\000\000\
\\032\002\012\000\236\000\000\000\
\\033\002\000\000\
\\034\002\000\000\
\\035\002\000\000\
\\036\002\000\000\
\\037\002\000\000\
\\038\002\000\000\
\\039\002\000\000\
\\040\002\000\000\
\\041\002\000\000\
\\042\002\000\000\
\\043\002\000\000\
\\044\002\000\000\
\\045\002\000\000\
\\046\002\000\000\
\\047\002\000\000\
\\048\002\000\000\
\\049\002\013\000\174\000\000\000\
\\051\002\013\000\174\000\000\000\
\\052\002\012\000\236\000\013\000\140\001\000\000\
\\053\002\013\000\174\000\000\000\
\\054\002\000\000\
\\055\002\060\000\008\001\000\000\
\\056\002\000\000\
\\057\002\013\000\174\000\060\000\006\001\000\000\
\\058\002\000\000\
\\059\002\011\000\170\000\000\000\
\\060\002\000\000\
\\061\002\059\000\218\000\000\000\
\\062\002\012\000\236\000\000\000\
\\063\002\000\000\
\\064\002\011\000\012\001\000\000\
\\065\002\014\000\216\000\000\000\
\\066\002\000\000\
\\067\002\011\000\219\000\000\000\
\\068\002\000\000\
\\069\002\000\000\
\\070\002\000\000\
\\071\002\000\000\
\\072\002\003\000\096\000\005\000\050\000\006\000\049\000\007\000\095\000\
\\008\000\094\000\040\000\093\000\055\000\091\000\058\000\090\000\
\\061\000\089\000\062\000\088\000\063\000\087\000\000\000\
\\073\002\000\000\
\\074\002\000\000\
\\075\002\012\000\236\000\000\000\
\\076\002\011\000\194\000\000\000\
\\077\002\000\000\
\\078\002\000\000\
\\079\002\004\000\100\000\063\000\099\000\000\000\
\\080\002\060\000\019\001\000\000\
\\081\002\000\000\
\\082\002\000\000\
\\083\002\011\000\228\000\000\000\
\\084\002\000\000\
\\085\002\014\000\168\001\000\000\
\\086\002\000\000\
\\087\002\039\000\192\001\000\000\
\\088\002\012\000\236\000\000\000\
\\089\002\020\000\061\001\039\000\060\001\000\000\
\\090\002\012\000\236\000\000\000\
\\091\002\000\000\
\\092\002\011\000\226\000\000\000\
\\093\002\003\000\110\000\020\000\042\000\058\000\021\000\000\000\
\\094\002\000\000\
\\095\002\003\000\110\000\020\000\042\000\058\000\021\000\000\000\
\\096\002\000\000\
\\097\002\005\000\050\000\006\000\049\000\000\000\
\\098\002\000\000\
\\099\002\005\000\050\000\006\000\049\000\000\000\
\\100\002\000\000\
\\101\002\000\000\
\\102\002\011\000\170\000\000\000\
\\103\002\011\000\012\001\000\000\
\\104\002\000\000\
\\105\002\011\000\194\000\000\000\
\\106\002\057\000\229\000\000\000\
\\107\002\011\000\194\000\000\000\
\\108\002\000\000\
\\109\002\011\000\226\000\000\000\
\\110\002\000\000\
\\111\002\000\000\
\\112\002\000\000\
\\113\002\011\000\176\001\000\000\
\\114\002\000\000\
\\115\002\002\000\119\000\010\000\045\000\016\000\043\000\022\000\041\000\
\\027\000\039\000\034\000\035\000\035\000\034\000\037\000\118\000\
\\038\000\031\000\041\000\029\000\042\000\028\000\052\000\024\000\
\\053\000\023\000\000\000\
\\116\002\000\000\
\\117\002\000\000\
\\118\002\000\000\
\\119\002\003\000\055\000\020\000\042\000\058\000\021\000\000\000\
\\120\002\000\000\
\\121\002\002\000\050\001\003\000\049\001\016\000\048\001\021\000\047\001\
\\022\000\046\001\033\000\045\001\034\000\035\000\035\000\034\000\
\\037\000\044\001\038\000\031\000\041\000\043\001\046\000\042\001\
\\050\000\041\001\052\000\040\001\053\000\039\001\000\000\
\\121\002\002\000\050\001\016\000\048\001\021\000\047\001\022\000\046\001\
\\033\000\045\001\034\000\035\000\035\000\034\000\037\000\044\001\
\\038\000\031\000\041\000\043\001\046\000\042\001\050\000\041\001\
\\052\000\040\001\053\000\039\001\000\000\
\\122\002\000\000\
\\123\002\000\000\
\\124\002\011\000\157\001\000\000\
\\125\002\000\000\
\\126\002\011\000\155\001\000\000\
\\127\002\011\000\155\001\000\000\
\\128\002\011\000\153\001\000\000\
\\129\002\011\000\164\001\000\000\
\\130\002\000\000\
\\131\002\011\000\159\001\000\000\
\\132\002\000\000\
\\133\002\000\000\
\\134\002\000\000\
\\135\002\011\000\157\001\000\000\
\\136\002\000\000\
\\137\002\011\000\155\001\000\000\
\\138\002\000\000\
\\139\002\011\000\153\001\000\000\
\\140\002\012\000\236\000\000\000\
\\141\002\011\000\164\001\000\000\
\\142\002\039\000\165\001\000\000\
\\143\002\012\000\236\000\000\000\
\\144\002\011\000\159\001\000\000\
\\145\002\000\000\
\\146\002\000\000\
\\147\002\020\000\160\001\000\000\
\\148\002\000\000\
\\149\002\000\000\
\\150\002\000\000\
\\151\002\059\000\199\000\000\000\
\\152\002\000\000\
\\153\002\011\000\200\000\000\000\
\\154\002\000\000\
\\155\002\000\000\
\\156\002\000\000\
\\157\002\000\000\
\\158\002\000\000\
\\159\002\000\000\
\\160\002\000\000\
\\161\002\000\000\
\\162\002\000\000\
\\163\002\002\000\115\000\003\000\094\001\009\000\046\000\010\000\045\000\
\\016\000\043\000\020\000\042\000\022\000\041\000\027\000\039\000\
\\028\000\038\000\034\000\035\000\035\000\034\000\036\000\093\001\
\\037\000\114\000\038\000\031\000\041\000\029\000\042\000\028\000\
\\048\000\026\000\049\000\092\001\050\000\025\000\052\000\024\000\
\\053\000\023\000\058\000\021\000\000\000\
\\163\002\002\000\115\000\009\000\046\000\010\000\045\000\016\000\043\000\
\\022\000\041\000\027\000\039\000\028\000\038\000\034\000\035\000\
\\035\000\034\000\037\000\114\000\038\000\031\000\041\000\029\000\
\\042\000\028\000\048\000\026\000\050\000\025\000\052\000\024\000\
\\053\000\023\000\000\000\
\\164\002\000\000\
\\165\002\000\000\
\\166\002\009\000\046\000\010\000\045\000\016\000\043\000\022\000\041\000\
\\027\000\039\000\028\000\038\000\034\000\035\000\035\000\034\000\
\\037\000\032\000\038\000\031\000\041\000\029\000\042\000\028\000\
\\048\000\026\000\050\000\025\000\052\000\024\000\053\000\023\000\000\000\
\\167\002\009\000\046\000\010\000\045\000\016\000\043\000\022\000\041\000\
\\027\000\039\000\028\000\038\000\034\000\035\000\035\000\034\000\
\\037\000\032\000\038\000\031\000\041\000\029\000\042\000\028\000\
\\048\000\026\000\050\000\025\000\052\000\024\000\053\000\023\000\000\000\
\\168\002\011\000\197\000\000\000\
\\169\002\011\000\197\000\000\000\
\\170\002\011\000\200\000\000\000\
\\171\002\011\000\214\000\000\000\
\\172\002\000\000\
\\173\002\000\000\
\\174\002\011\000\197\000\000\000\
\\175\002\000\000\
\\176\002\000\000\
\\177\002\000\000\
\\178\002\011\000\214\000\000\000\
\\179\002\008\000\064\000\000\000\
\\180\002\000\000\
\\181\002\000\000\
\\182\002\000\000\
\\183\002\000\000\
\"
val actionRowNumbers =
"\001\000\057\001\071\001\062\001\
\\006\000\133\000\130\000\135\000\
\\141\000\144\000\150\000\139\000\
\\073\001\156\000\151\000\025\000\
\\004\000\003\000\008\000\092\000\
\\002\000\010\000\223\000\006\000\
\\006\000\002\000\006\000\016\000\
\\006\000\245\000\053\001\003\001\
\\243\000\241\000\002\000\007\000\
\\006\000\014\000\011\000\095\000\
\\093\000\223\000\002\000\223\000\
\\006\000\158\000\157\000\084\000\
\\083\000\089\000\054\001\255\000\
\\007\001\088\000\002\000\011\000\
\\002\000\143\000\152\000\153\000\
\\018\000\072\001\069\001\075\000\
\\128\000\076\000\162\000\073\000\
\\170\000\166\000\070\000\126\000\
\\043\000\161\000\101\000\100\000\
\\053\000\246\000\180\000\178\000\
\\216\000\172\000\028\000\186\000\
\\181\000\013\000\012\000\020\000\
\\087\000\189\000\021\000\006\000\
\\188\000\187\000\086\000\006\000\
\\249\000\024\000\221\000\058\001\
\\040\001\060\001\044\000\149\000\
\\064\000\254\000\239\000\099\000\
\\090\000\154\000\053\001\055\000\
\\053\001\053\001\056\000\003\001\
\\003\001\003\001\244\000\242\000\
\\062\000\159\000\061\001\069\000\
\\209\000\205\000\248\000\211\000\
\\216\000\013\000\029\000\121\000\
\\145\000\253\000\006\000\094\000\
\\227\000\250\000\006\000\061\000\
\\063\000\059\001\016\000\008\001\
\\134\000\131\000\132\000\137\000\
\\142\000\138\000\116\000\118\000\
\\113\000\018\000\009\000\107\000\
\\103\000\070\001\164\000\002\000\
\\002\000\163\000\165\000\002\000\
\\160\000\007\000\002\000\002\000\
\\011\000\174\000\216\000\002\000\
\\011\000\031\000\182\000\074\000\
\\201\000\190\000\071\000\199\000\
\\045\000\192\000\200\000\032\000\
\\247\000\205\000\096\000\006\000\
\\085\000\184\000\016\000\046\000\
\\223\000\077\000\224\000\006\000\
\\047\000\022\000\006\000\022\000\
\\018\000\240\000\016\000\049\001\
\\053\001\057\000\050\001\002\000\
\\004\001\058\000\005\001\002\000\
\\006\000\009\001\014\000\048\000\
\\018\000\014\000\215\000\216\000\
\\173\000\030\000\002\000\011\000\
\\095\000\233\000\223\000\223\000\
\\049\000\011\000\003\001\155\000\
\\005\000\005\000\018\000\112\000\
\\018\000\078\000\027\000\072\000\
\\106\000\065\000\109\000\017\000\
\\168\000\169\000\127\000\129\000\
\\171\000\125\000\124\000\147\000\
\\203\000\018\000\217\000\204\000\
\\176\000\179\000\011\000\191\000\
\\011\000\193\000\019\000\011\000\
\\018\000\011\000\021\000\050\000\
\\097\000\185\000\018\000\220\000\
\\222\000\024\000\064\001\023\000\
\\041\001\010\001\038\001\042\001\
\\043\001\026\000\098\000\034\000\
\\053\001\035\000\003\001\033\000\
\\068\001\079\000\010\001\066\001\
\\006\000\095\000\223\000\006\000\
\\015\000\016\000\010\001\006\000\
\\006\000\223\000\223\000\066\000\
\\010\001\210\000\002\000\206\000\
\\212\000\175\000\216\000\123\000\
\\122\000\236\000\018\000\016\000\
\\226\000\251\000\095\000\146\000\
\\036\000\136\000\140\000\117\000\
\\114\000\115\000\017\000\111\000\
\\018\000\108\000\007\000\018\000\
\\102\000\177\000\080\000\202\000\
\\198\000\194\000\196\000\195\000\
\\208\000\054\000\219\000\225\000\
\\063\001\044\001\053\001\053\001\
\\091\000\037\000\002\000\056\001\
\\038\000\167\000\039\000\002\000\
\\040\001\011\001\019\001\017\001\
\\006\000\015\001\006\000\013\001\
\\067\000\035\001\020\001\051\000\
\\016\000\021\001\237\000\059\000\
\\023\001\018\001\031\001\016\001\
\\014\001\022\000\012\001\218\000\
\\216\000\214\000\234\000\235\000\
\\229\000\228\000\006\000\252\000\
\\110\000\120\000\119\000\105\000\
\\104\000\183\000\011\000\011\000\
\\040\000\060\000\052\001\039\001\
\\000\001\001\001\055\001\053\001\
\\003\001\148\000\052\000\095\000\
\\068\000\223\000\027\001\006\000\
\\022\000\015\000\016\000\034\001\
\\238\000\010\001\006\000\018\000\
\\065\001\213\000\095\000\231\000\
\\197\000\207\000\045\001\023\000\
\\081\000\082\000\002\000\051\001\
\\006\001\023\000\028\001\018\000\
\\026\001\024\001\025\001\033\001\
\\037\001\036\001\041\000\030\001\
\\032\001\230\000\018\000\042\000\
\\046\001\047\001\002\001\067\001\
\\029\001\022\001\232\000\048\001\
\\000\000"
val gotoT =
"\
\\001\000\014\000\003\000\013\000\021\000\012\000\022\000\011\000\
\\023\000\010\000\024\000\009\000\025\000\008\000\026\000\007\000\
\\027\000\006\000\028\000\005\000\057\000\004\000\058\000\003\000\
\\075\000\002\000\076\000\001\000\081\000\200\001\000\000\
\\057\000\004\000\058\000\003\000\075\000\050\000\076\000\001\000\000\000\
\\000\000\
\\000\000\
\\001\000\052\000\061\000\051\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\001\000\059\000\003\000\013\000\023\000\058\000\024\000\057\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\080\000\061\000\000\000\
\\001\000\014\000\003\000\013\000\020\000\065\000\021\000\064\000\
\\022\000\011\000\023\000\010\000\024\000\009\000\025\000\008\000\
\\026\000\007\000\027\000\006\000\028\000\005\000\030\000\063\000\000\000\
\\001\000\014\000\003\000\013\000\021\000\068\000\022\000\011\000\
\\023\000\010\000\024\000\009\000\025\000\008\000\026\000\007\000\
\\027\000\006\000\028\000\005\000\029\000\067\000\000\000\
\\008\000\072\000\018\000\071\000\019\000\070\000\000\000\
\\000\000\
\\001\000\014\000\003\000\013\000\021\000\076\000\022\000\011\000\
\\023\000\010\000\024\000\009\000\025\000\008\000\026\000\007\000\
\\027\000\006\000\028\000\005\000\000\000\
\\002\000\084\000\003\000\083\000\031\000\082\000\032\000\081\000\
\\033\000\080\000\034\000\079\000\035\000\078\000\040\000\077\000\000\000\
\\048\000\096\000\049\000\095\000\000\000\
\\001\000\100\000\077\000\099\000\000\000\
\\001\000\102\000\072\000\101\000\000\000\
\\001\000\014\000\003\000\013\000\021\000\103\000\022\000\011\000\
\\023\000\010\000\024\000\009\000\025\000\008\000\026\000\007\000\
\\027\000\006\000\028\000\005\000\000\000\
\\001\000\104\000\000\000\
\\001\000\107\000\006\000\106\000\056\000\105\000\000\000\
\\001\000\109\000\000\000\
\\000\000\
\\057\000\004\000\058\000\003\000\074\000\111\000\076\000\110\000\000\000\
\\057\000\004\000\058\000\115\000\060\000\114\000\000\000\
\\003\000\118\000\000\000\
\\003\000\119\000\000\000\
\\001\000\014\000\003\000\013\000\021\000\120\000\022\000\011\000\
\\023\000\010\000\024\000\009\000\025\000\008\000\026\000\007\000\
\\027\000\006\000\028\000\005\000\000\000\
\\008\000\121\000\000\000\
\\001\000\123\000\079\000\122\000\000\000\
\\002\000\084\000\003\000\083\000\034\000\128\000\035\000\078\000\
\\043\000\127\000\044\000\126\000\046\000\125\000\047\000\124\000\000\000\
\\002\000\084\000\003\000\083\000\016\000\132\000\017\000\131\000\
\\031\000\130\000\032\000\081\000\033\000\080\000\034\000\079\000\
\\035\000\078\000\000\000\
\\004\000\134\000\055\000\133\000\000\000\
\\000\000\
\\049\000\138\000\051\000\137\000\052\000\136\000\000\000\
\\001\000\014\000\003\000\013\000\021\000\139\000\022\000\011\000\
\\023\000\010\000\024\000\009\000\025\000\008\000\026\000\007\000\
\\027\000\006\000\028\000\005\000\000\000\
\\049\000\138\000\051\000\140\000\052\000\136\000\000\000\
\\001\000\100\000\077\000\141\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\001\000\052\000\061\000\143\000\000\000\
\\000\000\
\\001\000\014\000\003\000\013\000\022\000\011\000\023\000\010\000\
\\024\000\009\000\025\000\008\000\026\000\007\000\027\000\145\000\
\\028\000\144\000\000\000\
\\002\000\084\000\003\000\083\000\016\000\146\000\017\000\131\000\
\\031\000\130\000\032\000\081\000\033\000\080\000\034\000\079\000\
\\035\000\078\000\000\000\
\\001\000\014\000\003\000\013\000\022\000\011\000\023\000\010\000\
\\024\000\009\000\025\000\148\000\026\000\147\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\009\000\152\000\012\000\151\000\013\000\150\000\014\000\149\000\000\000\
\\000\000\
\\080\000\157\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\002\000\084\000\003\000\083\000\033\000\170\000\034\000\079\000\
\\035\000\078\000\045\000\169\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\002\000\084\000\003\000\083\000\031\000\173\000\032\000\081\000\
\\033\000\080\000\034\000\079\000\035\000\078\000\000\000\
\\002\000\084\000\003\000\083\000\031\000\176\000\032\000\081\000\
\\033\000\080\000\034\000\079\000\035\000\078\000\039\000\175\000\000\000\
\\008\000\180\000\036\000\179\000\037\000\178\000\000\000\
\\000\000\
\\000\000\
\\002\000\186\000\005\000\185\000\042\000\184\000\000\000\
\\001\000\189\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\001\000\191\000\000\000\
\\000\000\
\\050\000\193\000\000\000\
\\000\000\
\\000\000\
\\071\000\196\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\001\000\107\000\006\000\106\000\056\000\201\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\057\000\004\000\058\000\003\000\074\000\203\000\076\000\110\000\000\000\
\\000\000\
\\057\000\004\000\058\000\003\000\074\000\205\000\076\000\110\000\000\000\
\\057\000\004\000\058\000\003\000\074\000\206\000\076\000\110\000\000\000\
\\000\000\
\\057\000\004\000\058\000\115\000\060\000\208\000\000\000\
\\057\000\004\000\058\000\115\000\060\000\209\000\000\000\
\\057\000\004\000\058\000\115\000\060\000\210\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\041\000\215\000\000\000\
\\000\000\
\\000\000\
\\002\000\084\000\003\000\083\000\033\000\170\000\034\000\079\000\
\\035\000\078\000\045\000\218\000\000\000\
\\002\000\084\000\003\000\083\000\031\000\221\000\032\000\220\000\
\\033\000\219\000\034\000\079\000\035\000\078\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\001\000\225\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\001\000\228\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\001\000\107\000\006\000\231\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\009\000\235\000\000\000\
\\000\000\
\\009\000\152\000\012\000\151\000\013\000\150\000\014\000\238\000\
\\015\000\237\000\000\000\
\\008\000\241\000\010\000\240\000\011\000\239\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\001\000\014\000\003\000\013\000\021\000\245\000\022\000\011\000\
\\023\000\010\000\024\000\009\000\025\000\008\000\026\000\007\000\
\\027\000\006\000\028\000\005\000\030\000\244\000\000\000\
\\001\000\014\000\003\000\013\000\020\000\247\000\021\000\246\000\
\\022\000\011\000\023\000\010\000\024\000\009\000\025\000\008\000\
\\026\000\007\000\027\000\006\000\028\000\005\000\000\000\
\\000\000\
\\000\000\
\\001\000\014\000\003\000\013\000\021\000\068\000\022\000\011\000\
\\023\000\010\000\024\000\009\000\025\000\008\000\026\000\007\000\
\\027\000\006\000\028\000\005\000\029\000\248\000\000\000\
\\000\000\
\\008\000\072\000\018\000\071\000\019\000\249\000\000\000\
\\001\000\014\000\003\000\013\000\021\000\250\000\022\000\011\000\
\\023\000\010\000\024\000\009\000\025\000\008\000\026\000\007\000\
\\027\000\006\000\028\000\005\000\000\000\
\\001\000\014\000\003\000\013\000\021\000\251\000\022\000\011\000\
\\023\000\010\000\024\000\009\000\025\000\008\000\026\000\007\000\
\\027\000\006\000\028\000\005\000\000\000\
\\002\000\084\000\003\000\083\000\031\000\082\000\032\000\081\000\
\\033\000\080\000\034\000\079\000\035\000\078\000\040\000\252\000\000\000\
\\000\000\
\\002\000\084\000\003\000\083\000\033\000\170\000\034\000\079\000\
\\035\000\078\000\045\000\254\000\000\000\
\\001\000\014\000\003\000\013\000\021\000\255\000\022\000\011\000\
\\023\000\010\000\024\000\009\000\025\000\008\000\026\000\007\000\
\\027\000\006\000\028\000\005\000\000\000\
\\002\000\084\000\003\000\083\000\031\000\000\001\032\000\081\000\
\\033\000\080\000\034\000\079\000\035\000\078\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\041\000\011\001\000\000\
\\000\000\
\\001\000\012\001\000\000\
\\000\000\
\\000\000\
\\001\000\107\000\006\000\013\001\000\000\
\\000\000\
\\048\000\015\001\049\000\095\000\000\000\
\\000\000\
\\000\000\
\\001\000\100\000\077\000\018\001\000\000\
\\000\000\
\\070\000\020\001\000\000\
\\001\000\102\000\072\000\023\001\000\000\
\\070\000\024\001\000\000\
\\009\000\152\000\012\000\151\000\013\000\150\000\014\000\025\001\000\000\
\\000\000\
\\001\000\107\000\006\000\026\001\000\000\
\\000\000\
\\057\000\004\000\058\000\003\000\074\000\027\001\076\000\110\000\000\000\
\\000\000\
\\000\000\
\\001\000\014\000\003\000\013\000\020\000\029\001\021\000\246\000\
\\022\000\011\000\023\000\010\000\024\000\009\000\025\000\008\000\
\\026\000\007\000\027\000\006\000\028\000\005\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\001\000\014\000\003\000\013\000\021\000\031\001\022\000\011\000\
\\023\000\010\000\024\000\009\000\025\000\008\000\026\000\007\000\
\\027\000\006\000\028\000\005\000\000\000\
\\001\000\123\000\079\000\032\001\000\000\
\\057\000\036\001\062\000\035\001\063\000\034\001\078\000\033\001\000\000\
\\002\000\084\000\003\000\083\000\034\000\128\000\035\000\078\000\
\\043\000\049\001\046\000\125\000\047\000\124\000\000\000\
\\000\000\
\\009\000\152\000\012\000\151\000\013\000\150\000\014\000\051\001\000\000\
\\002\000\084\000\003\000\083\000\034\000\128\000\035\000\078\000\
\\043\000\127\000\044\000\052\001\046\000\125\000\047\000\124\000\000\000\
\\000\000\
\\002\000\084\000\003\000\083\000\033\000\170\000\034\000\079\000\
\\035\000\078\000\045\000\053\001\000\000\
\\000\000\
\\000\000\
\\001\000\014\000\003\000\013\000\021\000\055\001\022\000\011\000\
\\023\000\010\000\024\000\009\000\025\000\008\000\026\000\007\000\
\\027\000\006\000\028\000\005\000\000\000\
\\002\000\084\000\003\000\083\000\016\000\056\001\017\000\131\000\
\\031\000\130\000\032\000\081\000\033\000\080\000\034\000\079\000\
\\035\000\078\000\000\000\
\\004\000\134\000\055\000\057\001\000\000\
\\000\000\
\\049\000\138\000\051\000\060\001\052\000\136\000\000\000\
\\048\000\061\001\049\000\095\000\000\000\
\\000\000\
\\002\000\084\000\003\000\083\000\016\000\063\001\017\000\131\000\
\\031\000\130\000\032\000\081\000\033\000\080\000\034\000\079\000\
\\035\000\078\000\000\000\
\\057\000\004\000\058\000\115\000\060\000\064\001\000\000\
\\000\000\
\\001\000\014\000\003\000\013\000\022\000\066\001\023\000\010\000\
\\026\000\065\001\028\000\144\000\000\000\
\\001\000\014\000\003\000\013\000\022\000\066\001\023\000\010\000\
\\026\000\147\000\000\000\
\\009\000\152\000\012\000\151\000\013\000\150\000\014\000\067\001\000\000\
\\000\000\
\\009\000\152\000\012\000\069\001\013\000\068\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\009\000\076\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\009\000\152\000\012\000\151\000\013\000\150\000\014\000\077\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\002\000\084\000\003\000\083\000\031\000\176\000\032\000\081\000\
\\033\000\080\000\034\000\079\000\035\000\078\000\039\000\078\001\000\000\
\\000\000\
\\002\000\084\000\003\000\083\000\031\000\176\000\032\000\081\000\
\\033\000\080\000\034\000\079\000\035\000\078\000\039\000\079\001\000\000\
\\000\000\
\\008\000\180\000\036\000\179\000\037\000\080\001\000\000\
\\002\000\084\000\003\000\083\000\031\000\081\001\032\000\081\000\
\\033\000\080\000\034\000\079\000\035\000\078\000\000\000\
\\009\000\152\000\012\000\151\000\013\000\150\000\014\000\082\001\000\000\
\\002\000\084\000\003\000\083\000\031\000\083\001\032\000\081\000\
\\033\000\080\000\034\000\079\000\035\000\078\000\000\000\
\\002\000\186\000\005\000\185\000\042\000\084\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\009\000\152\000\012\000\151\000\013\000\150\000\014\000\086\001\000\000\
\\000\000\
\\000\000\
\\050\000\087\001\000\000\
\\000\000\
\\001\000\107\000\006\000\089\001\073\000\088\001\000\000\
\\000\000\
\\057\000\036\001\062\000\093\001\063\000\034\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\057\000\004\000\058\000\003\000\074\000\096\001\076\000\110\000\000\000\
\\000\000\
\\057\000\004\000\058\000\115\000\060\000\098\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\057\000\036\001\062\000\101\001\063\000\034\001\000\000\
\\000\000\
\\001\000\052\000\061\000\102\001\000\000\
\\004\000\104\001\066\000\103\001\000\000\
\\049\000\106\001\065\000\105\001\000\000\
\\001\000\108\001\064\000\107\001\000\000\
\\001\000\107\000\006\000\111\001\068\000\110\001\069\000\109\001\000\000\
\\001\000\107\000\006\000\114\001\007\000\113\001\000\000\
\\057\000\036\001\062\000\115\001\063\000\034\001\000\000\
\\001\000\116\001\000\000\
\\001\000\118\001\067\000\117\001\000\000\
\\049\000\106\001\065\000\119\001\000\000\
\\049\000\138\000\051\000\120\001\052\000\136\000\000\000\
\\000\000\
\\057\000\036\001\062\000\122\001\063\000\034\001\000\000\
\\000\000\
\\001\000\014\000\003\000\013\000\021\000\123\001\022\000\011\000\
\\023\000\010\000\024\000\009\000\025\000\008\000\026\000\007\000\
\\027\000\006\000\028\000\005\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\002\000\084\000\003\000\083\000\033\000\170\000\034\000\079\000\
\\035\000\078\000\045\000\125\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\009\000\152\000\012\000\151\000\013\000\150\000\014\000\126\001\000\000\
\\001\000\107\000\006\000\127\001\000\000\
\\000\000\
\\000\000\
\\004\000\130\001\053\000\129\001\054\000\128\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\001\000\059\000\003\000\013\000\023\000\058\000\000\000\
\\000\000\
\\000\000\
\\009\000\235\000\000\000\
\\009\000\132\001\000\000\
\\000\000\
\\009\000\152\000\012\000\151\000\013\000\150\000\014\000\134\001\
\\015\000\133\001\000\000\
\\000\000\
\\008\000\241\000\010\000\240\000\011\000\135\001\000\000\
\\009\000\152\000\012\000\151\000\013\000\150\000\014\000\136\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\057\000\004\000\058\000\003\000\074\000\140\001\076\000\110\000\000\000\
\\057\000\004\000\058\000\003\000\074\000\141\001\076\000\110\000\000\000\
\\000\000\
\\000\000\
\\001\000\014\000\003\000\013\000\021\000\145\001\022\000\011\000\
\\023\000\010\000\024\000\009\000\025\000\008\000\026\000\007\000\
\\027\000\006\000\028\000\005\000\059\000\144\001\000\000\
\\057\000\004\000\058\000\003\000\075\000\146\001\076\000\001\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\001\000\014\000\003\000\013\000\021\000\149\001\022\000\011\000\
\\023\000\010\000\024\000\009\000\025\000\008\000\026\000\007\000\
\\027\000\006\000\028\000\005\000\000\000\
\\071\000\150\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\001\000\152\001\000\000\
\\000\000\
\\001\000\154\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\001\000\107\000\006\000\111\001\069\000\159\001\000\000\
\\000\000\
\\001\000\107\000\006\000\114\001\007\000\160\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\070\000\164\001\000\000\
\\000\000\
\\000\000\
\\002\000\084\000\003\000\083\000\033\000\170\000\034\000\079\000\
\\035\000\078\000\045\000\165\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\001\000\167\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\002\000\084\000\003\000\083\000\031\000\168\001\032\000\081\000\
\\033\000\080\000\034\000\079\000\035\000\078\000\000\000\
\\002\000\084\000\003\000\083\000\016\000\169\001\017\000\131\000\
\\031\000\130\000\032\000\081\000\033\000\080\000\034\000\079\000\
\\035\000\078\000\000\000\
\\000\000\
\\000\000\
\\001\000\107\000\006\000\089\001\057\000\004\000\058\000\003\000\
\\073\000\173\001\074\000\172\001\076\000\110\000\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\057\000\004\000\058\000\003\000\074\000\175\001\076\000\110\000\000\000\
\\057\000\004\000\058\000\115\000\060\000\176\001\000\000\
\\000\000\
\\000\000\
\\004\000\104\001\066\000\178\001\000\000\
\\000\000\
\\049\000\106\001\065\000\180\001\000\000\
\\000\000\
\\001\000\108\001\064\000\181\001\000\000\
\\070\000\182\001\000\000\
\\001\000\107\000\006\000\111\001\068\000\183\001\069\000\109\001\000\000\
\\001\000\107\000\006\000\185\001\069\000\184\001\000\000\
\\000\000\
\\000\000\
\\057\000\036\001\062\000\186\001\063\000\034\001\000\000\
\\001\000\118\001\067\000\187\001\000\000\
\\009\000\152\000\012\000\151\000\013\000\150\000\014\000\188\001\000\000\
\\000\000\
\\000\000\
\\004\000\130\001\053\000\189\001\054\000\128\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\001\000\107\000\006\000\089\001\073\000\191\001\000\000\
\\000\000\
\\000\000\
\\001\000\014\000\003\000\013\000\021\000\145\001\022\000\011\000\
\\023\000\010\000\024\000\009\000\025\000\008\000\026\000\007\000\
\\027\000\006\000\028\000\005\000\059\000\194\001\000\000\
\\000\000\
\\000\000\
\\001\000\107\000\006\000\089\001\073\000\195\001\000\000\
\\000\000\
\\009\000\152\000\012\000\151\000\013\000\150\000\014\000\196\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\009\000\152\000\012\000\151\000\013\000\150\000\014\000\198\001\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\\000\000\
\"
val numstates = 457
val numrules = 237
val s = ref "" and index = ref 0
val string_to_int = fn () => 
let val i = !index
in index := i+2; ordof(!s,i) + ordof(!s,i+1) * 256
end
val string_to_list = fn s' =>
    let val len = String.length s'
        fun f () =
           if !index < len then string_to_int() :: f()
           else nil
   in index := 0; s := s'; f ()
   end
val string_to_pairlist = fn (conv_key,conv_entry) =>
     let fun f () =
         case string_to_int()
         of 0 => EMPTY
          | n => PAIR(conv_key (n-1),conv_entry (string_to_int()),f())
     in f
     end
val string_to_pairlist_default = fn (conv_key,conv_entry) =>
    let val conv_row = string_to_pairlist(conv_key,conv_entry)
    in fn () =>
       let val default = conv_entry(string_to_int())
           val row = conv_row()
       in (row,default)
       end
   end
val string_to_table = fn (convert_row,s') =>
    let val len = String.length s'
 	 fun f ()=
	    if !index < len then convert_row() :: f()
	    else nil
     in (s := s'; index := 0; f ())
     end
local
  val memo = array(numstates+numrules,ERROR)
  val _ =let fun g i=(update(memo,i,REDUCE(i-numstates)); g(i+1))
	fun f i =
	     if i=numstates then g i
	     else (update(memo,i,SHIFT (STATE i)); f (i+1))
	   in f 0 handle Subscript => ()
	   end
in
val entry_to_action = fn 0 => ACCEPT | 1 => ERROR | j => memo sub (j-2)
end
val gotoT=arrayoflist(string_to_table(string_to_pairlist(NT,STATE),gotoT))
val actionRows=string_to_table(string_to_pairlist_default(T,entry_to_action),actionRows)
val actionRowNumbers = string_to_list actionRowNumbers
val actionT = let val actionRowLookUp=
let val a=arrayoflist(actionRows) in fn i=>a sub i end
in arrayoflist(map actionRowLookUp actionRowNumbers)
end
in LrTable.mkLrTable {actions=actionT,gotos=gotoT,numRules=numrules,
numStates=numstates,initialState=STATE 0}
end
end
local open Header in
type pos = int
type arg = pos*pos -> ErrorMsg.severity -> string -> unit
structure MlyValue = 
struct
datatype svalue = VOID | ntVOID of unit | STRING of  (string)
 | REAL of  (string) | INT0 of  (int) | INT of  (int)
 | TYVAR of  (Symbol.symbol) | ID of  (Symbol.symbol)
 | interdec of  (dec susp) | importdec of  (string list)
 | fctb of  ( ( symbol * functorVar * fctb )  list susp)
 | fparam of  ( ( symbol * Structure * bool )  susp)
 | strb of  (bool ->  ( symbol*structureVar*strb )  list pathstamped)
 | sdec of  (dec pathnstamped) | sdecs' of  (dec list pathnstamped)
 | sdecs of  (dec list pathnstamped)
 | str of  (strArg -> strexp*Structure*thinning)
 | sigb of  (signatureVar list susp)
 | sigconstraint_op of  (Structure -> Structure option)
 | sign of  (bool*Structure -> signtype)
 | patheqn of  (symbol list list) | sharespec of  (spectype)
 | exnspec of  (spectype) | valspec of  (spectype)
 | tyspec of  (eqprop -> spectype) | strspec of  (spectype)
 | spec of  (spectype) | spec_s of  (spectype) | ops of  (symbol list)
 | ldecs of  (dec pathvstamped uvars) | exp_pa of  (exp list vstamped)
 | ldec of  (dec pathvstamped uvars) | fixity of  (fixity)
 | qid_p of  (structureVar list susp)
 | eb of  (eb list pathvstamped uvars)
 | constr of  ( ( ty * tyclooker -> symbol * bool * ty )  uvars)
 | constrs of  ( ( ty * tyclooker -> (symbol * bool * ty) list )  uvars)
 | db' of  (symbol*int*datacon list tpathed)
 | db of  ( ( symbol * int * datacon list tpathed )  list)
 | tyvar_pc of  (tyvar list) | tyvars of  (tyvar list)
 | tb of  (bool -> tb list pathvstamped)
 | clause of  (rawclause susp uvars)
 | clause' of  ( ( symbol * pat list )  susp uvars)
 | apats of  ( ( pat * fixity * complainer )  list susp uvars)
 | fb of  (rawclause list list susp uvars)
 | fb' of  (rawclause list susp uvars) | rvb of  (rawrvb list susp)
 | constraint of  (ty option susp uvars) | vb of  (vb list vstamped)
 | pat_list of  (pat list susp uvars)
 | pat_2c of  (pat list susp uvars)
 | plabels of  ( ( (symbol * pat) list * bool )  susp uvars)
 | plabel of  ( ( symbol * pat )  susp uvars)
 | apat'' of  (pat susp uvars)
 | apat' of  ( ( pat * fixity * complainer )  susp uvars)
 | apat of  ( ( pat * fixity * complainer )  susp uvars)
 | pat' of  (pat susp uvars) | pat of  (pat susp uvars)
 | exp_2c of  (exp list vstamped uvars)
 | exp_list of  (exp list vstamped uvars)
 | eexp of  (exp vstamped uvars) | dexp' of  (exp vstamped uvars)
 | dexp of  (exp vstamped uvars) | cexp' of  (exp vstamped uvars)
 | bexp of  (exp vstamped uvars) | aexp of  (exp vstamped uvars)
 | app_exp of  (exp precStack vstamped uvars)
 | exp of  (exp vstamped uvars) | exp_ps of  (exp list vstamped uvars)
 | elabels of  ( ( symbol * exp )  list vstamped uvars)
 | elabel of  ( ( symbol * exp )  vstamped uvars)
 | rule of  (rule vstamped uvars)
 | match of  (rule list vstamped uvars)
 | ty0_pc of  (ty list tsusp uvars) | ty of  (ty tsusp uvars)
 | tuple_ty of  (ty list tsusp uvars) | ty' of  (ty tsusp uvars)
 | tlabels of  ( ( symbol * ty )  list tsusp uvars)
 | tlabel of  ( ( symbol * ty )  tsusp uvars)
 | tycon of  (symbol list) | selector of  (symbol)
 | qid_p0 of  (symbol list list) | qid of  (symbol list)
 | opid of  (symbol susp) | op_op of  (unit susp) | int of  (int)
 | id of  (symbol) | ident of  (symbol)
end
type svalue = MlyValue.svalue
type result = dec susp
end
structure EC=
struct
open LrTable
val is_keyword =
fn (T 68) => true | (T 67) => true | (T 66) => true | (T 56) => true
 | (T 55) => true | (T 53) => true | (T 52) => true | (T 51) => true
 | (T 50) => true | (T 49) => true | (T 48) => true | (T 47) => true
 | (T 46) => true | (T 45) => true | (T 44) => true | (T 43) => true
 | (T 41) => true | (T 40) => true | (T 39) => true | (T 38) => true
 | (T 37) => true | (T 36) => true | (T 35) => true | (T 34) => true
 | (T 33) => true | (T 32) => true | (T 31) => true | (T 30) => true
 | (T 28) => true | (T 27) => true | (T 26) => true | (T 25) => true
 | (T 24) => true | (T 22) => true | (T 21) => true | (T 20) => true
 | (T 18) => true | (T 17) => true | (T 16) => true | (T 15) => true
 | (T 14) => true | (T 12) => true | (T 10) => true | (T 9) => true | 
(T 8) => true | _ => false
val preferred_insert =
fn (T 17) => true | (T 50) => true | (T 52) => true | _ => false
val preferred_subst =
fn (T 1) =>(T 59)::nil
|(T 10) =>(T 67)::nil
|(T 19) =>(T 24)::nil
|(T 24) =>(T 19)::nil
|(T 58) =>(T 38)::nil
|(T 59) =>(T 1)::nil
| _ => nil
val noShift = 
fn (T 0) => true | _ => false
val showTerminal =
fn (T 0) => "EOF"
  | (T 1) => "SEMICOLON"
  | (T 2) => "ID"
  | (T 3) => "TYVAR"
  | (T 4) => "INT"
  | (T 5) => "INT0"
  | (T 6) => "REAL"
  | (T 7) => "STRING"
  | (T 8) => "ABSTRACTION"
  | (T 9) => "ABSTYPE"
  | (T 10) => "AND"
  | (T 11) => "ARROW"
  | (T 12) => "AS"
  | (T 13) => "BAR"
  | (T 14) => "CASE"
  | (T 15) => "DATATYPE"
  | (T 16) => "DOTDOTDOT"
  | (T 17) => "ELSE"
  | (T 18) => "END"
  | (T 19) => "EQUAL"
  | (T 20) => "EQTYPE"
  | (T 21) => "EXCEPTION"
  | (T 22) => "DO"
  | (T 23) => "DOT"
  | (T 24) => "DARROW"
  | (T 25) => "FN"
  | (T 26) => "FUN"
  | (T 27) => "FUNCTOR"
  | (T 28) => "HANDLE"
  | (T 29) => "HASH"
  | (T 30) => "IF"
  | (T 31) => "IN"
  | (T 32) => "INCLUDE"
  | (T 33) => "INFIX"
  | (T 34) => "INFIXR"
  | (T 35) => "LET"
  | (T 36) => "LOCAL"
  | (T 37) => "NONFIX"
  | (T 38) => "OF"
  | (T 39) => "OP"
  | (T 40) => "OPEN"
  | (T 41) => "OVERLOAD"
  | (T 42) => "QUERY"
  | (T 43) => "RAISE"
  | (T 44) => "REC"
  | (T 45) => "SHARING"
  | (T 46) => "SIG"
  | (T 47) => "SIGNATURE"
  | (T 48) => "STRUCT"
  | (T 49) => "STRUCTURE"
  | (T 50) => "THEN"
  | (T 51) => "TYPE"
  | (T 52) => "VAL"
  | (T 53) => "WHILE"
  | (T 54) => "WILD"
  | (T 55) => "WITH"
  | (T 56) => "WITHTYPE"
  | (T 57) => "ASTERISK"
  | (T 58) => "COLON"
  | (T 59) => "COMMA"
  | (T 60) => "LBRACE"
  | (T 61) => "LBRACKET"
  | (T 62) => "LPAREN"
  | (T 63) => "RBRACE"
  | (T 64) => "RBRACKET"
  | (T 65) => "RPAREN"
  | (T 66) => "ORELSE"
  | (T 67) => "ANDALSO"
  | (T 68) => "IMPORT"
  | _ => "bogus-term"
val errtermvalue=
let open Header in
fn (T 2) => MlyValue.ID((Symbol.symbol "bogus")) | 
(T 3) => MlyValue.TYVAR((Symbol.symbol "'bogus")) | 
(T 4) => MlyValue.INT((1)) | 
(T 5) => MlyValue.INT0((0)) | 
(T 6) => MlyValue.REAL(("0.0")) | 
(T 7) => MlyValue.STRING(("")) | 
_ => MlyValue.VOID
end
val terms = (T 0) :: (T 1) :: (T 8) :: (T 9) :: (T 10) :: (T 11) :: 
(T 12) :: (T 13) :: (T 14) :: (T 15) :: (T 16) :: (T 17) :: (T 18) :: 
(T 19) :: (T 20) :: (T 21) :: (T 22) :: (T 23) :: (T 24) :: (T 25) :: 
(T 26) :: (T 27) :: (T 28) :: (T 29) :: (T 30) :: (T 31) :: (T 32) :: 
(T 33) :: (T 34) :: (T 35) :: (T 36) :: (T 37) :: (T 38) :: (T 39) :: 
(T 40) :: (T 41) :: (T 42) :: (T 43) :: (T 44) :: (T 45) :: (T 46) :: 
(T 47) :: (T 48) :: (T 49) :: (T 50) :: (T 51) :: (T 52) :: (T 53) :: 
(T 54) :: (T 55) :: (T 56) :: (T 57) :: (T 58) :: (T 59) :: (T 60) :: 
(T 61) :: (T 62) :: (T 63) :: (T 64) :: (T 65) :: (T 66) :: (T 67) :: 
(T 68) :: nil
end
structure Actions =
struct 
exception mlyAction of int
val actions = 
let open Header
in
fn (i392,defaultPos,stack,
    (error):arg) =>
case (i392,stack)
of (0,(_,(MlyValue.INT INT,INT1left,INT1right))::rest671) => let val 
result=MlyValue.int((INT))
 in (LrTable.NT 2,(result,INT1left,INT1right),rest671) end
| (1,(_,(MlyValue.INT0 INT0,INT01left,INT01right))::rest671) => let 
val result=MlyValue.int((INT0))
 in (LrTable.NT 2,(result,INT01left,INT01right),rest671) end
| (2,(_,(MlyValue.ID ID,ID1left,ID1right))::rest671) => let val result
=MlyValue.id((ID))
 in (LrTable.NT 1,(result,ID1left,ID1right),rest671) end
| (3,(_,(_,ASTERISK1left,ASTERISK1right))::rest671) => let val result=
MlyValue.id((ASTERISKsym))
 in (LrTable.NT 1,(result,ASTERISK1left,ASTERISK1right),rest671) end
| (4,(_,(MlyValue.ID ID,ID1left,ID1right))::rest671) => let val result
=MlyValue.ident((ID))
 in (LrTable.NT 0,(result,ID1left,ID1right),rest671) end
| (5,(_,(_,ASTERISK1left,ASTERISK1right))::rest671) => let val result=
MlyValue.ident((ASTERISKsym))
 in (LrTable.NT 0,(result,ASTERISK1left,ASTERISK1right),rest671) end
| (6,(_,(_,EQUAL1left,EQUAL1right))::rest671) => let val result=
MlyValue.ident((EQUALsym))
 in (LrTable.NT 0,(result,EQUAL1left,EQUAL1right),rest671) end
| (7,(_,(_,OPleft as OP1left,OPright as OP1right))::rest671) => let 
val result=MlyValue.op_op((
fn()=> error (OPleft,OPright) WARN "unnecessary `op'"))
 in (LrTable.NT 3,(result,OP1left,OP1right),rest671) end
| (8,rest671) => let val result=MlyValue.op_op((fn()=>()))
 in (LrTable.NT 3,(result,defaultPos,defaultPos),rest671) end
| (9,(_,(MlyValue.id id,idleft as id1left,idright as id1right))::
rest671) => let val result=MlyValue.opid((
fn()=>(case lookFIX id of NONfix => ()
				  | _ => error(idleft,idright)COMPLAIN
						"nonfix identifier required";
				id)
))
 in (LrTable.NT 4,(result,id1left,id1right),rest671) end
| (10,(_,(MlyValue.ident ident,_,ident1right))::(_,(_,OP1left,_))::
rest671) => let val result=MlyValue.opid((fn()=>ident))
 in (LrTable.NT 4,(result,OP1left,ident1right),rest671) end
| (11,(_,(MlyValue.qid qid,_,qid1right))::_::(_,(MlyValue.ID ID,
ID1left,_))::rest671) => let val result=MlyValue.qid((ID :: qid))
 in (LrTable.NT 5,(result,ID1left,qid1right),rest671) end
| (12,(_,(MlyValue.ident ident,ident1left,ident1right))::rest671) => 
let val result=MlyValue.qid(([ident]))
 in (LrTable.NT 5,(result,ident1left,ident1right),rest671) end
| (13,(_,(MlyValue.ID ID,ID1left,ID1right))::rest671) => let val 
result=MlyValue.selector((ID))
 in (LrTable.NT 7,(result,ID1left,ID1right),rest671) end
| (14,(_,(MlyValue.INT INT,INT1left,INT1right))::rest671) => let val 
result=MlyValue.selector((Symbol.symbol(makestring INT)))
 in (LrTable.NT 7,(result,INT1left,INT1right),rest671) end
| (15,(_,(MlyValue.tycon tycon,_,tycon1right))::_::(_,(MlyValue.ID ID,
ID1left,_))::rest671) => let val result=MlyValue.tycon((ID :: tycon))
 in (LrTable.NT 8,(result,ID1left,tycon1right),rest671) end
| (16,(_,(MlyValue.ID ID,ID1left,ID1right))::rest671) => let val 
result=MlyValue.tycon(([ID]))
 in (LrTable.NT 8,(result,ID1left,ID1right),rest671) end
| (17,(_,(MlyValue.ty ty,_,ty1right))::_::(_,(MlyValue.selector 
selector,selector1left,_))::rest671) => let val result=MlyValue.tlabel
((fn $ =>(selector, E ty $), V ty))
 in (LrTable.NT 9,(result,selector1left,ty1right),rest671) end
| (18,(_,(MlyValue.tlabels tlabels,_,tlabels1right))::_::(_,(
MlyValue.tlabel tlabel,tlabel1left,_))::rest671) => let val result=
MlyValue.tlabels((
fn $ => E tlabel $ :: E tlabels $,
				 V tlabel \/ V tlabels))
 in (LrTable.NT 10,(result,tlabel1left,tlabels1right),rest671) end
| (19,(_,(MlyValue.tlabel tlabel,tlabel1left,tlabel1right))::rest671)
 => let val result=MlyValue.tlabels((fn $ => [E tlabel $], V tlabel))
 in (LrTable.NT 10,(result,tlabel1left,tlabel1right),rest671) end
| (20,(_,(MlyValue.TYVAR TYVAR,TYVAR1left,TYVAR1right))::rest671) => 
let val result=MlyValue.ty'((
let val tyv = mkTyvar(mkUBOUND TYVAR)
			  in (fn $ => VARty tyv, singleton_tyvar tyv)
			 end
))
 in (LrTable.NT 11,(result,TYVAR1left,TYVAR1right),rest671) end
| (21,(_,(_,_,RBRACEright as RBRACE1right))::(_,(MlyValue.tlabels 
tlabels,_,_))::(_,(_,LBRACEleft as LBRACE1left,_))::rest671) => let 
val result=MlyValue.ty'((
fn $ => make_recordTy(E tlabels $,
						error(LBRACEleft,RBRACEright)),
			 V tlabels
))
 in (LrTable.NT 11,(result,LBRACE1left,RBRACE1right),rest671) end
| (22,(_,(_,_,RBRACEright as RBRACE1right))::(_,(_,LBRACEleft as 
LBRACE1left,_))::rest671) => let val result=MlyValue.ty'((
fn $ => make_recordTy(nil,
					error(LBRACEleft,RBRACEright)),
			 no_tyvars
))
 in (LrTable.NT 11,(result,LBRACE1left,RBRACE1right),rest671) end
| (23,(_,(MlyValue.tycon tycon,tyconleft,tyconright as tycon1right))::
_::(_,(MlyValue.ty0_pc ty0_pc,_,_))::(_,(_,LPAREN1left,_))::rest671)
 => let val result=MlyValue.ty'((
fn look =>let val ts = E ty0_pc look
			  in CONty(look(tycon,length ts,error(tyconleft,tyconright)COMPLAIN),ts)
				 end,
			 V ty0_pc
))
 in (LrTable.NT 11,(result,LPAREN1left,tycon1right),rest671) end
| (24,(_,(_,_,RPAREN1right))::(_,(MlyValue.ty ty,_,_))::(_,(_,
LPAREN1left,_))::rest671) => let val result=MlyValue.ty'((ty))
 in (LrTable.NT 11,(result,LPAREN1left,RPAREN1right),rest671) end
| (25,(_,(MlyValue.tycon tycon,tyconleft,tyconright as tycon1right))::
(_,(MlyValue.ty' ty',ty'1left,_))::rest671) => let val result=
MlyValue.ty'((
fn look =>CONty(look(tycon,1,
					error(tyconleft,tyconright)COMPLAIN),
					[E ty' look]),
			 V ty'
))
 in (LrTable.NT 11,(result,ty'1left,tycon1right),rest671) end
| (26,(_,(MlyValue.tycon tycon,tyconleft as tycon1left,tyconright as 
tycon1right))::rest671) => let val result=MlyValue.ty'((
fn look =>CONty(look(tycon, 0,
				  error(tyconleft,tyconright)COMPLAIN),[]),
			 no_tyvars
))
 in (LrTable.NT 11,(result,tycon1left,tycon1right),rest671) end
| (27,(_,(MlyValue.tuple_ty tuple_ty,_,tuple_ty1right))::_::(_,(
MlyValue.ty' ty',ty'1left,_))::rest671) => let val result=
MlyValue.tuple_ty((
fn $ => E ty' $ :: E tuple_ty $,
			  V ty' \/ V tuple_ty))
 in (LrTable.NT 12,(result,ty'1left,tuple_ty1right),rest671) end
| (28,(_,(MlyValue.ty' ty'2,_,ty'2right))::_::(_,(MlyValue.ty' ty'1,
ty'1left,_))::rest671) => let val result=MlyValue.tuple_ty((
fn $ =>[E ty'1 $, E ty'2 $], V ty'1 \/ V ty'2))
 in (LrTable.NT 12,(result,ty'1left,ty'2right),rest671) end
| (29,(_,(MlyValue.tuple_ty tuple_ty,tuple_ty1left,tuple_ty1right))::
rest671) => let val result=MlyValue.ty((
fn $ =>tupleTy(E tuple_ty $), V tuple_ty))
 in (LrTable.NT 13,(result,tuple_ty1left,tuple_ty1right),rest671) end
| (30,(_,(MlyValue.ty ty2,_,ty2right))::_::(_,(MlyValue.ty ty1,ty1left
,_))::rest671) => let val result=MlyValue.ty((
fn $ =>CONty(arrowTycon, [E ty1 $, E ty2 $]),
			 V ty1 \/ V ty2))
 in (LrTable.NT 13,(result,ty1left,ty2right),rest671) end
| (31,(_,(MlyValue.ty' ty',ty'1left,ty'1right))::rest671) => let val 
result=MlyValue.ty((ty'))
 in (LrTable.NT 13,(result,ty'1left,ty'1right),rest671) end
| (32,(_,(MlyValue.ty ty2,_,ty2right))::_::(_,(MlyValue.ty ty1,ty1left
,_))::rest671) => let val result=MlyValue.ty0_pc((
fn $ => [E ty1 $, E ty2 $], V ty1 \/ V ty2))
 in (LrTable.NT 14,(result,ty1left,ty2right),rest671) end
| (33,(_,(MlyValue.ty0_pc ty0_pc,_,ty0_pc1right))::_::(_,(MlyValue.ty 
ty,ty1left,_))::rest671) => let val result=MlyValue.ty0_pc((
fn $ => E ty $ :: E ty0_pc $, V ty \/ V ty0_pc))
 in (LrTable.NT 14,(result,ty1left,ty0_pc1right),rest671) end
| (34,(_,(MlyValue.rule rule,rule1left,rule1right))::rest671) => let 
val result=MlyValue.match((fn st => [E rule st], V rule))
 in (LrTable.NT 15,(result,rule1left,rule1right),rest671) end
| (35,(_,(MlyValue.match match,_,match1right))::_::(_,(MlyValue.rule 
rule,rule1left,_))::rest671) => let val result=MlyValue.match((
fn st => E rule st :: E match st, V rule \/ V match))
 in (LrTable.NT 15,(result,rule1left,match1right),rest671) end
| (36,(_,(MlyValue.exp exp,expleft,expright as exp1right))::_::(_,(
MlyValue.pat pat,patleft as pat1left,patright))::rest671) => let val 
result=MlyValue.rule((
makeRULE(E pat, fn $ => markexp(E exp $,expleft,expright),
					error(patleft,patright)),
			 V pat \/ V exp
))
 in (LrTable.NT 16,(result,pat1left,exp1right),rest671) end
| (37,(_,(MlyValue.exp exp,_,exp1right))::_::(_,(MlyValue.selector 
selector,selector1left,_))::rest671) => let val result=MlyValue.elabel
((fn st => (selector,E exp st), V exp))
 in (LrTable.NT 17,(result,selector1left,exp1right),rest671) end
| (38,(_,(MlyValue.elabels elabels,_,elabels1right))::_::(_,(
MlyValue.elabel elabel,elabel1left,_))::rest671) => let val result=
MlyValue.elabels((
fn st => (E elabel st :: E elabels st),
			 V elabel \/ V elabels))
 in (LrTable.NT 18,(result,elabel1left,elabels1right),rest671) end
| (39,(_,(MlyValue.elabel elabel,elabel1left,elabel1right))::rest671)
 => let val result=MlyValue.elabels((fn st => [E elabel st], V elabel)
)
 in (LrTable.NT 18,(result,elabel1left,elabel1right),rest671) end
| (40,(_,(MlyValue.exp exp,exp1left,exp1right))::rest671) => let val 
result=MlyValue.exp_ps((fn st => [E exp st], V exp))
 in (LrTable.NT 19,(result,exp1left,exp1right),rest671) end
| (41,(_,(MlyValue.exp_ps exp_ps,_,exp_ps1right))::_::(_,(MlyValue.exp
 exp,exp1left,_))::rest671) => let val result=MlyValue.exp_ps((
fn st => E exp st :: E exp_ps st, V exp \/ V exp_ps))
 in (LrTable.NT 19,(result,exp1left,exp_ps1right),rest671) end
| (42,(_,(MlyValue.dexp' dexp',dexp'1left,dexp'1right))::rest671) => 
let val result=MlyValue.exp((dexp'))
 in (LrTable.NT 20,(result,dexp'1left,dexp'1right),rest671) end
| (43,(_,(MlyValue.dexp' dexp',dexp'left,dexp'right as dexp'1right))::
_::(_,(MlyValue.eexp eexp,eexpleft as eexp1left,eexpright))::rest671)
 => let val result=MlyValue.exp((
fn st=> ORELSEexp(markexp(E eexp st,eexpleft,eexpright),
				   		markexp(E dexp' st,dexp'left,dexp'right)),
			 V eexp \/ V dexp'
))
 in (LrTable.NT 20,(result,eexp1left,dexp'1right),rest671) end
| (44,(_,(MlyValue.match match,_,match1right))::_::(_,(MlyValue.eexp 
eexp,eexp1left,_))::rest671) => let val result=MlyValue.exp((
fn st=> makeHANDLEexp(E eexp st, E match st),
				 V eexp \/ V match))
 in (LrTable.NT 20,(result,eexp1left,match1right),rest671) end
| (45,(_,(MlyValue.eexp eexp,eexp1left,eexp1right))::rest671) => let 
val result=MlyValue.exp((eexp))
 in (LrTable.NT 20,(result,eexp1left,eexp1right),rest671) end
| (46,(_,(MlyValue.eexp eexp2,eexp2left,eexp2right))::_::(_,(
MlyValue.eexp eexp1,eexp1left,eexpright as eexp1right))::rest671) => 
let val result=MlyValue.eexp((
fn st=> ORELSEexp(markexp(E eexp1 st, eexp1left,eexp1right),
					 markexp(E eexp2 st,eexp2left,eexpright)),
			 V eexp1 \/ V eexp2
))
 in (LrTable.NT 27,(result,eexp1left,eexp2right),rest671) end
| (47,(_,(MlyValue.dexp dexp,dexp1left,dexp1right))::rest671) => let 
val result=MlyValue.eexp((dexp))
 in (LrTable.NT 27,(result,dexp1left,dexp1right),rest671) end
| (48,(_,(MlyValue.dexp dexp2,dexp2left,dexp2right))::_::(_,(
MlyValue.dexp dexp1,dexp1left,dexp1right))::rest671) => let val result
=MlyValue.dexp((
fn st=> ANDALSOexp(markexp(E dexp1 st,dexp1left,dexp1right),
				markexp(E dexp2 st,dexp2left,dexp2right)),
			 V dexp1 \/ V dexp2
))
 in (LrTable.NT 25,(result,dexp1left,dexp2right),rest671) end
| (49,(_,(MlyValue.ty ty,_,ty1right))::_::(_,(MlyValue.app_exp app_exp
,app_exp1left,app_expright))::rest671) => let val result=MlyValue.dexp
((
fn st=> CONSTRAINTexp(exp_finish(E app_exp st,
				       error(app_expright,app_expright)),
					E ty tyArg),
			 V app_exp \/ V ty
))
 in (LrTable.NT 25,(result,app_exp1left,ty1right),rest671) end
| (50,(_,(MlyValue.app_exp app_exp,app_exp1left,app_expright as 
app_exp1right))::rest671) => let val result=MlyValue.dexp((
fn st=> exp_finish(E app_exp st,
					error(app_expright,app_expright)),
			 V app_exp
))
 in (LrTable.NT 25,(result,app_exp1left,app_exp1right),rest671) end
| (51,(_,(MlyValue.cexp' cexp',cexp'1left,cexp'1right))::rest671) => 
let val result=MlyValue.dexp'((cexp'))
 in (LrTable.NT 26,(result,cexp'1left,cexp'1right),rest671) end
| (52,(_,(MlyValue.cexp' cexp',cexp'left,cexp'right as cexp'1right))::
_::(_,(MlyValue.dexp dexp,dexpleft as dexp1left,dexpright))::rest671)
 => let val result=MlyValue.dexp'((
fn st=> ANDALSOexp(markexp(E dexp st, 
						dexpleft,dexpright),
				    markexp(E cexp' st,cexp'left,cexp'right)),
			 V dexp \/ V cexp'
))
 in (LrTable.NT 26,(result,dexp1left,cexp'1right),rest671) end
| (53,(_,(MlyValue.bexp bexp,bexpleft,bexpright as bexp1right))::(_,(
MlyValue.app_exp app_exp,app_exp1left,_))::rest671) => let val result=
MlyValue.cexp'((
fn st =>  exp_finish(exp_parse'(E app_exp st, 
					markexp(E bexp st, bexpleft,bexpright),
					NONfix, error(bexpleft,bexpright)),
						error(bexpright,bexpright)),
			 V app_exp \/ V bexp
))
 in (LrTable.NT 24,(result,app_exp1left,bexp1right),rest671) end
| (54,(_,(MlyValue.bexp bexp,bexp1left,bexp1right))::rest671) => let 
val result=MlyValue.cexp'((bexp))
 in (LrTable.NT 24,(result,bexp1left,bexp1right),rest671) end
| (55,(_,(MlyValue.match match,_,matchright as match1right))::(_,(_,
FNleft as FN1left,_))::rest671) => let val result=MlyValue.bexp((
fn st=> markexp(FNexp(completeMatch(E match st)),
					 FNleft,matchright),
			 V match
))
 in (LrTable.NT 23,(result,FN1left,match1right),rest671) end
| (56,(_,(MlyValue.match match,_,matchright as match1right))::_::(_,(
MlyValue.exp exp,_,_))::(_,(_,CASEleft as CASE1left,_))::rest671) => 
let val result=MlyValue.bexp((
fn st=>markexp(CASEexp(E exp st, 
						completeMatch(E match st)),
						CASEleft,matchright),
			 V exp \/ V match
))
 in (LrTable.NT 23,(result,CASE1left,match1right),rest671) end
| (57,(_,(MlyValue.exp exp2,exp2left,exp2right))::_::(_,(MlyValue.exp 
exp1,_,_))::(_,(_,WHILE1left,_))::rest671) => let val result=
MlyValue.bexp((
fn st=> WHILEexp(E exp1 st,
					markexp(E exp2 st,exp2left,exp2right)),
			 V exp1 \/ V exp2
))
 in (LrTable.NT 23,(result,WHILE1left,exp2right),rest671) end
| (58,(_,(MlyValue.exp exp3,exp3left,exp3right))::_::(_,(MlyValue.exp 
exp2,exp2left,exp2right))::_::(_,(MlyValue.exp exp1,_,_))::(_,(_,
IF1left,_))::rest671) => let val result=MlyValue.bexp((
fn st=>IFexp(E exp1 st, 
					markexp(E exp2 st,exp2left,exp2right),
				        markexp(E exp3 st,exp3left,exp3right)),
			 V exp1 \/ V exp2 \/ V exp3
))
 in (LrTable.NT 23,(result,IF1left,exp3right),rest671) end
| (59,(_,(MlyValue.exp exp,_,expright as exp1right))::(_,(_,RAISEleft
 as RAISE1left,_))::rest671) => let val result=MlyValue.bexp((
fn st=>markexp(RAISEexp(E exp st),RAISEleft,expright),
			 V exp))
 in (LrTable.NT 23,(result,RAISE1left,exp1right),rest671) end
| (60,(_,(MlyValue.aexp aexp,aexpleft as aexp1left,aexpright as 
aexp1right))::rest671) => let val result=MlyValue.app_exp((
fn st => exp_start(markexp(E aexp st, aexpleft,aexpright),
					    NONfix, 
					    error (aexpleft,aexpright)),
			 V aexp
))
 in (LrTable.NT 21,(result,aexp1left,aexp1right),rest671) end
| (61,(_,(MlyValue.ident ident,identleft as ident1left,identright as 
ident1right))::rest671) => let val result=MlyValue.app_exp((
fn st => let val e = error(identleft,identright)
			       in exp_start(markexp(lookID(ident,e),identleft,identright),
					    lookFIX ident, e)
			 end,
			 no_tyvars
))
 in (LrTable.NT 21,(result,ident1left,ident1right),rest671) end
| (62,(_,(MlyValue.aexp aexp,aexpleft,aexpright as aexp1right))::(_,(
MlyValue.app_exp app_exp,app_exp1left,_))::rest671) => let val result=
MlyValue.app_exp((
fn st => exp_parse(E app_exp st, 
					markexp(E aexp st, aexpleft,aexpright),
					NONfix,
					error (aexpleft,aexpright)),
			 V app_exp \/ V aexp
))
 in (LrTable.NT 21,(result,app_exp1left,aexp1right),rest671) end
| (63,(_,(MlyValue.ident ident,identleft,identright as ident1right))::
(_,(MlyValue.app_exp app_exp,app_exp1left,_))::rest671) => let val 
result=MlyValue.app_exp((
fn st => let val e = error(identleft,identright)
			           in exp_parse(E app_exp st, 
						markexp(lookID(ident,e), identleft,identright),
						lookFIX ident, e)
				  end,
			 V app_exp
))
 in (LrTable.NT 21,(result,app_exp1left,ident1right),rest671) end
| (64,(_,(MlyValue.ident ident,identleft,identright as ident1right))::
(_,(_,OP1left,_))::rest671) => let val result=MlyValue.aexp((
fn st=> lookID(ident,error(identleft,identright)),
				 no_tyvars))
 in (LrTable.NT 22,(result,OP1left,ident1right),rest671) end
| (65,(_,(MlyValue.qid qid,_,qidright as qid1right))::_::(_,(
MlyValue.ID ID,IDleft as ID1left,_))::rest671) => let val result=
MlyValue.aexp((
fn st=> varcon(lookPathVARCON(ID::qid,
						    error(IDleft,qidright)COMPLAIN)),
				 no_tyvars
))
 in (LrTable.NT 22,(result,ID1left,qid1right),rest671) end
| (66,(_,(MlyValue.int int,int1left,int1right))::rest671) => let val 
result=MlyValue.aexp((fn st => INTexp int, no_tyvars))
 in (LrTable.NT 22,(result,int1left,int1right),rest671) end
| (67,(_,(MlyValue.REAL REAL,REAL1left,REAL1right))::rest671) => let 
val result=MlyValue.aexp((fn st => REALexp REAL, no_tyvars))
 in (LrTable.NT 22,(result,REAL1left,REAL1right),rest671) end
| (68,(_,(MlyValue.STRING STRING,STRING1left,STRING1right))::rest671)
 => let val result=MlyValue.aexp((fn st => STRINGexp STRING, no_tyvars
))
 in (LrTable.NT 22,(result,STRING1left,STRING1right),rest671) end
| (69,(_,(MlyValue.selector selector,_,selector1right))::(_,(_,
HASH1left,_))::rest671) => let val result=MlyValue.aexp((
fn st => SELECTORexp selector, no_tyvars))
 in (LrTable.NT 22,(result,HASH1left,selector1right),rest671) end
| (70,(_,(_,_,RBRACEright as RBRACE1right))::(_,(MlyValue.elabels 
elabels,_,_))::(_,(_,LBRACEleft as LBRACE1left,_))::rest671) => let 
val result=MlyValue.aexp((
fn st=> makeRECORDexp(E elabels st,
				        error(LBRACEleft,RBRACEright)),
				 V elabels
))
 in (LrTable.NT 22,(result,LBRACE1left,RBRACE1right),rest671) end
| (71,(_,(_,_,RBRACE1right))::(_,(_,LBRACE1left,_))::rest671) => let 
val result=MlyValue.aexp((fn st=> RECORDexp nil, no_tyvars))
 in (LrTable.NT 22,(result,LBRACE1left,RBRACE1right),rest671) end
| (72,(_,(_,_,RPAREN1right))::(_,(_,LPAREN1left,_))::rest671) => let 
val result=MlyValue.aexp((fn st=> unitExp, no_tyvars))
 in (LrTable.NT 22,(result,LPAREN1left,RPAREN1right),rest671) end
| (73,(_,(_,_,RPAREN1right))::(_,(MlyValue.exp_ps exp_ps,_,_))::(_,(_,
LPAREN1left,_))::rest671) => let val result=MlyValue.aexp((
fn st=> SEQexp(E exp_ps st), V exp_ps))
 in (LrTable.NT 22,(result,LPAREN1left,RPAREN1right),rest671) end
| (74,(_,(_,_,RPAREN1right))::(_,(MlyValue.exp_2c exp_2c,_,_))::(_,(_,
LPAREN1left,_))::rest671) => let val result=MlyValue.aexp((
fn st=> TUPLEexp(E exp_2c st), V exp_2c))
 in (LrTable.NT 22,(result,LPAREN1left,RPAREN1right),rest671) end
| (75,(_,(_,_,RBRACKET1right))::(_,(MlyValue.exp_list exp_list,_,_))::
(_,(_,LBRACKET1left,_))::rest671) => let val result=MlyValue.aexp((
fn st=> LISTexp(E exp_list st), V exp_list))
 in (LrTable.NT 22,(result,LBRACKET1left,RBRACKET1right),rest671) end
| (76,(_,(_,_,RBRACKET1right))::(_,(_,LBRACKET1left,_))::rest671) => 
let val result=MlyValue.aexp((fn st=> nilExp, no_tyvars))
 in (LrTable.NT 22,(result,LBRACKET1left,RBRACKET1right),rest671) end
| (77,(_,(_,_,ENDright as END1right))::(_,(MlyValue.exp_ps exp_ps,_,_)
)::_::(_,(MlyValue.ldecs ldecs,_,_))::(_,(_,LETleft as LET1left,_))::
rest671) => let val result=MlyValue.aexp((
fn (tv,st) => protect(protectScope,fn()=>
					 markexp(LETexp(E ldecs([],tv,st),
						SEQexp(E exp_ps(tv,st))),
					    LETleft,ENDright)),
				 V exp_ps \/ V ldecs
))
 in (LrTable.NT 22,(result,LET1left,END1right),rest671) end
| (78,(_,(MlyValue.exp_2c exp_2c,_,exp_2c1right))::_::(_,(MlyValue.exp
 exp,exp1left,_))::rest671) => let val result=MlyValue.exp_2c((
fn st=> E exp st :: E exp_2c st,
				 V exp \/ V exp_2c))
 in (LrTable.NT 29,(result,exp1left,exp_2c1right),rest671) end
| (79,(_,(MlyValue.exp exp2,_,exp2right))::_::(_,(MlyValue.exp exp1,
exp1left,_))::rest671) => let val result=MlyValue.exp_2c((
fn st=> [E exp1 st, E exp2 st],
				 V exp1 \/ V exp2))
 in (LrTable.NT 29,(result,exp1left,exp2right),rest671) end
| (80,(_,(MlyValue.exp exp,exp1left,exp1right))::rest671) => let val 
result=MlyValue.exp_list((fn st=> [E exp st], V exp))
 in (LrTable.NT 28,(result,exp1left,exp1right),rest671) end
| (81,(_,(MlyValue.exp_list exp_list,_,exp_list1right))::_::(_,(
MlyValue.exp exp,exp1left,_))::rest671) => let val result=
MlyValue.exp_list((
fn st=> E exp st :: E exp_list st,
				 V exp \/ V exp_list))
 in (LrTable.NT 28,(result,exp1left,exp_list1right),rest671) end
| (82,(_,(MlyValue.pat' pat',pat'1left,pat'1right))::rest671) => let 
val result=MlyValue.pat((pat'))
 in (LrTable.NT 30,(result,pat'1left,pat'1right),rest671) end
| (83,(_,(MlyValue.apats apats,_,apats1right))::(_,(MlyValue.apat apat
,apat1left,_))::rest671) => let val result=MlyValue.pat((
fn()=> make_app_pat(E apat()::E apats()),
				 V apat \/ V apats))
 in (LrTable.NT 30,(result,apat1left,apats1right),rest671) end
| (84,(_,(MlyValue.pat pat2,_,pat2right))::_::(_,(MlyValue.pat pat1,
pat1left,pat1right))::rest671) => let val result=MlyValue.pat'((
fn()=> layered(E pat1(), E pat2 (),
						error(pat1left,pat1right)),
				 V pat1 \/ V pat2
))
 in (LrTable.NT 31,(result,pat1left,pat2right),rest671) end
| (85,(_,(MlyValue.ty ty,_,ty1right))::_::(_,(MlyValue.apats apats,_,_
))::(_,(MlyValue.apat apat,apat1left,_))::rest671) => let val result=
MlyValue.pat'((
fn()=> CONSTRAINTpat(
					 make_app_pat(E apat()::E apats()),
					  E ty tyArg),
				 V apat \/ V apats \/ V ty
))
 in (LrTable.NT 31,(result,apat1left,ty1right),rest671) end
| (86,(_,(MlyValue.apat' apat',apat'1left,apat'1right))::rest671) => 
let val result=MlyValue.apat((apat'))
 in (LrTable.NT 32,(result,apat'1left,apat'1right),rest671) end
| (87,(_,(_,_,RPARENright as RPAREN1right))::(_,(MlyValue.pat pat,_,_)
)::(_,(_,LPARENleft as LPAREN1left,_))::rest671) => let val result=
MlyValue.apat((
fn()=>(E pat(),NONfix,error(LPARENleft,RPARENright)),
				 V pat))
 in (LrTable.NT 32,(result,LPAREN1left,RPAREN1right),rest671) end
| (88,(_,(MlyValue.apat'' apat'',apat''left as apat''1left,apat''right
 as apat''1right))::rest671) => let val result=MlyValue.apat'((
fn()=>(E apat''(),NONfix,error(apat''left,apat''right)),
				 V apat''
))
 in (LrTable.NT 33,(result,apat''1left,apat''1right),rest671) end
| (89,(_,(MlyValue.id id,idleft as id1left,idright as id1right))::
rest671) => let val result=MlyValue.apat'((
fn()=>let val e = error(idleft,idright)
				  in (pat_id id, lookFIX id, e)
				 end,
				 no_tyvars
))
 in (LrTable.NT 33,(result,id1left,id1right),rest671) end
| (90,(_,(_,_,RPARENright as RPAREN1right))::(_,(_,LPARENleft as 
LPAREN1left,_))::rest671) => let val result=MlyValue.apat'((
fn()=>(unitPat,NONfix,
					error(LPARENleft,RPARENright)),
				 no_tyvars
))
 in (LrTable.NT 33,(result,LPAREN1left,RPAREN1right),rest671) end
| (91,(_,(_,_,RPARENright as RPAREN1right))::(_,(MlyValue.pat_list 
pat_list,_,_))::_::(_,(MlyValue.pat pat,_,_))::(_,(_,LPARENleft as 
LPAREN1left,_))::rest671) => let val result=MlyValue.apat'((
fn()=>(TUPLEpat(E pat()::E pat_list()),
					 NONfix,error(LPARENleft,RPARENright)),
				 V pat \/ V pat_list
))
 in (LrTable.NT 33,(result,LPAREN1left,RPAREN1right),rest671) end
| (92,(_,(MlyValue.ident ident,_,ident1right))::(_,(_,OP1left,_))::
rest671) => let val result=MlyValue.apat''((
fn()=>pat_id ident, no_tyvars))
 in (LrTable.NT 34,(result,OP1left,ident1right),rest671) end
| (93,(_,(MlyValue.qid qid,_,qidright as qid1right))::_::(_,(
MlyValue.ID ID,IDleft as ID1left,_))::rest671) => let val result=
MlyValue.apat''((
fn()=>qid_pat(ID::qid,error(IDleft,qidright)),
				 no_tyvars))
 in (LrTable.NT 34,(result,ID1left,qid1right),rest671) end
| (94,(_,(MlyValue.int int,int1left,int1right))::rest671) => let val 
result=MlyValue.apat''((fn()=>INTpat int, no_tyvars))
 in (LrTable.NT 34,(result,int1left,int1right),rest671) end
| (95,(_,(MlyValue.REAL REAL,REAL1left,REAL1right))::rest671) => let 
val result=MlyValue.apat''((fn()=>REALpat REAL, no_tyvars))
 in (LrTable.NT 34,(result,REAL1left,REAL1right),rest671) end
| (96,(_,(MlyValue.STRING STRING,STRING1left,STRING1right))::rest671)
 => let val result=MlyValue.apat''((fn()=>STRINGpat STRING, no_tyvars)
)
 in (LrTable.NT 34,(result,STRING1left,STRING1right),rest671) end
| (97,(_,(_,WILD1left,WILD1right))::rest671) => let val result=
MlyValue.apat''((fn()=>WILDpat, no_tyvars))
 in (LrTable.NT 34,(result,WILD1left,WILD1right),rest671) end
| (98,(_,(_,_,RBRACKET1right))::(_,(_,LBRACKET1left,_))::rest671) => 
let val result=MlyValue.apat''((fn()=>LISTpat nil, no_tyvars))
 in (LrTable.NT 34,(result,LBRACKET1left,RBRACKET1right),rest671) end
| (99,(_,(_,_,RBRACKET1right))::(_,(MlyValue.pat_list pat_list,_,_))::
(_,(_,LBRACKET1left,_))::rest671) => let val result=MlyValue.apat''((
fn()=>LISTpat(E pat_list()), V pat_list))
 in (LrTable.NT 34,(result,LBRACKET1left,RBRACKET1right),rest671) end
| (100,(_,(_,_,RBRACEright as RBRACE1right))::(_,(_,LBRACEleft as 
LBRACE1left,_))::rest671) => let val result=MlyValue.apat''((
fn()=>makeRECORDpat((nil,false),
						error(LBRACEleft,RBRACEright)),
				 no_tyvars
))
 in (LrTable.NT 34,(result,LBRACE1left,RBRACE1right),rest671) end
| (101,(_,(_,_,RBRACEright as RBRACE1right))::(_,(MlyValue.plabels 
plabels,_,_))::(_,(_,LBRACEleft as LBRACE1left,_))::rest671) => let 
val result=MlyValue.apat''((
fn()=>makeRECORDpat(E plabels(),
						error(LBRACEleft,RBRACEright)),
				 V plabels
))
 in (LrTable.NT 34,(result,LBRACE1left,RBRACE1right),rest671) end
| (102,(_,(MlyValue.pat pat,_,pat1right))::_::(_,(MlyValue.selector 
selector,selector1left,_))::rest671) => let val result=MlyValue.plabel
((fn()=> (selector,E pat()), V pat))
 in (LrTable.NT 35,(result,selector1left,pat1right),rest671) end
| (103,(_,(MlyValue.ID ID,ID1left,ID1right))::rest671) => let val 
result=MlyValue.plabel((fn()=> (ID, pat_id ID), no_tyvars))
 in (LrTable.NT 35,(result,ID1left,ID1right),rest671) end
| (104,(_,(MlyValue.pat pat,_,pat1right))::_::(_,(MlyValue.ID ID,
ID1left,_))::rest671) => let val result=MlyValue.plabel((
fn()=> (ID, LAYEREDpat(pat_id ID, E pat())),
				 V pat))
 in (LrTable.NT 35,(result,ID1left,pat1right),rest671) end
| (105,(_,(MlyValue.ty ty,_,ty1right))::_::(_,(MlyValue.ID ID,ID1left,
_))::rest671) => let val result=MlyValue.plabel((
fn()=> (ID, CONSTRAINTpat(pat_id ID, 
							   E ty tyArg)),
				 V ty
))
 in (LrTable.NT 35,(result,ID1left,ty1right),rest671) end
| (106,(_,(MlyValue.pat pat,_,pat1right))::_::(_,(MlyValue.ty ty,_,_))
::_::(_,(MlyValue.ID ID,ID1left,_))::rest671) => let val result=
MlyValue.plabel((
fn()=> (ID, LAYEREDpat(CONSTRAINTpat(
					   pat_id ID,
					   E ty tyArg), E pat())),
				 V ty \/ V pat
))
 in (LrTable.NT 35,(result,ID1left,pat1right),rest671) end
| (107,(_,(MlyValue.plabels plabels,_,plabels1right))::_::(_,(
MlyValue.plabel plabel,plabel1left,_))::rest671) => let val result=
MlyValue.plabels((
fn()=>let val (a,(b,fx))=(E plabel(),E plabels())
				in (a::b, fx)
			       end,
			 V plabel \/ V plabels
))
 in (LrTable.NT 36,(result,plabel1left,plabels1right),rest671) end
| (108,(_,(MlyValue.plabel plabel,plabel1left,plabel1right))::rest671)
 => let val result=MlyValue.plabels((
fn()=> ([E plabel()],false), V plabel))
 in (LrTable.NT 36,(result,plabel1left,plabel1right),rest671) end
| (109,(_,(_,DOTDOTDOT1left,DOTDOTDOT1right))::rest671) => let val 
result=MlyValue.plabels((fn()=> (nil, true), no_tyvars))
 in (LrTable.NT 36,(result,DOTDOTDOT1left,DOTDOTDOT1right),rest671)
 end
| (110,(_,(MlyValue.pat pat,pat1left,pat1right))::rest671) => let val 
result=MlyValue.pat_list((fn()=> [E pat()], V pat))
 in (LrTable.NT 38,(result,pat1left,pat1right),rest671) end
| (111,(_,(MlyValue.pat_list pat_list,_,pat_list1right))::_::(_,(
MlyValue.pat pat,pat1left,_))::rest671) => let val result=
MlyValue.pat_list((
fn()=> E pat() :: E pat_list(),
				 V pat \/ V pat_list))
 in (LrTable.NT 38,(result,pat1left,pat_list1right),rest671) end
| (112,(_,(MlyValue.vb vb2,_,vb2right))::_::(_,(MlyValue.vb vb1,
vb1left,_))::rest671) => let val result=MlyValue.vb((
fn st=> vb1 st @ vb2 st))
 in (LrTable.NT 39,(result,vb1left,vb2right),rest671) end
| (113,(_,(MlyValue.exp exp,_,exp1right))::_::(_,(MlyValue.pat pat,
pat1left,_))::rest671) => let val result=MlyValue.vb((
valbind(pat, exp)))
 in (LrTable.NT 39,(result,pat1left,exp1right),rest671) end
| (114,rest671) => let val result=MlyValue.constraint((
fn()=>NONE, no_tyvars))
 in (LrTable.NT 40,(result,defaultPos,defaultPos),rest671) end
| (115,(_,(MlyValue.ty ty,_,ty1right))::(_,(_,COLON1left,_))::rest671)
 => let val result=MlyValue.constraint((fn()=>SOME(E ty tyArg), V ty))
 in (LrTable.NT 40,(result,COLON1left,ty1right),rest671) end
| (116,(_,(MlyValue.match match,_,match1right))::_::_::(_,(
MlyValue.constraint constraint,_,_))::(_,(MlyValue.opid opid,opid1left
,_))::rest671) => let val result=MlyValue.rvb((
fn()=>[{name=opid(),
					 ty=constraint,match=match}]))
 in (LrTable.NT 41,(result,opid1left,match1right),rest671) end
| (117,(_,(MlyValue.rvb rvb2,_,rvb2right))::_::(_,(MlyValue.rvb rvb1,
rvb1left,_))::rest671) => let val result=MlyValue.rvb((
fn()=> rvb1() @ rvb2()))
 in (LrTable.NT 41,(result,rvb1left,rvb2right),rest671) end
| (118,(_,(MlyValue.clause clause,clause1left,clause1right))::rest671)
 => let val result=MlyValue.fb'((fn()=>[E clause()], V clause))
 in (LrTable.NT 42,(result,clause1left,clause1right),rest671) end
| (119,(_,(MlyValue.fb' fb',_,fb'1right))::_::(_,(MlyValue.clause 
clause,clause1left,_))::rest671) => let val result=MlyValue.fb'((
fn()=>E clause()::E fb'(), V clause \/ V fb'))
 in (LrTable.NT 42,(result,clause1left,fb'1right),rest671) end
| (120,(_,(MlyValue.fb' fb',fb'left as fb'1left,fb'right as fb'1right)
)::rest671) => let val result=MlyValue.fb((
fn() => [checkFB(E fb'(),error(fb'left,fb'right))],
				 V fb'))
 in (LrTable.NT 43,(result,fb'1left,fb'1right),rest671) end
| (121,(_,(MlyValue.fb fb,_,fb1right))::_::(_,(MlyValue.fb' fb',
fb'left as fb'1left,fb'right))::rest671) => let val result=MlyValue.fb
((
fn() => checkFB(E fb'(),error(fb'left,fb'right)) :: E fb(), V fb' \/ V fb
))
 in (LrTable.NT 43,(result,fb'1left,fb1right),rest671) end
| (122,(_,(MlyValue.apats apats2,_,apats2right))::_::(_,(
MlyValue.apats apats1,_,_))::(_,(MlyValue.apat apat,_,_))::(_,(_,
LPAREN1left,_))::rest671) => let val result=MlyValue.clause'((
fn()=>makecl(E apat()::E apats1(),E apats2()),
				 V apat \/ V apats1 \/ V apats2
))
 in (LrTable.NT 45,(result,LPAREN1left,apats2right),rest671) end
| (123,(_,(MlyValue.apats apats,_,apats1right))::(_,(_,_,RPARENright))
::(_,(MlyValue.pat' pat',_,_))::(_,(_,LPARENleft as LPAREN1left,_))::
rest671) => let val result=MlyValue.clause'((
fn()=>makecl([],(E pat'(),NONfix,
						 error(LPARENleft,RPARENright))
						 ::E apats()),
				 V pat' \/ V apats
))
 in (LrTable.NT 45,(result,LPAREN1left,apats1right),rest671) end
| (124,(_,(MlyValue.apats apats,_,apats1right))::(_,(MlyValue.apat' 
apat',apat'1left,_))::rest671) => let val result=MlyValue.clause'((
fn()=>makecl([],E apat'()::E apats()),
				 V apat' \/ V apats))
 in (LrTable.NT 45,(result,apat'1left,apats1right),rest671) end
| (125,rest671) => let val result=MlyValue.apats((fn()=>nil, no_tyvars
))
 in (LrTable.NT 44,(result,defaultPos,defaultPos),rest671) end
| (126,(_,(MlyValue.apats apats,_,apats1right))::(_,(MlyValue.apat 
apat,apat1left,_))::rest671) => let val result=MlyValue.apats((
fn()=> E apat()::E apats(), V apat \/ V apats))
 in (LrTable.NT 44,(result,apat1left,apats1right),rest671) end
| (127,(_,(MlyValue.exp exp,expleft,expright as exp1right))::_::(_,(
MlyValue.constraint constraint,_,_))::(_,(MlyValue.clause' clause',
clause'left as clause'1left,clause'right))::rest671) => let val result
=MlyValue.clause((
fn()=> let val (id,pats) = E clause'()
				         in {name=id,pats=pats,
					     resultty=E constraint(),
				   	     exp=fn $ => markexp(E exp $,expleft,expright),
					     err=error(clause'left,clause'right)}
					end,
				 V clause' \/ V constraint \/ V exp
))
 in (LrTable.NT 46,(result,clause'1left,exp1right),rest671) end
| (128,(_,(MlyValue.ty ty,tyleft,tyright as ty1right))::_::(_,(
MlyValue.ident ident,_,_))::(_,(MlyValue.tyvars tyvars,tyvars1left,_))
::rest671) => let val result=MlyValue.tb((
makeTB(tyvars,ident,ty,
					error(tyleft,tyright))))
 in (LrTable.NT 47,(result,tyvars1left,ty1right),rest671) end
| (129,(_,(MlyValue.tb tb2,_,tb2right))::_::(_,(MlyValue.tb tb1,
tb1left,_))::rest671) => let val result=MlyValue.tb((
fn nw => fn $ => tb1 nw $ @ tb2 nw $))
 in (LrTable.NT 47,(result,tb1left,tb2right),rest671) end
| (130,(_,(MlyValue.TYVAR TYVAR,TYVAR1left,TYVAR1right))::rest671) => 
let val result=MlyValue.tyvars(([mkTyvar(mkUBOUND TYVAR)]))
 in (LrTable.NT 48,(result,TYVAR1left,TYVAR1right),rest671) end
| (131,(_,(_,_,RPAREN1right))::(_,(MlyValue.tyvar_pc tyvar_pc,
tyvar_pcleft,tyvar_pcright))::(_,(_,LPAREN1left,_))::rest671) => let 
val result=MlyValue.tyvars((
checkUniq(error(tyvar_pcleft,tyvar_pcright),
				  	     "duplicate type variable")
					     (map(fn ref(UBOUND{name,...})=>name)
					      tyvar_pc);
				   tyvar_pc
))
 in (LrTable.NT 48,(result,LPAREN1left,RPAREN1right),rest671) end
| (132,rest671) => let val result=MlyValue.tyvars((nil))
 in (LrTable.NT 48,(result,defaultPos,defaultPos),rest671) end
| (133,(_,(MlyValue.TYVAR TYVAR,TYVAR1left,TYVAR1right))::rest671) => 
let val result=MlyValue.tyvar_pc(([mkTyvar(mkUBOUND TYVAR)]))
 in (LrTable.NT 49,(result,TYVAR1left,TYVAR1right),rest671) end
| (134,(_,(MlyValue.tyvar_pc tyvar_pc,_,tyvar_pc1right))::_::(_,(
MlyValue.TYVAR TYVAR,TYVAR1left,_))::rest671) => let val result=
MlyValue.tyvar_pc((mkTyvar(mkUBOUND TYVAR) :: tyvar_pc))
 in (LrTable.NT 49,(result,TYVAR1left,tyvar_pc1right),rest671) end
| (135,(_,(MlyValue.db db,_,db1right))::_::(_,(MlyValue.db' db',
db'1left,_))::rest671) => let val result=MlyValue.db((db' :: db))
 in (LrTable.NT 50,(result,db'1left,db1right),rest671) end
| (136,(_,(MlyValue.db' db',db'1left,db'1right))::rest671) => let val 
result=MlyValue.db(([db']))
 in (LrTable.NT 50,(result,db'1left,db'1right),rest671) end
| (137,(_,(MlyValue.constrs constrs,constrsleft,constrsright as 
constrs1right))::_::(_,(MlyValue.ident ident,_,_))::(_,(
MlyValue.tyvars tyvars,tyvars1left,_))::rest671) => let val result=
MlyValue.db'((
ident,length tyvars,
					 makeDB'(tyvars,ident,constrs,
						error(constrsleft,constrsright))
))
 in (LrTable.NT 51,(result,tyvars1left,constrs1right),rest671) end
| (138,(_,(MlyValue.constr constr,constr1left,constr1right))::rest671)
 => let val result=MlyValue.constrs((fn $ => [E constr $], V constr))
 in (LrTable.NT 52,(result,constr1left,constr1right),rest671) end
| (139,(_,(MlyValue.constrs constrs,_,constrs1right))::_::(_,(
MlyValue.constr constr,constr1left,_))::rest671) => let val result=
MlyValue.constrs((
fn $ => E constr $ :: E constrs $,
				 V constr \/ V constrs))
 in (LrTable.NT 52,(result,constr1left,constrs1right),rest671) end
| (140,(_,(MlyValue.ident ident,_,ident1right))::(_,(MlyValue.op_op 
op_op,op_op1left,_))::rest671) => let val result=MlyValue.constr((
fire op_op (fn(t,_)=> (ident,true,t)),
				 no_tyvars))
 in (LrTable.NT 53,(result,op_op1left,ident1right),rest671) end
| (141,(_,(MlyValue.ty ty,_,ty1right))::_::(_,(MlyValue.ident ident,_,
_))::(_,(MlyValue.op_op op_op,op_op1left,_))::rest671) => let val 
result=MlyValue.constr((
fire op_op (fn(t,$)=> (ident,false,
					 CONty(arrowTycon,[E ty $, t]))),
				 V ty
))
 in (LrTable.NT 53,(result,op_op1left,ty1right),rest671) end
| (142,(_,(MlyValue.ident ident,_,ident1right))::(_,(MlyValue.op_op 
op_op,op_op1left,_))::rest671) => let val result=MlyValue.eb((
fire op_op (makeEB ident), no_tyvars))
 in (LrTable.NT 54,(result,op_op1left,ident1right),rest671) end
| (143,(_,(MlyValue.ty ty,tyleft,tyright as ty1right))::_::(_,(
MlyValue.ident ident,_,_))::(_,(MlyValue.op_op op_op,op_op1left,_))::
rest671) => let val result=MlyValue.eb((
fire op_op (makeEBof(ident,E ty,
					   error(tyleft,tyright))),
					 V ty
))
 in (LrTable.NT 54,(result,op_op1left,ty1right),rest671) end
| (144,(_,(MlyValue.qid qid,qidleft,qidright as qid1right))::_::(_,(
MlyValue.ident ident,_,_))::(_,(MlyValue.op_op op_op,op_op1left,_))::
rest671) => let val result=MlyValue.eb((
fire op_op (makeEBeq(ident,qid,
					   error(qidleft,qidright))),
					 no_tyvars
))
 in (LrTable.NT 54,(result,op_op1left,qid1right),rest671) end
| (145,(_,(MlyValue.eb eb2,_,eb2right))::_::(_,(MlyValue.eb eb1,
eb1left,_))::rest671) => let val result=MlyValue.eb((
fn $ => E eb1 $ @ E eb2 $,
					 V eb1 \/ V eb2))
 in (LrTable.NT 54,(result,eb1left,eb2right),rest671) end
| (146,(_,(MlyValue.qid qid,qid1left,qid1right))::rest671) => let val 
result=MlyValue.qid_p0(([qid]))
 in (LrTable.NT 6,(result,qid1left,qid1right),rest671) end
| (147,(_,(MlyValue.qid_p0 qid_p0,_,qid_p01right))::(_,(MlyValue.qid 
qid,qid1left,_))::rest671) => let val result=MlyValue.qid_p0((
qid::qid_p0))
 in (LrTable.NT 6,(result,qid1left,qid_p01right),rest671) end
| (148,(_,(MlyValue.qid qid,qidleft as qid1left,qidright as qid1right)
)::rest671) => let val result=MlyValue.qid_p((
fn()=> [getSTRpath(qid,error(qidleft,qidright))]))
 in (LrTable.NT 55,(result,qid1left,qid1right),rest671) end
| (149,(_,(MlyValue.qid_p qid_p,_,qid_p1right))::(_,(MlyValue.qid qid,
qidleft as qid1left,qidright))::rest671) => let val result=
MlyValue.qid_p((
fn()=> getSTRpath(qid,error(qidleft,qidright)) :: qid_p()))
 in (LrTable.NT 55,(result,qid1left,qid_p1right),rest671) end
| (150,(_,(_,INFIX1left,INFIX1right))::rest671) => let val result=
MlyValue.fixity((infixleft 0))
 in (LrTable.NT 56,(result,INFIX1left,INFIX1right),rest671) end
| (151,(_,(MlyValue.int int,_,int1right))::(_,(_,INFIX1left,_))::
rest671) => let val result=MlyValue.fixity((infixleft int))
 in (LrTable.NT 56,(result,INFIX1left,int1right),rest671) end
| (152,(_,(_,INFIXR1left,INFIXR1right))::rest671) => let val result=
MlyValue.fixity((infixright 0))
 in (LrTable.NT 56,(result,INFIXR1left,INFIXR1right),rest671) end
| (153,(_,(MlyValue.int int,_,int1right))::(_,(_,INFIXR1left,_))::
rest671) => let val result=MlyValue.fixity((infixright int))
 in (LrTable.NT 56,(result,INFIXR1left,int1right),rest671) end
| (154,(_,(_,NONFIX1left,NONFIX1right))::rest671) => let val result=
MlyValue.fixity((NONfix))
 in (LrTable.NT 56,(result,NONFIX1left,NONFIX1right),rest671) end
| (155,(_,(MlyValue.vb vb,vbleft,vbright as vb1right))::(_,(_,VAL1left
,_))::rest671) => let val result=MlyValue.ldec((
(fn $ => markdec(makeVALdec(vb,error(vbleft,vbright)) $,
					 vbleft,vbright)),
				 no_tyvars
))
 in (LrTable.NT 57,(result,VAL1left,vb1right),rest671) end
| (156,(_,(MlyValue.rvb rvb,rvbleft,rvbright as rvb1right))::_::(_,(_,
VAL1left,_))::rest671) => let val result=MlyValue.ldec((
(fn $ =>markdec(makeVALRECdec(rvb,
				       		       error(rvbleft,rvbright)) $,
						rvbleft,rvbright)),
				 no_tyvars
))
 in (LrTable.NT 57,(result,VAL1left,rvb1right),rest671) end
| (157,(_,(MlyValue.fb fb,fbleft,fbright as fb1right))::(_,(_,FUN1left
,_))::rest671) => let val result=MlyValue.ldec((
(fn $ => markdec(makeFUNdec fb $,fbleft,fbright)),
				 no_tyvars))
 in (LrTable.NT 57,(result,FUN1left,fb1right),rest671) end
| (158,(_,(MlyValue.tb tb,tbleft,tbright as tb1right))::(_,(_,
TYPE1left,_))::rest671) => let val result=MlyValue.ldec((
(fn ps => makeTYPEdec(tb true ps, 
					      error(tbleft,tbright))),
				 no_tyvars
))
 in (LrTable.NT 57,(result,TYPE1left,tb1right),rest671) end
| (159,(_,(MlyValue.db db,_,db1right))::(_,(_,DATATYPE1left,_))::
rest671) => let val result=MlyValue.ldec((
(makeDB(db, fn _ => fn _ => nil)),
				 no_tyvars))
 in (LrTable.NT 57,(result,DATATYPE1left,db1right),rest671) end
| (160,(_,(MlyValue.tb tb,_,tb1right))::_::(_,(MlyValue.db db,_,_))::(
_,(_,DATATYPE1left,_))::rest671) => let val result=MlyValue.ldec((
(makeDB(db, tb)),
				 no_tyvars))
 in (LrTable.NT 57,(result,DATATYPE1left,tb1right),rest671) end
| (161,(_,(_,_,END1right))::(_,(MlyValue.ldecs ldecs,_,_))::_::(_,(
MlyValue.db db,_,_))::(_,(_,ABSTYPE1left,_))::rest671) => let val 
result=MlyValue.ldec(((makeABSTYPEdec(db,E ldecs)), V ldecs))
 in (LrTable.NT 57,(result,ABSTYPE1left,END1right),rest671) end
| (162,(_,(MlyValue.eb eb,ebleft,ebright as eb1right))::(_,(_,
EXCEPTIONleft as EXCEPTION1left,_))::rest671) => let val result=
MlyValue.ldec((
(fn $ => markdec(makeEXCEPTIONdec(E eb $, 
					          error(ebleft,ebright)),
						 EXCEPTIONleft,ebright)),
				 V eb
))
 in (LrTable.NT 57,(result,EXCEPTION1left,eb1right),rest671) end
| (163,(_,(MlyValue.qid_p qid_p,_,qid_pright as qid_p1right))::(_,(_,
OPENleft as OPEN1left,_))::rest671) => let val result=MlyValue.ldec((
(fn $ => markdec(makeOPENdec qid_p $,
						OPENleft,qid_pright)),
				 no_tyvars
))
 in (LrTable.NT 57,(result,OPEN1left,qid_p1right),rest671) end
| (164,(_,(MlyValue.ops ops,_,ops1right))::(_,(MlyValue.fixity fixity,
fixity1left,_))::rest671) => let val result=MlyValue.ldec((
makeFIXdec(fixity,ops),
				 no_tyvars))
 in (LrTable.NT 57,(result,fixity1left,ops1right),rest671) end
| (165,(_,(MlyValue.exp_pa exp_pa,_,exp_pa1right))::_::(_,(MlyValue.ty
 ty,_,_))::_::(_,(MlyValue.ident ident,_,_))::(_,(_,OVERLOAD1left,_))
::rest671) => let val result=MlyValue.ldec((
makeOVERLOADdec(ident,ty,exp_pa),
				 no_tyvars))
 in (LrTable.NT 57,(result,OVERLOAD1left,exp_pa1right),rest671) end
| (166,(_,(MlyValue.exp exp,exp1left,exp1right))::rest671) => let val 
result=MlyValue.exp_pa((fn st => [E exp st]))
 in (LrTable.NT 58,(result,exp1left,exp1right),rest671) end
| (167,(_,(MlyValue.exp_pa exp_pa,_,exp_pa1right))::_::(_,(
MlyValue.exp exp,exp1left,_))::rest671) => let val result=
MlyValue.exp_pa((fn st => E exp st :: exp_pa st))
 in (LrTable.NT 58,(result,exp1left,exp_pa1right),rest671) end
| (168,rest671) => let val result=MlyValue.ldecs((
fn $ => SEQdec nil, no_tyvars))
 in (LrTable.NT 59,(result,defaultPos,defaultPos),rest671) end
| (169,(_,(MlyValue.ldecs ldecs,_,ldecs1right))::(_,(MlyValue.ldec 
ldec,ldec1left,_))::rest671) => let val result=MlyValue.ldecs((
makeSEQdec(E ldec, E ldecs), V ldec \/ V ldecs))
 in (LrTable.NT 59,(result,ldec1left,ldecs1right),rest671) end
| (170,(_,(MlyValue.ldecs ldecs,_,ldecs1right))::(_,(_,SEMICOLON1left,
_))::rest671) => let val result=MlyValue.ldecs((ldecs))
 in (LrTable.NT 59,(result,SEMICOLON1left,ldecs1right),rest671) end
| (171,(_,(MlyValue.ldecs ldecs3,_,ldecs3right))::(_,(_,_,ENDright))::
(_,(MlyValue.ldecs ldecs2,_,_))::_::(_,(MlyValue.ldecs ldecs1,_,_))::(
_,(_,LOCALleft as LOCAL1left,_))::rest671) => let val result=
MlyValue.ldecs((
makeSEQdec(fn $ => 
				   markdec(makeLOCALdec(E ldecs1, E ldecs2) $,
				   	   	   LOCALleft,ENDright),
				   E ldecs3),
				 V ldecs1 \/ V ldecs2 \/ V ldecs3
))
 in (LrTable.NT 59,(result,LOCAL1left,ldecs3right),rest671) end
| (172,(_,(MlyValue.ident ident,ident1left,ident1right))::rest671) => 
let val result=MlyValue.ops(([ident]))
 in (LrTable.NT 60,(result,ident1left,ident1right),rest671) end
| (173,(_,(MlyValue.ops ops,_,ops1right))::(_,(MlyValue.ident ident,
ident1left,_))::rest671) => let val result=MlyValue.ops((ident::ops))
 in (LrTable.NT 60,(result,ident1left,ops1right),rest671) end
| (174,rest671) => let val result=MlyValue.spec_s((fn $ => nil))
 in (LrTable.NT 61,(result,defaultPos,defaultPos),rest671) end
| (175,(_,(MlyValue.spec_s spec_s,_,spec_s1right))::(_,(MlyValue.spec 
spec,spec1left,_))::rest671) => let val result=MlyValue.spec_s((
fn $ => spec $ @ spec_s $))
 in (LrTable.NT 61,(result,spec1left,spec_s1right),rest671) end
| (176,(_,(MlyValue.spec_s spec_s,_,spec_s1right))::(_,(_,
SEMICOLON1left,_))::rest671) => let val result=MlyValue.spec_s((spec_s
))
 in (LrTable.NT 61,(result,SEMICOLON1left,spec_s1right),rest671) end
| (177,(_,(MlyValue.strspec strspec,_,strspec1right))::(_,(_,
STRUCTURE1left,_))::rest671) => let val result=MlyValue.spec((strspec)
)
 in (LrTable.NT 62,(result,STRUCTURE1left,strspec1right),rest671) end
| (178,(_,(MlyValue.db db,_,db1right))::(_,(_,DATATYPE1left,_))::
rest671) => let val result=MlyValue.spec((make_dtyspec db))
 in (LrTable.NT 62,(result,DATATYPE1left,db1right),rest671) end
| (179,(_,(MlyValue.tyspec tyspec,_,tyspec1right))::(_,(_,TYPE1left,_)
)::rest671) => let val result=MlyValue.spec((tyspec UNDEF))
 in (LrTable.NT 62,(result,TYPE1left,tyspec1right),rest671) end
| (180,(_,(MlyValue.tyspec tyspec,_,tyspec1right))::(_,(_,EQTYPE1left,
_))::rest671) => let val result=MlyValue.spec((tyspec YES))
 in (LrTable.NT 62,(result,EQTYPE1left,tyspec1right),rest671) end
| (181,(_,(MlyValue.valspec valspec,_,valspec1right))::(_,(_,VAL1left,
_))::rest671) => let val result=MlyValue.spec((valspec))
 in (LrTable.NT 62,(result,VAL1left,valspec1right),rest671) end
| (182,(_,(MlyValue.exnspec exnspec,_,exnspec1right))::(_,(_,
EXCEPTION1left,_))::rest671) => let val result=MlyValue.spec((exnspec)
)
 in (LrTable.NT 62,(result,EXCEPTION1left,exnspec1right),rest671) end
| (183,(_,(MlyValue.ops ops,_,ops1right))::(_,(MlyValue.fixity fixity,
fixity1left,_))::rest671) => let val result=MlyValue.spec((
make_fixityspec(fixity,ops)))
 in (LrTable.NT 62,(result,fixity1left,ops1right),rest671) end
| (184,(_,(MlyValue.sharespec sharespec,_,sharespec1right))::(_,(_,
SHARING1left,_))::rest671) => let val result=MlyValue.spec((sharespec)
)
 in (LrTable.NT 62,(result,SHARING1left,sharespec1right),rest671) end
| (185,(_,(MlyValue.qid_p0 qid_p0,_,qid_p0right as qid_p01right))::(_,
(_,OPENleft as OPEN1left,_))::rest671) => let val result=MlyValue.spec
((make_openspec(qid_p0,
					       error(OPENleft,qid_p0right))))
 in (LrTable.NT 62,(result,OPEN1left,qid_p01right),rest671) end
| (186,(_,(_,_,END1right))::(_,(MlyValue.spec_s spec_s2,_,_))::_::(_,(
MlyValue.spec_s spec_s1,spec_s1left,spec_s1right))::(_,(_,LOCAL1left,_
))::rest671) => let val result=MlyValue.spec((
fn $ => (spec_s1 $; 
					  error(spec_s1left,spec_s1right) WARN
				"LOCAL specs are only partially implemented";
						spec_s2 $)
))
 in (LrTable.NT 62,(result,LOCAL1left,END1right),rest671) end
| (187,(_,(MlyValue.ident ident,identleft,identright as ident1right))
::(_,(_,INCLUDE1left,_))::rest671) => let val result=MlyValue.spec((
make_includespec(ident,error(identleft,identright))))
 in (LrTable.NT 62,(result,INCLUDE1left,ident1right),rest671) end
| (188,(_,(MlyValue.strspec strspec2,_,strspec2right))::_::(_,(
MlyValue.strspec strspec1,strspec1left,_))::rest671) => let val result
=MlyValue.strspec((fn $ => strspec1 $ @ strspec2 $))
 in (LrTable.NT 63,(result,strspec1left,strspec2right),rest671) end
| (189,(_,(MlyValue.sign sign,_,sign1right))::_::(_,(MlyValue.ident 
ident,ident1left,_))::rest671) => let val result=MlyValue.strspec((
make_strspec(ident, sign(false,NULLstr))))
 in (LrTable.NT 63,(result,ident1left,sign1right),rest671) end
| (190,(_,(MlyValue.tyspec tyspec2,_,tyspec2right))::_::(_,(
MlyValue.tyspec tyspec1,tyspec1left,_))::rest671) => let val result=
MlyValue.tyspec((fn eq => fn $ => 
				    tyspec1 eq $ @ tyspec2 eq $
))
 in (LrTable.NT 64,(result,tyspec1left,tyspec2right),rest671) end
| (191,(_,(MlyValue.ident ident,_,identright as ident1right))::(_,(
MlyValue.tyvars tyvars,tyvarsleft as tyvars1left,_))::rest671) => let 
val result=MlyValue.tyspec((
fn eq => make_tyspec(eq,tyvars,ident,
					error(tyvarsleft,identright))
))
 in (LrTable.NT 64,(result,tyvars1left,ident1right),rest671) end
| (192,(_,(MlyValue.valspec valspec2,_,valspec2right))::_::(_,(
MlyValue.valspec valspec1,valspec1left,_))::rest671) => let val result
=MlyValue.valspec((fn $ => valspec1 $ @ valspec2 $))
 in (LrTable.NT 65,(result,valspec1left,valspec2right),rest671) end
| (193,(_,(MlyValue.ty ty,_,ty1right))::_::(_,(MlyValue.ident ident,_,
_))::(_,(MlyValue.op_op op_op,op_op1left,_))::rest671) => let val 
result=MlyValue.valspec((fire op_op (make_valspec(ident,ty))))
 in (LrTable.NT 65,(result,op_op1left,ty1right),rest671) end
| (194,(_,(MlyValue.exnspec exnspec2,_,exnspec2right))::_::(_,(
MlyValue.exnspec exnspec1,exnspec1left,_))::rest671) => let val result
=MlyValue.exnspec((fn $ => exnspec1 $ @ exnspec2 $))
 in (LrTable.NT 66,(result,exnspec1left,exnspec2right),rest671) end
| (195,(_,(MlyValue.ident ident,ident1left,ident1right))::rest671) => 
let val result=MlyValue.exnspec((make_exnspec ident))
 in (LrTable.NT 66,(result,ident1left,ident1right),rest671) end
| (196,(_,(MlyValue.ty ty,_,ty1right))::_::(_,(MlyValue.ident ident,
ident1left,_))::rest671) => let val result=MlyValue.exnspec((
make_exnspecOF (ident,ty)))
 in (LrTable.NT 66,(result,ident1left,ty1right),rest671) end
| (197,(_,(MlyValue.sharespec sharespec2,_,sharespec2right))::_::(_,(
MlyValue.sharespec sharespec1,sharespec1left,_))::rest671) => let val 
result=MlyValue.sharespec((fn $ => sharespec1 $ @ sharespec2 $))
 in (LrTable.NT 67,(result,sharespec1left,sharespec2right),rest671)
 end
| (198,(_,(MlyValue.patheqn patheqn,_,patheqn1right))::(_,(_,TYPE1left
,_))::rest671) => let val result=MlyValue.sharespec((
make_type_sharespec patheqn))
 in (LrTable.NT 67,(result,TYPE1left,patheqn1right),rest671) end
| (199,(_,(MlyValue.patheqn patheqn,patheqn1left,patheqn1right))::
rest671) => let val result=MlyValue.sharespec((
make_str_sharespec patheqn))
 in (LrTable.NT 67,(result,patheqn1left,patheqn1right),rest671) end
| (200,(_,(MlyValue.qid qid2,_,qid2right))::_::(_,(MlyValue.qid qid1,
qid1left,_))::rest671) => let val result=MlyValue.patheqn(([qid1,qid2]
))
 in (LrTable.NT 68,(result,qid1left,qid2right),rest671) end
| (201,(_,(MlyValue.patheqn patheqn,_,patheqn1right))::_::(_,(
MlyValue.qid qid,qid1left,_))::rest671) => let val result=
MlyValue.patheqn((qid :: patheqn))
 in (LrTable.NT 68,(result,qid1left,patheqn1right),rest671) end
| (202,(_,(MlyValue.ID ID,IDleft as ID1left,IDright as ID1right))::
rest671) => let val result=MlyValue.sign((
makeSIGid(ID,error(IDleft,IDright))))
 in (LrTable.NT 69,(result,ID1left,ID1right),rest671) end
| (203,(_,(_,_,END1right))::(_,(MlyValue.spec_s spec_s,spec_sleft,
spec_sright))::(_,(_,SIG1left,_))::rest671) => let val result=
MlyValue.sign((makeSIG(spec_s,error(spec_sleft,spec_sright))))
 in (LrTable.NT 69,(result,SIG1left,END1right),rest671) end
| (204,rest671) => let val result=MlyValue.sigconstraint_op((
fn _ => NONE))
 in (LrTable.NT 70,(result,defaultPos,defaultPos),rest671) end
| (205,(_,(MlyValue.sign sign,_,sign1right))::(_,(_,COLON1left,_))::
rest671) => let val result=MlyValue.sigconstraint_op((
fn param =>
				  SOME(sign(true,param)
				           (1,Stampset.newStampsets()))
))
 in (LrTable.NT 70,(result,COLON1left,sign1right),rest671) end
| (206,(_,(MlyValue.sigb sigb2,_,sigb2right))::_::(_,(MlyValue.sigb 
sigb1,sigb1left,_))::rest671) => let val result=MlyValue.sigb((
fn()=> sigb1() @ sigb2()))
 in (LrTable.NT 71,(result,sigb1left,sigb2right),rest671) end
| (207,(_,(MlyValue.sign sign,_,sign1right))::_::(_,(MlyValue.ident 
ident,ident1left,_))::rest671) => let val result=MlyValue.sigb((
make_sigb(ident, sign(true,NULLstr))))
 in (LrTable.NT 71,(result,ident1left,sign1right),rest671) end
| (208,(_,(MlyValue.qid qid,qidleft as qid1left,qidright as qid1right)
)::rest671) => let val result=MlyValue.str((
markstr(qidleft,qidright,
				  make_str_qid(qid,error(qidleft,qidright)))
))
 in (LrTable.NT 72,(result,qid1left,qid1right),rest671) end
| (209,(_,(_,_,ENDright as END1right))::(_,(MlyValue.sdecs sdecs,_,_))
::(_,(_,STRUCTleft as STRUCT1left,_))::rest671) => let val result=
MlyValue.str((
markstr(STRUCTleft,ENDright,
				  make_str_struct(sdecs,
					error(STRUCTleft,ENDright)))
))
 in (LrTable.NT 72,(result,STRUCT1left,END1right),rest671) end
| (210,(_,(_,_,RPARENright as RPAREN1right))::(_,(MlyValue.sdecs sdecs
,sdecsleft,sdecsright))::_::(_,(MlyValue.ID ID,IDleft as ID1left,
IDright))::rest671) => let val result=MlyValue.str((
markstr(IDleft,RPARENright,
				   make_str_app(ID,error(IDleft,IDright),
				      (fn $ => let val (s,s')=spread_args sdecs $
					        in (MARKstr(s,sdecsleft,sdecsright)
							     ,s')
					       end)))
))
 in (LrTable.NT 72,(result,ID1left,RPAREN1right),rest671) end
| (211,(_,(_,_,RPARENright as RPAREN1right))::(_,(MlyValue.str str,_,_
))::_::(_,(MlyValue.ID ID,IDleft as ID1left,IDright))::rest671) => 
let val result=MlyValue.str((
markstr(IDleft,RPARENright,
				  make_str_app(ID,error(IDleft,IDright),
					      single_arg str))
))
 in (LrTable.NT 72,(result,ID1left,RPAREN1right),rest671) end
| (212,(_,(_,_,ENDright as END1right))::(_,(MlyValue.str str,_,_))::_
::(_,(MlyValue.sdecs sdecs,_,_))::(_,(_,LETleft as LET1left,_))::
rest671) => let val result=MlyValue.str((
markstr(LETleft,ENDright,
				  make_str_let(sdecs,str))))
 in (LrTable.NT 72,(result,LET1left,END1right),rest671) end
| (213,(_,(MlyValue.sdecs sdecs,_,sdecs1right))::(_,(MlyValue.sdec 
sdec,sdecleft as sdec1left,sdecright))::rest671) => let val result=
MlyValue.sdecs((fn $ => markdec(sdec $,sdecleft,sdecright) :: sdecs $)
)
 in (LrTable.NT 73,(result,sdec1left,sdecs1right),rest671) end
| (214,(_,(MlyValue.sdecs sdecs,_,sdecs1right))::(_,(_,SEMICOLON1left,
_))::rest671) => let val result=MlyValue.sdecs((sdecs))
 in (LrTable.NT 73,(result,SEMICOLON1left,sdecs1right),rest671) end
| (215,(_,(MlyValue.sdecs sdecs3,_,sdecs3right))::_::(_,(
MlyValue.sdecs sdecs2,_,_))::_::(_,(MlyValue.sdecs sdecs1,_,_))::(_,(_
,LOCAL1left,_))::rest671) => let val result=MlyValue.sdecs((
fn $ => makeLOCALsdecs(sdecs1,sdecs2) $
							@ sdecs3 $))
 in (LrTable.NT 73,(result,LOCAL1left,sdecs3right),rest671) end
| (216,rest671) => let val result=MlyValue.sdecs((fn $ => nil))
 in (LrTable.NT 73,(result,defaultPos,defaultPos),rest671) end
| (217,(_,(MlyValue.sdecs' sdecs',_,sdecs'1right))::(_,(MlyValue.sdec 
sdec,sdecleft as sdec1left,sdecright))::rest671) => let val result=
MlyValue.sdecs'((
fn $ => markdec(sdec $,sdecleft,sdecright)
						 :: sdecs' $))
 in (LrTable.NT 74,(result,sdec1left,sdecs'1right),rest671) end
| (218,(_,(MlyValue.sdecs' sdecs',_,sdecs'1right))::_::(_,(
MlyValue.sdecs sdecs2,_,_))::_::(_,(MlyValue.sdecs sdecs1,_,_))::(_,(_
,LOCAL1left,_))::rest671) => let val result=MlyValue.sdecs'((
fn $ =>makeLOCALsdecs(sdecs1,sdecs2) $
							@ sdecs' $))
 in (LrTable.NT 74,(result,LOCAL1left,sdecs'1right),rest671) end
| (219,(_,(_,_,END1right))::(_,(MlyValue.sdecs sdecs2,_,_))::_::(_,(
MlyValue.sdecs sdecs1,_,_))::(_,(_,LOCAL1left,_))::rest671) => let 
val result=MlyValue.sdecs'((makeLOCALsdecs(sdecs1,sdecs2)))
 in (LrTable.NT 74,(result,LOCAL1left,END1right),rest671) end
| (220,(_,(MlyValue.sdec sdec,sdecleft as sdec1left,sdecright as 
sdec1right))::rest671) => let val result=MlyValue.sdecs'((
fn $ => [markdec(sdec $,sdecleft,sdecright)]))
 in (LrTable.NT 74,(result,sdec1left,sdec1right),rest671) end
| (221,(_,(MlyValue.strb strb,_,strb1right))::(_,(_,STRUCTURE1left,_))
::rest671) => let val result=MlyValue.sdec((makeSTRBs(strb false)))
 in (LrTable.NT 75,(result,STRUCTURE1left,strb1right),rest671) end
| (222,(_,(MlyValue.strb strb,_,strb1right))::(_,(_,ABSTRACTION1left,_
))::rest671) => let val result=MlyValue.sdec((makeSTRBs(strb true)))
 in (LrTable.NT 75,(result,ABSTRACTION1left,strb1right),rest671) end
| (223,(_,(MlyValue.sigb sigb,_,sigbright as sigb1right))::(_,(_,
SIGNATUREleft as SIGNATURE1left,_))::rest671) => let val result=
MlyValue.sdec((makeSIGdec(sigb,error(SIGNATUREleft,sigbright))))
 in (LrTable.NT 75,(result,SIGNATURE1left,sigb1right),rest671) end
| (224,(_,(MlyValue.fctb fctb,_,fctbright as fctb1right))::(_,(_,
FUNCTORleft as FUNCTOR1left,_))::rest671) => let val result=
MlyValue.sdec((makeFCTdec(fctb,error(FUNCTORleft,fctbright))))
 in (LrTable.NT 75,(result,FUNCTOR1left,fctb1right),rest671) end
| (225,(_,(MlyValue.ldec ldec,ldecleft as ldec1left,ldecright as 
ldec1right))::rest671) => let val result=MlyValue.sdec((
fn (pa,top,st) => let val dec = E ldec (pa,no_tyvars,st)
			                  in Typecheck.decType(dec,top,error,
							       (ldecleft,ldecright));
					     dec
				         end
))
 in (LrTable.NT 75,(result,ldec1left,ldec1right),rest671) end
| (226,(_,(MlyValue.str str,_,str1right))::_::(_,(
MlyValue.sigconstraint_op sigconstraint_op,sigconstraint_opleft,
sigconstraint_opright))::(_,(MlyValue.ident ident,ident1left,_))::
rest671) => let val result=MlyValue.strb((
makeSTRB(ident,sigconstraint_op,str,
				  error(sigconstraint_opleft,sigconstraint_opright))
))
 in (LrTable.NT 76,(result,ident1left,str1right),rest671) end
| (227,(_,(MlyValue.strb strb2,_,strb2right))::_::(_,(MlyValue.strb 
strb1,strb1left,_))::rest671) => let val result=MlyValue.strb((
fn a => fn $ => strb1 a $ @ strb2 a $))
 in (LrTable.NT 76,(result,strb1left,strb2right),rest671) end
| (228,(_,(MlyValue.sign sign,_,sign1right))::_::(_,(MlyValue.ID ID,
ID1left,_))::rest671) => let val result=MlyValue.fparam((
single_formal(ID, sign(true,NULLstr))))
 in (LrTable.NT 77,(result,ID1left,sign1right),rest671) end
| (229,(_,(MlyValue.spec_s spec_s,spec_sleft as spec_s1left,
spec_sright as spec_s1right))::rest671) => let val result=
MlyValue.fparam((
spread_formal(spec_s,
					       error(spec_sleft,spec_sright))))
 in (LrTable.NT 77,(result,spec_s1left,spec_s1right),rest671) end
| (230,(_,(MlyValue.str str,strleft,strright as str1right))::_::(_,(
MlyValue.sigconstraint_op sigconstraint_op,_,_))::_::(_,(
MlyValue.fparam fparam,_,_))::_::(_,(MlyValue.ident ident,ident1left,_
))::rest671) => let val result=MlyValue.fctb((
makeFCTB(ident,fparam,
						sigconstraint_op,str,
						error(strleft,strright))
))
 in (LrTable.NT 78,(result,ident1left,str1right),rest671) end
| (231,(_,(MlyValue.fctb fctb2,_,fctb2right))::_::(_,(MlyValue.fctb 
fctb1,fctb1left,_))::rest671) => let val result=MlyValue.fctb((
fn $ => fctb1 $ @ fctb2 $))
 in (LrTable.NT 78,(result,fctb1left,fctb2right),rest671) end
| (232,(_,(MlyValue.STRING STRING,STRING1left,STRING1right))::rest671)
 => let val result=MlyValue.importdec(([STRING]))
 in (LrTable.NT 79,(result,STRING1left,STRING1right),rest671) end
| (233,(_,(MlyValue.importdec importdec,_,importdec1right))::(_,(
MlyValue.STRING STRING,STRING1left,_))::rest671) => let val result=
MlyValue.importdec((STRING :: importdec))
 in (LrTable.NT 79,(result,STRING1left,importdec1right),rest671) end
| (234,(_,(MlyValue.sdecs' sdecs',sdecs'left as sdecs'1left,
sdecs'right as sdecs'1right))::rest671) => let val result=
MlyValue.interdec((
fn()=>markdec(SEQdec(sdecs'([],true,Stampset.globalStamps)),sdecs'left,sdecs'right)
))
 in (LrTable.NT 80,(result,sdecs'1left,sdecs'1right),rest671) end
| (235,(_,(MlyValue.importdec importdec,_,importdec1right))::(_,(_,
IMPORT1left,_))::rest671) => let val result=MlyValue.interdec((
fn()=>IMPORTdec importdec))
 in (LrTable.NT 80,(result,IMPORT1left,importdec1right),rest671) end
| (236,(_,(MlyValue.exp exp,expleft as exp1left,expright as exp1right)
)::rest671) => let val result=MlyValue.interdec((
fn()=>markdec(toplevelexp(exp,error,(expleft,expright)),
					expleft,expright)
))
 in (LrTable.NT 80,(result,exp1left,exp1right),rest671) end
| _ => raise (mlyAction i392)
end
val void = MlyValue.VOID
val extract = fn a => (fn MlyValue.interdec x => x
| _ => let exception ParseInternal
	in raise ParseInternal end) a 
end
end
structure Tokens : ML_TOKENS =
struct
type svalue = ParserData.svalue
type ('a,'b) token = ('a,'b) Token.token
fun EOF (p1,p2) = Token.TOKEN (ParserData.LrTable.T 0,(
ParserData.MlyValue.VOID,p1,p2))
fun SEMICOLON (p1,p2) = Token.TOKEN (ParserData.LrTable.T 1,(
ParserData.MlyValue.VOID,p1,p2))
fun ID (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 2,(
ParserData.MlyValue.ID i,p1,p2))
fun TYVAR (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 3,(
ParserData.MlyValue.TYVAR i,p1,p2))
fun INT (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 4,(
ParserData.MlyValue.INT i,p1,p2))
fun INT0 (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 5,(
ParserData.MlyValue.INT0 i,p1,p2))
fun REAL (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 6,(
ParserData.MlyValue.REAL i,p1,p2))
fun STRING (i,p1,p2) = Token.TOKEN (ParserData.LrTable.T 7,(
ParserData.MlyValue.STRING i,p1,p2))
fun ABSTRACTION (p1,p2) = Token.TOKEN (ParserData.LrTable.T 8,(
ParserData.MlyValue.VOID,p1,p2))
fun ABSTYPE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 9,(
ParserData.MlyValue.VOID,p1,p2))
fun AND (p1,p2) = Token.TOKEN (ParserData.LrTable.T 10,(
ParserData.MlyValue.VOID,p1,p2))
fun ARROW (p1,p2) = Token.TOKEN (ParserData.LrTable.T 11,(
ParserData.MlyValue.VOID,p1,p2))
fun AS (p1,p2) = Token.TOKEN (ParserData.LrTable.T 12,(
ParserData.MlyValue.VOID,p1,p2))
fun BAR (p1,p2) = Token.TOKEN (ParserData.LrTable.T 13,(
ParserData.MlyValue.VOID,p1,p2))
fun CASE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 14,(
ParserData.MlyValue.VOID,p1,p2))
fun DATATYPE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 15,(
ParserData.MlyValue.VOID,p1,p2))
fun DOTDOTDOT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 16,(
ParserData.MlyValue.VOID,p1,p2))
fun ELSE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 17,(
ParserData.MlyValue.VOID,p1,p2))
fun END (p1,p2) = Token.TOKEN (ParserData.LrTable.T 18,(
ParserData.MlyValue.VOID,p1,p2))
fun EQUAL (p1,p2) = Token.TOKEN (ParserData.LrTable.T 19,(
ParserData.MlyValue.VOID,p1,p2))
fun EQTYPE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 20,(
ParserData.MlyValue.VOID,p1,p2))
fun EXCEPTION (p1,p2) = Token.TOKEN (ParserData.LrTable.T 21,(
ParserData.MlyValue.VOID,p1,p2))
fun DO (p1,p2) = Token.TOKEN (ParserData.LrTable.T 22,(
ParserData.MlyValue.VOID,p1,p2))
fun DOT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 23,(
ParserData.MlyValue.VOID,p1,p2))
fun DARROW (p1,p2) = Token.TOKEN (ParserData.LrTable.T 24,(
ParserData.MlyValue.VOID,p1,p2))
fun FN (p1,p2) = Token.TOKEN (ParserData.LrTable.T 25,(
ParserData.MlyValue.VOID,p1,p2))
fun FUN (p1,p2) = Token.TOKEN (ParserData.LrTable.T 26,(
ParserData.MlyValue.VOID,p1,p2))
fun FUNCTOR (p1,p2) = Token.TOKEN (ParserData.LrTable.T 27,(
ParserData.MlyValue.VOID,p1,p2))
fun HANDLE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 28,(
ParserData.MlyValue.VOID,p1,p2))
fun HASH (p1,p2) = Token.TOKEN (ParserData.LrTable.T 29,(
ParserData.MlyValue.VOID,p1,p2))
fun IF (p1,p2) = Token.TOKEN (ParserData.LrTable.T 30,(
ParserData.MlyValue.VOID,p1,p2))
fun IN (p1,p2) = Token.TOKEN (ParserData.LrTable.T 31,(
ParserData.MlyValue.VOID,p1,p2))
fun INCLUDE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 32,(
ParserData.MlyValue.VOID,p1,p2))
fun INFIX (p1,p2) = Token.TOKEN (ParserData.LrTable.T 33,(
ParserData.MlyValue.VOID,p1,p2))
fun INFIXR (p1,p2) = Token.TOKEN (ParserData.LrTable.T 34,(
ParserData.MlyValue.VOID,p1,p2))
fun LET (p1,p2) = Token.TOKEN (ParserData.LrTable.T 35,(
ParserData.MlyValue.VOID,p1,p2))
fun LOCAL (p1,p2) = Token.TOKEN (ParserData.LrTable.T 36,(
ParserData.MlyValue.VOID,p1,p2))
fun NONFIX (p1,p2) = Token.TOKEN (ParserData.LrTable.T 37,(
ParserData.MlyValue.VOID,p1,p2))
fun OF (p1,p2) = Token.TOKEN (ParserData.LrTable.T 38,(
ParserData.MlyValue.VOID,p1,p2))
fun OP (p1,p2) = Token.TOKEN (ParserData.LrTable.T 39,(
ParserData.MlyValue.VOID,p1,p2))
fun OPEN (p1,p2) = Token.TOKEN (ParserData.LrTable.T 40,(
ParserData.MlyValue.VOID,p1,p2))
fun OVERLOAD (p1,p2) = Token.TOKEN (ParserData.LrTable.T 41,(
ParserData.MlyValue.VOID,p1,p2))
fun QUERY (p1,p2) = Token.TOKEN (ParserData.LrTable.T 42,(
ParserData.MlyValue.VOID,p1,p2))
fun RAISE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 43,(
ParserData.MlyValue.VOID,p1,p2))
fun REC (p1,p2) = Token.TOKEN (ParserData.LrTable.T 44,(
ParserData.MlyValue.VOID,p1,p2))
fun SHARING (p1,p2) = Token.TOKEN (ParserData.LrTable.T 45,(
ParserData.MlyValue.VOID,p1,p2))
fun SIG (p1,p2) = Token.TOKEN (ParserData.LrTable.T 46,(
ParserData.MlyValue.VOID,p1,p2))
fun SIGNATURE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 47,(
ParserData.MlyValue.VOID,p1,p2))
fun STRUCT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 48,(
ParserData.MlyValue.VOID,p1,p2))
fun STRUCTURE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 49,(
ParserData.MlyValue.VOID,p1,p2))
fun THEN (p1,p2) = Token.TOKEN (ParserData.LrTable.T 50,(
ParserData.MlyValue.VOID,p1,p2))
fun TYPE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 51,(
ParserData.MlyValue.VOID,p1,p2))
fun VAL (p1,p2) = Token.TOKEN (ParserData.LrTable.T 52,(
ParserData.MlyValue.VOID,p1,p2))
fun WHILE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 53,(
ParserData.MlyValue.VOID,p1,p2))
fun WILD (p1,p2) = Token.TOKEN (ParserData.LrTable.T 54,(
ParserData.MlyValue.VOID,p1,p2))
fun WITH (p1,p2) = Token.TOKEN (ParserData.LrTable.T 55,(
ParserData.MlyValue.VOID,p1,p2))
fun WITHTYPE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 56,(
ParserData.MlyValue.VOID,p1,p2))
fun ASTERISK (p1,p2) = Token.TOKEN (ParserData.LrTable.T 57,(
ParserData.MlyValue.VOID,p1,p2))
fun COLON (p1,p2) = Token.TOKEN (ParserData.LrTable.T 58,(
ParserData.MlyValue.VOID,p1,p2))
fun COMMA (p1,p2) = Token.TOKEN (ParserData.LrTable.T 59,(
ParserData.MlyValue.VOID,p1,p2))
fun LBRACE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 60,(
ParserData.MlyValue.VOID,p1,p2))
fun LBRACKET (p1,p2) = Token.TOKEN (ParserData.LrTable.T 61,(
ParserData.MlyValue.VOID,p1,p2))
fun LPAREN (p1,p2) = Token.TOKEN (ParserData.LrTable.T 62,(
ParserData.MlyValue.VOID,p1,p2))
fun RBRACE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 63,(
ParserData.MlyValue.VOID,p1,p2))
fun RBRACKET (p1,p2) = Token.TOKEN (ParserData.LrTable.T 64,(
ParserData.MlyValue.VOID,p1,p2))
fun RPAREN (p1,p2) = Token.TOKEN (ParserData.LrTable.T 65,(
ParserData.MlyValue.VOID,p1,p2))
fun ORELSE (p1,p2) = Token.TOKEN (ParserData.LrTable.T 66,(
ParserData.MlyValue.VOID,p1,p2))
fun ANDALSO (p1,p2) = Token.TOKEN (ParserData.LrTable.T 67,(
ParserData.MlyValue.VOID,p1,p2))
fun IMPORT (p1,p2) = Token.TOKEN (ParserData.LrTable.T 68,(
ParserData.MlyValue.VOID,p1,p2))
end
end
