(* Copyright (c) 1991 by Carnegie Mellon University *)

functor ControlFun(structure Bignum : CBIGNUM) : CONTROL =
  struct
     structure Bignum = Bignum

     val exp : int -> Bignum.bignum =
        let val i2 = Bignum.inttobignum 2
             fun f 0 = Bignum.inttobignum 1
               | f i = Bignum.*(i2,f(i-1))
        in f
        end

     val wordsize = 32
     val maxint = Bignum.-(exp(wordsize-1),Bignum.inttobignum 1)
     val minint = Bignum.~(exp(wordsize-1))
     val intType = "int"
     val floatSize = 8
     val floatType = "double"
     val overflow = "overflow_e0"
     val mult = "mult"

      (* optimization flags *)

      val unsafeArith = ref false
      val arithOpt = ref true
      val regArray = ref true
      val regOpt = ref true
      val tailOpt = ref true
      val integOpt = ref false
      val zeroCheck = ref true
      val autoIncrement = ref false
      val usageCount = ref 1
      val debug = ref false
end
