\begin{caml_primitive}
is_integer_ratio : ratio -> bool
integer_ratio : ratio -> big_int
floor_ratio : ratio -> big_int
round_ratio : ratio -> big_int
ceiling_ratio : ratio -> big_int
\end{caml_primitive}

\verb"is_integer_ratio" normalizes its argument, in order to determine if it is
an integer. It is equivalent to:
\begin{small}
\begin{verbatim}
let is_integer_ratio r =
 eq_big_int ((normalize_ratio r).Denominator, unit_big_int)
;;
\end{verbatim}
\end{small}

\verb"integer_ratio" is the odd function of truncature for rational numbers.

\verb"floor_ratio" (resp. \verb"round_ratio", \verb"ceiling_ratio") are the 
mathematical functions for rounding to the lower (resp. nearest, higher) 
integer.

\exple
\begin{small}
\begin{verbatim}
#is_integer_ratio #[1.2e3/1200];;
true : bool

#integer_ratio #[1/3];;
#(0) : big_int

#floor_ratio #[1/3];;
#(0) : big_int

#round_ratio #[1/3];;
#(0) : big_int

#ceiling_ratio #[1/3];;
#(1) : big_int

#integer_ratio #[1/2];;
#(0) : big_int

#floor_ratio #[1/2];;
#(0) : big_int

#round_ratio #[1/2];;
#(1) : big_int

#ceiling_ratio #[1/2];;
#(1) : big_int

#integer_ratio #[-1/3];;
#(0) : big_int

#floor_ratio #[-1/3];;
#(-1) : big_int

#round_ratio #[-1/3];;
#(0) : big_int

#ceiling_ratio #[-1/3];;
#(0) : big_int

#integer_ratio #[-1/2];;
#(0) : big_int

#floor_ratio #[-1/2];;
#(-1) : big_int

#round_ratio #[-1/2];;
#(-1) : big_int

#ceiling_ratio #[-1/2];;
#(0) : big_int
\end{verbatim}
\end{small}
