\begin{caml_primitive}
sys_nat_of_string  : int * string * int * int -> nat
nat_of_string  : string -> nat
\end{caml_primitive}
\conceptindex{coercion between types \verb"nat" and \verb"string"}

It is not possible to read directly natural numbers, but coercion from strings 
exists. 

\verb"sys_nat_of_string (base, s, off, len)" maps the substring $s_{off, len}$
in base \verb"base" onto a natural number. 

A string must verify the following convention for recognition as a natural 
number: 
\begin{small}
\begin{verbatim}
Separator ::= ' ' | '\f' | '\n' | |\r' | '\t' | '\\'
Pseudodigit ::= Digit | Separator
NAT ::= Separator* Digit Pseudodigit*
\end{verbatim}
\end{small}
\verb"nat_of_string s" is equivalent to:
\begin{small}
\begin{verbatim}
let nat_of_string s = 
  sys_nat_of_string (#10, s, #0, length_string s)
;;
\end{verbatim}
\end{small}

\exple
\begin{small}
\begin{verbatim}
#sys_nat_of_string (#16, "FF", #0, #2);;
#<255> : nat

#nat_of_string "123";;
#<123> : nat
\end{verbatim}
\end{small}
