\begin{caml_primitive}
simple_big_int_of_string : int * string * int * int -> big_int
decimal_of_string : int * string * int * int -> string * int
sys_big_int_of_string : int * string * int * int -> big_int
big_int_of_string : string -> big_int
\end{caml_primitive}
\conceptindex{coercion between types \verb"big_int" and \verb"string"}

CAML is able to read \verb"big_int" entered directly, according to the
following lexical convention: 

\begin{small}
\begin{verbatim}
Separator ::= ' ' | '\f' | '\n' | |\r' | '\t' | '\\'
Pseudodigit ::= Digit | Separator
Decimal ::= {'-'| '+'} Separator* Digit Pseudodigit* 
            {'.' Separator* Digit Pseudodigit*} {'e' {'-' | '+'} INT}
BIG_INT ::= '#(' Decimal ')'
\end{verbatim}
\end{small}

\exple
\begin{small}
\begin{verbatim}
##(12);;
#(12) : big_int

##(12.0);;
#(12) : big_int

##(1.2e1);;
#(12) : big_int

##(120e-1);;
#(12) : big_int
\end{verbatim}
\end{small}

\verb"simple_big_int_of_string" recognizes simple expressions for
\verb"big_int", i.e. without mantissa and without
floating point. 

\verb"decimal_of_string" is the fundamental function for recognizing 
numerical expressions with floating point and mantissa. 
\verb"decimal_of_string (base, s, off, len)" yields the pair of a string 
representing a simple \verb"big_int" and an \verb"int" representing the
corresponding mantissa. Roughly speaking, if $s_{off, len}$ is of the
form \verb"s1.s2es3" then the result is \verb"(s1^s2, s3-length_string s2)". 

\verb"sys_big_int_of_string (base, s, off, len)" maps the substring 
$s_{off, len}$ in base \verb"base" onto a \verb"big_int".

\verb"big_int_of_string s" is equivalent to:
\begin{small}
\begin{verbatim}
let big_int_of_string s = 
  sys_big_int_of_string (#10, s, #0, length_string s)
;;
\end{verbatim}
\end{small}

\exple
\begin{small}
\begin{verbatim}
#simple_big_int_of_string (#10, "1200", #0, #4);;
#(1200) : big_int

#simple_big_int_of_string (#10, "1.2e3", #0, #5);;

Evaluation Failed: failure "base_digit_of_char"

#decimal_of_string (#10, "1200", #0, #4);;
("1200",0) : string * int

#decimal_of_string (#10, "1.2e3", #0, #5);;
("12",2) : string * int

#decimal_of_string (#10, "1.2e-1", #0, #6);;
("12",-2) : string * int

#sys_big_int_of_string (#16, "FF", #0, #2);;
#(255) : big_int

#big_int_of_string "1.2e3";;
#(1200) : big_int
\end{verbatim}
\end{small}
