\begin{caml_primitive}
sys_string_of_num : int * string * num * string -> string
string_of_num : num -> string
string_for_read_of_num : num -> string
display_num : num -> unit
echo_num : num -> unit
sys_print_num : int * string * num * string -> unit
print_num : num -> unit
print_num_for_read : num -> unit
\end{caml_primitive}
\conceptindex{coercion between types \verb"string" and \verb"num"}

\verb"sys_string_of_num (base, before, r, after)" writes into the 
resulting string first the string \verb"before", then the representation of 
rational number \verb"n" in base \verb"base", and last the string \verb"after".
In fact if the approximation when printing rational numbers is turned on, 
the result is the floating point approximation to the floating point precision 
of the rational number. This feature is not implemented with 
$\verb"base " \neq 10$. For more information see section~\ref{approxratio} and 
chapter~\ref{numdir}.

\verb"string_of_num n" is semantically equivalent to:
\begin{small}
\begin{verbatim}
let string_of_num n = 
  sys_string_of_num (#10, "", n, "")
;;
\end{verbatim}
\end{small}

\verb"string_for_read_of_num n" is analogous to \verb"string_of_num n" 
except that the number is written between \verb"#{" and \verb"}", according to 
conventions to write ``big'' numbers. 

It is equivalent to:
\begin{small}
\begin{verbatim}
let string_for_read_of_num r =
 sys_string_of_num (#10, "#{", r, "}")
;;
\end{verbatim}
\end{small}

\verb"display_num" and \verb"echo_num" are equivalent to:
\begin{small}
\begin{verbatim}
let display_num n = display_string (string_of_num n)

and echo_num n = echo_string (string_of_num n)
;;
\end{verbatim}
\end{small}
For more information on the differences between {\verb"display",
\verb"echo", \verb"print"}-* like functions see the corresponding
chapter of the reference manual. 

\verb"sys_print_of_num (base, before, r, after)" prints the 
\verb"base"-radix representation of the rational number \verb"n" between 
strings \verb"before" and \verb"after". It is equivalent to:
\begin{small}
\begin{verbatim}
let sys_print_num (base, before, r, after) =
 print_string (sys_string_of_num (base, before, r, after))
;;
\end{verbatim}
\end{small}

\verb"print_num" and \verb"print_num_for_read" are equivalent to:
\begin{small}
\begin{verbatim}
let print_num n = sys_print_num (#10, "", n, "");;

let print_num_for_read n = sys_print_num (#10, "#{", n, "}");;
\end{verbatim}
\end{small}

\exple
\begin{small}
\begin{verbatim}
#sys_string_of_num 
#  (#16, "num 16-radix representation = ", #{1.2e3/1.1e2}, "");;
"num 16-radix representation = 78/B" : string

#sys_string_of_num 
#  (#2, "num 2-radix representation = ", #{1.2e3/1.1e2}, "");;
"num 2-radix representation = 1111000/1011" : string

#sys_string_of_num 
#  (#8, "num 8-radix representation = ", #{1.2e3/1.1e2}, "");;
"num 8-radix representation = 170/13" : string

#sys_string_of_num 
#  (#10, "num 10-radix representation = ", #{1.2e3/1.1e2}, "");;
"num 10-radix representation = 120/11" : string

#string_of_num #{1.2e3/1.1e2};;
"120/11" : string

#string_for_read_of_num #{1.2e3/1.1e2};;
"#{120/11}" : string

#sys_print_num (#16, "num 16-radix representation = ", #{1.2e3/1.1e2}, "");;
num 16-radix representation = 78/B() : unit

#print_num #{1.2e3/1.1e2};;
120/11() : unit

#print_num_for_read #{1.2e3/1.1e2};;
#{120/11}() : unit
\end{verbatim}
\end{small}
