\begin{caml_primitive}
numerator_ratio : ratio -> big_int
denominator_ratio : ratio -> big_int
null_denominator : ratio -> bool
verify_null_denominator : ratio -> bool
\end{caml_primitive}

\verb"numerator_ratio" and \verb"denominator_ratio" consult the corresponding 
label of the record.

\verb"null_denominator r" and \verb"verify_null_denominator" test if the 
denominator of the \verb"ratio" is null. \verb"verify_null_denominator" 
fails when a null denominator is encountered and null denominators are 
prohibited.

\exple
\begin{small}
\begin{verbatim}
#null_denominator {Numerator=#(1);Denominator=#(0);Normalized=false};;
true : bool

#verify_null_denominator {Numerator=#(1);Denominator=#(0);Normalized=false};;

Evaluation Failed: failure "infinite or undefined rational number"
\end{verbatim}
\end{small}
