\begin{caml_primitive}
land_digit_nat  : nat * int * nat * int -> unit
lor_digit_nat  : nat * int * nat * int -> unit
lxor_digit_nat  : nat * int * nat * int -> unit
\end{caml_primitive}
\verb"land_digit_nat (nat1, off1, nat2, off2)" performs ``logical and'' 
on digits $nat1_{off1}$ and $nat1_{off2}$, the resulting digit is put in 
$nat1_{off1}$.

\exple
\begin{small}
\begin{verbatim}
#let nat = create_nat #4;;
Value nat is #<0> : nat

#for i = #0 to #3 do set_digit_nat (nat, i, i) done; debug_print_nat nat;;
|00000003|00000002|00000001|00000000|() : unit

#land_digit_nat (nat, #3, nat, #1); debug_print_nat nat;;
|00000001|00000002|00000001|00000000|() : unit

#land_digit_nat (nat, #0, nat, #2); debug_print_nat nat;;
|00000001|00000002|00000001|00000000|() : unit
\end{verbatim}
\end{small}

\verb"lor_digit_nat (nat1, off1, nat2, off2)" performs ``logical or'' 
on digits $nat1_{off1}$ and $nat1_{off2}$, the resulting digit is put in 
$nat1_{off1}$.

\exple
\begin{small}
\begin{verbatim}
#let nat = create_nat #4;;
Value nat is #<0> : nat

#for i = #0 to #3 do set_digit_nat (nat, i, i) done; debug_print_nat nat;;
|00000003|00000002|00000001|00000000|() : unit

#lor_digit_nat (nat, #3, nat, #1); debug_print_nat nat;;
|00000003|00000002|00000001|00000000|() : unit

#lor_digit_nat (nat, #0, nat, #2); debug_print_nat nat;;
|00000003|00000002|00000001|00000002|() : unit
\end{verbatim}
\end{small}

\verb"lxor_digit_nat (nat1, off1, nat2, off2)" performs 
``logical exclusive or'' on digits $nat1_{off1}$ and $nat1_{off2}$, 
the resulting digit is put in $nat1_{off1}$.

\exple
\begin{small}
\begin{verbatim}
#let nat = create_nat #4;;
Value nat is #<0> : nat

#for i = #0 to #3 do set_digit_nat (nat, i, i) done; debug_print_nat nat;;
|00000003|00000002|00000001|00000000|() : unit

#lxor_digit_nat (nat, #3, nat, #1); debug_print_nat nat;;
|00000002|00000002|00000001|00000000|() : unit

#lxor_digit_nat (nat, #0, nat, #2); debug_print_nat nat;;
|00000002|00000002|00000001|00000002|() : unit
\end{verbatim}
\end{small}
