\begin{caml_primitive}
sin : float -> float
cos : float -> float
asin : float -> float
acos : float -> float
atan : float -> float
exp : float -> float
log : float -> float
log10 : float -> float
sqrt : float -> float
power_float : float * float -> float
\end{caml_primitive}

\verb"sin" and \verb"cos" are the classical trigonometric functions. 
As an example one can create a function \verb"tan" using the mathematical
definition:

\exple
\begin{small}
\begin{verbatim}
#let tan x = div_float (sin x, cos x);;
Value tan is <fun> : float -> float

#tan 1.0;;
1.557408 : float

#atan it;;
0.9999999 : float

#let pi_over_2 = div_float (3.14159265,2.0);;
Value pi_over_2 is 1.570796 : float

#(* Computation with floating point numbers approximates *)
#tan pi_over_2;;
13245400.0 : float

#(* But sometimes consistently ! *)
#atan it;;
1.570796 : float
\end{verbatim}
\end{small}

\verb"asin", \verb"acos" and \verb"atan" are the reciprocal functions of these 
trigonometric functions.

\verb"log" and \verb"exp" are the Neperian logarithm and the exponential 
function. \verb"log10" is the decimal logarithm.

\verb"sqrt" is the square root function and \verb"power_float (x, y)" yields 
$x^y$.
