\begin{caml_primitive}
get_approx_printing : unit -> bool
set_approx_printing : bool -> bool
get_floating_precision : unit -> int
set_floating_precision : int -> int
\end{caml_primitive}

\verb"get_approx_printing" (resp. \verb"set_approx_printing") consults (resp. 
modifies) the flag of rational printing mode. If turned on, each rational number 
will be printed as its floating point approximation according to the current 
default floating point precision flag, consultable (resp. modifiable) with
\verb"get_floating_precision" (resp. \verb"set_floating_precision").

By default, this flag is set to false.

\exple
\begin{small}
\begin{verbatim}
#get_approx_printing ();;
false : bool

#set_approx_printing true;;
true : bool

##[2/3];;
#[2/3] : ratio

#get_floating_precision ();;
12 : int

#set_floating_precision #2;;
2 : int

##{1/4};;
#{1/4} : num
\end{verbatim}
\end{small}
