\begin{caml_primitive}
create_nat : int -> nat
make_nat : int -> nat
copy_nat : nat * int * int -> nat
\end{caml_primitive}
\verb"create_nat len" and \verb"make_nat len" create a new natural 
number of $len$ digits ($len \geq 1$). \verb"create_nat" is the
primitive function, it is not supposed to initialize the created
number, on the other hand, \verb"make_nat" is supposed to initialize
the created number to zero.  

\verb"make_nat" is equivalent to the following CAML definition:
\begin{small}
\begin{verbatim}
let make_nat len =
  let res = create_nat (len) in 
    set_to_zero_nat (res, #0, len); 
res
;;
\end{verbatim}
\end{small}
\bigskip

\begin{beware}
\item In fact in this version \verb"create_nat" and \verb"make_nat" are 
identical and initialize the created number.
\end{beware}

\verb"copy_nat (nat, off, len)" is a copy of the value of subnat 
$nat_{off, len}$.
