\begin{caml_primitive}
eq_int : int * int -> bool
compare_int : int * int -> int
lt_int : int * int -> bool
le_int : int * int -> bool
gt_int : int * int -> bool
ge_int : int * int -> bool
sign_int : int -> int
abs_int : int -> int
minus_int : int -> int
max_int : int -> int -> int
min_int : int -> int -> int
\end{caml_primitive}
\conceptindex{\verb"<="}
\conceptindex{\verb"="}
\conceptindex{\verb">="}
\conceptindex{\verb"<"}
\conceptindex{\verb">"}
\conceptindex{\verb"max"}
\conceptindex{\verb"min"}
\conceptindex{\verb"abs"}
\conceptindex{\verb"monster_int"}

\verb"eq_int" is the semantic and syntactic equality on numbers of
type \protect\verb"int". 

\verb"lt_int", \verb"le_int", \verb"gt_int", \verb"ge_int" are arithmetic 
comparisons corresponding respectively to \verb"<", \verb"<=", \verb">", 
\verb">=".

The primitive function for these functions is \verb"compare_int", that is 
semantically (and almost really) equivalent to
\begin{small}
\begin{verbatim}
let compare_int (int1, int2) =
  when (int1 = int2) -> #0
     | (int1 < int2) -> #-1
     |       _       -> #1;;
\end{verbatim}
\end{small}

\exple
\begin{small}
\begin{verbatim}
#compare_int (#0, #1);;
-1 : int

#compare_int (#0, #0);;
0 : int

#compare_int (#0, #-1);;
1 : int
\end{verbatim}
\end{small}

\verb"sign_int" is completely equivalent to 
\begin{small}
\begin{verbatim}
let sign_int n = compare_int (n, 0);;
\end{verbatim}
\end{small}
\verb"abs_int n" is the absolute value of number \verb"n". 

\begin{beware}
\item $abs\_int\: monster\_int = minus\_int\: monster\_int = monster\_int$
and \verb"monster_int" is negative. So \verb"abs_int" and \verb"minus_int" of 
a negative number of type \protect\verb"int" don't always produce
positive numbers. 

\item $pred\_int\: monster\_int = biggest\_int$ is the greatest number
of type \protect\verb"int", but \verb"monster_int" is the least one.
In fact \verb"least_int" is the smallest ``normal'' number of type
\protect\verb"int". 
\end{beware}

\verb"max_int n1 n2" and \verb"min_int n1 n2" are respectively the 
greater and the smaller of the numbers \verb"n1" and \verb"n2".

\exple
\begin{small}
\begin{verbatim}
#eq_int (succ_int biggest_int, monster_int);;
true : bool

#gt_int (succ_int biggest_int, biggest_int);;
false : bool

#sign_int (succ_int biggest_int);;
-1 : int

#sign_int monster_int;;
-1 : int

#sign_int #0;;
0 : int

#sign_int #2;;
1 : int

#sign_int #-3;;
-1 : int

#abs_int #-3;;
3 : int

#abs_int monster_int;;
-32768 : int

#max_int #1 #2;;
2 : int

#min_int #1 #2;;
1 : int
\end{verbatim}
\end{small}
