\begin{caml_primitive}
eq_num : num * num -> bool
compare_num : num * num -> int
lt_num : num * num -> bool
le_num : num * num -> bool
gt_num : num * num -> bool
ge_num : num * num -> bool
sign_num : num -> int
abs_num : num -> num
min_num : num -> num -> num
max_num : num -> num -> num
\end{caml_primitive}
\conceptindex{\verb"<="}
\conceptindex{\verb"="}
\conceptindex{\verb">="}
\conceptindex{\verb"<"}
\conceptindex{\verb">"}
\conceptindex{\verb"max"}
\conceptindex{\verb"min"}
\conceptindex{\verb"abs"}

\verb"lt_num", \verb"le_num", \verb"gt_num", \verb"ge_num" are arithmetic 
comparisons corresponding respectively to \verb"<", \verb"<=", \verb">", 
\verb">=" between elements of type \verb"num".

The primitive function for these functions is \verb"compare_num", that is 
semantically equivalent to:
\begin{small}
\begin{verbatim}
let compare_num (r1, r2) =
 when (r1 = r2) -> #0
    | (r1 < r2) -> #-1
    |     _     -> #1
;;
\end{verbatim}
\end{small}

\verb"sign_num" is equivalent to:
\begin{small}
\begin{verbatim}
let sign_num = function
  Int i -> sign_int i
| Big_int bi -> sign_big_int bi
| Ratio r -> sign_ratio r
;;
\end{verbatim}
\end{small}

\verb"abs_num n" is the absolute value of \verb"n".

\verb"max_num (n1, n2)" and \verb"min_num (n1, n2)" are respectively
the greater one and the smaller one of rational numbers \verb"n1" and 
\verb"n2".

\exple
\begin{small}
\begin{verbatim}
#sign_num (succ_num (num_of_int biggest_int));;
1 : int

#sign_num (num_of_int monster_int);;
-1 : int

#abs_num (succ_num (num_of_int biggest_int));;
#{32768} : num

#abs_num (num_of_int monster_int);;
#{32768} : num
\end{verbatim}
\end{small}
