\begin{caml_primitive}
sys_float_of_nat : nat * int * int -> float
float_of_nat  : nat -> float
nat_of_float  : float -> nat
\end{caml_primitive}
\conceptindex{coercion between types \verb"float" and \verb"nat"}

\verb"sys_float_of_nat (nat, off, len)" converts subnat $nat_{off, len}$ 
into a floating point number.

\verb"float_of_nat" converts its argument into a floating point number. 
This function is equivalent to:
\begin{small}
\begin{verbatim}
let float_of_nat nat = sys_float_of_nat (nat, #0, length_nat nat);;
\end{verbatim}
\end{small}
\verb"nat_of_float" converts its floating point argument into a natural 
number when it is a positive integer.

\exple
\begin{small}
\begin{verbatim}
#let nat = create_nat #2;;
Value nat is #<0> : nat

#set_digit_nat (nat, #1, #1);;
() : unit

#sys_float_of_nat (nat, #0, #1);;
0.0 : float

#sys_float_of_nat (nat, #1, #1);;
1.0 : float

#float_of_nat nat;;
4294967000.0 : float

#nat_of_float #1.0;;
#<1> : nat

#nat_of_float #1.0e10;;
#<9999999000> : nat

#nat_of_float #1.5;;

Evaluation Failed: failure "sys_big_int_of_string"
\end{verbatim}
\end{small}
