\begin{caml_primitive}
set_digit_nat : nat * int * int -> unit
blit_nat : nat * int * nat * int * int -> unit
set_to_zero_nat : nat * int * int -> unit
\end{caml_primitive}
\verb"set_digit_nat (nat, off, digit)" assigns $nat_{off}$ to the value of 
$digit$ of type \verb"int".

\verb"blit_nat (nat1, off1, nat2, off2, len2)" assigns subnat
$nat2_{off2, len2}$ to the subnat $nat1_{off1, len2}$. 

The following conditions must be verified : 
\begin{eqnarray*}
off1 & \geq & 0 \\
off2 & \geq & 0 \\
len2 & > & 0 \\
off1 + len2 & \leq & size (nat1) \\
off2 + len2 & \leq & size (nat2)
\end{eqnarray*}
%              off1 >= 0 
%              off2 >= 0 
%              len2 >= 1 
%       off1 + len2 <= size (nat1) 
%       off2 + len2 <= size (nat2)

where $size (nat)$ designates the length of $nat$. 

Notice that $nat1$ and $nat2$ can be the same.

\verb"set_to_zero_nat (nat, off, len)" sets subnat $nat_{off, len}$ to zero.

\exple
\begin{small}
\begin{verbatim}
#let nat1 = create_nat (#2) 
#and nat2 = create_nat (#2);;
Value nat1 is #<0> : nat
Value nat2 is #<0> : nat

#set_to_zero_nat (nat1, #0, #2);
#set_digit_nat (nat2, #0, #1);
#set_digit_nat (nat2, #1, #1);
#debug_print_nat nat1;;
|00000000|00000000|() : unit

#debug_print_nat nat2;;
|00000001|00000001|() : unit

#blit_nat (nat1, #0, nat2, #1, #1);
#debug_print_nat nat1;;
|00000000|00000001|() : unit

#debug_print_nat nat2;;
|00000001|00000001|() : unit

#blit_nat (nat1, #1, nat1, #0, #1);
#debug_print_nat nat1;;
|00000001|00000001|() : unit

#debug_print_nat nat2;;
|00000001|00000001|() : unit
\end{verbatim}
\end{small}
