\begin{caml_primitive}
add_int_ratio : int * ratio -> ratio
add_big_int_ratio : big_int * ratio -> ratio
add_ratio : ratio * ratio -> ratio
minus_ratio : ratio -> ratio
sub_ratio : ratio * ratio -> ratio
mult_int_ratio : int * ratio -> ratio
mult_big_int_ratio : big_int * ratio -> ratio
mult_ratio : ratio * ratio -> ratio
square_ratio : ratio -> ratio
inverse_ratio : ratio -> ratio
div_int_ratio : int * ratio -> ratio
div_big_int_ratio : big_int * ratio -> ratio
div_ratio_int : ratio * int -> ratio
div_ratio_big_int : ratio * big_int -> ratio
div_ratio : ratio * ratio -> ratio
\end{caml_primitive}
\conceptindex{\verb"+"}
\conceptindex{\verb"-"}
\conceptindex{\verb"*"}
\conceptindex{\verb"/"}

\verb"add_ratio" adds two rational numbers. 

\verb"add_int_ratio" (resp. \verb"add_big_int_ratio") performs the addition of 
an \verb"int" (resp. \verb"big_int") to a rational number. These functions are 
semantically equivalent to:
\begin{small}
\begin{verbatim}
let add_int_ratio (i, r) = add_ratio (ratio_of_int i, r)
and add_big_int_ratio (bi, r) = add_ratio (ratio_of_big_int bi, r)
;;
\end{verbatim}
\end{small}

\verb"minus_ratio r" is the opposite of the rational number $r$.

\verb"sub_ratio" is the subtraction between rational numbers.

\verb"mult_ratio" multiplies two rational numbers.

\verb"mult_int_ratio" (resp. \verb"mult_big_int_ratio") performs the 
multiplication of an \verb"int" (resp. \verb"big_int") to a rational
number. These functions are semantically equivalent to:
\begin{small}
\begin{verbatim}
let mult_int_ratio (i, r) = mult_ratio (ratio_of_int i, r)
and mult_big_int_ratio (bi, r) = mult_ratio (ratio_of_big_int bi, r)
;;
\end{verbatim}
\end{small}

\verb"square_ratio r" computes the square of the rational number $r$.
It is equivalent to:
\begin{small}
\begin{verbatim}
let square_ratio r =
  { Numerator = square_big_int r.Numerator;
    Denominator = square_big_int r.Denominator;
    Normalized = r.Normalized }
;;
\end{verbatim}
\end{small}

\verb"inverse_ratio" is equivalent to:
\begin{small}
\begin{verbatim}
let inverse_ratio r = 
  { Numerator = r.Denominator;
    Denominator = r.Numerator;
    Normalized = r.Normalized}
;;
\end{verbatim}
\end{small}

\verb"div_ratio" performs the division on rational numbers.

\verb"div_int_ratio" (resp. \verb"div_big_int_ratio") performs the 
division of an \verb"int" (resp. \verb"big_int") by a rational number. These 
functions are semantically equivalent to:
\begin{small}
\begin{verbatim}
let div_int_ratio (i, r) = div_ratio (ratio_of_int i, r)
and div_big_int_ratio (bi, r) = div_ratio (ratio_of_big_int bi, r)
;;
\end{verbatim}
\end{small}

\verb"div_ratio_int" (resp. \verb"div_ratio_big_int") performs the 
division of a rational number by an \verb"int" (resp. \verb"big_int"). These 
functions are semantically equivalent to:
\begin{small}
\begin{verbatim}
let div_ratio_int (r, i) = div_ratio (r, ratio_of_int i)
and div_ratio_big_int (r, bi) = div_ratio (r, ratio_of_big_int bi)
;;
\end{verbatim}
\end{small}

\exple
\begin{small}
\begin{verbatim}
#add_ratio (#[1/2], #[1/2]);;
#[1/1] : ratio

#sub_ratio (#[1/2], #[1/2]);;
#[0/1] : ratio

#inverse_ratio #[1/2];;
#[2/1] : ratio

#mult_int_ratio (#2, #[1/2]);;
#[1/1] : ratio

#square_ratio #[1/3];;
#[1/9] : ratio

#div_int_ratio (#2, #[2]);;
#[1/1] : ratio
\end{verbatim}
\end{small}
