\begin{caml_primitive}
msd_ratio : ratio -> int
round_futur_last_digit : string * int * int -> bool
approx_ratio_fix : int * ratio -> string
approx_ratio_exp : int * ratio -> string
float_of_rational_string : ratio -> string
\end{caml_primitive}

\verb"msd_ratio r" is the position of the leading digit of the decimal 
expansion of a strictly positive rational number. If
$$
r = \sum_{k=-p}^{k=N} r_k 10^k
$$
%     k=N
%    _____
%    \           k
% r = )     r  10
%    /       k
%    -----
%    k=-p
then we have \verb"msd_ratio r = N".

\verb"round_futur_last_digit (s, off, len)" rounds off in place the last but 
one digit-character of the substring $s_{off, len}$ and yields true if and 
only if it causes an overflow, i.e. if s contains an integer of the form 
$10^n-1$. In this case after transformation s will contain only 0 characters 
and the resulting value of the function is true.

\verb"approx_ratio_fix (n, r)" approaches the rational number \verb"r" with a 
\verb"n" 10-digits fix point representation. This is an odd function and the 
last digit is round off. In an informal manner, the printing format is:
\begin{small}
\begin{verbatim}
integer_part . decimal_part_with_n_digits
\end{verbatim}
\end{small}

\verb"approx_ratio_exp (n, r)" approaches the rational number \verb"r" with a
\verb"n" 10-digits floating point representation. This is an odd function and 
the last digit is round off. In an informal manner, the printing format is:
\begin{small}
\begin{verbatim}
(+|-) (0. n_first_digits e msd) | (1. n_zeros e (msd+1))
\end{verbatim}
\end{small}

\verb"float_of_rational_string" is the same function with a default precision 
value according to the floating point precision flag. For more information see 
chapter~\ref{numdir}.

\exple
\begin{small}
\begin{verbatim}
#msd_ratio #[1.2e3/1.1e2];;
1 : int

#let s = "+109090909090909";;
Value s is "+109090909090909" : string

#round_futur_last_digit (s, #0, #16);;
false : bool

#s;;
"+109090909090919" : string

#approx_ratio_fix (#12, #[1.2e3/1.1e2]);;
"+10.909090909091" : string

#approx_ratio_fix (#-1, #[1.2e3/1.1e2]);;
"+1" : string

#approx_ratio_exp (#12, #[1.2e3/1.1e2]);;
"+0.109090909091e2" : string

#approx_ratio_exp (#2, #[1.2e3/1.1e2]);;
"+0.11e2" : string

#float_of_rational_string #[1.2e3/1.1e2];;
"0.109090909091e2" : string
\end{verbatim}
\end{small}
