;; Eulisp Module
;; Author: pab
;; File: sems.em
;; Date: Tue May  5 23:23:43 1992
;;
;; Project:
;; Description: 
;;

(defmodule semaphores
  (defs
   extras0
   macros0
   sems
   classes
   lists
   list-operators
   (except (null) class-names)
   initcode
   calls
   errors
   generics
   threads
   ;;boot
   )
  ()
  
  (defstruct semaphore ()
    ((real-sem initform (make-primitive-semaphore)
	       reader semaphore-real-sem))
    constructor make-semaphore
    predicate semaphore-p)

  (defgeneric open-semaphore (sem))
  (defgeneric close-semaphore (sem))
  (defgeneric initialize-semaphore (sem))
    
  (defmethod open-semaphore ((x object))
    (error "Wrong class for open-semaphore" Internal-Error))
  
  (defmethod open-semaphore ((x semaphore))
    (open-primitive-semaphore (semaphore-real-sem x))
    x)

  (defmethod close-semaphore ((x object))
    (error "Wrong class for close-semaphore" Internal-Error))
  
  (defmethod close-semaphore ((x semaphore))
    (close-primitive-semaphore (semaphore-real-sem x))
    x)

  (defmethod initialize-semaphore ((x object))
    (error "Wrong class for initialize-semaphore" Internal-Error))
  
  (defmethod initialize-semaphore ((x semaphore))
    (initialize-primitive-semaphore (semaphore-real-sem x))
    x)

  (export make-semaphore open-semaphore close-semaphore semaphore-p initialize-semaphore
	  semaphore)

  ;; end module
  )
