;; Eulisp Module
;; Author: pab
;; File: test2.em
;; Date: Wed Feb 26 23:21:39 1992
;;
;; Project:
;; Description: 
;;  inline tests
;;  continuation/handler tests

(defmodule test2
  (
   lists
   arith
   list-operators
   streams
   vectors
   others
   macros0
   calls
   )
  ()

  (defun wibble (x y z)
    (list x (cons y z) 2 3))

  (defun a (x)
    (labels ((bar (x) 
		  (if (= x 0) 0 
		    (bar (- x 1)))))
	    (bar x)))
  
  (defun foo (x) 
    (cons (car x) (cdr x)))

  (defun bar (x)
    (lambda (a)
      (cons a x)))


  (defun xxx (x)
    (let ((a 1))
      (setq a x)
      a))

  (defun b (x y)
    (vector-ref x y))

  (defun x (a b c)
    ((setter vector-ref) a b c))

 ;; possibly the worst reverse in the world
  ;; Exercise: Make it work in-place.

  (defun rev (l)
    (if (null l) l
      (if (null (cdr l)) l
	(let ((a1 (rev (cdr l))))
	  (cons (car a1)
		(rev (cons (car l)
			   (rev (cdr a1)))))))))

  (defun swap (l) (cons (car (cdr l)) (cons (car l) (cdr (cdr l)))))

  ;; originally from
  ;; : rev 
  ;;   depth 0= if 
  ;;   else depth 1 = if
  ;;   else depth 2 = if swap
  ;;   else >r recurse >r recurse r> r> swap r> recurse >r;
  ;; or similar.

  ;; condition tests

  (defun test-let/cc (x)
    (let/cc foo 
       (if (= x 0) (foo 2)
	 3)
       (print 3)))

  (defun test-unwind-protect (x)
    (unwind-protect 
	(+ 1 nil)
      (print "Yowzer")))

  (defun test-with-handler (x)
    (with-handler (lambda (a b)
		    (print "error"))
	 (+ 1 nil)))

  (defun std-open (file)
    (let/cc ouch
	    (with-handler (lambda (a b) (print "recovering...") (ouch nil))
			  (open file 'input))))

  ;; end module
)
  (defun xxx x
    x)

  (defun yyy (x . y) 
    (list y x))
   
  (defun aaa (x y z)
    (print (xxx))
    (print (xxx 1 2 3))
    (print (yyy 1))
    (print (yyy 1 2))
    (print (yyy 1 2 3)))


(de rev (l)
    (cond ((null l) l)
	  ((null (cdr l)) l)
	  (t ((lambda (a1)
		(cons (car a1)
		      (rev (cons (car l)
				 (rev (cdr a1))))))
	      (rev (cdr l))))))
