

/* ****************************************************************** */
/* Function : EmptyList.c
 * 
 * Author   : J.Paul Schmidt.
 * 
 * Cree le  : 88/04/12 Version  : 1.2
 * 
 * Modifications : 90/01/18 Author   : Reason   :
 * 
 * Implemented functionality : Test if a list is empty.
 * 
 * Input parameters : List identifier. (Pointer to le first element of the list.)
 * Output parameter : 1 if empty list, 0 else -1 if error... */
/* ****************************************************************** */

#include "ListeP.h"

long EmptyList (
#if NeedFunctionPrototypes
  Liste s_idlist		/* list to process indentifier */
)
#else
s_idlist)
  Liste s_idlist ;          /* list to process indentifier */
#endif

{
  ty_list *p_firstelem;		/* Pointer to the list to process */

#ifdef debug
  (void) fprintf (stderr, " Function : EmptyList \n");
#endif

  /* Parameter transformation */
  p_firstelem = (ty_list *) s_idlist;

  /* Prarameters checking */
  Lst_TestPar (p_firstelem, "NULL POINTER AS PARAMETER \n", ERRNU);

  /* Test si la list est vide */
  if (p_firstelem->num == 0) {

#ifdef debug
    (void) fprintf (stderr, " End of : EmptyList  : TRUE \n");
#endif

    return (1);
  }
  else {

#ifdef debug
    (void) fprintf (stderr, " End of : EmptyList  : FALSE  \n");
#endif

    return (0);
  };				/* End of the if (p_firstelem == NULL) */

}				/* End of EmptyList */
