/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

Name : OpenOutFile
Type : int
Written on   : 14-Nov-90     By : A. Etemadi
Modified on  :               By : 
Directory    : ~atae/ORT/ORT/LPEG/src/MiscRoutines

==============================================================================

Input parameters    : 
 OutFileName	--   Name of output file 

Output parameters   : 
 p_OutFile	--   Pointer to start of Output file

Output result       : 
 0 = successful, 
 1 = error

Calling procedure:

 char *OutFileName;
 FILE *p_OutFile;

 OpenOutFile(OutFileName, &p_OutFile)

Functionality: 
 Open a file for write access. On successfull completion this function returns 
 the pointer to the start of the file into p_OutFile.

----------------------------------------------------------------------------*/

#include <stdio.h>     /* Standard C I/O library */
#include <math.h>      /* Standard C mathematics library */
#include <errno.h>     /* Standard C error handling routines */
/* #include <strings.h> */   /* Standard C string handling routines */
#include <ctype.h>     /* Standard C type identification routines */

int OpenOutFile (OutFileName,
		   p_OutFile)

       char *OutFileName; 	/* Name of Output file */
	FILE *(*p_OutFile);	/* Pointer to start of file */
     
 { 

#ifdef debug
	  fprintf(stderr," Start of function OpenOutFile \n");
#endif

/*
 Open file for reading
*/
	  *p_OutFile = fopen(OutFileName,"w");

	  if ( (*p_OutFile) == NULL) {
             fprintf(stderr," NULL pointer returned when opening file %s \n",OutFileName);
	      exit(-1);
	  }

	  fseek(*p_OutFile,0,0);
	  return(0);

#ifdef debug
	  fprintf(stderr," End of function OpenOutFile \n");
#endif

 }
