/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

Name : LineSegRowIntercept
Type : int
Written on   : 20-Nov-90     By : A. Etemadi
Modified on  :               By : 
Directory    : ~atae/ORT/ORT/LPEG/src/LineRoutines

==============================================================================

Input parameters    : 

 StartCol		-- The column number of the start point of the line
 StartRow		-- The row number of the start point of the line
 EndCol		-- The column number of the end point of the line
 EndRow		-- The row number of the end point of the line 

Output result       : 

 -1 = Intercept point is at infinity (ie line is vertical)
  0 = successful in calculating gradient

Output parameters   :

 RowIntercept		-- Intercept of the line (y = m.x + c) with y axis

Calling procedure:

 double StartCol;
 double StartRow;
 double EndCol;
 double EndRow;

 double RowIntercept;

 LineSegRowIntercept( StartCol,
  		     StartRow,
		     EndCol,
                   EndRow,
		    &RowIntercept)

Functionality: 

This function finds the intercept point of a line with the y axis, given 
any two points that lie along the line. 

----------------------------------------------------------------------------*/

#include <stdio.h>     /* Standard C I/O library */
#include <math.h>      /* Standard C mathematics library */
#include <errno.h>     /* Standard C error handling routines */
/* #include <strings.h> */   /* Standard C string handling routines */
#include <ctype.h>     /* Standard C type identification routines */

#ifndef HUGE
#define HUGE 999999999.0
#endif

int LineSegRowIntercept(StartCol,
		       StartRow,
		       EndCol,
		       EndRow,
		       RowIntercept)

 double StartCol;
 double StartRow;
 double EndCol;
 double EndRow;

 double *RowIntercept;

{

#ifdef debug
          fprintf(stderr," Start of function LineSegRowIntercept \n");
#endif

    if (EndCol != StartCol) {	/* Line is not vertical */
	*RowIntercept = (EndCol*StartRow - StartCol*EndRow)/
		 	        (EndCol - StartCol); 
	return(0);
    }

  *RowIntercept = HUGE;	/* Line is vertical */
  return(-1);

#ifdef debug
          fprintf(stderr," End of function LineSegRowIntercept \n");
#endif

}
