/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

Name : LineLength
Type : double
Written on   : 20-Nov-90     By : A. Etemadi
Modified on  :               By : 
Directory    : ~atae/ORT/ORT/LPEG/src/LineRoutines

==============================================================================

Input parameters    : 
Following parameters are end points of lines. They could be line data produced
by the routine ReadHTLine

 StartCol		-- The column number of the start point of the line
 StartRow		-- The row number of the start point of the line
 EndCol		-- The column number of the end point of the line
 EndRow		-- The row number of the end point of the line

Output result       : 
 Length		-- Length of the line

Calling procedure:

 double StartCol;
 double StartRow;
 double EndCol;
 double EndRow;

 Length_of_my_bloody_line = LineLength( StartCol,
					     StartRow,
					     EndCol,
                                        EndRow)


Functionality: 

This function finds the length of a line given its end points.
Note: the center of the image is used as the origin for the rows 
and columns. This is not important here but it may be for other 
functions which handle lines so look out! Also this function does
no error checking ie overflow, underflow etc.. Want to include it yourself ?

----------------------------------------------------------------------------*/

#include <stdio.h>     /* Standard C I/O library */
#include <math.h>      /* Standard C mathematics library */
#include <errno.h>     /* Standard C error handling routines */
/* #include <strings.h> */   /* Standard C string handling routines */
#include <ctype.h>     /* Standard C type identification routines */

double LineLength(StartCol,
		    StartRow,
		    EndCol,
		    EndRow)

 double StartCol;
 double StartRow;
 double EndCol;
 double EndRow;

{

 double dx,dy; 

 double Length;

#ifdef debug
          fprintf(stderr," Start of function LineLength \n");
#endif

  dx = EndCol - StartCol;
  dy = EndRow - StartRow;

  Length = hypot( dx , dy );

  return(Length);

#ifdef debug
          fprintf(stderr," End of function LineLength \n");
#endif

}

