/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

Name : CPEG.h
Type : header file
Written on   : 14-July-91    By : A. Etemadi
Modified on  :               By : 
Directory    : ~atae/ORT/ORT/Incs

All Constants are in uppercase. 
All Macro names start with the letters MAC

----------------------------------------------------------------------------*/

/* 
 				TYPES
*/ 

/* 
  A ORT line. 0,0 is the center of the image, and +x, and +y are rightward, and
upward. Theta = 0, and 180 are along the x axis, Theta = 90 is along the y axis. 

*/

  struct ORTCurve {
		int 	  ID;	  	/* ID number associated with the line */
		int 	  RC;	  	/* Recency of the line */
	struct ORTPoint Start;	/* Start point of the line */
	struct ORTPoint End;	  	/* End point of the line */
	struct ORTPoint MidPoint; 	/* Midpoint of the line */
	double	Length;		/* Length of the line in pixels */
	double	LengthParlVar;	/* Variance in the length of the line */
					/* parallel to the direction of the line (empirical) */
	double	LengthPerpVar;	/* Variance in the length of the line */
					/* perpendicular to the direction of the line (empirical) */
	double	Theta;		  	/* Orientation of the line pi < Theta <= 0 */
	double	ThetaVar;		/* Variance in the line orientation (empirical) */
  };

/* 
 A pair of lines forming a Lambda junction.

*/

  struct ORTLambdaJunction {  	
	int 	  FirstID;  		/* ID number associated with the 1st line */
	int 	  SecondID;  		/* ID number associated with the 2nd line */
       int 	  ip;			/* ip=1 junction pt on 1st line */
       				/* ip=2 junction pt on 2nd line */
       				/* ip=3 junction pt on both lines */
       int 	  jp1;			/* jp=0 junction pt is closest to StartCol,StartRow of line 1*/
					/* jp=1 junction pt is closest to EndCol,EndRow of line 1 */
	int 	  jp2;			/* jp=0 junction pt is closest to StartCol,StartRow of line 2 */
					/* jp=1 junction pt is closest to EndCol,EndRow of line 2 */
       struct ORTPoint JunctionPt; /* Junction point */
	double	  Quality; 		/* Quality of Lambda junction */
  };

/* 
 				FUNCTIONS

*/ 

