/*
 * file:     styleMenu.c
 * author:   Wes Barris
 * date:     5/07/92
 * purpose:  creates Style menu
 *
 * copyright info:
 *
 *    @Copyright 1992
 *    Research Equipment Inc. dba Minnesota Supercomputer Center
 *
 * RESTRICTED RIGHTS LEGEND
 *
 * Use, duplication, or disclosure of this software and its documentation
 * by the Government is subject to restrictions as set forth in subdivision
 * { (b) (3) (ii) } of the Rights in Technical Data and Computer Software
 * clause at 52.227-7013.
 */

#include "desi.h"
#include "proto.h"
#include "PSutils.h"
#include <X11/StringDefs.h>
#include <Xm/CascadeB.h>
#include <Xm/Form.h>
#include <Xm/Label.h>
#include <Xm/RowColumn.h>
#include <Xm/ToggleB.h>
#include <Xm/Scale.h>
#include <Xm/Separator.h>
#include "Umsc/List.h"

Widget	styleMenu;

extern DESI		desi;
extern UmscList		theList;
extern GenericInfo	defaultInfo;
extern TextInfo		selectedText;

static Widget		textRGBPanel = NULL,
			red, grn, blu;

static void
SetStyleCB(w, client_data, call_data)
Widget				w;
int				client_data;
XmToggleButtonCallbackStruct	*call_data;
{
   GenericInfo	*thisObject;
   int		n;
/*
 * Return if the button is unselected or if this event was triggered by
 * calling XmToggleButtonSetState.
 */
   if (!call_data->set || !call_data->event)
      return;
/*
 * Make a valid font name for both the default text and any selected text.
 */
   strcpy(defaultInfo.u.text.fontname,
          MakeName(defaultInfo.u.text.font, client_data));
   strcpy(selectedText.fontname, MakeName(selectedText.font, client_data));
   selectedText.fontstyle = defaultInfo.u.text.fontstyle = client_data;
/*
 * Are there any selected text objects?
 */
   thisObject = UmscListSetCurrent(theList, UmscFIRST);
   for (n=0; n<UmscListGetCount(theList); n++) {
      if (thisObject->objtype == TXTOBJ && thisObject->selected == True) {
         thisObject->u.text.font = selectedText.font;
         thisObject->u.text.fontstyle = selectedText.fontstyle;
         strcpy(thisObject->u.text.fontname, selectedText.fontname);
         DrawText(thisObject);
         }
      thisObject = UmscListGetNext(theList);
      }
}


static struct {
   char   *name;         /* name of menu item widget */
   void   (*func)();      /* callback function */
   int    data;
   } items[] = {
      { "normal",	SetStyleCB,	ROMAN		},
      { "bold",		SetStyleCB,	BOLD		},
      { "italic",	SetStyleCB,	ITALIC		},
      { "bolditalic",	SetStyleCB,	BOLDITALIC	},
      /*{ NULL,		NULL,		NULL},
      { "jleft",	SetJustifyCB,	JUSTIFY_LEFT},
      { "jcenter",	SetJustifyCB,	JUSTIFY_CENTER},
      { "jright",	SetJustifyCB,	JUSTIFY_RIGHT},
      { NULL,		NULL,		NULL},
      { "color",	ColorPanelCB,	NULL},*/
      };


static void
SetItemCB(w, client_data, call_data)
Widget			w;
char			*client_data;
XmAnyCallbackStruct	*call_data;
{
   int	i;
/*
 * Set the justify item so that it matches that of the selected text.
 */
   for (i = 0; i < XtNumber(items); i++) {
      if (items[i].data == selectedText.fontstyle) {
         XmToggleButtonSetState(XtNameToWidget(styleMenu, items[i].name), True, True);
         return;
         }
      else
         XmToggleButtonSetState(XtNameToWidget(styleMenu, items[i].name), False, False);
      }
}


void
StyleMenuInit(Widget parent)
{
   int		i, n;
   Arg		arg[10];
   Widget	w;

/*
 * Create pulldown menu.
 */
   n = 0;
   XtSetArg(arg[n], XmNradioBehavior, True); n++;
   styleMenu = XmCreatePulldownMenu(parent, "styleMenu", arg, n);
/*
 * Create the entries for the style menu.
 */
   for (i = 0; i < XtNumber(items); i++) {
      if (items[i].name != NULL) {
         w = XmCreateToggleButton(styleMenu, items[i].name, arg, 0);
         XtAddCallback(w, XmNvalueChangedCallback, (XtCallbackProc)items[i].func, (char *)items[i].data);
         }
      else 
         w = XmCreateSeparator(styleMenu, "sep", arg, 0);
      XtManageChild(w);
      }
/*
 * Create the Style cascade button.
 */
   n = 0;
   XtSetArg(arg[n], XmNsubMenuId, styleMenu); n++;
   w = XmCreateCascadeButton(parent, "style", arg, n);
   XtAddCallback(w, XmNcascadingCallback, (XtCallbackProc)SetItemCB, NULL);
   XtManageChild(w);
}
