/*
 * file:     sizeMenu.c
 * author:   Wes Barris
 * date:     5/07/92
 * purpose:  creates Size menu
 *
 * copyright info:
 *
 *    @Copyright 1992
 *    Research Equipment Inc. dba Minnesota Supercomputer Center
 *
 * RESTRICTED RIGHTS LEGEND
 *
 * Use, duplication, or disclosure of this software and its documentation
 * by the Government is subject to restrictions as set forth in subdivision
 * { (b) (3) (ii) } of the Rights in Technical Data and Computer Software
 * clause at 52.227-7013.
 */

#include "desi.h"
#include "proto.h"
#include <X11/StringDefs.h>
#include <Xm/CascadeB.h>
#include <Xm/Form.h>
#include <Xm/RowColumn.h>
#include <Xm/PushB.h>
#include <Xm/Scale.h>
#include <Xm/Separator.h>
#include <Xm/ToggleB.h>
#include "Umsc/List.h"

static Widget		sizeMenu,
			otherPanel,
			oscale;
extern DESI		desi;
extern UmscList		theList;
extern GenericInfo	defaultInfo;
extern TextInfo		selectedText;

static void
SetSizeCB(Widget w, XtPointer client_data, char *call_data)
{
   GenericInfo	*thisObject;
   int		n;
/*
 * Return if the button is unselected or if this event was triggered by
 * calling XmToggleButtonSetState.
 */
   if (!((XmToggleButtonCallbackStruct *)call_data)->set || !((XmToggleButtonCallbackStruct *)call_data)->event)
      return;
   if (defaultInfo.u.text.scale != atof(client_data)) {
      defaultInfo.u.text.scale = atof(client_data);
      selectedText.scale = defaultInfo.u.text.scale;
      }
/*
 * Are there any selected text objects?
 */
      thisObject = UmscListSetCurrent(theList, UmscFIRST);
      for (n=0; n<UmscListGetCount(theList); n++) {
         if (thisObject->objtype == TXTOBJ && thisObject->selected == True) {
            thisObject->u.text.scale = defaultInfo.u.text.scale;
            DrawText(thisObject);
            }
         thisObject = UmscListGetNext(theList);
         }
}


static void
SetOtherSizeCB(Widget w, XtPointer client_data, char *call_data)
{
   GenericInfo	*thisObject;
   int		n;

   if ((int)defaultInfo.u.text.scale != ((XmScaleCallbackStruct *)call_data)->value) {
      defaultInfo.u.text.scale = ((XmScaleCallbackStruct *)call_data)->value;
      selectedText.scale = defaultInfo.u.text.scale;
/*
 * Are there any selected text objects?
 */
      thisObject = UmscListSetCurrent(theList, UmscFIRST);
      for (n=0; n<UmscListGetCount(theList); n++) {
         if (thisObject->objtype == TXTOBJ && thisObject->selected == True) {
            thisObject->u.text.scale = defaultInfo.u.text.scale;
            DrawText(thisObject);
            }
         thisObject = UmscListGetNext(theList);
         }
      }
}



static void
OtherPopupInit(void)
{
   Arg		args[10];
   Widget	sep2,
		doneButton;
   int		n;
   n = 0;
   otherPanel = XmCreateFormDialog(desi.toplevel, "otherPanel", args, n);

   n = 0;
   XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM); n++;
   XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
   XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
   oscale = XtCreateWidget("oscale", xmScaleWidgetClass, otherPanel, args, n);
   XtAddCallback(oscale, XmNvalueChangedCallback, (XtCallbackProc)SetOtherSizeCB, NULL);
   XtManageChild(oscale);

   n = 0;
   XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
   XtSetArg(args[n], XmNtopWidget, oscale); n++;
   XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
   XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
   sep2 = XtCreateWidget("separator", xmSeparatorWidgetClass, otherPanel, args, n);
   XtManageChild(sep2);

   n = 0;
   XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
   XtSetArg(args[n], XmNtopWidget, sep2); n++;
   XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
   XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
   XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
   doneButton = XtCreateWidget("doneButton", xmPushButtonWidgetClass, otherPanel, args, n);
   XtManageChild(doneButton);
}


static void
OtherPopupCB(w, client_data, call_data)
Widget				w;
char				*client_data;
XmPushButtonCallbackStruct	*call_data;
{
   if (!otherPanel)
      OtherPopupInit();
   XmScaleSetValue(oscale, (int)selectedText.scale);
   XtManageChild(otherPanel);
}


static struct {
   char   *name;         /* name of menu item widget */
   void   (*func)();      /* callback function */
   } items[] = {
      { "10",		SetSizeCB	},
      { "20",		SetSizeCB	},
      { "30",		SetSizeCB	},
      { "40",		SetSizeCB	},
      { "50",		SetSizeCB	},
      { "60",		SetSizeCB	},
      { "70",		SetSizeCB	},
      { "80",		SetSizeCB	},
      { NULL,		NULL		},
      { "other",	OtherPopupCB	},
      };

static void
SetItemCB(w, client_data, call_data)
Widget			w;
char			*client_data;
XmAnyCallbackStruct	*call_data;
{
   char	str[3];
   int	i;
/*
 * Set the size item so that it matches that of the selected text.
 */
   sprintf(str, "%2d", (int)selectedText.scale);
   for (i = 0; i < XtNumber(items)-2; i++) {
      /*if (items[i].name == NULL)
         ;
      else*/ if (!strcmp(items[i].name, str)) {
         XmToggleButtonSetState(XtNameToWidget(sizeMenu, str), True, True);
         return;
         }
      else
         XmToggleButtonSetState(XtNameToWidget(sizeMenu, items[i].name), False, False);
      }
}


void
SizeMenuInit(Widget parent)
{
   int		i, n;
   Arg		arg[10];
   Widget	w;

/*
 * Create pulldown menu.
 */
   n = 0;
   XtSetArg(arg[n], XmNradioBehavior, True); n++;
   XtSetArg(arg[n], XmNradioAlwaysOne, False); n++;
   sizeMenu = XmCreatePulldownMenu(parent, "sizeMenu", arg, n);
/*
 * Create the entries for the size menu.
 */
   for (i = 0; i < XtNumber(items); i++) {
      if (items[i].name == NULL)
         w = XmCreateSeparator(sizeMenu, "sep", arg, 0);
      else if (!strcmp(items[i].name, "other")) {
         w = XmCreatePushButton(sizeMenu, items[i].name, arg, 0);
         XtAddCallback(w, XmNactivateCallback, (XtCallbackProc)items[i].func, items[i].name);
         }
      else {
         w = XmCreateToggleButton(sizeMenu, items[i].name, arg, 0);
         XtAddCallback(w, XmNvalueChangedCallback, (XtCallbackProc)items[i].func, items[i].name);
         }
      XtManageChild(w);
      }
/*
 * Create the Edit cascade button.
 */
   n = 0;
   XtSetArg(arg[n], XmNsubMenuId, sizeMenu); n++;
   w = XmCreateCascadeButton(parent, "size", arg, n);
   XtAddCallback(w, XmNcascadingCallback, (XtCallbackProc)SetItemCB, NULL);
   XtManageChild(w);
}
