/*
 * file:     icon.c
 * author:   Wes Barris
 * date:     8/10/92
 * purpose:  inits the desi icon used for both the about box and iconify
 *
 * copyright info:
 *
 *                           @Copyright 1992
 *      Research Equipment Inc. dba Minnesota Supercomputer Center
 *
 * RESTRICTED RIGHTS LEGEND
 *
 * Use, duplication, or disclosure of this software and its documentation
 * by the Government is subject to restrictions as set forth in subdivision
 * { (b) (3) (ii) } of the Rights in Technical Data and Computer Software
 * clause at 52.227-7013.
 */

#include "desi.h"
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <Xm/Xm.h>
#include "Desi.xpm"

extern DESI	desi;


/*
 * InitIcon:  creates a desi pixmap.
 */
void
InitIcon(void)
{
   Arg		args[1];
   XImage	*image;
   XColor	*colors;
   XVisualInfo	vTemplate, *visualList;
   int		visualsMatched;
   int		x,y,i,n;
   char		*data;
/*
 * First find an 8 bit pseudocolor visual.
 */
   vTemplate.screen = DefaultScreen(XtDisplay(desi.toplevel));
   vTemplate.depth  = 8;
   vTemplate.class  = PseudoColor;
   visualList = XGetVisualInfo(XtDisplay(desi.toplevel),
                VisualScreenMask | VisualDepthMask | VisualClassMask,
                &vTemplate, &visualsMatched);
   if (visualsMatched == 0) {
      fprintf(stderr, "I can't find an 8 bit color mapped visual.\n");
      exit(1);
      }
/*
 * Paul's icon code to show my Desi picture.
 */
                        /*DefaultVisualOfScreen(XtScreen(desi.toplevel)),
                        DefaultDepthOfScreen(XtScreen(desi.toplevel)),*/
                        /*visualList[0].visual,
                        vTemplate.depth,*/
   image = XCreateImage(XtDisplay(desi.toplevel),
                        visualList[0].visual,
                        vTemplate.depth,
                        ZPixmap,
                        0,
                        NULL,
                        desi_width,
                        desi_height,
                        vTemplate.depth,
                        0);
   XFree((char *)visualList);

   image->data = (char *)XtMalloc(desi_width*desi_height);
   colors = (XColor *)XtMalloc(sizeof(XColor)*desi_ncolors);

   for (i=0; i<desi_ncolors; i++) {
      XParseColor(XtDisplay(desi.toplevel),
                  DefaultColormapOfScreen(XtScreen(desi.toplevel)),
                  desi_colors[i*2+1],&colors[i]);
      XAllocColor(XtDisplay(desi.toplevel),
                  DefaultColormapOfScreen(XtScreen(desi.toplevel)),
                  &colors[i]);
      }
   for (y=0; y<desi_height; y++) {
      data = desi_pixels[y];
      for (x=0; x<desi_width; x++)
         for (i=0; i<desi_ncolors; i++)
            if (strncmp(data, desi_colors[i*2], desi_chars_per_pixel) == 0) {
               XPutPixel(image,x,y,colors[i].pixel);
               data += desi_chars_per_pixel;
               break;
               }
      }
   if (!XmInstallImage(image,"desiIcon"))
      fprintf(stderr, "Could not install desi icon image.\n");
/*
 * This smidgen of code will attempt to load the pixmap into the default
 * iconPixmap. However, X only allows 2 colors for the icon pixmap :'(
 */
   /*n = 0;
   XtSetArg(args[n], XmNiconPixmap,
            XmGetPixmap(XtScreen(desi.toplevel), "desiIcon",
            colors[1].pixel, colors[desi_ncolors-2].pixel)); n++;
   XtSetValues(desi.toplevel, args, n);*/
}
