/*
 * file:     decPanel.c
 * author:   Wes Barris
 * date:     12/16/92
 * purpose:  creates decoration panel
 *
 * copyright info:
 *
 *    @Copyright 1992
 *    Research Equipment Inc. dba Minnesota Supercomputer Center
 *
 * RESTRICTED RIGHTS LEGEND
 *
 * Use, duplication, or disclosure of this software and its documentation
 * by the Government is subject to restrictions as set forth in subdivision
 * { (b) (3) (ii) } of the Rights in Technical Data and Computer Software
 * clause at 52.227-7013.
 */

#include "desi.h"
#include "proto.h"
#include <Xm/RowColumn.h>
#include <Xm/PushB.h>
#include <Xm/Scale.h>
#include <Xm/SelectioB.h>
#include <Xm/Separator.h>
#include <Xm/ToggleB.h>
#include "Umsc/List.h"

extern DESI		desi;
extern UmscList		theList;
extern GenericInfo	defaultInfo;
extern GenericInfo	selectedObject;

static Widget		decPanel = NULL,
			dropShadow,
			border,
			decSize;


static void
ApplyDecorationCB(w, client_data, call_data)
Widget                          w;
int                             client_data;
XmToggleButtonCallbackStruct    *call_data;
{
   GenericInfo  *thisObject;
   int          n, offset, decstyle;

   if (XmToggleButtonGetState(dropShadow)) {
      XmScaleGetValue(decSize, &offset);
      decstyle = DROP_SHADOW;
      }
   else if (XmToggleButtonGetState(border)) {
      XmScaleGetValue(decSize, &offset);
      decstyle = BORDER;
      }
   else {
      offset = 0;
      decstyle = 0;
      }
/*
 * Are there any selected text objects?
 */
   thisObject = UmscListSetCurrent(theList, UmscFIRST);
   for (n=0; n<UmscListGetCount(theList); n++) {
      if (thisObject->selected == True) {
         thisObject->decoration = decstyle;
         thisObject->dec_size = offset;
         DrawObject(thisObject);
         }
      thisObject = UmscListGetNext(theList);
      }
}


static void
FinalizeItCB(w, client_data, call_data)
Widget                          w;
int                             client_data;
XmToggleButtonCallbackStruct    *call_data;
{
   int	offset, decstyle;

   if (XmToggleButtonGetState(dropShadow)) {
      XmScaleGetValue(decSize, &offset);
      decstyle = DROP_SHADOW;
      }
   else if (XmToggleButtonGetState(border)) {
      XmScaleGetValue(decSize, &offset);
      decstyle = BORDER;
      }
   else {
      offset = 0;
      decstyle = 0;
      }
   defaultInfo.decoration = decstyle;
   defaultInfo.dec_size = offset;
}


static void
CancelCB(w, client_data, call_data)
Widget                          w;
int                             client_data;
XmToggleButtonCallbackStruct    *call_data;
{
   GenericInfo  *thisObject;
   int          n, offset, decstyle;
/*
 * Reset the controls back to the default value.
 */
   offset = selectedObject.dec_size;
   decstyle = selectedObject.decoration;
   if (decstyle == DROP_SHADOW) {
      XmToggleButtonSetState(dropShadow, True, False);
      XmScaleSetValue(decSize, offset);
      }
   else if (decstyle == BORDER) {
      XmToggleButtonSetState(border, True, False);
      XmScaleSetValue(decSize, offset);
      }
   else {
      XmToggleButtonSetState(dropShadow, False, False);
      XmToggleButtonSetState(border, False, False);
      }
/*
 * If there are any selected objects, reset them to the default value.
 */
   thisObject = UmscListSetCurrent(theList, UmscFIRST);
   for (n=0; n<UmscListGetCount(theList); n++) {
      if (thisObject->selected == True) {
         thisObject->decoration = decstyle;
         thisObject->dec_size = offset;
         DrawObject(thisObject);
         }
      thisObject = UmscListGetNext(theList);
      }
}



static Widget
InitDecPanel(void)
{
   Arg		args[10];
   Widget	work,
		rc,
		decColor;
   int		n;

   n = 0;
   decPanel = XmCreatePromptDialog(desi.toplevel, "decPanel", args, n);
   XtUnmanageChild(XmSelectionBoxGetChild(decPanel, XmDIALOG_TEXT));
   XtUnmanageChild(XmSelectionBoxGetChild(decPanel, XmDIALOG_SELECTION_LABEL));
   XtUnmanageChild(XmSelectionBoxGetChild(decPanel, XmDIALOG_HELP_BUTTON));
   XtManageChild(XmSelectionBoxGetChild(decPanel, XmDIALOG_APPLY_BUTTON));

   n = 0;
   work = XmCreateWorkArea(decPanel, "work", args, n);
   XtManageChild(work);

   n = 0;
   rc = XmCreateRowColumn(work, "rc", args, n);
   XtManageChild(rc);

   n = 0;
   dropShadow	= XtCreateManagedWidget("dropShadow", xmToggleButtonWidgetClass,
                                rc, args, n);
   n = 0;
   border	= XtCreateManagedWidget("border", xmToggleButtonWidgetClass,
                                rc, args, n);
   n = 0;
   decSize = XtCreateManagedWidget("decSize", xmScaleWidgetClass,
                                work, args, n);
   n = 0;
   decColor	= XtCreateManagedWidget("decColor", xmPushButtonWidgetClass,
                                work, args, n);

   XtAddCallback(decColor, XmNactivateCallback, (XtCallbackProc)ApplyDecorationCB, (XtPointer)NULL);
   XtAddCallback(decColor, XmNactivateCallback, (XtCallbackProc)unmanageCB, (XtPointer)decPanel);
   XtAddCallback(decColor, XmNactivateCallback, (XtCallbackProc)ColorPanelCB, (XtPointer)2);
   XtAddCallback(decPanel, XmNokCallback, (XtCallbackProc)ApplyDecorationCB, (XtPointer)NULL);
   XtAddCallback(decPanel, XmNokCallback, (XtCallbackProc)FinalizeItCB, (XtPointer)NULL);
   XtAddCallback(decPanel, XmNapplyCallback, (XtCallbackProc)ApplyDecorationCB, (XtPointer)NULL);
   XtAddCallback(decPanel, XmNcancelCallback, (XtCallbackProc)CancelCB, (XtPointer)NULL);

   return decPanel;
}


/*
 * This routine is called when the decoration item is selected from the edit
 * menu.
 */
void
DecorationCB(Widget w, XtPointer client_data, char *call_data)
{
   GenericInfo  *thisObject;
   int		n;

   if (decPanel == NULL)
      decPanel = InitDecPanel();
/*
 * Are there any selected text objects?
 */
   thisObject = UmscListSetCurrent(theList, UmscFIRST);
   for (n=0; n<UmscListGetCount(theList); n++) {
      if (thisObject->selected == True) {
         if (thisObject->decoration == DROP_SHADOW) {
            XmToggleButtonSetState(dropShadow, True, False);
            XmToggleButtonSetState(border, False, False);
            XmScaleSetValue(decSize, selectedObject.dec_size);
            XtManageChild(decPanel);
            return;
            }
         else if (thisObject->decoration == BORDER) {
            XmToggleButtonSetState(border, True, False);
            XmToggleButtonSetState(dropShadow, False, False);
            XmScaleSetValue(decSize, selectedObject.dec_size);
            XtManageChild(decPanel);
            return;
            }
          else {
            XmToggleButtonSetState(dropShadow, False, False);
            XmToggleButtonSetState(border, False, False);
            XtManageChild(decPanel);
            return;
            }



         }
      thisObject = UmscListGetNext(theList);
      }
/*
 * No objects were selected -- set controls to default values.
 */
   if (defaultInfo.decoration == DROP_SHADOW) {
      XmToggleButtonSetState(dropShadow, True, False);
      XmScaleSetValue(decSize, defaultInfo.dec_size);
      }
   else
      XmToggleButtonSetState(dropShadow, False, False);
   XtManageChild(decPanel);
}
