/*
 * This software is copyrighted as noted below.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is
 * preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the author, who may or may not act on them as he desires.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 */
/*
 * chroma.c - do a chroma with two images.
 *
 * Author:      Raul Rivero
 *              Mathematics Dept.
 *              University of Oviedo
 * Date:        Mon Jan 6 1992
 * Copyright (c) 1992, Raul Rivero
 *
 */

#include <lug.h>
#include <lugfnts.h>

chroma_bitmaps(basebitmap, superbitmap, outbitmap)
bitmap_hdr *basebitmap, *superbitmap;
bitmap_hdr *outbitmap;
{
  int totalsize = basebitmap->xsize * basebitmap->ysize;

  if ( superbitmap->xsize != basebitmap->xsize ||
       superbitmap->ysize != basebitmap->ysize )
    error( 12 );

  if ( basebitmap->magic != LUGUSED )
    error( 19 );

  /* A RGB image ? */
  if ( basebitmap->depth != 24 )
    error(7);

  /*
   * Chroma modifies the base image, so we
   * copy ( and save ) it.
   */
  copy_bitmap( basebitmap, outbitmap );
  chroma( outbitmap, superbitmap );

  /* No errors */
  return 0;
}

chroma( base, super )
bitmap_hdr *base;
bitmap_hdr *super;
{
  register int i, j;
  byte *r1, *g1, *b1;
  byte *r2, *g2, *b2;

  /* Set pointers */
  r1= base->r , g1= base->g , b1= base->b;
  r2= super->r, g2= super->g, b2= super->b;

  for ( i = 0; i < super->ysize; i++ ) {
    for ( j = 0; j < base->xsize; j++ ) {
      if ( j < super->xsize ) {
        /* We are into super image */
        if ( (*r2 + *g2 + *b2) < CHROMABORDER ) {
          r1++, g1++, b1++;
          r2++, g2++, b2++;
        }else {
          *r1++ = *r2++;
          *g1++ = *g2++;
          *b1++ = *b2++;
        }
      }else {
        /* Out of super borders */
        r1++, g1++, b1++;
      }
    }
  }
}
