/*
 * This software is copyrighted as noted below.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is
 * preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the author, who may or may not act on them as he desires.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 */
/*
 * vfr.c - interface with SGI's Video FRamer.
 *
 * Author:      Raul Rivero
 *              Mathematics Dept.
 *              University of Oviedo
 * Date:        Thu Jan 16 1992
 * Copyright (c) 1992, Raul Rivero
 *
 */

#include <lug.h>
#include <lugfnts.h>


/*
 * Look here !!!
 * =============
 *
 * This code is valid only if we have defined the iVFR
 * macro ( read the root Makefile for more information ).
 *
 */


#ifdef iVFR

#include "image.h"
#include "vframer.h"

#define VIDEO_BUFFER_NAME		"r_y_625"
#define VFRLINESIZE             	1024

write_vfr( bitmap, resetVFR, VFRbuffer )
bitmap_hdr *bitmap;
int resetVFR;
char *VFRbuffer;
{
  register int y, x;
  VFR_DEV *vfr;
  byte *ptr;
  int totalsize = bitmap->ysize * bitmap->xsize;
  byte *r, *g, *b;
  int offset;
  int flag;
  char *videomode;

  /* An image ? */
  if ( bitmap->magic != LUGUSED )
    error( 19 );

  /* We need a RGB image */
  if ( bitmap->depth < 24 )
    error( 7 );

  /*
   * Open the Video FRamer.
   */
  flag = ( resetVFR ? VFR_CUSTOM_SETUP : -VFR_CUSTOM_SETUP );
  videomode = ( VFRbuffer ? VFRbuffer : VIDEO_BUFFER_NAME );
  if ( !(vfr = vfr_open( DEFAULT_VFR_ADDR, flag, videomode )) )
    error( 16 );

  /*
   * Pointers to VF's shadow memory and
   * image components.
   */
  ptr =  (byte *) VFR_DEVICE_PSHADOW( *vfr );
  r = bitmap->r;
  g = bitmap->g;
  b = bitmap->b;
  offset = 4 * ( VFRLINESIZE - bitmap->xsize );

  for ( y = 0; y < bitmap->ysize; y += 2 ) {
    /*
     * Odd lines.
     */
    for ( x = 0; x < bitmap->xsize; x++ ) {
      *ptr++ = 0;
      *ptr++ = *b++;
      *ptr++ = *g++;
      *ptr++ = *r++;
    }
    /*
     * Fill unused line with 0's.
     */
    bzero( ptr, offset );
    ptr += offset;

    /*
     * Non odd lines.
     */
    for ( x = 0; x < bitmap->xsize; x++ ) {
      *ptr++ = 0;
      *ptr++ = *b++;
      *ptr++ = *g++;
      *ptr++ = *r++;
    }
    bzero( ptr, offset );
    ptr += offset;
  }

  /*
   * Now we have the image into shadow memory, so write
   * it to VFR.
   */
  if ( !vfr_convert_from_rgb( vfr, bitmap->xsize ) )
    error( 10 );
}


#endif  /* iVFR */
