 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>              xvobject Creation Code
   >>>>
   >>>>  Private:
   >>>>		create_interface()
   >>>>   Static:
   >>>>		keylist_callback()
   >>>>
   >>>>   Public:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "kdbmedit.h"
#include "keyinfo.h"

xvobject	xv_keydata;
xvobject	xvoDescription;
kform_struct   *keylist;
int		selected_key;

int		selected_addkey;
kstring         selected_addstring;


/*-----------------------------------------------------------
| Routine Name:	create_interface - create xvobjects
|
| Purpose:	create_interface() creates the xvobjects needed by
|		kdbmedit which can't be described in the UIS file.
|
| Input:	workspace - workspace widget to put the text widget in.
|
| Returns:	TRUE on success, FALSE on failure
|
| Written By:	Neil Bowers
| Date:		22-aug-93
------------------------------------------------------------*/
int
create_interface(
   xvobject	workspace)
{
   int		width, height;


   selected_key = -1;

   /*-- get width of workspace --*/
   xvw_get_attributes(workspace,
		      XVW_WIDTH,		&width,
		      XVW_HEIGHT,		&height,
		      NULL);
   xvw_set_attributes(workspace,
		      XVW_MAXIMUM_WIDTH,	width,
		      XVW_MAXIMUM_HEIGHT,	height,
		      NULL);

   xvf_set_attributes(gui_info->kdbmedit->addpane->allkeys_struct,
		      XVF_LIST_SIZE,		knumber(kcmskeys),
		      XVF_LIST_CONTENTS,	kcmskeys,
		      NULL);

   keylist = gui_info->kdbmedit->keylist_struct;

   xv_keydata = xvw_create_textdisplay(workspace, "key-data");
   xvw_set_attributes(xv_keydata,
		      XVW_BORDER_WIDTH,			1,
		      XVW_TACK_EDGE,			KMANAGER_TACK_ALL,
		      XVW_TEXTDISPLAY_CLEARTEXT,	TRUE,
		      NULL);

   xvoDescription = xvw_create_text(gui_info->kdbmedit->addpane->workspace,
				    "key-description");
   xvw_set_attributes(xvoDescription,
		      XVW_BORDER_WIDTH,		1,
		      XVW_TEXT_MULTILINE,	TRUE,
		      XVW_TACK_EDGE,		KMANAGER_TACK_ALL,
		      XVW_TEXT_TYPE,		KTEXT_TYPE_STRING,
		      XVW_TEXT_EDIT_TYPE,	KTEXT_READ,
		      XVW_TEXT_STRING,		"",
		      NULL);

   return TRUE;
}

/*-----------------------------------------------------------
| Routine Name:	select_addkey - handler for list of valid keys
|
| Purpose:	This is the handler function invoked when the user
|		selects a key from the list of valid keys,
|		on the "Add Key" pane.
|
| Written By:	Neil Bowers
| Date:		13-jan-95
------------------------------------------------------------*/
void
select_addkey(
   int  key_id)
{
   key_id--;
   selected_addkey = key_id;
   selected_addstring = kcmskeys[key_id];
   xvw_set_attribute(xvoDescription, XVW_TEXT_STRING, key_descriptions[key_id]);
}
