 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Form Info Structure for kdbmedit Form
   >>>> 
   >>>>    Written By: conductor -name kdbmedit -l 3
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 08, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _form_info_h_
#define _form_info_h_

#include <xvinclude.h>

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

/*
 * Pane Info Struct for 'pane' Pane
 */
typedef struct _kdbmedit_pane{

xvobject     workspace;          /* address of workspace 'workspace'*/
kform_struct *workspace_struct;  /* pass to xvf_set_attributes() */

} kdbmedit_pane;

/*
 * Pane Info Struct for 'addpane' Pane
 */
typedef struct _kdbmedit_addpane{

int          allkeys;          /* int value of 'allkeys'*/
char         *allkeys_label;   /* label representing int value of 'allkeys'*/
kform_struct *allkeys_struct;  /* pass to xvf_set_attributes() */
int          allkeys_selected; /* TRUE on <cr> for 'allkeys' */

xvobject     workspace;          /* address of workspace 'workspace'*/
kform_struct *workspace_struct;  /* pass to xvf_set_attributes() */

int          addkey;          /* TRUE when user clicks on 'addkey'*/
kform_struct *addkey_struct;  /* pass to xvf_set_attributes() */

char         *custom;         /* string for 'custom'*/
kform_struct *custom_struct;  /* pass to xvf_set_attributes() */
int          custom_selected; /* TRUE on <cr> for 'custom' */

kform_struct *description_struct; /* pass to xvf_set_attributes() */

} kdbmedit_addpane;

/*
 * Subform Info Struct for 'kdbmedit' Subform
 */
typedef struct _form_kdbmedit {

kform_struct *options_struct; /* submenu button, pass to xvf_set_attributes() */

kform_struct *license_struct; /* pass to xvf_set_attributes() */

kform_struct *help_struct; /* pass to xvf_set_attributes() */

int          quit;         /* TRUE when user clicks on 'Quit' button */
kform_struct *quit_struct; /* pass to xvf_set_attributes() */

int          keylist;          /* int value of 'keylist'*/
char         *keylist_label;   /* label representing int value of 'keylist'*/
kform_struct *keylist_struct;  /* pass to xvf_set_attributes() */
int          keylist_selected; /* TRUE on <cr> for 'keylist' */

int          edit;          /* TRUE when user clicks on 'edit'*/
kform_struct *edit_struct;  /* pass to xvf_set_attributes() */

int          delete;          /* TRUE when user clicks on 'delete'*/
kform_struct *delete_struct;  /* pass to xvf_set_attributes() */

kform_struct *pixmap_struct; /* pass to xvf_set_attributes() */

kdbmedit_pane  *pane;          /* ptr to Pane Info struct for pane 'pane' */
int           pane_selected;          /* TRUE if input was from pane 'pane' */
kform_struct  *pane_struct;          /* pass to xvf_set_attributes() */

kdbmedit_addpane  *addpane;          /* ptr to Pane Info struct for pane 'addpane' */
int              addpane_selected;          /* TRUE if input was from pane 'addpane' */
kform_struct     *addpane_struct;          /* pass to xvf_set_attributes() */

}  form_kdbmedit;

/*
 * Form Info Struct for 'form' form
 */
typedef struct _gui_info_struct {

form_kdbmedit  *kdbmedit;
int kdbmedit_selected;
kform_struct *kdbmedit_struct;


 } gui_info_struct; 

        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void _xvf_free_form PROTO((gui_info_struct *));
void _xvf_get_form  PROTO((gui_info_struct *));

int  _xvf_init_form PROTO((kform *, gui_info_struct *));
void run_form       PROTO((kform *, ksubform *, kaddr));

void run_kdbmedit      PROTO((form_kdbmedit *));
void _xvf_get_kdbmedit PROTO((form_kdbmedit *));
void kdbmedit_keylist	PROTO((form_kdbmedit *));
void kdbmedit_edit	PROTO((form_kdbmedit *));
void kdbmedit_delete	PROTO((form_kdbmedit *));

void run_pane      PROTO((kdbmedit_pane *));
void _xvf_get_pane PROTO((kdbmedit_pane *));

void run_addpane      PROTO((kdbmedit_addpane *));
void _xvf_get_addpane PROTO((kdbmedit_addpane *));
void addpane_allkeys	PROTO((kdbmedit_addpane *));
void addpane_addkey	PROTO((kdbmedit_addpane *));
void addpane_custom	PROTO((kdbmedit_addpane *));




#endif /* _form_info_h_ */ 
/* Don't add after this point */
