 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Functionality routines for guidepane kdbmedit
   >>>> 
   >>>>  Private: 
   >>>> 	kdbmedit_keylist
   >>>> 	kdbmedit_edit
   >>>> 	kdbmedit_delete
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "kdbmedit.h"

/*-----------------------------------------------------------
| 
|  Routine Name: kdbmedit_keylist
| 
|       Purpose: Do routine which is called when
|                  displaylist selection keylist is used
| 
|         Input: kdbmedit_info - ptr to SubformInfo struct for subform kdbmedit
| 
|        Output: None
|    Written By: 
|          Date: Jan 13, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void kdbmedit_keylist(
     form_kdbmedit *kdbmedit_info)
{
   int		keyindex;
   char		*strKeyData;


   if (!xvf_get_attribute(keylist,XVF_LIST_INDEX,&keyindex))
      return;

   if ((strKeyData = get_dbm_item(keyindex)) == NULL)
      return;

   xvw_set_attribute(xv_keydata, XVW_TEXTDISPLAY_CLEARTEXT, TRUE);
   xvw_set_attribute(xv_keydata, XVW_TEXTDISPLAY_ADDTEXT, strKeyData);
   selected_key = keyindex;
}


/*-----------------------------------------------------------
| 
|  Routine Name: kdbmedit_edit
| 
|       Purpose: Do routine which is called when
|                  pane action button edit is used
| 
|         Input: kdbmedit_info - ptr to SubformInfo struct for subform kdbmedit
| 
| Written By:	Neil Bowers
| Date:		13-jan-94
------------------------------------------------------------*/
/* ARGSUSED */
void
kdbmedit_edit(
   form_kdbmedit *kdbmedit_info)
{
   (void)edit_dbm_item(selected_key);
}


/*-----------------------------------------------------------
| 
|  Routine Name: kdbmedit_delete
| 
|       Purpose: Do routine which is called when
|                  pane action button delete is used
| 
|         Input: kdbmedit_info - ptr to SubformInfo struct for subform kdbmedit
| 
|        Output: None
|    Written By: 
|          Date: Jan 13, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
kdbmedit_delete(
   form_kdbmedit *kdbmedit_info)
{
   delete_dbm_item(selected_key);
}


