 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Functionality routines for pane addpane
   >>>> 
   >>>>  Private: 
   >>>> 	addpane_allkeys
   >>>> 	addpane_addkey
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "kdbmedit.h"

extern kstring selected_addstring;

/*-----------------------------------------------------------
| Routine Name: addpane_allkeys - handler for list of valid keys
| 
| Purpose:	Do routine which is called when
|		displaylist selection allkeys is used
| 
| Input:	addpane_info - ptr to PaneInfo struct for addpane pane
| 
| Written By:	Neil Bowers
| Date:		13-jan-95
------------------------------------------------------------*/
void addpane_allkeys(
   kdbmedit_addpane *addpane_info)
{
   select_addkey(addpane_info->allkeys);
}


/*-----------------------------------------------------------
| Routine Name:	addpane_addkey - handler for "Add Key" button
| 
| Purpose:	Do routine which is called when
|		pane action button addkey is used
| 
| Input:	addpane_info - ptr to PaneInfo struct for addpane pane
| 
| Written By:	Neil Bowers
| Date:		13-jan-95
------------------------------------------------------------*/
/* ARGSUSED */
void
addpane_addkey(
   kdbmedit_addpane *addpane_info)
{
   add_dbm_item(selected_addstring);
}

/*-----------------------------------------------------------
| Routine Name:	addpane_custom - add a custom key typed in by the user
| 
| Purpose:	This function is invoked when the user hits RETURN in
|		the 'Add:' text selection on the 'Add key' pane.
| 
| Input:	addpane_info - ptr to PaneInfo struct for addpane pane
| 
| Written By:	Neil Bowers
| Date:		15-jan-1995
------------------------------------------------------------*/
void
addpane_custom(
   kdbmedit_addpane *addpane_info)
{
   add_dbm_item(addpane_info->custom);
   xvf_set_attribute(addpane_info->custom_struct, XVF_STRING_VAL, NULL);
}


