: # use perl
        eval 'exec perl -S $0 "$@"'
                if $runnning_under_some_shell;

# Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
# All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.

#----| list of files ok to edit
@editfiles	= ();
@arglist	= ();
@lockedfiles	= ();
$force		= 0;
$HOME		= $ENV{'HOME'};
$LOCKDB		= "$HOME/.vilock";
$TERM		= $ENV{'TERM'};
$USER		= $ENV{'USER'};
chop($cwd	= `pwd`);
$lockname	= $ENV{'VILOCKNAME'} || $ENV{'USER'};
chop($HOSTNAME	= `hostname`);
$XTITLE		= $ENV{'XTITLE'} || "$USER\@$HOSTNAME";
$SIG{'INT'}	= 'interrupt_handler';
$SIG{'QUIT'}	= 'interrupt_handler';
$SIG{'TERM'}	= 'interrupt_handler';

&GetRealVi();

&LoadLocks();
#----| check each file to see if locked
foreach $file (@ARGV)
{
   ($force=1),next if $file eq '-f';

   #----| Check for option
   (@arglist = (@arglist, $file)),next if $file =~ /^-/ || $file =~ /^\+/;

   #----| try to lock file for editing, if so, add to edit list
   (@editfiles = (@editfiles, $file)),next if &lock($file);
}
&SaveLocks();

if (@lockedfiles > 0)
{
   if (@editfiles == 0)
   {
      print STDERR "Press RETURN to continue ";
      $response = <STDIN>;
   }
   else
   {
      print STDERR "Ok to edit: @editfiles\n";
      print STDERR "Do you wish to continue? [y] ";
      $response = <STDIN>;
      if ($response =~ /\s*n/i)
      {
	 foreach $locked (@editfiles)
	 {
	    &unlock($locked);
	 }
	 &SaveLocks();
	 exit(0);
      }
   }
}

#----| Were there any files not locked?
exit(0) if @editfiles == 0 && int(@ARGV) != int(@arglist);

$title = "@editfiles";
$title = "$editfiles[0] $editfiles[1] $editfiles[2] ..." if @editfiles>3;
print STDERR "]0;$title" if $TERM eq 'xterm' || $TERM eq 'xterms';
system("$realvi @arglist @editfiles");

#----| unlock files
&LoadLocks();
&unlock(shift(@editfiles)) while @editfiles > 0;
&SaveLocks();

#----| reset title bar, if running in an xterm
print STDERR "]0;$XTITLE" if $TERM eq 'xterm' || $TERM eq 'xterms';


# ------------------------------------------------------------------------
# lock()
#	take a filename, and try to lock it.
#	Return: 1 for success, 0 for failure
# ------------------------------------------------------------------------
sub lock
{
   local($filename) = @_;
   local($fullpath) = &fullpath($filename);

   if ($force==0 && defined($lockdb{$fullpath}))
   {
      print STDERR "$filename is locked [by $lockdb{$fullpath}]\n";
      @lockedfiles = (@lockedfiles, $filename);
      return 0;
   }
   $lockdb{$fullpath} = $lockname;
   return 1;
}

# ------------------------------------------------------------------------
# unlock()
#	take a filename, and try to unlock it.
#	Return: 1 for success, 0 for failure
# ------------------------------------------------------------------------
sub unlock
{
   local($filename) = @_;
   local($fullpath) = &fullpath($filename);

   delete $lockdb{$fullpath};
   return 1;
}

# ------------------------------------------------------------------------
# Fullpath()
#	take a filename, return the fullpath
#	Return: 1 for success, 0 for failure
# ------------------------------------------------------------------------
sub fullpath
{
   local($filename) = @_;

   return $filename if $filename =~ /^\//;
   return "$cwd/$1" if $filename =~ /^\.\/(.*)/;
   chop($foo=`echo $filename`),return $foo if $filename =~ /^~/;
   return "$cwd/$filename";
}

# ------------------------------------------------------------------------
# LoadLocks()
#	load %lockdb from locks database file
# ------------------------------------------------------------------------
sub LoadLocks
{
   local($key,$datum);


   undef %lockdb;
   open(LOCKDB,"< $LOCKDB") || return;
   while (<LOCKDB>)
   {
      chop;
      ($key,$datum) = split(/:/);
      $lockdb{$key} = $datum;
   }
   close(LOCKDB);
}

# ------------------------------------------------------------------------
# SaveLocks()
#	Save %lockdb to locks database file
# ------------------------------------------------------------------------
sub SaveLocks
{
   local($key,$datum);


   open(LOCKDB,"> $LOCKDB") || die "can't write lock database $LOCKDB\n";
   while (($key,$datum) = each %lockdb)
   {
      print LOCKDB "$key:$datum\n";
   }
   close(LOCKDB);
}

# ------------------------------------------------------------------------
# GetRealVi()
#	find location of real vi.
# ------------------------------------------------------------------------
sub GetRealVi
{
   local($dir,@path);

   @path = split(/:/,$ENV{'PATH'});
   foreach $dir (@path)
   {
      $realvi = $dir.'/vi';
      return if -x $realvi;
   }
   print STDERR "Cannot find the real vi on your path :-(\n";
   exit(1);
}

# ------------------------------------------------------------------------
# interrupt_handler()
#	when we get an interrupt, free locks, then exit
# ------------------------------------------------------------------------
sub interrupt_handler
{
   &LoadLocks();
   &unlock(shift(@editfiles)) while @editfiles > 0;
   &SaveLocks();
}
