#
# kutils.pl
#
# a perl library which provides kutils-like functions
#
# Mark Young, Neil Bowers
#
# Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
# All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
#

$HOME           = $ENV{'HOME'};		     # get home directory in $HOME
chop($LOCALHOST = `hostname`);		     # name of local host
$LOCALHOST      =~ s/\..*$//;		     # strip off domain name
$DEBUG		= '';

@MONTHS         = (
		   'January', 'February', 'March', 'April', 'May', 'June',
		   'July', 'August', 'September', 'November', 'December'
		   );
 
@WEEKDAYS       = (
		   'Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday',
                   'Friday', 'Saturday'
		   );
 

# ========================================================================
# Routine Name: WaitForWorkers - wait for all child processes to finish
#
# Purpose:      This function will wait until all running child processes
#               have finished.  If the current process has no child processes
#               then the function will return immediately.
# ========================================================================
sub WaitForWorkers
{
   1 while wait() != -1;
}


# ========================================================================
# Routine Name: spawn - wait for all child processes to finish
#
# Purpose:      This function will wait until all running child processes
#               have finished.  If the current process has no child processes
# ========================================================================
sub spawn
{
   local($host,@commands) = @_;
   local($pid);
   local($cmdstring);
   local($attempts)       = (0);


   if (@commands == 0)
   {
      warn "spawn(): no command specified\n";
      return 0;
   }

   # make sure the .rhosts is in place
   link("$HOME/.rhosts.bk", "$HOME/.rhosts") unless -f "$HOME/.rhosts";

   while ($attempts < 5)
   {
      if ($pid = fork())
      {
	 # this is the parent, child successfully fork()ed.
	 return 1;
      }
      elsif (defined $pid)
      {
	 # this is the child, successfully forked
	 if (@commands == 1)
	 {
	    if ($host eq $LOCALHOST)
	    {
	       # local process, just exec the puppy
	       exec "$DEBUG $commands[0]";
	    }
	    else
	    {
	       # escape redirection and other meta-characters
	       $commands[0] =~ s/(>|<|&|")/\\$1/g;

	       exec "$DEBUG rsh -n $host /bin/sh -c \\'$commands[0]\\'";
	       exit 0;
	    }
	 }
	 else
	 {
	    #
	    # more than one command given
	    #
	    if ($host eq $LOCALHOST)
	    {
	       # multiple commands executed locally
	       $cmdstring = join(' ; ', @commands);
	       exec "$DEBUG $cmdstring";
	    }
	    else
	    {
	       # multiple commands executed remotely
	       $cmdstring = join(' \; ', @commands);

	       # escape redirection and other meta-characters
	       $cmdstring =~ s/(>|<|&|")/\\$1/g;

	       # remotely execute, ensuring bourne shell
	       exec "$DEBUG rsh -n $host /bin/sh -c \\' $cmdstring \\'";
	       exit 0;
	    }
	 }
      }
      elsif ($! =~ /no more process/i)
      {
	 # no processes, we could wait and try a bit later ...
	 warn "no more processes -- sleeping, will try again.\n";
	 $attempts++;
	 sleep 300;			     # 5 minutes
      }
      else
      {
	 # fork() failed, dunno why, so do nothing.
	 warn "fork() failed: $!\n";
	 warn "   Command: @commands\n";
	 return 0;
      }
   }

   return 0;
}


# ========================================================================
# Routine Name: enableRemoteShell - enable remote shell through rsh
#
# Purpose:      This function enables placement of remote processes through
#               rsh(1).  This is done by making a link to $HOME/.rhosts.bk
#               called .rhosts.  You should remember to remove the .rhosts
#               by calling disableRemoteShell().
# ========================================================================
sub enableRemoteShell
{
   link("$HOME/.rhosts.bk", "$HOME/.rhosts");
}


# ========================================================================
# Routine Name: disableRemoteShell - disable remote shell
#
# Purpose:      This function disables placement of remote processes through
#               rsh(1).  This is done by making removing .rhosts, which it
#               is assumed will be a link to .rhosts.bk.
# ========================================================================
sub disableRemoteShell
{
   unlink("$HOME/.rhosts");
}

sub DateStamp
{
   local($sec,$min,$hour,$mday,$month,$year,$wday,$yday,$isdst);
 
 
   ($sec,$min,$hour,$mday,$month,$year,$wday,$yday,$isdst) = localtime(time());
   return sprintf("%.2d:%.2d $WEEKDAYS[$wday] $mday $MONTHS[$month]",
		  $hour, $min);
}


1;
