: # use perl
        eval 'exec perl -S $0 "$@"'
                if $runnning_under_some_shell;

@khoros_toolbox = ('KHOROS_TOOLBOX');
if (! eval("\$toolboxes = \$ENV{\"KHOROS_TOOLBOX\"}"))
{
   die "The KHOROS_TOOLBOX environment variable must be set.\n";
}

@architectures = ('zen', 'osf3.2', 'osf3.0', 'sun4', 'solaris', 'irix5.2',
		  'solaris2.4-gcc', 'linux386', 'solaris-clcc', 'solaris-gcc',
		  'sgi', 'bsdos386', 'dg', 'sun4-gcc', 'alpha', 'ibmrs6');

$notfound = 1;
@toolbox_list = split(':', $toolboxes);
foreach $toolbox_file (sort(@toolbox_list))
{
   if ( ! open(TBS,"<$toolbox_file"))
   {
      print "Can not open $toolbox_file.  Please check to make sure your\n";
      die   "KHOROS_TOOLBOX environment variable points to existing files.\n";
   }

   while(<TBS>)
   {
      chop($_);
      @line = split(':',$_,3);
      if ($line[0] eq 'SUPPORT')
      {
         if ( $notfound )
         {
            $support_path = $line[1];
            $notfound = 0;
         }
         else
         {
            print "The SUPPORT toolbox is defined twice.  Please check your\n";
            print "KHOROS_TOOLBOX environment variable and the file(s)\n";
            print "pointed to by it and make sure that all toolboxes are\n";
            die   "only defined once.\n";
         }
      }
   }
}

if ( $notfound )
{
   print "The SUPPORT toolbox is not defined in any of the files pointed to\n";
   die   "by the environment variable KHOROS_TOOLBOX.\n";
}

@INC = ("$support_path/repos/perl", @INC);
require "khoros.pl";
require "find.pl";

$whatis = 'build a shadow directory structure, with hard or soft links';
@klndir_args	= (
   '[src]',
	'directory',		'directory to copy structure from',
   '[dest]',
	'directory',		'directory to create duplicate structure in',
   '[s]',
	'',                     'create symlinks rather than hardlinks',
   '[tb]',
	'toolbox1[,toolbox2]',	'name of toolbox(es) [none]',
   '[oname]',
	'oname1[,oname2]',	'name of object(s) [none]',
   '[type]',
	'type1[,type2]',	'type(s) of objects [none]',
   '[testsuite]',
	'',			'whether to link the testsuite for a toolbox',
   '[examples]',
	'',			'whether to link the examples for a toolbox',
   '[arch]',
	'arch1[,arch2]',	'name of arch(s) [zen osf3.2 osf3.0 sun4'.
				'solaris irix5.2 solaris2.4-gcc linux386'.
				'solaris-clcc solaris-gcc sgi bsdos386 dg'.
				'sun4-gcc alpha ibmrs6]',
   '[rm]',
	'',                     'remove destination before linking'
);

&khoros'initialize("SUPPORT",$whatis,@klndir_args);
&khoros'parse_args(@ARGV);

$opt_src  = $khoros'seenswitch{"src"};
$opt_dest = $khoros'seenswitch{"dest"};
$opt_tb   = $khoros'seenswitch{"tb"};
$opt_a    = $khoros'seenswitch{"arch"};
$opt_ty   = $khoros'seenswitch{"type"};
$opt_test = $khoros'seenswitch{"testsuite"};
$opt_ex   = $khoros'seenswitch{"examples"};
$opt_o    = $khoros'seenswitch{"oname"};
$opt_rm   = $khoros'seenswitch{"rm"};

if ( $opt_src && $opt_dest ) {

   $SOURCEDIR	= $khoros'argval{'src'};
   $DESTDIR	= $khoros'argval{'dest'};

   &dolink($SOURCEDIR,$DESTDIR);
}
elsif ( $opt_tb ) {

   $_ = &khoros'get_tb_name;
   tr/,/\ /;
   @toolbox = split(' ', $_);
   for ( $i = 0 ; $i <= $#toolbox ; $i++ ) {

      $tbpath = `kecho -tb $toolbox[$i] -echo path`;
      if ( $? ) {
         die "toolbox $toolbox[$i] does not exist\n";
      }
   }

   if ($opt_a) {
      $_ = $khoros'argval{"arch"};
      tr/,/\ /;
      @archs = split(' ', $_);
   }
   else {
      @archs = @architectures;
   }

   if ($opt_ty) {
      $_ = $khoros'argval{"type"};
      tr/,/\ /;
      @types = split(' ', $_);
   }

   if ($opt_o) {
      $_ = $khoros'argval{"oname"};
      tr/,/\ /;
      @objects = split(' ', $_);
   }

   TOOLBOX: foreach $tb (sort(@toolbox))
   {
      $tbpath = `kecho -tb $tb -echo path`;
      chop($tbpath);

      for ( $i = 0 ; $i <= $#archs ; $i++ ) {

	 $path = "$tbpath/mach/$archs[$i]";
	 if ( ! -d  "$path" ) {
	     print "$path does not exist in $tb\n";
	     next;
	 }

	 if ( $opt_o ) {
            for ( $j = 0 ; $j <= $#objects ; $j++ ) {

	       $objectpath = `kecho -tb $tb -oname $objects[$j] -echo path`;
	       if ( $? ) {
		  print "object $objects[$j] does not exist\n";
		  next;
	       }
	       chop($objectpath);
	       @dirs = split('/',$objectpath);

	       &dolink("$tbpath/objects/$dirs[$#dirs-1]/$dirs[$#dirs]","$tbpath/mach/$archs[$i]/objects/$dirs[$#dirs-1]/$dirs[$#dirs]");
	    }
	 }
	 elsif ( $opt_ty ) {
            for ( $j = 0 ; $j <= $#types ; $j++ ) {

	       &dolink("$tbpath/objects/$types[$j]","$tbpath/mach/$archs[$i]/objects/$types[$j]");
	    }
	 }
	 elsif ( $opt_test ) {
	    &dolink("$tbpath/testsuite","$tbpath/mach/$archs[$i]/testsuite");
	 }
	 elsif ( $opt_ex ) {
	    &dolink("$tbpath/examples","$tbpath/mach/$archs[$i]/examples");
	 }
	 else {
	    &dolink("$tbpath/objects","$tbpath/mach/$archs[$i]/objects");
	 }
      }
   }
}
else {
   &khoros'kerror("Must specify -src -dest or -tb [-arch]");
}

sub dolink
{
   local($SOURCEDIR) = $_[0];
   local($DESTDIR)   = $_[1];
   local($relsrc);
   local($reldest);
   local(@cpts);
   local($path);
   local($TB);


   $relsrc = $SOURCEDIR;
   $reldest = $DESTDIR;
   foreach $TB (keys %khoros'toolboxPath)
   {
      if ($relsrc =~ /^$khoros'toolboxPath{$TB}/)
      {
         $relsrc =~ s|^$khoros'toolboxPath{$TB}|\$$TB|;
      }
      if ($reldest =~ /^$khoros'toolboxPath{$TB}/)
      {
         $reldest =~ s|^$khoros'toolboxPath{$TB}|\$$TB|;
      }
   }
   &khoros'kinfo("STANDARD","$progname:\n\tSRC  = $relsrc\n\tDEST = $reldest\n");
   &khoros'kerror("$SOURCEDIR is not a directory!") unless -d $SOURCEDIR;
   &khoros'kerror("src and dest are the same.") if $SOURCEDIR eq $DESTDIR;

   unless (-d $DESTDIR)
   {
      @cpts = split(/\//, $DESTDIR);
      shift(@cpts);
      ($path .= "/".shift(@cpts)),mkdir($path,0755) while @cpts > 0;
   }
   else
   {
        unless ( $opt_rm )
        {
	    system("find $DESTDIR \\( -type l -o -name Makefile -o -name Imakefile -o -name y.tab.h \\) -exec /bin/rm -f {} \\;");
        }
        else
        {
	    system("rm -rf $DESTDIR");
        }
   }

   &find($SOURCEDIR);
}

sub wanted
{
   $target=$name;
   ($dev,$ino,$mode,$nlink,$uid,$gid) = lstat($_);
   $target =~ s|$SOURCEDIR/?||;
   mkdir("$DESTDIR/$target",0755),return if -d _;
   system("cp $name $DESTDIR/$target"),return if "$_" eq "Makefile" || "$_" eq "y.tab.h";
   return if -e "$DESTDIR/$target";

   # actually link the file: type of link depends on -s switch
   if ($khoros'seenswitch{'s'})
   {
      symlink($name, "$DESTDIR/$target");
   }
   else
   {
      link($name, "$DESTDIR/$target");
   }
}
