 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "kgentbindex.h"

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>            File Title
   >>>>
   >>>>  Static:
   >>>>             _static_routines()
   >>>>  Private:
   >>>>             process_cmd_line()
   >>>>  Public:
   >>>>             public_routines()
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */



/*-----------------------------------------------------------
|
|  Routine Name: process_cmd_line  - 
|
|       Purpose: 
|                
|                
|
|         Input: argument1 - explanation
|                
|                
|
|        Output: argument4 - explanation
|               
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Becky Bishop
|          Date: Wed Jan 26 13:57:25 MST 1994
| Modifications:
|
------------------------------------------------------------*/
int process_cmd_line(void)
{
   if (clui_info->alltb_flag)
      return(TRUE);
   else
      return(FALSE);
}

/*-----------------------------------------------------------
|
|  Routine Name: process_all_tbs  - 
|
|       Purpose: 
|                
|                
|
|         Input: argument1 - explanation
|                
|                
|
|        Output: argument4 - explanation
|               
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Becky Bishop
|          Date: Wed Jan 26 13:57:25 MST 1994
| Modifications:
|
------------------------------------------------------------*/
int process_all_tbs(void)
{

   int			i;
   int			j;
   int			k;

   int			num_tbs;
   int			num_manual_vols;
   int			num_vol_chapters;

   ToolboxInfo		*ToolboxStructPtr;
   ToolboxInfo		*ToolboxStructHead;
   ToolboxInfo		*ToolboxStructTail;

   VolumeInfo		*VolumeStructPtr;
   VolumeInfo		*VolumeStructHead;
   VolumeInfo		*VolumeStructTail;

   ChapterInfo		*ChapterStructPtr;
   ChapterInfo		*ChapterStructHead;
   ChapterInfo		*ChapterStructTail;

   char			**toolbox_list;

   char			*toolbox_path;
   char			*manual_path;
   char			*volume_path;
   char			*chapter_path;

   char			**tb_manual_vols;

   char			**tb_volume_chapters;

   char			temp[KLENGTH];

   kobject		toolbox_object;

   /*
    * Get a list of all possible toolboxes installed in the system.
    */
   toolbox_list = get_list_of_tbs(&num_tbs);

   /*
    * Store all toolbox names, paths, and number of associated volumes in
    * a structure and link these structures together for later processing.
    */
   ToolboxStructHead = NULL;
   ToolboxStructTail = NULL;

   for (i = 0; i < num_tbs; i++)
   {
      /*
       * Allocate a toolbox node.
       */
      ToolboxStructPtr = (ToolboxInfo *) kmalloc(sizeof(ToolboxInfo));

      /*
       * Store the toolbox name.
       */
      ToolboxStructPtr->toolbox_name = kstring_copy(toolbox_list[i], NULL);

      toolbox_object = kcms_open_toolbox(toolbox_list[i]);
      kcms_get_attribute(toolbox_object,
		         KCMS_TB_PATH,  &toolbox_path,
			 NULL);
      kcms_close(toolbox_object);
 
      /*
       * Store the toolbox path.
       */
      ToolboxStructPtr->toolbox_path = kstring_copy(toolbox_path, NULL);

      /*
       * Determine the manual path based on the toolbox.
       */
      ksprintf(temp, "%s/manual", ToolboxStructPtr->toolbox_path);
      manual_path = kexpandpath(temp, NULL, NULL);

      /*
       * Get a list of all volumes in the toolbox manual directory.  Note
       * that a volume is denoted by a directory name which begins with
       * an upper case charater such as "Intro".
       */
      tb_manual_vols = 
	   get_manual_vols(&num_manual_vols, ToolboxStructPtr->toolbox_path);

      /*
       * Initialize the head and tail of the list of volumes.
       */
      VolumeStructHead = NULL;
      VolumeStructTail = NULL;

      /*
       * Go through the list of volumes, storing their names, paths, and
       * number of chapter subdirectories in a volume node.
       */
      for (j = 0; j < num_manual_vols; j++)
      {
         /*
          * Determine the volume path based on the list of volumes, and
          * the path to the toolbox manual.
          */
         volume_path = kstring_3cat(manual_path, "/", tb_manual_vols[j], NULL);

         /*
          * Allocate a volume node.
          */
         VolumeStructPtr = (VolumeInfo *) kmalloc(sizeof(VolumeInfo));

         /*
          * Store the volume name and path in the volume node.
          */
	 VolumeStructPtr->volume_name = kstring_copy(tb_manual_vols[j], NULL);
	 VolumeStructPtr->volume_path = kstring_copy(volume_path, NULL);

         /*
          * Get a list of all chapters in the volume directory.  Note that
          * a chapter is denoted by a directory name which begins with
          * the same upper case character as the volume name.  For example,
          * for a volume named "Introduction", an appropriate chapter
          * name subdirectory would be named "I.intro_part1".
          */
         tb_volume_chapters =
           get_volume_chapters(&num_vol_chapters, VolumeStructPtr->volume_path);

         /*
          * Store the number of chapters in the volume node.
          */
         VolumeStructPtr->num_chapters = num_vol_chapters;

         /*
          * Initialize the remaining volume node pointers.  
          */
         VolumeStructPtr->ChapterInfoPtr = NULL;
         VolumeStructPtr->next = NULL;
         VolumeStructPtr->prev = NULL;
     
         /*
          * Add the new volume node to the list of volumes.
          */

         /*
          * First volume node in the list.
          */
         if (VolumeStructHead == NULL && VolumeStructTail == NULL)
         {
            VolumeStructHead = VolumeStructPtr;
            VolumeStructTail = VolumeStructPtr;
         }

         /*
          * Second volume node in the list.
          */
         else if (VolumeStructHead == VolumeStructTail)
         {
	    VolumeStructTail = VolumeStructPtr;
            VolumeStructHead->next = VolumeStructTail;
            VolumeStructTail->prev = VolumeStructHead;
         }

         /*
          * Volume node list has at least 2 items on the list.
          */
         else 
         {
            VolumeStructPtr->prev = VolumeStructTail;
            VolumeStructTail->next = VolumeStructPtr;
            VolumeStructTail = VolumeStructPtr;
         }

         /*
          * Initialize the chapter node list pointers.
          */
         ChapterStructHead = NULL;
         ChapterStructTail = NULL;

         /*
          * Go through the list of chapters storing the chapter name
	  * and chapter path.
	  */
         for (k = 0; k < num_vol_chapters; k++)
	 {
            ksprintf(temp, "%s/%s/%s", manual_path, 
		     tb_manual_vols[j], tb_volume_chapters[k]);

	    /*
             * Determine the chapter path based on the toolbox manual
	     * path and chapter name.
             */
            chapter_path = kexpandpath(temp, NULL, NULL);

	    /*
             * Allocate a chapter node.
             */
	    ChapterStructPtr = (ChapterInfo *) kmalloc(sizeof(ChapterInfo));

            /*
             * Store the chapter name and path.
             */
            ChapterStructPtr->chapter_name = 
		kstring_copy(tb_volume_chapters[k], NULL);
            ChapterStructPtr->chapter_path = kstring_copy(chapter_path, NULL);

            /*
             * Initialize the chapter node pointers.
             */
            ChapterStructPtr->next = NULL;
            ChapterStructPtr->prev = NULL;

            /*
             * Add the new chapter node to the chapter node list.
             */

	    /*
             * First chapter node on the list.
             */
	    if (ChapterStructHead == NULL && ChapterStructTail == NULL)
	    {
	       ChapterStructHead = ChapterStructPtr;
	       ChapterStructTail = ChapterStructPtr;
	    }

            /*
             * Second chapter node on the list.
             */
            else if (ChapterStructHead == ChapterStructTail)
	    {
	       ChapterStructTail = ChapterStructPtr;
	       ChapterStructHead->next = ChapterStructTail;
	       ChapterStructTail->prev = ChapterStructHead;
	    }

            /*
             * Chapter node list has 2 or more nodes on the list.
             */
            else
	    {
	       ChapterStructPtr->prev = ChapterStructTail;
	       ChapterStructTail->next = ChapterStructPtr;
	       ChapterStructTail = ChapterStructPtr;
	    }
	 }

         /*
          * Store the pointer to the chapter node list in the given
	  * volume node.
          */
         VolumeStructPtr->ChapterInfoPtr = ChapterStructHead;
      }

      /*
       * Store the number of manual volumes in the toolbox manual node.
       */
      ToolboxStructPtr->num_manual_vols = num_manual_vols;

      /*
       * Store the pointer to the volume list in the given toolbox node
       * list.
       */
      ToolboxStructPtr->VolInfoPtr = VolumeStructHead;

      /*
       * Initialize the toolbox node pointers.
       */
      ToolboxStructPtr->next = NULL;
      ToolboxStructPtr->prev = NULL;

      /*
       * Add the new toolbox node to the list of toolbox nodes.
       */

      /*
       * First toolbox node on the toolbox node list.
       */
      if (ToolboxStructHead == NULL && ToolboxStructTail == NULL)
      {
	 ToolboxStructHead = ToolboxStructPtr;
         ToolboxStructTail = ToolboxStructPtr;
      }

      /*
       * Second toolbox node on the toolbox node list.
       */
      else if (ToolboxStructHead == ToolboxStructTail)
      {
         ToolboxStructTail = ToolboxStructPtr;
         ToolboxStructHead->next = ToolboxStructTail;
         ToolboxStructTail->prev = ToolboxStructHead;
      }

      /*
       * Toolbox node list has 2 or more nodes.
       */
      else
      {
	 ToolboxStructPtr->prev = ToolboxStructTail;
         ToolboxStructTail->next = ToolboxStructPtr;
	 ToolboxStructTail = ToolboxStructPtr;
      }
   }

   return TRUE;
}

/*-----------------------------------------------------------
|
|  Routine Name: get_list_of_tbs  - 
|
|       Purpose: 
|                
|                
|
|         Input: argument1 - explanation
|                
|                
|
|        Output: argument4 - explanation
|               
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Becky Bishop
|          Date: Wed Jan 26 13:57:25 MST 1994
| Modifications:
|
------------------------------------------------------------*/
char **get_list_of_tbs(int *num_tbs)
{
   return(kcms_query_toolboxes(num_tbs));
}

/*-----------------------------------------------------------
|
|  Routine Name: get_manual_vols  - 
|
|       Purpose: 
|                
|                
|
|         Input: argument1 - explanation
|                
|                
|
|        Output: argument4 - explanation
|               
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Becky Bishop
|          Date: Wed Jan 26 13:57:25 MST 1994
| Modifications:
|
------------------------------------------------------------*/
char **get_manual_vols(int *num_manual_vols, char *tb_path)
{
   char		**all_volume_subdirs;
   char		**valid_manual_vols;
   char		*tb_manual_full_path;
   char		temp[KLENGTH];
   int		first_vol_char;
   int		i = 0;
   int		num_vol_subdirs;
   
   *num_manual_vols = 0;
   ksprintf(temp, "%s/manual", tb_path);
   tb_manual_full_path = kexpandpath(temp, NULL, NULL);
   all_volume_subdirs = karray_dirlist(NULL, tb_manual_full_path, NULL,
				       KDIR, FALSE, &num_vol_subdirs);
   valid_manual_vols = (char **)
		       kmalloc(num_vol_subdirs * sizeof(char *));
   
   for (i = 0; i < num_vol_subdirs; i++)
   {
      first_vol_char = all_volume_subdirs[i][0];
      
      if ( first_vol_char >= ASCIICAP_A && first_vol_char <= ASCIICAP_Z )
      {
         valid_manual_vols[*num_manual_vols] = 
		kstring_copy(all_volume_subdirs[i], NULL);
         (*num_manual_vols)++;
      }
   }
/*
   kfree(all_volume_subdirs);
   kfree(tb_manual_full_path);
*/
   return(valid_manual_vols);
}

/*-----------------------------------------------------------
|
|  Routine Name: get_volume_chapters  - 
|
|       Purpose: 
|                
|                
|
|         Input: argument1 - explanation
|                
|                
|
|        Output: argument4 - explanation
|               
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Becky Bishop
|          Date: Wed Jan 26 13:57:25 MST 1994
| Modifications:
|
------------------------------------------------------------*/
char **get_volume_chapters(int *num_vol_chapters, char *vol_path)
{
   char		**all_chapter_subdirs;
   char		**valid_vol_chapters;
   char		*volume;
   char		first_vol_char;
   char		first_chapt_char;
   int		i = 0;
   int		num_chapter_subdirs;
   
   *num_vol_chapters = 0;
   volume = kbasename(vol_path, NULL);
   all_chapter_subdirs = karray_dirlist(NULL, vol_path, NULL,
				        KDIR, FALSE, &num_chapter_subdirs);

   valid_vol_chapters = (char **) 
			kmalloc(num_chapter_subdirs * (sizeof(char *)));

   first_vol_char = volume[0];
   
   for (i = 0; i < num_chapter_subdirs; i++)
   {
      first_chapt_char = all_chapter_subdirs[i][0];
      
      if ( first_chapt_char == first_vol_char )
      {
         valid_vol_chapters[*num_vol_chapters] = 
		kstring_copy(all_chapter_subdirs[i], NULL);
         (*num_vol_chapters)++;
      }
   }
/*
   kfree(all_chapter_subdirs);
   kfree(volume);
*/
   return(valid_vol_chapters);
}
