 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>            Image Display Utility Routines
   >>>>
   >>>>   Static:
   >>>>  Private:
   >>>>             gw_init_keynames()
   >>>>   Public:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"

/*-----------------------------------------------------------
|
|  Routine Name: gw_init_keynames - initializes the key names for
|				    reading the prog file
|
|       Purpose: This routine initializes the key names for the
|		 text blocks in the program specification file
|		 Note: this routine exists only for converting
|		 khoros 1.0 prog files into 2.0 program objects
|
|         Input: 
|
|        Output: keynames - double string array of key names where
|			    the first index accesses the textblock, and
|			    the second index accesses the begin or end key
|       Returns: 
|
|    Written By: Danielle Argiro
|          Date: Feb 03, 1993 00:18
| Modifications: Converted from gw_init_keynames in Khoros 1.0 (SJ)
|
------------------------------------------------------------*/
void gw_init_keynames(char ***keynames)
{
     int i;

     keynames[0] = (char **) kcalloc(1,sizeof(char *)*MAX_PROGSPEC_SIZE);
     keynames[1] = (char **) kcalloc(1,sizeof(char *)*MAX_PROGSPEC_SIZE);
     for (i = 0; i < MAX_PROGSPEC_SIZE; i++)
            keynames[0][i] = NULL;
     for (i = 0; i < MAX_PROGSPEC_SIZE; i++)
            keynames[1][i] = NULL;

     keynames[0][AUTHORS] = kstring_copy("-authors", NULL);
     keynames[1][AUTHORS] = kstring_copy("-authors_end", NULL);

     keynames[0][LIBRARY_SHORTDESC] = kstring_copy("-short_lib_description", NULL);
     keynames[1][LIBRARY_SHORTDESC] = kstring_copy("-short_lib_description_end", NULL);

     keynames[0][MAN1_LONGDESC] = kstring_copy("-man1_long_description", NULL);
     keynames[1][MAN1_LONGDESC] = kstring_copy("-man1_long_description_end", NULL);

     keynames[0][MAN1_RESTRICTIONS] = kstring_copy("-man1_restrictions", NULL);
     keynames[1][MAN1_RESTRICTIONS] = kstring_copy("-man1_restrictions_end", NULL);

     keynames[0][MAN1_SEEALSO] = kstring_copy("-man1_see_also", NULL);
     keynames[1][MAN1_SEEALSO] = kstring_copy("-man1_see_also_end", NULL);

     keynames[0][MAN1_EXAMPLES] = kstring_copy("-man1_examples", NULL);
     keynames[1][MAN1_EXAMPLES] = kstring_copy("-man1_examples_end", NULL);

     keynames[0][LIBRARY_LONGDESC] = kstring_copy("-man3_long_description", NULL);
     keynames[1][LIBRARY_LONGDESC] = kstring_copy("-man3_long_description_end", NULL);

     keynames[0][LIBRARY_RESTRICT] = kstring_copy("-man3_restrictions", NULL);
     keynames[1][LIBRARY_RESTRICT] = kstring_copy("-man3_restrictions_end", NULL);

     keynames[0][MAN3_SEEALSO] = kstring_copy("-man3_see_also", NULL);
     keynames[1][MAN3_SEEALSO] = kstring_copy("-man3_see_also_end", NULL);

     keynames[0][USAGEADD] = kstring_copy("-usage_additions", NULL);
     keynames[1][USAGEADD] = kstring_copy("-usage_additions_end", NULL);

     keynames[0][INCLUDE_ADDITIONS] = kstring_copy("-include_additions", NULL);
     keynames[1][INCLUDE_ADDITIONS] = kstring_copy("-include_additions_end", NULL);

     keynames[0][INCLUDE_INCLUDES] = kstring_copy("-include_includes", NULL);
     keynames[1][INCLUDE_INCLUDES] = kstring_copy("-include_includes_end", NULL);

     keynames[0][INCLUDE_MACROS] = kstring_copy("-include_macros", NULL);
     keynames[1][INCLUDE_MACROS] = kstring_copy("-include_macros_end", NULL);

     keynames[0][MAIN_VARIABLES] = kstring_copy("-main_variable_list", NULL);
     keynames[1][MAIN_VARIABLES] = kstring_copy("-main_variable_list_end", NULL);

     keynames[0][MAIN_BEFORELIB] = kstring_copy("-main_before_lib_call", NULL);
     keynames[1][MAIN_BEFORELIB] = kstring_copy("-main_before_lib_call_end", NULL);

     keynames[0][MAIN_LIBCALL] = kstring_copy("-main_library_call", NULL);
     keynames[1][MAIN_LIBCALL] = kstring_copy("-main_library_call_end", NULL);

     keynames[0][MAIN_AFTERLIB] = kstring_copy("-main_after_lib_call", NULL);
     keynames[1][MAIN_AFTERLIB] = kstring_copy("-main_after_lib_call_end", NULL);

     keynames[0][LIBRARY_INPUT] = kstring_copy("-library_input", NULL);
     keynames[1][LIBRARY_INPUT] = kstring_copy("-library_input_end", NULL);

     keynames[0][LIBRARY_OUTPUT] = kstring_copy("-library_output", NULL);
     keynames[1][LIBRARY_OUTPUT] = kstring_copy("-library_output_end", NULL);

     keynames[0][LIBRARY_DEF] = kstring_copy("-library_def", NULL);
     keynames[1][LIBRARY_DEF] = kstring_copy("-library_def_end", NULL);

     keynames[0][LIBRARY_CODE] = kstring_copy("-library_code", NULL);
     keynames[1][LIBRARY_CODE] = kstring_copy("-library_code_end", NULL);

     keynames[0][LIBRARY_INCLUDES] = kstring_copy("-library_includes", NULL);
     keynames[1][LIBRARY_INCLUDES] = kstring_copy("-library_includes_end", NULL);

     keynames[0][LIBRARY_MODS] = kstring_copy("-library_mods", NULL);
     keynames[1][LIBRARY_MODS] = kstring_copy("-library_mods_end", NULL);

}

/*-----------------------------------------------------------
|
|  Routine Name: gw_init_config_keys
|
|       Purpose: This routine initializes the key names for the
|		 config file
|
|         Input: keynames - string array of key names for the config file
|
|        Output: 
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Danielle Argiro
|          Date: Jan 27, 1994
| Modifications:
|
------------------------------------------------------------*/
void gw_init_config_keys(char **config_keys)
{
        config_keys[KG_CPATH]        = kstring_copy("cfile", NULL);
        config_keys[KG_HPATH]        = kstring_copy("hfile", NULL);
        config_keys[KG_LPATH]        = kstring_copy("lfile", NULL);
        config_keys[KG_MAN1PATH]     = kstring_copy("man1file", NULL);
        config_keys[KG_MAN3PATH]     = kstring_copy("man3file", NULL);
        config_keys[KG_PROGPATH]     = kstring_copy("progfile", NULL);
        config_keys[KG_PANEPATH]     = kstring_copy("panefile", NULL);
        config_keys[KG_HELPPATH]     = kstring_copy("helpfile", NULL);
        config_keys[KG_SUBHELPPATH]  = kstring_copy("subhelpfile", NULL);
        config_keys[KG_TOPSRC]       = kstring_copy("topsrc", NULL);
}
