 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for mkproto
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "mkproto.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Make prototypes for functions
|
|       Purpose: main program for mkproto
|
|         Input:
|		int clui_info->n_logic; {put line numbers of declarations as comments}
|		int clui_info->n_flag; {TRUE if -n specified}
|
|		int clui_info->s_logic; {include declarations for static functions}
|		int clui_info->s_flag; {TRUE if -s specified}
|
|		int clui_info->v_logic; {include variable name in declaration}
|		int clui_info->v_flag; {TRUE if -v specified}
|
|		int clui_info->d_logic; {include declaration for the PROTO() definition}
|		int clui_info->d_flag; {TRUE if -d specified}
|
|		int clui_info->p_logic; {do not make header files readable by non-ANSI compiler}
|		int clui_info->p_flag; {TRUE if -p specified}
|
|		int clui_info->h_logic; {do file headers}
|		int clui_info->h_flag; {TRUE if -h specified}
|
|        Output:
|       Returns:
|
|    Written By: 
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
/*	argv++; argc--;*/
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "MIGRATION");
	kexit_handler(mkproto_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "MIGRATION", "mkproto",
		mkproto_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	mkproto_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
	if (clui_info->p_logic && clui_info->d_logic) {
		kprintf("#ifdef __STDC__\n");
		kprintf("# define\tPROTO(s) s\n");
		kprintf("#else\n");
		kprintf("# define PROTO(s) ()\n");
		kprintf("#endif\n\n");
	}

	getdecl(kstdin);

	if (clui_info->p_logic && clui_info->d_logic) {
		kprintf("\n#undef PROTO\n");	/* clean up namespace */
	}
/* -main_before_lib_call_end */

/* -main_library_call */
/* -main_library_call_end */

/* -main_after_lib_call */
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: mkproto_usage_additions
| 
|       Purpose: Prints usage additions in mkproto_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname mkproto
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void mkproto_usage_additions(void)
{
	kfprintf(kstderr, "\tMake prototypes for functions\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: mkproto_free_args
| 
|       Purpose: Frees CLUI struct allocated in mkproto_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname mkproto
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
mkproto_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
